"""
The commands module contains wrapper functions for os.popen() which take a system command as a string and return any output generated by the command and,
optionally, the exit status.
"""
from splunk_appinspect.python_modules_metadata.metadata_common.metadata_decorator import tags
from splunk_appinspect.python_modules_metadata.metadata_common.metadata_consts import TagConsts


@tags(TagConsts.EXTERNAL_COMMAND_EXECUTION)
def getoutput():
    """
    Like getstatusoutput(), except the exit status is ignored and the return value is a string containing the command's output.
    """
    pass


@tags(TagConsts.EXTERNAL_COMMAND_EXECUTION)
def getstatusoutput():
    """
    Execute the string cmd in a shell with os.popen() and return a 2-tuple (status, output)
    """
    pass