# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .sheet_link_mode import SheetLinkMode as SheetLinkMode_c8380c2d

class XSheetLinkable(XInterface_8f010a43):
    """
    enables a sheet to refer to another sheet in a different document.
    
    To insert a sheet link, the sheet used as linked sheet has to exist already. The method XSheetLinkable.link() creates a SheetLink object in the document's SheetLinks collection and links the sheet to the specified external sheet.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API XSheetLinkable <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XSheetLinkable.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.sheet.XSheetLinkable']

    def getLinkMode(self) -> 'SheetLinkMode_c8380c2d':
        """
        returns the link mode of the spreadsheet.
        
        If the returned value is SheetLinkMode.NORMAL, formulas are copied. With SheetLinkMode.VALUE, only results of formulas are used.
        """
    def getLinkSheetName(self) -> str:
        """
        returns the sheet name of the sheet in the source document.
        """
    def getLinkUrl(self) -> str:
        """
        returns the target URL of the link.
        """
    def link(self, aUrl: str, aSheetName: str, aFilterName: str, aFilterOptions: str, nMode: 'SheetLinkMode_c8380c2d') -> None:
        """
        links the sheet to another sheet in another document.
        
        A SheetLink object is created if it does not exist, and the link mode, the URL of the linked document and the linked sheet name are set.
        """
    def setLinkMode(self, nLinkMode: 'SheetLinkMode_c8380c2d') -> None:
        """
        enables the linking of the sheet and controls whether formulas are copied.
        
        If the value is SheetLinkMode.NORMAL, formulas are copied. With SheetLinkMode.VALUE, only results of formulas are used.
        """
    def setLinkSheetName(self, aLinkSheetName: str) -> None:
        """
        sets the name of the linked sheet in the source document.
        
        This method sets the sheet name in the SheetLink object, it does not modify the sheet name in the source document.
        """
    def setLinkUrl(self, aLinkUrl: str) -> None:
        """
        sets the target URL of the link.
        
        A SheetLink object with the same file name must exist already or the link will not work.
        """

