# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sdbc
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_connection import XConnection as XConnection_a36a0b0c

class XDataSource(XInterface_8f010a43):
    """
    is used for establishing connections via a factory which is identified by its name.
    
    A DataSource object is typically registered by a naming service provider.

    See Also:
        `API XDataSource <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sdbc_1_1XDataSource.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.sdbc.XDataSource']

    def getConnection(self, user: str, password: str) -> 'XConnection_a36a0b0c':
        """
        attempts to establish a database connection.

        Raises:
            SQLException: ``SQLException``
        """
    def getLoginTimeout(self) -> int:
        """
        gets the maximum time in seconds that this data source can wait while attempting to connect to a database.
        
        A value of zero means that the timeout is the default system timeout if there is one; otherwise, it means that there is no timeout. When a DataSource object is created the login timeout is initially zero.

        Raises:
            SQLException: ``SQLException``
        """
    def setLoginTimeout(self, seconds: int) -> None:
        """
        sets the maximum time in seconds that this data source will wait while attempting to connect to a database.
        
        A value of zero specifies that the timeout is the default system timeout if there is one; otherwise, it specifies that there is no timeout. When a DataSource object is created the login timeout is initially zero.

        Raises:
            SQLException: ``SQLException``
        """

