# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.reflection
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .param_mode import ParamMode as ParamMode_d7260ca9
from .x_idl_class import XIdlClass as XIdlClass_d63a0c9a


class ParamInfo(object):
    """
    Struct Class

    Provides information about a formal parameter of a method.

    See Also:
        `API ParamInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1reflection_1_1ParamInfo.html>`_
    """
    typeName: Literal['com.sun.star.reflection.ParamInfo']

    def __init__(self, aName: typing.Optional[str] = ..., aMode: typing.Optional[ParamMode_d7260ca9] = ..., aType: typing.Optional[XIdlClass_d63a0c9a] = ...) -> None:
        """
        Constructor

        Arguments:
            aName (str, optional): aName value.
            aMode (ParamMode, optional): aMode value.
            aType (XIdlClass, optional): aType value.
        """


    @property
    def aName(self) -> str:
        """
        name of the parameter
        """


    @property
    def aMode(self) -> ParamMode_d7260ca9:
        """
        parameter mode: in, out, inout
        """


    @property
    def aType(self) -> XIdlClass_d63a0c9a:
        """
        formal type of the parameter
        """


