# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.media
from typing_extensions import Literal
import typing
from abc import ABC
if typing.TYPE_CHECKING:
    from ..awt.size import Size as Size_576707ef
    from .x_frame_grabber import XFrameGrabber as XFrameGrabber_c56f0c00
    from .x_player_window import XPlayerWindow as XPlayerWindow_c7130c45

class XPlayer(ABC):
    """
    is the multimedia stream handling interface.
    
    This allows to perform every basic operation on videos and sounds.

    See Also:
        `API XPlayer <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1media_1_1XPlayer.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.media.XPlayer']

    def createFrameGrabber(self) -> 'XFrameGrabber_c56f0c00':
        """
        gets a frame grabber for this stream.
        """
    def createPlayerWindow(self, aArguments: 'typing.Tuple[object, ...]') -> 'XPlayerWindow_c7130c45':
        """
        gets a new player window for this stream control
        """
    def getDuration(self) -> float:
        """
        gets the stream length
        """
    def getMediaTime(self) -> float:
        """
        gets the current position of the cursor in the stream
        """
    def getPreferredPlayerWindowSize(self) -> 'Size_576707ef':
        """
        gets the preferred window size
        """
    def getVolumeDB(self) -> int:
        """
        gets the current audio volume in decibel
        """
    def isMute(self) -> bool:
        """
        gets whether the volume is temporarily down to 0 or not.
        """
    def isPlaybackLoop(self) -> bool:
        """
        indicates whether the stream reading will restart after the end of the stream.
        """
    def isPlaying(self) -> bool:
        """
        indicates whether the stream is played or not.
        """
    def setMediaTime(self, fTime: float) -> None:
        """
        sets the new cursor position in the media stream.
        
        After using this method the stream is stopped.
        """
    def setMute(self, bSet: bool) -> None:
        """
        sets the volume to 0 or to its previous value.
        """
    def setPlaybackLoop(self, bSet: bool) -> None:
        """
        sets whether the stream reading should restart at the stream start after the end of the stream.
        """
    def setVolumeDB(self, nDB: int) -> None:
        """
        sets the audio volume in decibel.
        """
    def start(self) -> None:
        """
        starts reading the stream from the current position.
        """
    def stop(self) -> None:
        """
        stops reading the stream and leave the cursor at its current position.
        """

