# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from typing_extensions import Literal


class ImagePosition(object):
    """
    Const

    specifies the position of an image, relative to another object

    See Also:
        `API ImagePosition <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1ImagePosition.html>`_
    """
    LeftTop: Literal[0]
    """
    specifies that the image should be positioned at the left of, and top-aligned to, the other object
    """
    LeftCenter: Literal[1]
    """
    specifies that the image should be positioned at the left of, and vertically centered to, the other object
    """
    LeftBottom: Literal[2]
    """
    specifies that the image should be positioned at the left of, and bottom-aligned to, the other object
    """
    RightTop: Literal[3]
    """
    specifies that the image should be positioned at the right of, and top-aligned to, the other object
    """
    RightCenter: Literal[4]
    """
    specifies that the image should be positioned at the right of, and vertically centered to, the other object
    """
    RightBottom: Literal[5]
    """
    specifies that the image should be positioned at the right of, and bottom-aligned to, the other object
    """
    AboveLeft: Literal[6]
    """
    specifies that the image should be positioned above and left-aligned to the other object
    """
    AboveCenter: Literal[7]
    """
    specifies that the image should be positioned above and horizontally centered to the other object
    """
    AboveRight: Literal[8]
    """
    specifies that the image should be positioned above and right-aligned to the other object
    """
    BelowLeft: Literal[9]
    """
    specifies that the image should be positioned below and left-aligned to the other object
    """
    BelowCenter: Literal[10]
    """
    specifies that the image should be positioned below and horizontally centered to the other object
    """
    BelowRight: Literal[11]
    """
    specifies that the image should be positioned below and right-aligned centered to the other object
    """
    Centered: Literal[12]
    """
    specifies that the image should be horizontally and vertically centered to the other object.
    """

