# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt.grid
# Libre Office Version: 7.2
from typing_extensions import Literal
from ...lang.event_object import EventObject as EventObject_a3d70b03
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing


class GridSelectionEvent(EventObject_a3d70b03):
    """
    Struct Class

    An event used by a XGridControl to notify changes in its row selection.

    See Also:
        `API GridSelectionEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1grid_1_1GridSelectionEvent.html>`_
    """
    typeName: Literal['com.sun.star.awt.grid.GridSelectionEvent']

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = ..., SelectedRowIndexes: typing.Optional[typing.Tuple[int, ...]] = ..., SelectedColumnIndexes: typing.Optional[typing.Tuple[int, ...]] = ...) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            SelectedRowIndexes (typing.Tuple[int, ...], optional): SelectedRowIndexes value.
            SelectedColumnIndexes (typing.Tuple[int, ...], optional): SelectedColumnIndexes value.
        """


    @property
    def SelectedRowIndexes(self) -> typing.Tuple[int, ...]:
        """
        denotes the indexes of the rows being selected at the time the event was fired.
        """


    @property
    def SelectedColumnIndexes(self) -> typing.Tuple[int, ...]:
        """
        denotes the indexes of the columns being selected at the time the event was fired.
        """


