"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SNS2Telegram = exports.Moderation = exports.ModerationLabels = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const s3 = require("@aws-cdk/aws-s3");
const s3n = require("@aws-cdk/aws-s3-notifications");
const sns = require("@aws-cdk/aws-sns");
const snss = require("@aws-cdk/aws-sns-subscriptions");
const cdk = require("@aws-cdk/core");
/**
 * content moderation labels.
 *
 * @see https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html
 * @stability stable
 */
var ModerationLabels;
(function (ModerationLabels) {
    ModerationLabels["EXPLICIT_NUDITY"] = "Explicit Nudity";
    ModerationLabels["NUDITY"] = "Nudity";
    ModerationLabels["SEXUAL_ACTIVITY"] = "Sexual Activity";
    ModerationLabels["SUGGESTIVE"] = "Suggestive";
    ModerationLabels["PARTIAL_NUDITY"] = "Partial Nudity";
    ModerationLabels["VIOLENCE"] = "Violence";
    ModerationLabels["VISUALLY_DISTURBING"] = "Visually Disturbing";
    ModerationLabels["RUDE_GESTURES"] = "Rude Gestures";
    ModerationLabels["DRUGS"] = "Drugs";
    ModerationLabels["TOBACCO"] = "Tobacco";
    ModerationLabels["ALCOHOL"] = "Alcohol";
    ModerationLabels["GAMBLING"] = "Gambling";
    ModerationLabels["HATE_SYMBOLS"] = "Hate Symbols";
})(ModerationLabels = exports.ModerationLabels || (exports.ModerationLabels = {}));
/**
 * @stability stable
 */
class Moderation extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _c;
        super(scope, id);
        this.bucketOptions = props.bucketOptions;
        this.topic = (_c = props.topic) !== null && _c !== void 0 ? _c : this._createTopic();
        this.handler = new aws_lambda_nodejs_1.NodejsFunction(this, 'Handler', {
            entry: path.join(__dirname, '../lambda/moderation/index.ts'),
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.ONLY_LABELS': props.moderationLabels ?
                        JSON.stringify(props.moderationLabels.map(x => x.valueOf())) : '',
                },
            },
            environment: {
                TOPIC_ARN: this.topic.topicArn,
                PREVIEW_TTL: props.previewTtl ? props.previewTtl.toSeconds().toString() : '10',
            },
        });
        this.topic.grantPublish(this.handler);
        this.handler.addToRolePolicy(new iam.PolicyStatement({
            actions: ['rekognition:DetectModerationLabels'],
            resources: ['*'],
        }));
        this.bucket = this._createBucket();
        this.bucket.grantRead(this.handler);
        new cdk.CfnOutput(this, 'bucket', { value: `s3://${this.bucket.bucketName}` });
    }
    _createBucket() {
        const bucket = new s3.Bucket(this, 'Bucket', this.bucketOptions);
        // bucket.addObjectCreatedNotification(new s3n.SnsDestination(this.topic));
        bucket.addObjectCreatedNotification(new s3n.LambdaDestination(this.handler));
        return bucket;
    }
    _createTopic() {
        return new sns.Topic(this, 'Topic');
    }
}
exports.Moderation = Moderation;
_a = JSII_RTTI_SYMBOL_1;
Moderation[_a] = { fqn: "cdk-image-moderation.Moderation", version: "0.1.3" };
/**
 * forward SNS messages to Telegram chat via Lambda.
 *
 * @stability stable
 */
class SNS2Telegram extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const telegramToken = process.env.TELEGRAM_TOKEN || this.node.tryGetContext('TELEGRAM_TOKEN');
        if (!telegramToken) {
            throw new Error('missing TELEGRAM_TOKEN in env var or context variable');
        }
        const fn = new aws_lambda_nodejs_1.NodejsFunction(this, 'SNS2TG', {
            entry: path.join(__dirname, '../lambda/sns2telegram/index.ts'),
            runtime: lambda.Runtime.NODEJS_14_X,
            environment: {
                TELEGRAM_TOKEN: telegramToken,
                TELEGRAM_CHAT_ID: props.chatid,
            },
        });
        const topic = (_c = props.topic) !== null && _c !== void 0 ? _c : this._createTopic();
        topic.addSubscription(new snss.LambdaSubscription(fn));
    }
    _createTopic() {
        return new sns.Topic(this, 'Topic', {
            fifo: true,
        });
    }
}
exports.SNS2Telegram = SNS2Telegram;
_b = JSII_RTTI_SYMBOL_1;
SNS2Telegram[_b] = { fqn: "cdk-image-moderation.SNS2Telegram", version: "0.1.3" };
//# sourceMappingURL=data:application/json;base64,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