# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class HistoricalAdherenceActuals(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        HistoricalAdherenceActuals - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'actual_activity_category': 'str',
            'start_offset_seconds': 'int',
            'end_offset_seconds': 'int'
        }

        self.attribute_map = {
            'actual_activity_category': 'actualActivityCategory',
            'start_offset_seconds': 'startOffsetSeconds',
            'end_offset_seconds': 'endOffsetSeconds'
        }

        self._actual_activity_category = None
        self._start_offset_seconds = None
        self._end_offset_seconds = None

    @property
    def actual_activity_category(self):
        """
        Gets the actual_activity_category of this HistoricalAdherenceActuals.
        Activity in which the user is actually engaged

        :return: The actual_activity_category of this HistoricalAdherenceActuals.
        :rtype: str
        """
        return self._actual_activity_category

    @actual_activity_category.setter
    def actual_activity_category(self, actual_activity_category):
        """
        Sets the actual_activity_category of this HistoricalAdherenceActuals.
        Activity in which the user is actually engaged

        :param actual_activity_category: The actual_activity_category of this HistoricalAdherenceActuals.
        :type: str
        """
        allowed_values = ["OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled"]
        if actual_activity_category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for actual_activity_category -> " + actual_activity_category)
            self._actual_activity_category = "outdated_sdk_version"
        else:
            self._actual_activity_category = actual_activity_category

    @property
    def start_offset_seconds(self):
        """
        Gets the start_offset_seconds of this HistoricalAdherenceActuals.
        Actual start offset in seconds relative to query start time

        :return: The start_offset_seconds of this HistoricalAdherenceActuals.
        :rtype: int
        """
        return self._start_offset_seconds

    @start_offset_seconds.setter
    def start_offset_seconds(self, start_offset_seconds):
        """
        Sets the start_offset_seconds of this HistoricalAdherenceActuals.
        Actual start offset in seconds relative to query start time

        :param start_offset_seconds: The start_offset_seconds of this HistoricalAdherenceActuals.
        :type: int
        """
        
        self._start_offset_seconds = start_offset_seconds

    @property
    def end_offset_seconds(self):
        """
        Gets the end_offset_seconds of this HistoricalAdherenceActuals.
        Actual end offset in seconds relative to query start time

        :return: The end_offset_seconds of this HistoricalAdherenceActuals.
        :rtype: int
        """
        return self._end_offset_seconds

    @end_offset_seconds.setter
    def end_offset_seconds(self, end_offset_seconds):
        """
        Sets the end_offset_seconds of this HistoricalAdherenceActuals.
        Actual end offset in seconds relative to query start time

        :param end_offset_seconds: The end_offset_seconds of this HistoricalAdherenceActuals.
        :type: int
        """
        
        self._end_offset_seconds = end_offset_seconds

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

