# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Annotation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Annotation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'location': 'int',
            'duration_ms': 'int',
            'absolute_location': 'int',
            'absolute_duration_ms': 'int',
            'recording_location': 'int',
            'recording_duration_ms': 'int',
            'user': 'User',
            'description': 'str',
            'keyword_name': 'str',
            'confidence': 'float',
            'keyword_set_id': 'str',
            'keyword_set_name': 'str',
            'utterance': 'str',
            'time_begin': 'str',
            'time_end': 'str',
            'keyword_confidence_threshold': 'str',
            'agent_score_modifier': 'str',
            'customer_score_modifier': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'location': 'location',
            'duration_ms': 'durationMs',
            'absolute_location': 'absoluteLocation',
            'absolute_duration_ms': 'absoluteDurationMs',
            'recording_location': 'recordingLocation',
            'recording_duration_ms': 'recordingDurationMs',
            'user': 'user',
            'description': 'description',
            'keyword_name': 'keywordName',
            'confidence': 'confidence',
            'keyword_set_id': 'keywordSetId',
            'keyword_set_name': 'keywordSetName',
            'utterance': 'utterance',
            'time_begin': 'timeBegin',
            'time_end': 'timeEnd',
            'keyword_confidence_threshold': 'keywordConfidenceThreshold',
            'agent_score_modifier': 'agentScoreModifier',
            'customer_score_modifier': 'customerScoreModifier',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._type = None
        self._location = None
        self._duration_ms = None
        self._absolute_location = None
        self._absolute_duration_ms = None
        self._recording_location = None
        self._recording_duration_ms = None
        self._user = None
        self._description = None
        self._keyword_name = None
        self._confidence = None
        self._keyword_set_id = None
        self._keyword_set_name = None
        self._utterance = None
        self._time_begin = None
        self._time_end = None
        self._keyword_confidence_threshold = None
        self._agent_score_modifier = None
        self._customer_score_modifier = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Annotation.
        The globally unique identifier for the object.

        :return: The id of this Annotation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Annotation.
        The globally unique identifier for the object.

        :param id: The id of this Annotation.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Annotation.


        :return: The name of this Annotation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Annotation.


        :param name: The name of this Annotation.
        :type: str
        """
        
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this Annotation.


        :return: The type of this Annotation.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Annotation.


        :param type: The type of this Annotation.
        :type: str
        """
        
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this Annotation.
        Offset of annotation in milliseconds.

        :return: The location of this Annotation.
        :rtype: int
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this Annotation.
        Offset of annotation in milliseconds.

        :param location: The location of this Annotation.
        :type: int
        """
        
        self._location = location

    @property
    def duration_ms(self):
        """
        Gets the duration_ms of this Annotation.
        Duration of annotation in milliseconds.

        :return: The duration_ms of this Annotation.
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms):
        """
        Sets the duration_ms of this Annotation.
        Duration of annotation in milliseconds.

        :param duration_ms: The duration_ms of this Annotation.
        :type: int
        """
        
        self._duration_ms = duration_ms

    @property
    def absolute_location(self):
        """
        Gets the absolute_location of this Annotation.
        Offset of annotation (milliseconds) from start of recording.

        :return: The absolute_location of this Annotation.
        :rtype: int
        """
        return self._absolute_location

    @absolute_location.setter
    def absolute_location(self, absolute_location):
        """
        Sets the absolute_location of this Annotation.
        Offset of annotation (milliseconds) from start of recording.

        :param absolute_location: The absolute_location of this Annotation.
        :type: int
        """
        
        self._absolute_location = absolute_location

    @property
    def absolute_duration_ms(self):
        """
        Gets the absolute_duration_ms of this Annotation.
        Duration of annotation (milliseconds).

        :return: The absolute_duration_ms of this Annotation.
        :rtype: int
        """
        return self._absolute_duration_ms

    @absolute_duration_ms.setter
    def absolute_duration_ms(self, absolute_duration_ms):
        """
        Sets the absolute_duration_ms of this Annotation.
        Duration of annotation (milliseconds).

        :param absolute_duration_ms: The absolute_duration_ms of this Annotation.
        :type: int
        """
        
        self._absolute_duration_ms = absolute_duration_ms

    @property
    def recording_location(self):
        """
        Gets the recording_location of this Annotation.
        Offset of annotation (milliseconds) from start of recording, adjusted for any recording cuts

        :return: The recording_location of this Annotation.
        :rtype: int
        """
        return self._recording_location

    @recording_location.setter
    def recording_location(self, recording_location):
        """
        Sets the recording_location of this Annotation.
        Offset of annotation (milliseconds) from start of recording, adjusted for any recording cuts

        :param recording_location: The recording_location of this Annotation.
        :type: int
        """
        
        self._recording_location = recording_location

    @property
    def recording_duration_ms(self):
        """
        Gets the recording_duration_ms of this Annotation.
        Duration of annotation (milliseconds), adjusted for any recording cuts.

        :return: The recording_duration_ms of this Annotation.
        :rtype: int
        """
        return self._recording_duration_ms

    @recording_duration_ms.setter
    def recording_duration_ms(self, recording_duration_ms):
        """
        Sets the recording_duration_ms of this Annotation.
        Duration of annotation (milliseconds), adjusted for any recording cuts.

        :param recording_duration_ms: The recording_duration_ms of this Annotation.
        :type: int
        """
        
        self._recording_duration_ms = recording_duration_ms

    @property
    def user(self):
        """
        Gets the user of this Annotation.
        User that created this annotation (if any).

        :return: The user of this Annotation.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this Annotation.
        User that created this annotation (if any).

        :param user: The user of this Annotation.
        :type: User
        """
        
        self._user = user

    @property
    def description(self):
        """
        Gets the description of this Annotation.
        Text of annotation.

        :return: The description of this Annotation.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Annotation.
        Text of annotation.

        :param description: The description of this Annotation.
        :type: str
        """
        
        self._description = description

    @property
    def keyword_name(self):
        """
        Gets the keyword_name of this Annotation.
        The word or phrase which is being looked for with speech recognition.

        :return: The keyword_name of this Annotation.
        :rtype: str
        """
        return self._keyword_name

    @keyword_name.setter
    def keyword_name(self, keyword_name):
        """
        Sets the keyword_name of this Annotation.
        The word or phrase which is being looked for with speech recognition.

        :param keyword_name: The keyword_name of this Annotation.
        :type: str
        """
        
        self._keyword_name = keyword_name

    @property
    def confidence(self):
        """
        Gets the confidence of this Annotation.
        Actual confidence that this is an accurate match.

        :return: The confidence of this Annotation.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this Annotation.
        Actual confidence that this is an accurate match.

        :param confidence: The confidence of this Annotation.
        :type: float
        """
        
        self._confidence = confidence

    @property
    def keyword_set_id(self):
        """
        Gets the keyword_set_id of this Annotation.
        A unique identifier for the keyword set to which this spotted keyword belongs.

        :return: The keyword_set_id of this Annotation.
        :rtype: str
        """
        return self._keyword_set_id

    @keyword_set_id.setter
    def keyword_set_id(self, keyword_set_id):
        """
        Sets the keyword_set_id of this Annotation.
        A unique identifier for the keyword set to which this spotted keyword belongs.

        :param keyword_set_id: The keyword_set_id of this Annotation.
        :type: str
        """
        
        self._keyword_set_id = keyword_set_id

    @property
    def keyword_set_name(self):
        """
        Gets the keyword_set_name of this Annotation.
        The keyword set to which this spotted keyword belongs.

        :return: The keyword_set_name of this Annotation.
        :rtype: str
        """
        return self._keyword_set_name

    @keyword_set_name.setter
    def keyword_set_name(self, keyword_set_name):
        """
        Sets the keyword_set_name of this Annotation.
        The keyword set to which this spotted keyword belongs.

        :param keyword_set_name: The keyword_set_name of this Annotation.
        :type: str
        """
        
        self._keyword_set_name = keyword_set_name

    @property
    def utterance(self):
        """
        Gets the utterance of this Annotation.
        The phonetic spellings for the phrase and alternate spellings.

        :return: The utterance of this Annotation.
        :rtype: str
        """
        return self._utterance

    @utterance.setter
    def utterance(self, utterance):
        """
        Sets the utterance of this Annotation.
        The phonetic spellings for the phrase and alternate spellings.

        :param utterance: The utterance of this Annotation.
        :type: str
        """
        
        self._utterance = utterance

    @property
    def time_begin(self):
        """
        Gets the time_begin of this Annotation.
        Beginning time offset of the keyword spot match.

        :return: The time_begin of this Annotation.
        :rtype: str
        """
        return self._time_begin

    @time_begin.setter
    def time_begin(self, time_begin):
        """
        Sets the time_begin of this Annotation.
        Beginning time offset of the keyword spot match.

        :param time_begin: The time_begin of this Annotation.
        :type: str
        """
        
        self._time_begin = time_begin

    @property
    def time_end(self):
        """
        Gets the time_end of this Annotation.
        Ending time offset of the keyword spot match.

        :return: The time_end of this Annotation.
        :rtype: str
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """
        Sets the time_end of this Annotation.
        Ending time offset of the keyword spot match.

        :param time_end: The time_end of this Annotation.
        :type: str
        """
        
        self._time_end = time_end

    @property
    def keyword_confidence_threshold(self):
        """
        Gets the keyword_confidence_threshold of this Annotation.
        Configured sensitivity threshold that can be increased to lower false positives or decreased to reduce false negatives.

        :return: The keyword_confidence_threshold of this Annotation.
        :rtype: str
        """
        return self._keyword_confidence_threshold

    @keyword_confidence_threshold.setter
    def keyword_confidence_threshold(self, keyword_confidence_threshold):
        """
        Sets the keyword_confidence_threshold of this Annotation.
        Configured sensitivity threshold that can be increased to lower false positives or decreased to reduce false negatives.

        :param keyword_confidence_threshold: The keyword_confidence_threshold of this Annotation.
        :type: str
        """
        
        self._keyword_confidence_threshold = keyword_confidence_threshold

    @property
    def agent_score_modifier(self):
        """
        Gets the agent_score_modifier of this Annotation.
        A modifier to the evaluation score when the phrase is spotted in the agent channel.

        :return: The agent_score_modifier of this Annotation.
        :rtype: str
        """
        return self._agent_score_modifier

    @agent_score_modifier.setter
    def agent_score_modifier(self, agent_score_modifier):
        """
        Sets the agent_score_modifier of this Annotation.
        A modifier to the evaluation score when the phrase is spotted in the agent channel.

        :param agent_score_modifier: The agent_score_modifier of this Annotation.
        :type: str
        """
        
        self._agent_score_modifier = agent_score_modifier

    @property
    def customer_score_modifier(self):
        """
        Gets the customer_score_modifier of this Annotation.
        A modifier to the evaluation score when the phrase is spotted in the customer channel.

        :return: The customer_score_modifier of this Annotation.
        :rtype: str
        """
        return self._customer_score_modifier

    @customer_score_modifier.setter
    def customer_score_modifier(self, customer_score_modifier):
        """
        Sets the customer_score_modifier of this Annotation.
        A modifier to the evaluation score when the phrase is spotted in the customer channel.

        :param customer_score_modifier: The customer_score_modifier of this Annotation.
        :type: str
        """
        
        self._customer_score_modifier = customer_score_modifier

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Annotation.
        The URI for this object

        :return: The self_uri of this Annotation.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Annotation.
        The URI for this object

        :param self_uri: The self_uri of this Annotation.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

