import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#archive_url ApplicationContainer#archive_url}
    */
    readonly archiveUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#auth_type ApplicationContainer#auth_type}
    */
    readonly authType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#availability_domain ApplicationContainer#availability_domain}
    */
    readonly availabilityDomain?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#deployment_file ApplicationContainer#deployment_file}
    */
    readonly deploymentFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#git_password ApplicationContainer#git_password}
    */
    readonly gitPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#git_repository ApplicationContainer#git_repository}
    */
    readonly gitRepository?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#git_username ApplicationContainer#git_username}
    */
    readonly gitUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#id ApplicationContainer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#load_balancer_subnets ApplicationContainer#load_balancer_subnets}
    */
    readonly loadBalancerSubnets?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#manifest_file ApplicationContainer#manifest_file}
    */
    readonly manifestFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#name ApplicationContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#notes ApplicationContainer#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#notification_email ApplicationContainer#notification_email}
    */
    readonly notificationEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#region ApplicationContainer#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#runtime ApplicationContainer#runtime}
    */
    readonly runtime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#subscription_type ApplicationContainer#subscription_type}
    */
    readonly subscriptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#tags ApplicationContainer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * deployment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#deployment ApplicationContainer#deployment}
    */
    readonly deployment?: ApplicationContainerDeployment;
    /**
    * manifest block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#manifest ApplicationContainer#manifest}
    */
    readonly manifest?: ApplicationContainerManifest;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#timeouts ApplicationContainer#timeouts}
    */
    readonly timeouts?: ApplicationContainerTimeouts;
}
export interface ApplicationContainerDeploymentServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#identifier ApplicationContainer#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#name ApplicationContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#password ApplicationContainer#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#type ApplicationContainer#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#username ApplicationContainer#username}
    */
    readonly username: string;
}
export declare function applicationContainerDeploymentServicesToTerraform(struct?: ApplicationContainerDeploymentServices | cdktf.IResolvable): any;
export declare class ApplicationContainerDeploymentServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationContainerDeploymentServices | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationContainerDeploymentServices | cdktf.IResolvable | undefined);
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class ApplicationContainerDeploymentServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationContainerDeploymentServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationContainerDeploymentServicesOutputReference;
}
export interface ApplicationContainerDeployment {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#environment ApplicationContainer#environment}
    */
    readonly environment?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#instances ApplicationContainer#instances}
    */
    readonly instances?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#java_system_properties ApplicationContainer#java_system_properties}
    */
    readonly javaSystemProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#memory ApplicationContainer#memory}
    */
    readonly memory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#notes ApplicationContainer#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#secure_environment ApplicationContainer#secure_environment}
    */
    readonly secureEnvironment?: string[];
    /**
    * services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#services ApplicationContainer#services}
    */
    readonly services?: ApplicationContainerDeploymentServices[] | cdktf.IResolvable;
}
export declare function applicationContainerDeploymentToTerraform(struct?: ApplicationContainerDeploymentOutputReference | ApplicationContainerDeployment): any;
export declare class ApplicationContainerDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationContainerDeployment | undefined;
    set internalValue(value: ApplicationContainerDeployment | undefined);
    private _environment?;
    get environment(): {
        [key: string]: string;
    };
    set environment(value: {
        [key: string]: string;
    });
    resetEnvironment(): void;
    get environmentInput(): {
        [key: string]: string;
    } | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    resetInstances(): void;
    get instancesInput(): number | undefined;
    private _javaSystemProperties?;
    get javaSystemProperties(): {
        [key: string]: string;
    };
    set javaSystemProperties(value: {
        [key: string]: string;
    });
    resetJavaSystemProperties(): void;
    get javaSystemPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _secureEnvironment?;
    get secureEnvironment(): string[];
    set secureEnvironment(value: string[]);
    resetSecureEnvironment(): void;
    get secureEnvironmentInput(): string[] | undefined;
    private _services;
    get services(): ApplicationContainerDeploymentServicesList;
    putServices(value: ApplicationContainerDeploymentServices[] | cdktf.IResolvable): void;
    resetServices(): void;
    get servicesInput(): cdktf.IResolvable | ApplicationContainerDeploymentServices[] | undefined;
}
export interface ApplicationContainerManifestRelease {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#build ApplicationContainer#build}
    */
    readonly buildAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#commit ApplicationContainer#commit}
    */
    readonly commit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#version ApplicationContainer#version}
    */
    readonly version?: string;
}
export declare function applicationContainerManifestReleaseToTerraform(struct?: ApplicationContainerManifestReleaseOutputReference | ApplicationContainerManifestRelease): any;
export declare class ApplicationContainerManifestReleaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationContainerManifestRelease | undefined;
    set internalValue(value: ApplicationContainerManifestRelease | undefined);
    private _build?;
    get buildAttribute(): string;
    set buildAttribute(value: string);
    resetBuildAttribute(): void;
    get buildAttributeInput(): string | undefined;
    private _commit?;
    get commit(): string;
    set commit(value: string);
    resetCommit(): void;
    get commitInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface ApplicationContainerManifestRuntime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#major_version ApplicationContainer#major_version}
    */
    readonly majorVersion: string;
}
export declare function applicationContainerManifestRuntimeToTerraform(struct?: ApplicationContainerManifestRuntimeOutputReference | ApplicationContainerManifestRuntime): any;
export declare class ApplicationContainerManifestRuntimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationContainerManifestRuntime | undefined;
    set internalValue(value: ApplicationContainerManifestRuntime | undefined);
    private _majorVersion?;
    get majorVersion(): string;
    set majorVersion(value: string);
    get majorVersionInput(): string | undefined;
}
export interface ApplicationContainerManifest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#clustered ApplicationContainer#clustered}
    */
    readonly clustered?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#command ApplicationContainer#command}
    */
    readonly command?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#health_check_endpoint ApplicationContainer#health_check_endpoint}
    */
    readonly healthCheckEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#home ApplicationContainer#home}
    */
    readonly home?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#mode ApplicationContainer#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#notes ApplicationContainer#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#shutdown_time ApplicationContainer#shutdown_time}
    */
    readonly shutdownTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#startup_time ApplicationContainer#startup_time}
    */
    readonly startupTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#type ApplicationContainer#type}
    */
    readonly type?: string;
    /**
    * release block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#release ApplicationContainer#release}
    */
    readonly release?: ApplicationContainerManifestRelease;
    /**
    * runtime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#runtime ApplicationContainer#runtime}
    */
    readonly runtime?: ApplicationContainerManifestRuntime;
}
export declare function applicationContainerManifestToTerraform(struct?: ApplicationContainerManifestOutputReference | ApplicationContainerManifest): any;
export declare class ApplicationContainerManifestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationContainerManifest | undefined;
    set internalValue(value: ApplicationContainerManifest | undefined);
    private _clustered?;
    get clustered(): boolean | cdktf.IResolvable;
    set clustered(value: boolean | cdktf.IResolvable);
    resetClustered(): void;
    get clusteredInput(): boolean | cdktf.IResolvable | undefined;
    private _command?;
    get command(): string;
    set command(value: string);
    resetCommand(): void;
    get commandInput(): string | undefined;
    private _healthCheckEndpoint?;
    get healthCheckEndpoint(): string;
    set healthCheckEndpoint(value: string);
    resetHealthCheckEndpoint(): void;
    get healthCheckEndpointInput(): string | undefined;
    private _home?;
    get home(): string;
    set home(value: string);
    resetHome(): void;
    get homeInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _shutdownTime?;
    get shutdownTime(): number;
    set shutdownTime(value: number);
    resetShutdownTime(): void;
    get shutdownTimeInput(): number | undefined;
    private _startupTime?;
    get startupTime(): number;
    set startupTime(value: number);
    resetStartupTime(): void;
    get startupTimeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _release;
    get release(): ApplicationContainerManifestReleaseOutputReference;
    putRelease(value: ApplicationContainerManifestRelease): void;
    resetRelease(): void;
    get releaseInput(): ApplicationContainerManifestRelease | undefined;
    private _runtime;
    get runtime(): ApplicationContainerManifestRuntimeOutputReference;
    putRuntime(value: ApplicationContainerManifestRuntime): void;
    resetRuntime(): void;
    get runtimeInput(): ApplicationContainerManifestRuntime | undefined;
}
export interface ApplicationContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#create ApplicationContainer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container#delete ApplicationContainer#delete}
    */
    readonly delete?: string;
}
export declare function applicationContainerTimeoutsToTerraform(struct?: ApplicationContainerTimeoutsOutputReference | ApplicationContainerTimeouts | cdktf.IResolvable): any;
export declare class ApplicationContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationContainerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationContainerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container oraclepaas_application_container}
*/
export declare class ApplicationContainer extends cdktf.TerraformResource {
    static readonly tfResourceType = "oraclepaas_application_container";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/application_container oraclepaas_application_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationContainerConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationContainerConfig);
    get appUrl(): string;
    private _archiveUrl?;
    get archiveUrl(): string;
    set archiveUrl(value: string);
    resetArchiveUrl(): void;
    get archiveUrlInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _availabilityDomain?;
    get availabilityDomain(): string[];
    set availabilityDomain(value: string[]);
    resetAvailabilityDomain(): void;
    get availabilityDomainInput(): string[] | undefined;
    private _deploymentFile?;
    get deploymentFile(): string;
    set deploymentFile(value: string);
    resetDeploymentFile(): void;
    get deploymentFileInput(): string | undefined;
    private _gitPassword?;
    get gitPassword(): string;
    set gitPassword(value: string);
    resetGitPassword(): void;
    get gitPasswordInput(): string | undefined;
    private _gitRepository?;
    get gitRepository(): string;
    set gitRepository(value: string);
    resetGitRepository(): void;
    get gitRepositoryInput(): string | undefined;
    private _gitUsername?;
    get gitUsername(): string;
    set gitUsername(value: string);
    resetGitUsername(): void;
    get gitUsernameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadBalancerSubnets?;
    get loadBalancerSubnets(): string[];
    set loadBalancerSubnets(value: string[]);
    resetLoadBalancerSubnets(): void;
    get loadBalancerSubnetsInput(): string[] | undefined;
    private _manifestFile?;
    get manifestFile(): string;
    set manifestFile(value: string);
    resetManifestFile(): void;
    get manifestFileInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _notificationEmail?;
    get notificationEmail(): string;
    set notificationEmail(value: string);
    resetNotificationEmail(): void;
    get notificationEmailInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    resetRuntime(): void;
    get runtimeInput(): string | undefined;
    private _subscriptionType?;
    get subscriptionType(): string;
    set subscriptionType(value: string);
    resetSubscriptionType(): void;
    get subscriptionTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get webUrl(): string;
    private _deployment;
    get deployment(): ApplicationContainerDeploymentOutputReference;
    putDeployment(value: ApplicationContainerDeployment): void;
    resetDeployment(): void;
    get deploymentInput(): ApplicationContainerDeployment | undefined;
    private _manifest;
    get manifest(): ApplicationContainerManifestOutputReference;
    putManifest(value: ApplicationContainerManifest): void;
    resetManifest(): void;
    get manifestInput(): ApplicationContainerManifest | undefined;
    private _timeouts;
    get timeouts(): ApplicationContainerTimeoutsOutputReference;
    putTimeouts(value: ApplicationContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApplicationContainerTimeouts | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
