import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsimpleZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/d/zone#name DataDnsimpleZone#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/dnsimple/d/zone dnsimple_zone}
*/
export declare class DataDnsimpleZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dnsimple_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/dnsimple/d/zone dnsimple_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsimpleZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsimpleZoneConfig);
    get accountId(): number;
    get id(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get reverse(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
