from typing import Type

from polyfactory import BaseFactory

from litestar import Controller, Litestar
from litestar._openapi.typescript_converter.converter import (
    convert_openapi_to_typescript,
)


def test_openapi_to_typescript_converter(person_controller: Type[Controller], pet_controller: Type[Controller]) -> None:
    BaseFactory.seed_random(1)
    app = Litestar(route_handlers=[person_controller, pet_controller])
    assert app.openapi_schema

    result = convert_openapi_to_typescript(openapi_schema=app.openapi_schema)
    assert (
        result.write().replace("\t", "	") == "export namespace API {\n"
        "\texport namespace PetOwnerOrPetGetPetsOrOwners {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = ({\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "} | {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "})[];\n"
        "\n"
        "\texport interface ResponseHeaders {\n"
        '\t"x-my-tag"?: string;\n'
        "};\n"
        "};\n"
        "\n"
        "\texport namespace Http406 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace PetPets {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonBulkBulkCreatePerson {\n"
        "\texport interface HeaderParameters {\n"
        "\tsecret: string;\n"
        "};\n"
        "\n"
        "\texport namespace Http201 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonBulkBulkPartialUpdatePerson {\n"
        "\texport interface HeaderParameters {\n"
        "\tsecret: string;\n"
        "};\n"
        "\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonBulkBulkUpdatePerson {\n"
        "\texport interface HeaderParameters {\n"
        "\tsecret: string;\n"
        "};\n"
        "\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonCreatePerson {\n"
        "\texport interface HeaderParameters {\n"
        "\tsecret: string;\n"
        "};\n"
        "\n"
        "\texport namespace Http201 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonDataclassGetPersonDataclass {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonGetPersons {\n"
        "\texport interface CookieParameters {\n"
        "\tvalue: number;\n"
        "};\n"
        "\n"
        "\texport interface HeaderParameters {\n"
        "\tsecret: string;\n"
        "};\n"
        "\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "}[];\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport interface PathParameters {\n"
        "\tservice_id: number;\n"
        "};\n"
        "\n"
        "\texport interface QueryParameters {\n"
        "\tfrom_date?: null | number | string | string;\n"
        '\tgender?: "A" | "F" | "M" | "O" | ("A" | "F" | "M" | "O")[] | null;\n'
        "\tname?: null | string | string[];\n"
        "\tpage: number;\n"
        "\tpageSize: number;\n"
        "\tto_date?: null | number | string | string;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonPersonIdDeletePerson {\n"
        "\texport namespace Http204 {\n"
        "\texport type ResponseBody = undefined;\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport interface PathParameters {\n"
        "\tperson_id: string;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonPersonIdGetPersonById {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport interface PathParameters {\n"
        "\tperson_id: string;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonPersonIdPartialUpdatePerson {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport interface PathParameters {\n"
        "\tperson_id: string;\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional: null | string;\n"
        "\tpets: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace ServiceIdPersonPersonIdUpdatePerson {\n"
        "\texport namespace Http200 {\n"
        "\texport type ResponseBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "\n"
        "\texport namespace Http400 {\n"
        "\texport type ResponseBody = {\n"
        "\tdetail: string;\n"
        "\textra?: Record<string, unknown> | null | unknown[];\n"
        "\tstatus_code: number;\n"
        "};\n"
        "};\n"
        "\n"
        "\texport interface PathParameters {\n"
        "\tperson_id: string;\n"
        "};\n"
        "\n"
        "\texport type RequestBody = {\n"
        "\tcomplex: {\n"
        "\t\n"
        "};\n"
        "\tfirst_name: string;\n"
        "\tid: string;\n"
        "\tlast_name: string;\n"
        "\toptional?: null | string;\n"
        "\tpets?: null | {\n"
        "\tage: number;\n"
        "\tname: string;\n"
        '\tspecies?: "Cat" | "Dog" | "Monkey" | "Pig";\n'
        "}[];\n"
        "};\n"
        "};\n"
        "};"
    )
