# -*- coding: utf-8 -*-
from setuptools import setup
import setuptools 
packages = \
['convo',
 'convo.cli',
 'convo.cli.arguments',
 'convo.cli.initial_project.actions',
 'convo.core',
 'convo.core.actions',
 'convo.core.brokers',
 'convo.core.channels',
 'convo.core.featurizers',
 'convo.core.nlg',
 'convo.core.policies',
 'convo.core.training',
 'convo.core.training.converters',
 'convo.nlu',
 'convo.nlu.classifiers',
 'convo.nlu.emulators',
 'convo.nlu.extractors',
 'convo.nlu.featurizers',
 'convo.nlu.featurizers.dense_featurizer',
 'convo.nlu.featurizers.sparse_featurizer',
 'convo.nlu.selectors',
 'convo.nlu.tokenizers',
 'convo.nlu.training_data',
 'convo.nlu.training_data.converters',
 'convo.nlu.utils',
 'convo.nlu.utils.hugging_face',
 'convo.shared',
 'convo.shared.core',
 'convo.shared.core.training_data',
 'convo.shared.core.training_data.story_reader',
 'convo.shared.core.training_data.story_writer',
 'convo.shared.importers',
 'convo.shared.nlu',
 'convo.shared.nlu.training_data',
 'convo.shared.nlu.training_data.formats',
 'convo.shared.nlu.training_data.schemas',
 'convo.shared.utils',
 'convo.utils',
 'convo.utils.tensorflow']

package_data = \
{'': ['*'],
 'convo.cli': ['initial_project/*',
              'initial_project/data/*',
              'initial_project/tests/*'],
 'convo.utils': ['schemas/*']}

install_requires = \
['PyJWT>=1.7,<1.8',
 'SQLAlchemy>=1.3.3,<1.4.0',
 'absl-py>=0.9,<0.11',
 'aiohttp>=3.6,<3.7',
 'apscheduler>=3.6,<3.7',
 'async_generator>=1.10,<1.11',
 'attrs>=19.3,<20.3',
 'boto3>=1.12,<2.0',
 'cloudpickle>=1.2,<1.5',
 'colorclass>=2.2,<2.3',
 'coloredlogs>=10,<15',
 'colorhash>=1.0.2,<1.1.0',
 'fbmessenger>=6.0.0,<6.1.0',
 'joblib>=0.15.1,<0.16.0',
 'jsonpickle>=1.3,<1.5',
 'jsonschema>=3.2,<3.3',
 'kafka-python>=1.4,<3.0',
 'matplotlib>=3.1,<3.4',
 'mattermostwrapper>=2.2,<2.3',
 'multidict>=4.6,<5.0',
 'networkx>=2.4,<2.6',
 'numpy>=1.16,<2.0',
 'oauth2client==4.1.3',
 'packaging>=20.0,<21.0',
 'pika>=1.1.0,<1.2.0',
 'prompt-toolkit>=2.0,<3.0',
 'psycopg2-binary>=2.8.2,<2.9.0',
 'pydot>=1.4,<1.5',
 'pykwalify>=1.7.0,<1.8.0',
 'pymongo[tls,srv]>=3.8,<3.11',
 'python-dateutil>=2.8,<2.9',
 'python-engineio>=3.11,<3.14',
 'python-socketio>=4.4,<4.7',
 'python-telegram-bot>=11.1,<13.0',
 'pytz>=2019.1,<2021.0',
 'questionary>=1.5.1,<1.6.0',
 'redis>=3.4,<4.0',
 'regex>=2020.6,<2020.10',
 'requests>=2.23,<3.0',
 'rocketchat_API>=0.6.31,<1.10.0',
 'ruamel.yaml>=0.16,<0.17',
 'sanic-cors>=0.10.0b1,<0.11.0',
 'sanic-jwt>=1.3.2,<1.5.0',
 'sanic>=19.12.2,<21.0.0',
 'scikit-learn>=0.22,<0.24',
 'scipy>=1.4.1,<2.0.0',
 'sentry-sdk>=0.17.4,<0.18.0',
 'setuptools>=41.0.0',
 'sklearn-crfsuite>=0.3,<0.4',
 'slackclient>=2.0.0,<3.0.0',
 'tensorflow-addons>=0.10,<=0.12',
 'tensorflow-estimator>=2.3,<2.4',
 'tensorflow-probability>=0.11,<0.12',
 'tensorflow>=2.3,<2.4',
 'tensorflow_hub>=0.9,<0.10',
 'terminaltables>=3.1.0,<3.2.0',
 'tqdm>=4.31,<4.51',
 'twilio>=6.26,<6.46',
 'ujson>=1.35,<4.0',
 'webexteamssdk>=1.1.1,<1.7.0','spacy>=2.1,<2.3']

extras_require = \
{':sys_platform != "win32"': ['tensorflow-text>=2.3,<2.4'],
 'full': ['spacy>=2.1,<2.3', 'transformers>=2.4,<2.12', 'jieba>=0.39,<0.43'],
 'gh-release-notes': ['github3.py>=1.3.0,<1.4.0'],
 'jieba': ['jieba>=0.39,<0.43'],
 'spacy': ['spacy>=2.1,<2.3'],
 'transformers': ['transformers>=2.4,<2.12']}

entry_points = \
{'console_scripts': ['convo = convo.__main__:main']}

setup_kwargs = {
    'name': 'abdoconvo',
    'version': '2.0.0',
    'description': ' anything',
    'author': 'Abdelrahman ahmed',
    'author_email': 'abdelrahman.ahmed@smarttechsys.com',
    'maintainer': 'Abdelrahman ahmed',
    'maintainer_email': 'abdelrahman.ahmed@smarttechsys.com',
    'url': 'https://www.innovsoltech.com/',

    'packages': setuptools.find_packages(),
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.9',
}


setup(**setup_kwargs)
