# Contributing

osf-cli is an open-source project and contributions of all kinds
are welcome.

Contributors to the project are required to follow the [code of
conduct](CONDUCT.md).

By contributing, you are agreeing that we may redistribute your work under
[this license](LICENSE).

We use the [GitHub flow](https://guides.github.com/introduction/flow/) model
for contributions.

If you ever have a question about Python, `git`, GitHub, PRs, jargon,
lingo, processes or how to do something: please ask! We are more than happy to
help and spread the knowledge.

Contributions should follow 
[these guidelines](https://opensource.guide/how-to-contribute/#opening-a-pull-request),
and the ones below:

* all development is done in a personal fork;
* all changes by pull request (PR);
* open your PR as early as possible and add "[WIP]" to the title to mark it as
  work in progress;
* a PR solves one problem (do not mix problems together in one PR) with the
  minimal set of changes;
* describe why you are proposing the changes you are proposing;
* try to not rush changes (the definition of rush depends on how big your
  changes are);
* change [WIP] to [MRG] when your PR is ready to be reviewed;
* someone else has to merge your PR;
* new code needs to come with a test;
* apply [PEP8](https://www.python.org/dev/peps/pep-0008/) as much
  as possible, but not too much;
* please rebase your PR when it becomes outdated instead of merging in
  master; and
* no merging if travis is red.

These are not hard rules to be enforced by :police_car: but instead guidelines.

[license]: LICENSE
