"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabContainerRunner = exports.InstanceInterruptionBehavior = exports.BlockDuration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * BlockDuration enum.
 */
var BlockDuration;
(function (BlockDuration) {
    /**
     * one hours.
     */
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    /**
     * two hours.
     */
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    /**
     * three hours.
     */
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    /**
     * four hours.
     */
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    /**
     * five hours.
     */
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    /**
     * six hours.
     */
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    /**
     * seven hours.
     */
    BlockDuration[BlockDuration["SEVEN_HOURS"] = 420] = "SEVEN_HOURS";
    /**
     * eight hours.
     */
    BlockDuration[BlockDuration["EIGHT_HOURS"] = 480] = "EIGHT_HOURS";
    /**
     * nine hours.
     */
    BlockDuration[BlockDuration["NINE_HOURS"] = 540] = "NINE_HOURS";
    /**
     * ten hours.
     */
    BlockDuration[BlockDuration["TEN_HOURS"] = 600] = "TEN_HOURS";
    /**
     * eleven hours.
     */
    BlockDuration[BlockDuration["ELEVEN_HOURS"] = 660] = "ELEVEN_HOURS";
    /**
     * twelve hours.
     */
    BlockDuration[BlockDuration["TWELVE_HOURS"] = 720] = "TWELVE_HOURS";
    /**
     * thirteen hours.
     */
    BlockDuration[BlockDuration["THIRTEEN_HOURS"] = 780] = "THIRTEEN_HOURS";
    /**
     * fourteen hours.
     */
    BlockDuration[BlockDuration["FOURTEEN_HOURS"] = 840] = "FOURTEEN_HOURS";
    /**
     * fifteen hours.
     */
    BlockDuration[BlockDuration["FIFTEEN_HOURS"] = 900] = "FIFTEEN_HOURS";
    /**
     * sixteen hours.
     */
    BlockDuration[BlockDuration["SIXTEEN_HOURS"] = 960] = "SIXTEEN_HOURS";
    /**
     * seventeen hours.
     */
    BlockDuration[BlockDuration["SEVENTEEN_HOURS"] = 1020] = "SEVENTEEN_HOURS";
    /**
     * eightteen hours.
     */
    BlockDuration[BlockDuration["EIGHTTEEN_HOURS"] = 1080] = "EIGHTTEEN_HOURS";
    /**
     * nineteen hours.
     */
    BlockDuration[BlockDuration["NINETEEN_HOURS"] = 1140] = "NINETEEN_HOURS";
    /**
     * twenty hours.
     */
    BlockDuration[BlockDuration["TWENTY_HOURS"] = 1200] = "TWENTY_HOURS";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
/**
 * InstanceInterruptionBehavior enum.
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    /**
     * hibernate
     */
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    /**
     * stop
     */
    InstanceInterruptionBehavior["STOP"] = "stop";
    /**
     * terminate
     */
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * GitlabContainerRunner Construct for create a Gitlab Runner.
 */
class GitlabContainerRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const spotFleetId = id;
        const defaultProps = {
            gitlabRunnerImage: 'public.ecr.aws/gitlab/gitlab-runner:alpine',
            gitlaburl: 'https://gitlab.com/',
            ec2type: 't3.micro',
            tags: ['gitlab', 'awscdk', 'runner'],
        };
        const runnerProps = { ...defaultProps, ...props };
        const runnerBucket = new aws_s3_1.Bucket(this, 'runnerBucket', {
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            autoDeleteObjects: true,
        });
        const shell = aws_ec2_1.UserData.forLinux();
        shell.addCommands(...this.createUserData(runnerProps, runnerBucket.bucketName));
        this.runnerRole =
            runnerProps.ec2iamrole ??
                new aws_iam_1.Role(this, 'runner-role', {
                    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
                    description: 'For Gitlab EC2 Runner Role',
                });
        this.validUntil = runnerProps.validUntil;
        const instanceProfile = new aws_iam_1.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [this.runnerRole.roleName],
        });
        runnerBucket.grantWrite(this.runnerRole);
        this.vpc =
            runnerProps.selfvpc ??
                new aws_ec2_1.Vpc(this, 'VPC', {
                    cidr: '10.0.0.0/16',
                    maxAzs: 2,
                    subnetConfiguration: [
                        {
                            cidrMask: 26,
                            name: 'RunnerVPC',
                            subnetType: aws_ec2_1.SubnetType.PUBLIC,
                        },
                    ],
                    natGateways: 0,
                });
        this.defaultRunnerSG = new aws_ec2_1.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        this.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(22));
        const spotOrOnDemand = runnerProps.spotFleet ?? false;
        if (spotOrOnDemand) {
            //throw new Error('yes new spotfleet');
            const imageId = aws_ec2_1.MachineImage.latestAmazonLinux({
                generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).getImage(this).imageId;
            const lt = new aws_ec2_1.CfnLaunchTemplate(this, 'LaunchTemplate', {
                launchTemplateData: {
                    imageId,
                    instanceType: runnerProps.ec2type,
                    blockDeviceMappings: [
                        {
                            deviceName: '/dev/xvda',
                            ebs: {
                                volumeSize: runnerProps.ebsSize ?? 60,
                            },
                        },
                    ],
                    userData: aws_cdk_lib_1.Fn.base64(shell.render()),
                    keyName: runnerProps.keyName,
                    tagSpecifications: [
                        {
                            resourceType: 'instance',
                            tags: [
                                {
                                    key: 'Name',
                                    value: `${aws_cdk_lib_1.Stack.of(this).stackName}/spotFleetGitlabRunner/${spotFleetId}`,
                                },
                            ],
                        },
                    ],
                    instanceMarketOptions: {
                        marketType: 'spot',
                        spotOptions: {
                            blockDurationMinutes: runnerProps.blockDuration ?? BlockDuration.ONE_HOUR,
                            instanceInterruptionBehavior: runnerProps.instanceInterruptionBehavior ??
                                InstanceInterruptionBehavior.TERMINATE,
                        },
                    },
                    securityGroupIds: this.defaultRunnerSG.connections.securityGroups.map((m) => m.securityGroupId),
                    iamInstanceProfile: {
                        arn: instanceProfile.attrArn,
                    },
                },
            });
            const spotFleetRole = new aws_iam_1.Role(this, 'FleetRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('spotfleet.amazonaws.com'),
                managedPolicies: [
                    aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
                ],
            });
            const vpcSubnetSelection = runnerProps.vpcSubnet ?? {
                subnetType: aws_ec2_1.SubnetType.PUBLIC,
            };
            const subnetConfig = this.vpc
                .selectSubnets(vpcSubnetSelection)
                .subnets.map((s) => ({
                subnetId: s.subnetId,
            }));
            const cfnSpotFleet = new aws_ec2_1.CfnSpotFleet(this, id, {
                spotFleetRequestConfigData: {
                    launchTemplateConfigs: [
                        {
                            launchTemplateSpecification: {
                                launchTemplateId: lt.ref,
                                version: lt.attrLatestVersionNumber,
                            },
                            overrides: subnetConfig,
                        },
                    ],
                    iamFleetRole: spotFleetRole.roleArn,
                    targetCapacity: 1,
                    validUntil: aws_cdk_lib_1.Lazy.string({ produce: () => this.validUntil }),
                    terminateInstancesWithExpiration: true,
                },
            });
            const onEvent = new lambda.Function(this, 'OnEvent', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../assets/functions')),
                handler: 'index.on_event',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: aws_cdk_lib_1.Duration.seconds(60),
            });
            const isComplete = new lambda.Function(this, 'IsComplete', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../assets/functions')),
                handler: 'index.is_complete',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: aws_cdk_lib_1.Duration.seconds(60),
                role: onEvent.role,
            });
            const myProvider = new cr.Provider(this, 'MyProvider', {
                onEventHandler: onEvent,
                isCompleteHandler: isComplete,
                logRetention: logs.RetentionDays.ONE_DAY,
            });
            onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
                actions: ['ec2:DescribeSpotFleetInstances'],
                resources: ['*'],
            }));
            const fleetInstances = new aws_cdk_lib_1.CustomResource(this, 'GetInstanceId', {
                serviceToken: myProvider.serviceToken,
                properties: {
                    SpotFleetRequestId: cfnSpotFleet.ref,
                },
            });
            fleetInstances.node.addDependency(cfnSpotFleet);
            this.spotFleetInstanceId = aws_cdk_lib_1.Token.asString(fleetInstances.getAtt('InstanceId'));
            this.spotFleetRequestId = aws_cdk_lib_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
            new aws_cdk_lib_1.CfnOutput(this, 'InstanceId', { value: this.spotFleetInstanceId });
            new aws_cdk_lib_1.CfnOutput(this, 'SpotFleetId', { value: cfnSpotFleet.ref });
        }
        else {
            this.runnerEc2 = new aws_ec2_1.Instance(this, 'GitlabRunner', {
                instanceType: new aws_ec2_1.InstanceType(runnerProps.ec2type),
                instanceName: 'Gitlab-Runner',
                vpc: this.vpc,
                vpcSubnets: runnerProps.vpcSubnet ?? {
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
                machineImage: aws_ec2_1.MachineImage.latestAmazonLinux({
                    generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
                }),
                role: this.runnerRole,
                userData: shell,
                securityGroup: this.defaultRunnerSG,
                blockDevices: [
                    {
                        deviceName: '/dev/xvda',
                        volume: aws_ec2_1.BlockDeviceVolume.ebs(runnerProps.ebsSize ?? 60),
                    },
                ],
            });
            new aws_cdk_lib_1.CfnOutput(this, 'Runner-Instance-ID', {
                value: this.runnerEc2.instanceId,
            });
        }
        const unregisterRunnerOnEvent = new lambda.Function(this, 'unregisterRunnerOnEvent', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../assets/functions')),
            handler: 'unregister_runner.on_event',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        const unregisterRunnerProvider = new cr.Provider(this, 'unregisterRunnerProvider', {
            onEventHandler: unregisterRunnerOnEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const unregisterRunnerCR = new aws_cdk_lib_1.CustomResource(this, 'unregisterRunnerCR', {
            resourceType: 'Custom::unregisterRunnerProvider',
            serviceToken: unregisterRunnerProvider.serviceToken,
            properties: {
                BucketName: runnerBucket.bucketName,
                GitlabUrl: runnerProps.gitlaburl,
            },
        });
        runnerBucket.grantReadWrite(unregisterRunnerOnEvent);
        unregisterRunnerCR.node.addDependency(runnerBucket);
        this.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new aws_cdk_lib_1.CfnOutput(this, 'Runner-Role-Arn', {
            value: this.runnerRole.roleArn,
        });
    }
    /**
     * Add expire time function for spotfleet runner !!! .
     *
     * @param duration - Block duration.
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
    dockerVolumesList(dockerVolume) {
        let tempString = '--docker-volumes "/var/run/docker.sock:/var/run/docker.sock"';
        if (dockerVolume) {
            let tempList = [];
            dockerVolume.forEach(e => {
                tempList.push(`"${e.hostPath}:${e.containerPath}"`);
            });
            tempList.forEach(e => {
                tempString = `${tempString} --docker-volumes ${e}`;
            });
        }
        return tempString;
    }
    /**
     * @param props
     * @param bucketName - the bucketName to put gitlab runner token.
     * @returns Array.
     */
    createUserData(props, bucketName) {
        return [
            'yum update -y ',
            'sleep 15 && amazon-linux-extras install docker && yum install -y amazon-cloudwatch-agent && systemctl start docker && usermod -aG docker ec2-user && chmod 777 /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            `docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock \
      --name gitlab-runner-register ${props.gitlabRunnerImage} register --non-interactive --url ${props.gitlaburl} --registration-token ${props.gitlabtoken} \
      --docker-pull-policy if-not-present ${this.dockerVolumesList(props?.dockerVolumes)} \
      --executor docker --docker-image "alpine:latest" --description "Docker Runner" \
      --tag-list "${props.tags?.join(',')}" --docker-privileged`,
            `sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner ${props.gitlabRunnerImage}`,
            `TOKEN=$(cat /home/ec2-user/.gitlab-runner/config.toml | grep token | cut -d '"' -f 2) && echo '{"token": "TOKEN"}' > /tmp/runnertoken.txt && sed -i s/TOKEN/$TOKEN/g /tmp/runnertoken.txt && aws s3 cp /tmp/runnertoken.txt s3://${bucketName}`,
        ];
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
_a = JSII_RTTI_SYMBOL_1;
GitlabContainerRunner[_a] = { fqn: "cdk-gitlab-runner.GitlabContainerRunner", version: "2.0.150" };
//# sourceMappingURL=data:application/json;base64,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