import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

import attr
from dateutil.parser import isoparse

from ..models.booking_create_barcode_type import BookingCreateBarcodeType
from ..models.booking_create_payment_option import BookingCreatePaymentOption
from ..models.booking_create_reseller_source import BookingCreateResellerSource
from ..models.booking_create_source import BookingCreateSource
from ..models.booking_create_status import BookingCreateStatus
from ..models.booking_field import BookingField
from ..models.booking_item_create import BookingItemCreate
from ..models.booking_payment import BookingPayment
from ..models.credit_card import CreditCard
from ..models.customer import Customer
from ..models.user import User
from ..types import UNSET, Unset

T = TypeVar("T", bound="BookingCreate")


@attr.s(auto_attribs=True)
class BookingCreate:
    """Booking create object used to create a booking in Rezdy's system. Lists all the possible fields for all product
    types and scenarios. Most of them are not required when sending a new booking.<br>A single Booking can be used to
    book multiple products, each of them being a BookingItem. All the products of one booking have to be from the same
    supplier.

        Attributes:
            barcode_type (Union[Unset, BookingCreateBarcodeType]): Declares the redemption code format customers will
                receive if the booking was created with barcodes.
            comments (Union[Unset, str]): Special requirements entered by the customer. Visible to both customer and
                supplier.
            coupon (Union[Unset, str]): Promo code that has been applied to this booking
            credit_card (Union[Unset, CreditCard]):  Credit card details.<p>Used to send payment details for a booking</p>
            customer (Union[Unset, Customer]): The customer is the person making the booking, and most of the time paying
                for it.<br>It differs from Participants, who are the people attending a tour
            date_paid (Union[Unset, datetime.datetime]): Date this booking was fully paid
            date_reconciled (Union[Unset, datetime.datetime]): Date this booking was reconciled with the agent
            fields (Union[Unset, List[BookingField]]): List of custom fields that are required "once per booking" by all the
                products in this booking
            internal_notes (Union[Unset, str]): Comments only visible internally by the supplier
            items (Union[Unset, List[BookingItemCreate]]): List of items in this booking. A booking can contain multiple
                products. Each BookingItem is a separate product with its own set of quantities and participant details.
            order_number (Union[Unset, str]): Order number. This is the number you should give to customers and print on
                booking confirmations. Order number is generated by the system, therefore, even if it is specified in the
                booking request, it will be overwritten.
            payment_option (Union[Unset, BookingCreatePaymentOption]): Payment option selected by the customer when making
                an online booking
            payments (Union[Unset, List[BookingPayment]]): List of payments recorded for this booking
            reseller_comments (Union[Unset, str]): Comments only visible by the agent and the supplier. This should be used
                by the agent to send voucher numbers/redemption codes to suppliers.
            reseller_id (Union[Unset, int]): Rezdy internal ID of the agent company attached to this booking
            reseller_reference (Union[Unset, str]): External reseller reference, can be used to pass internal booking
                number. This reference will be shown to a supplier, also it will appear on reports and can be used to filter
                orders. Maxiumum number of characters is 30
            reseller_source (Union[Unset, BookingCreateResellerSource]): Source of this booking viewed from the agent
            reseller_user (Union[Unset, User]): Internal Rezdy user details. This is a Rezdy application user who belongs to
                a Rezdy agent or supplier company.
            send_notifications (Union[Unset, bool]): Flag to control if a booking confirmation email should be send to the
                customer after this booking is created.<br>This will also send other types of customer notifications when setup
                by the supplier (I.e. SMS, Gift cards)  Default: True.
            source (Union[Unset, BookingCreateSource]): Source of this booking viewed from the supplier
            source_channel (Union[Unset, str]): Agent code defined by the supplier
            source_referrer (Union[Unset, str]): Referrer code
            status (Union[Unset, BookingCreateStatus]): Status of this booking
            surcharge (Union[Unset, float]): Credit card surcharge calculated for this booking
            total_amount (Union[Unset, float]): Total booking amount
            vouchers (Union[Unset, List[str]]): List of vouchers (Gift cards) that have been redeemed to pay for this
                booking
    """

    barcode_type: Union[Unset, BookingCreateBarcodeType] = UNSET
    comments: Union[Unset, str] = UNSET
    coupon: Union[Unset, str] = UNSET
    credit_card: Union[Unset, CreditCard] = UNSET
    customer: Union[Unset, Customer] = UNSET
    date_paid: Union[Unset, datetime.datetime] = UNSET
    date_reconciled: Union[Unset, datetime.datetime] = UNSET
    fields: Union[Unset, List[BookingField]] = UNSET
    internal_notes: Union[Unset, str] = UNSET
    items: Union[Unset, List[BookingItemCreate]] = UNSET
    order_number: Union[Unset, str] = UNSET
    payment_option: Union[Unset, BookingCreatePaymentOption] = UNSET
    payments: Union[Unset, List[BookingPayment]] = UNSET
    reseller_comments: Union[Unset, str] = UNSET
    reseller_id: Union[Unset, int] = UNSET
    reseller_reference: Union[Unset, str] = UNSET
    reseller_source: Union[Unset, BookingCreateResellerSource] = UNSET
    reseller_user: Union[Unset, User] = UNSET
    send_notifications: Union[Unset, bool] = True
    source: Union[Unset, BookingCreateSource] = UNSET
    source_channel: Union[Unset, str] = UNSET
    source_referrer: Union[Unset, str] = UNSET
    status: Union[Unset, BookingCreateStatus] = UNSET
    surcharge: Union[Unset, float] = UNSET
    total_amount: Union[Unset, float] = UNSET
    vouchers: Union[Unset, List[str]] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        barcode_type: Union[Unset, str] = UNSET
        if not isinstance(self.barcode_type, Unset):
            barcode_type = self.barcode_type.value

        comments = self.comments
        coupon = self.coupon
        credit_card: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.credit_card, Unset):
            credit_card = self.credit_card.to_dict()

        customer: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.customer, Unset):
            customer = self.customer.to_dict()

        date_paid: Union[Unset, str] = UNSET
        if not isinstance(self.date_paid, Unset):
            date_paid = self.date_paid.isoformat()

        date_reconciled: Union[Unset, str] = UNSET
        if not isinstance(self.date_reconciled, Unset):
            date_reconciled = self.date_reconciled.isoformat()

        fields: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.fields, Unset):
            fields = []
            for fields_item_data in self.fields:
                fields_item = fields_item_data.to_dict()

                fields.append(fields_item)

        internal_notes = self.internal_notes
        items: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.items, Unset):
            items = []
            for items_item_data in self.items:
                items_item = items_item_data.to_dict()

                items.append(items_item)

        order_number = self.order_number
        payment_option: Union[Unset, str] = UNSET
        if not isinstance(self.payment_option, Unset):
            payment_option = self.payment_option.value

        payments: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.payments, Unset):
            payments = []
            for payments_item_data in self.payments:
                payments_item = payments_item_data.to_dict()

                payments.append(payments_item)

        reseller_comments = self.reseller_comments
        reseller_id = self.reseller_id
        reseller_reference = self.reseller_reference
        reseller_source: Union[Unset, str] = UNSET
        if not isinstance(self.reseller_source, Unset):
            reseller_source = self.reseller_source.value

        reseller_user: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.reseller_user, Unset):
            reseller_user = self.reseller_user.to_dict()

        send_notifications = self.send_notifications
        source: Union[Unset, str] = UNSET
        if not isinstance(self.source, Unset):
            source = self.source.value

        source_channel = self.source_channel
        source_referrer = self.source_referrer
        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        surcharge = self.surcharge
        total_amount = self.total_amount
        vouchers: Union[Unset, List[str]] = UNSET
        if not isinstance(self.vouchers, Unset):
            vouchers = self.vouchers

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if barcode_type is not UNSET:
            field_dict["barcodeType"] = barcode_type
        if comments is not UNSET:
            field_dict["comments"] = comments
        if coupon is not UNSET:
            field_dict["coupon"] = coupon
        if credit_card is not UNSET:
            field_dict["creditCard"] = credit_card
        if customer is not UNSET:
            field_dict["customer"] = customer
        if date_paid is not UNSET:
            field_dict["datePaid"] = date_paid
        if date_reconciled is not UNSET:
            field_dict["dateReconciled"] = date_reconciled
        if fields is not UNSET:
            field_dict["fields"] = fields
        if internal_notes is not UNSET:
            field_dict["internalNotes"] = internal_notes
        if items is not UNSET:
            field_dict["items"] = items
        if order_number is not UNSET:
            field_dict["orderNumber"] = order_number
        if payment_option is not UNSET:
            field_dict["paymentOption"] = payment_option
        if payments is not UNSET:
            field_dict["payments"] = payments
        if reseller_comments is not UNSET:
            field_dict["resellerComments"] = reseller_comments
        if reseller_id is not UNSET:
            field_dict["resellerId"] = reseller_id
        if reseller_reference is not UNSET:
            field_dict["resellerReference"] = reseller_reference
        if reseller_source is not UNSET:
            field_dict["resellerSource"] = reseller_source
        if reseller_user is not UNSET:
            field_dict["resellerUser"] = reseller_user
        if send_notifications is not UNSET:
            field_dict["sendNotifications"] = send_notifications
        if source is not UNSET:
            field_dict["source"] = source
        if source_channel is not UNSET:
            field_dict["sourceChannel"] = source_channel
        if source_referrer is not UNSET:
            field_dict["sourceReferrer"] = source_referrer
        if status is not UNSET:
            field_dict["status"] = status
        if surcharge is not UNSET:
            field_dict["surcharge"] = surcharge
        if total_amount is not UNSET:
            field_dict["totalAmount"] = total_amount
        if vouchers is not UNSET:
            field_dict["vouchers"] = vouchers

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        _barcode_type = d.pop("barcodeType", UNSET)
        barcode_type: Union[Unset, BookingCreateBarcodeType]
        if isinstance(_barcode_type, Unset):
            barcode_type = UNSET
        else:
            barcode_type = BookingCreateBarcodeType(_barcode_type)

        comments = d.pop("comments", UNSET)

        coupon = d.pop("coupon", UNSET)

        _credit_card = d.pop("creditCard", UNSET)
        credit_card: Union[Unset, CreditCard]
        if isinstance(_credit_card, Unset):
            credit_card = UNSET
        else:
            credit_card = CreditCard.from_dict(_credit_card)

        _customer = d.pop("customer", UNSET)
        customer: Union[Unset, Customer]
        if isinstance(_customer, Unset):
            customer = UNSET
        else:
            customer = Customer.from_dict(_customer)

        _date_paid = d.pop("datePaid", UNSET)
        date_paid: Union[Unset, datetime.datetime]
        if isinstance(_date_paid, Unset):
            date_paid = UNSET
        else:
            date_paid = isoparse(_date_paid)

        _date_reconciled = d.pop("dateReconciled", UNSET)
        date_reconciled: Union[Unset, datetime.datetime]
        if isinstance(_date_reconciled, Unset):
            date_reconciled = UNSET
        else:
            date_reconciled = isoparse(_date_reconciled)

        fields = []
        _fields = d.pop("fields", UNSET)
        for fields_item_data in _fields or []:
            fields_item = BookingField.from_dict(fields_item_data)

            fields.append(fields_item)

        internal_notes = d.pop("internalNotes", UNSET)

        items = []
        _items = d.pop("items", UNSET)
        for items_item_data in _items or []:
            items_item = BookingItemCreate.from_dict(items_item_data)

            items.append(items_item)

        order_number = d.pop("orderNumber", UNSET)

        _payment_option = d.pop("paymentOption", UNSET)
        payment_option: Union[Unset, BookingCreatePaymentOption]
        if isinstance(_payment_option, Unset):
            payment_option = UNSET
        else:
            payment_option = BookingCreatePaymentOption(_payment_option)

        payments = []
        _payments = d.pop("payments", UNSET)
        for payments_item_data in _payments or []:
            payments_item = BookingPayment.from_dict(payments_item_data)

            payments.append(payments_item)

        reseller_comments = d.pop("resellerComments", UNSET)

        reseller_id = d.pop("resellerId", UNSET)

        reseller_reference = d.pop("resellerReference", UNSET)

        _reseller_source = d.pop("resellerSource", UNSET)
        reseller_source: Union[Unset, BookingCreateResellerSource]
        if isinstance(_reseller_source, Unset):
            reseller_source = UNSET
        else:
            reseller_source = BookingCreateResellerSource(_reseller_source)

        _reseller_user = d.pop("resellerUser", UNSET)
        reseller_user: Union[Unset, User]
        if isinstance(_reseller_user, Unset):
            reseller_user = UNSET
        else:
            reseller_user = User.from_dict(_reseller_user)

        send_notifications = d.pop("sendNotifications", UNSET)

        _source = d.pop("source", UNSET)
        source: Union[Unset, BookingCreateSource]
        if isinstance(_source, Unset):
            source = UNSET
        else:
            source = BookingCreateSource(_source)

        source_channel = d.pop("sourceChannel", UNSET)

        source_referrer = d.pop("sourceReferrer", UNSET)

        _status = d.pop("status", UNSET)
        status: Union[Unset, BookingCreateStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = BookingCreateStatus(_status)

        surcharge = d.pop("surcharge", UNSET)

        total_amount = d.pop("totalAmount", UNSET)

        vouchers = cast(List[str], d.pop("vouchers", UNSET))

        booking_create = cls(
            barcode_type=barcode_type,
            comments=comments,
            coupon=coupon,
            credit_card=credit_card,
            customer=customer,
            date_paid=date_paid,
            date_reconciled=date_reconciled,
            fields=fields,
            internal_notes=internal_notes,
            items=items,
            order_number=order_number,
            payment_option=payment_option,
            payments=payments,
            reseller_comments=reseller_comments,
            reseller_id=reseller_id,
            reseller_reference=reseller_reference,
            reseller_source=reseller_source,
            reseller_user=reseller_user,
            send_notifications=send_notifications,
            source=source,
            source_channel=source_channel,
            source_referrer=source_referrer,
            status=status,
            surcharge=surcharge,
            total_amount=total_amount,
            vouchers=vouchers,
        )

        booking_create.additional_properties = d
        return booking_create

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
