"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const alb_controller_1 = require("./alb-controller");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
const PRUNE_LABEL_PREFIX = 'aws.cdk.eks/prune-';
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesManifestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KubernetesManifest);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const prune = props.prune ?? props.cluster.prune;
        const pruneLabel = prune
            ? this.injectPruneLabel(props.manifest)
            : undefined;
        if (props.ingressAlb ?? false) {
            this.injectIngressAlbAnnotations(props.manifest, props.ingressAlbScheme ?? alb_controller_1.AlbScheme.INTERNAL);
        }
        const customResource = new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PruneLabel: pruneLabel,
                Overwrite: props.overwrite,
                SkipValidation: props.skipValidation,
            },
        });
        this.node.defaultChild = customResource.node.defaultChild;
    }
    /**
     * Injects a generated prune label to all resources in this manifest. The
     * label name will be `awscdk.eks/manifest-ADDR` where `ADDR` is the address
     * of the construct in the construct tree.
     *
     * @returns the label name
     */
    injectPruneLabel(manifest) {
        // max label name is 64 chars and addrs is always 42.
        const pruneLabel = PRUNE_LABEL_PREFIX + constructs_1.Node.of(this).addr;
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (!resource.metadata) {
                resource.metadata = {};
            }
            if (!resource.metadata.labels) {
                resource.metadata.labels = {};
            }
            resource.metadata.labels = {
                [pruneLabel]: '',
                ...resource.metadata.labels,
            };
        }
        return pruneLabel;
    }
    /**
     * Inject the necessary ingress annontations if possible (and requested).
     *
     * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/guide/ingress/annotations/
     */
    injectIngressAlbAnnotations(manifest, scheme) {
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (resource.kind === 'Ingress') {
                resource.metadata.annotations = {
                    'kubernetes.io/ingress.class': 'alb',
                    'alb.ingress.kubernetes.io/scheme': scheme,
                    ...resource.metadata.annotations,
                };
            }
        }
    }
}
exports.KubernetesManifest = KubernetesManifest;
_a = JSII_RTTI_SYMBOL_1;
KubernetesManifest[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesManifest", version: "1.198.1" };
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiazhzLW1hbmlmZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiazhzLW1hbmlmZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUFzRDtBQUN0RCwyQ0FBNkM7QUFDN0MscURBQTZDO0FBRTdDLHlEQUFxRDtBQUVyRCxnSEFBZ0g7QUFDaEgsMkJBQTJCO0FBQzNCLHdDQUEyRDtBQUUzRCxNQUFNLGtCQUFrQixHQUFHLG9CQUFvQixDQUFDO0FBc0doRDs7Ozs7OztHQU9HO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSxnQkFBYTtJQU1uRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQThCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FQUixrQkFBa0I7Ozs7UUFTM0IsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM3QixNQUFNLFFBQVEsR0FBRyxrQ0FBZSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWxFLE1BQU0sS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUM7UUFDakQsTUFBTSxVQUFVLEdBQUcsS0FBSztZQUN0QixDQUFDLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDdkMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUVkLElBQUksS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLEVBQUU7WUFDN0IsSUFBSSxDQUFDLDJCQUEyQixDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLGdCQUFnQixJQUFJLDBCQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDaEc7UUFFRCxNQUFNLGNBQWMsR0FBRyxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMxRCxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsWUFBWSxFQUFFLGtCQUFrQixDQUFDLGFBQWE7WUFDOUMsVUFBVSxFQUFFO2dCQUNWLHVFQUF1RTtnQkFDdkUsNkRBQTZEO2dCQUM3RCw2Q0FBNkM7Z0JBQzdDLFFBQVEsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUM7Z0JBQzVDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RDLE9BQU8sRUFBRSxRQUFRLENBQUMsT0FBTztnQkFDekIsVUFBVSxFQUFFLFVBQVU7Z0JBQ3RCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztnQkFDMUIsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO2FBQ3JDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsY0FBYyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7S0FDM0Q7SUFFRDs7Ozs7O09BTUc7SUFDSyxnQkFBZ0IsQ0FBQyxRQUErQjtRQUN0RCxxREFBcUQ7UUFDckQsTUFBTSxVQUFVLEdBQUcsa0JBQWtCLEdBQUcsaUJBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDO1FBRTNELEtBQUssTUFBTSxRQUFRLElBQUksUUFBUSxFQUFFO1lBQy9CLHNFQUFzRTtZQUN0RSxJQUFJLE9BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxRQUFRLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFO2dCQUNuRCxTQUFTO2FBQ1Y7WUFFRCxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRTtnQkFDdEIsUUFBUSxDQUFDLFFBQVEsR0FBRyxFQUFFLENBQUM7YUFDeEI7WUFFRCxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUU7Z0JBQzdCLFFBQVEsQ0FBQyxRQUFRLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQzthQUMvQjtZQUVELFFBQVEsQ0FBQyxRQUFRLENBQUMsTUFBTSxHQUFHO2dCQUN6QixDQUFDLFVBQVUsQ0FBQyxFQUFFLEVBQUU7Z0JBQ2hCLEdBQUcsUUFBUSxDQUFDLFFBQVEsQ0FBQyxNQUFNO2FBQzVCLENBQUM7U0FDSDtRQUVELE9BQU8sVUFBVSxDQUFDO0tBQ25CO0lBRUQ7Ozs7T0FJRztJQUNLLDJCQUEyQixDQUFDLFFBQStCLEVBQUUsTUFBaUI7UUFFcEYsS0FBSyxNQUFNLFFBQVEsSUFBSSxRQUFRLEVBQUU7WUFFL0Isc0VBQXNFO1lBQ3RFLElBQUksT0FBTSxDQUFDLFFBQVEsQ0FBQyxLQUFLLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUU7Z0JBQ25ELFNBQVM7YUFDVjtZQUVELElBQUksUUFBUSxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUU7Z0JBQy9CLFFBQVEsQ0FBQyxRQUFRLENBQUMsV0FBVyxHQUFHO29CQUM5Qiw2QkFBNkIsRUFBRSxLQUFLO29CQUNwQyxrQ0FBa0MsRUFBRSxNQUFNO29CQUMxQyxHQUFHLFFBQVEsQ0FBQyxRQUFRLENBQUMsV0FBVztpQkFDakMsQ0FBQzthQUNIO1NBQ0Y7S0FFRjs7QUFqR0gsZ0RBa0dDOzs7QUFqR0M7O0dBRUc7QUFDb0IsZ0NBQWEsR0FBRyx1Q0FBdUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEN1c3RvbVJlc291cmNlLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBOb2RlIH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBBbGJTY2hlbWUgfSBmcm9tICcuL2FsYi1jb250cm9sbGVyJztcbmltcG9ydCB7IElDbHVzdGVyIH0gZnJvbSAnLi9jbHVzdGVyJztcbmltcG9ydCB7IEt1YmVjdGxQcm92aWRlciB9IGZyb20gJy4va3ViZWN0bC1wcm92aWRlcic7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIGltcG9ydCBhcyBhIHNlcGFyYXRlIHNlY3Rpb24gdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0IHdoZW4gZm9yd2FyZCBtZXJnaW5nIHdpdGggdGhlIHYyIGJyYW5jaC5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuY29uc3QgUFJVTkVfTEFCRUxfUFJFRklYID0gJ2F3cy5jZGsuZWtzL3BydW5lLSc7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgYEt1YmVybmV0ZXNNYW5pZmVzdGAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgS3ViZXJuZXRlc01hbmlmZXN0T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBXaGVuIGEgcmVzb3VyY2UgaXMgcmVtb3ZlZCBmcm9tIGEgS3ViZXJuZXRlcyBtYW5pZmVzdCwgaXQgbm8gbG9uZ2VyIGFwcGVhcnNcbiAgICogaW4gdGhlIG1hbmlmZXN0LCBhbmQgdGhlcmUgaXMgbm8gd2F5IHRvIGtub3cgdGhhdCB0aGlzIHJlc291cmNlIG5lZWRzIHRvIGJlXG4gICAqIGRlbGV0ZWQuIFRvIGFkZHJlc3MgdGhpcywgYGt1YmVjdGwgYXBwbHlgIGhhcyBhIGAtLXBydW5lYCBvcHRpb24gd2hpY2ggd2lsbFxuICAgKiBxdWVyeSB0aGUgY2x1c3RlciBmb3IgYWxsIHJlc291cmNlcyB3aXRoIGEgc3BlY2lmaWMgbGFiZWwgYW5kIHdpbGwgcmVtb3ZlXG4gICAqIGFsbCB0aGUgbGFiZWxkIHJlc291cmNlcyB0aGF0IGFyZSBub3QgcGFydCBvZiB0aGUgYXBwbGllZCBtYW5pZmVzdC4gSWYgdGhpc1xuICAgKiBvcHRpb24gaXMgZGlzYWJsZWQgYW5kIGEgcmVzb3VyY2UgaXMgcmVtb3ZlZCwgaXQgd2lsbCBiZWNvbWUgXCJvcnBoYW5lZFwiIGFuZFxuICAgKiB3aWxsIG5vdCBiZSBkZWxldGVkIGZyb20gdGhlIGNsdXN0ZXIuXG4gICAqXG4gICAqIFdoZW4gdGhpcyBvcHRpb24gaXMgZW5hYmxlZCAoZGVmYXVsdCksIHRoZSBjb25zdHJ1Y3Qgd2lsbCBpbmplY3QgYSBsYWJlbCB0b1xuICAgKiBhbGwgS3ViZXJuZXRlcyByZXNvdXJjZXMgaW5jbHVkZWQgaW4gdGhpcyBtYW5pZmVzdCB3aGljaCB3aWxsIGJlIHVzZWQgdG9cbiAgICogcHJ1bmUgcmVzb3VyY2VzIHdoZW4gdGhlIG1hbmlmZXN0IGNoYW5nZXMgdmlhIGBrdWJlY3RsIGFwcGx5IC0tcHJ1bmVgLlxuICAgKlxuICAgKiBUaGUgbGFiZWwgbmFtZSB3aWxsIGJlIGBhd3MuY2RrLmVrcy9wcnVuZS08QUREUj5gIHdoZXJlIGA8QUREUj5gIGlzIHRoZVxuICAgKiA0Mi1jaGFyIHVuaXF1ZSBhZGRyZXNzIG9mIHRoaXMgY29uc3RydWN0IGluIHRoZSBjb25zdHJ1Y3QgdHJlZS4gVmFsdWUgaXNcbiAgICogZW1wdHkuXG4gICAqXG4gICAqIEBzZWVcbiAgICogaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvdGFza3MvbWFuYWdlLWt1YmVybmV0ZXMtb2JqZWN0cy9kZWNsYXJhdGl2ZS1jb25maWcvI2FsdGVybmF0aXZlLWt1YmVjdGwtYXBwbHktZi1kaXJlY3RvcnktcHJ1bmUtbC15b3VyLWxhYmVsXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYmFzZWQgb24gdGhlIHBydW5lIG9wdGlvbiBvZiB0aGUgY2x1c3Rlciwgd2hpY2ggaXMgYHRydWVgIHVubGVzc1xuICAgKiBvdGhlcndpc2Ugc3BlY2lmaWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgcHJ1bmU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBIGZsYWcgdG8gc2lnbmlmeSBpZiB0aGUgbWFuaWZlc3QgdmFsaWRhdGlvbiBzaG91bGQgYmUgc2tpcHBlZFxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgc2tpcFZhbGlkYXRpb24/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBdXRvbWF0aWNhbGx5IGRldGVjdCBgSW5ncmVzc2AgcmVzb3VyY2VzIGluIHRoZSBtYW5pZmVzdCBhbmQgYW5ub3RhdGUgdGhlbSBzbyB0aGV5XG4gICAqIGFyZSBwaWNrZWQgdXAgYnkgYW4gQUxCIEluZ3Jlc3MgQ29udHJvbGxlci5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGluZ3Jlc3NBbGI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IHRoZSBBTEIgc2NoZW1lIHRoYXQgc2hvdWxkIGJlIGFwcGxpZWQgdG8gYEluZ3Jlc3NgIHJlc291cmNlcy5cbiAgICogT25seSBhcHBsaWNhYmxlIGlmIGBpbmdyZXNzQWxiYCBpcyBzZXQgdG8gYHRydWVgLlxuICAgKlxuICAgKiBAZGVmYXVsdCBBbGJTY2hlbWUuSU5URVJOQUxcbiAgICovXG4gIHJlYWRvbmx5IGluZ3Jlc3NBbGJTY2hlbWU/OiBBbGJTY2hlbWU7XG5cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBLdWJlcm5ldGVzTWFuaWZlc3RcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBLdWJlcm5ldGVzTWFuaWZlc3RQcm9wcyBleHRlbmRzIEt1YmVybmV0ZXNNYW5pZmVzdE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIEVLUyBjbHVzdGVyIHRvIGFwcGx5IHRoaXMgbWFuaWZlc3QgdG8uXG4gICAqXG4gICAqIFtkaXNhYmxlLWF3c2xpbnQ6cmVmLXZpYS1pbnRlcmZhY2VdXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyOiBJQ2x1c3RlcjtcblxuICAvKipcbiAgICogVGhlIG1hbmlmZXN0IHRvIGFwcGx5LlxuICAgKlxuICAgKiBDb25zaXN0cyBvZiBhbnkgbnVtYmVyIG9mIGNoaWxkIHJlc291cmNlcy5cbiAgICpcbiAgICogV2hlbiB0aGUgcmVzb3VyY2VzIGFyZSBjcmVhdGVkL3VwZGF0ZWQsIHRoaXMgbWFuaWZlc3Qgd2lsbCBiZSBhcHBsaWVkIHRvIHRoZVxuICAgKiBjbHVzdGVyIHRocm91Z2ggYGt1YmVjdGwgYXBwbHlgIGFuZCB3aGVuIHRoZSByZXNvdXJjZXMgb3IgdGhlIHN0YWNrIGlzXG4gICAqIGRlbGV0ZWQsIHRoZSByZXNvdXJjZXMgaW4gdGhlIG1hbmlmZXN0IHdpbGwgYmUgZGVsZXRlZCB0aHJvdWdoIGBrdWJlY3RsIGRlbGV0ZWAuXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqXG4gICAqIFt7XG4gICAqICAgYXBpVmVyc2lvbjogJ3YxJyxcbiAgICogICBraW5kOiAnUG9kJyxcbiAgICogICBtZXRhZGF0YTogeyBuYW1lOiAnbXlwb2QnIH0sXG4gICAqICAgc3BlYzoge1xuICAgKiAgICAgY29udGFpbmVyczogWyB7IG5hbWU6ICdoZWxsbycsIGltYWdlOiAncGF1bGJvdXdlci9oZWxsby1rdWJlcm5ldGVzOjEuNScsIHBvcnRzOiBbIHsgY29udGFpbmVyUG9ydDogODA4MCB9IF0gfSBdXG4gICAqICAgfVxuICAgKiB9XVxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgbWFuaWZlc3Q6IFJlY29yZDxzdHJpbmcsIGFueT5bXTtcblxuICAvKipcbiAgICogT3ZlcndyaXRlIGFueSBleGlzdGluZyByZXNvdXJjZXMuXG4gICAqXG4gICAqIElmIHRoaXMgaXMgc2V0LCB3ZSB3aWxsIHVzZSBga3ViZWN0bCBhcHBseWAgaW5zdGVhZCBvZiBga3ViZWN0bCBjcmVhdGVgXG4gICAqIHdoZW4gdGhlIHJlc291cmNlIGlzIGNyZWF0ZWQuIE90aGVyd2lzZSwgaWYgdGhlcmUgaXMgYWxyZWFkeSBhIHJlc291cmNlXG4gICAqIGluIHRoZSBjbHVzdGVyIHdpdGggdGhlIHNhbWUgbmFtZSwgdGhlIG9wZXJhdGlvbiB3aWxsIGZhaWwuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBvdmVyd3JpdGU/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBtYW5pZmVzdCB3aXRoaW4gdGhlIEt1YmVybmV0ZXMgc3lzdGVtLlxuICpcbiAqIEFsdGVybmF0aXZlbHksIHlvdSBjYW4gdXNlIGBjbHVzdGVyLmFkZE1hbmlmZXN0KHJlc291cmNlWywgcmVzb3VyY2UsIC4uLl0pYFxuICogdG8gZGVmaW5lIHJlc291cmNlcyBvbiB0aGlzIGNsdXN0ZXIuXG4gKlxuICogQXBwbGllcy9kZWxldGVzIHRoZSBtYW5pZmVzdCB1c2luZyBga3ViZWN0bGAuXG4gKi9cbmV4cG9ydCBjbGFzcyBLdWJlcm5ldGVzTWFuaWZlc3QgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZW9zdXJjZSB0eXBlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRVNPVVJDRV9UWVBFID0gJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzUmVzb3VyY2UnO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBLdWJlcm5ldGVzTWFuaWZlc3RQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IHByb3ZpZGVyID0gS3ViZWN0bFByb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMsIHByb3BzLmNsdXN0ZXIpO1xuXG4gICAgY29uc3QgcHJ1bmUgPSBwcm9wcy5wcnVuZSA/PyBwcm9wcy5jbHVzdGVyLnBydW5lO1xuICAgIGNvbnN0IHBydW5lTGFiZWwgPSBwcnVuZVxuICAgICAgPyB0aGlzLmluamVjdFBydW5lTGFiZWwocHJvcHMubWFuaWZlc3QpXG4gICAgICA6IHVuZGVmaW5lZDtcblxuICAgIGlmIChwcm9wcy5pbmdyZXNzQWxiID8/IGZhbHNlKSB7XG4gICAgICB0aGlzLmluamVjdEluZ3Jlc3NBbGJBbm5vdGF0aW9ucyhwcm9wcy5tYW5pZmVzdCwgcHJvcHMuaW5ncmVzc0FsYlNjaGVtZSA/PyBBbGJTY2hlbWUuSU5URVJOQUwpO1xuICAgIH1cblxuICAgIGNvbnN0IGN1c3RvbVJlc291cmNlID0gbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcmVzb3VyY2VUeXBlOiBLdWJlcm5ldGVzTWFuaWZlc3QuUkVTT1VSQ0VfVFlQRSxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgLy8gYHRvSnNvblN0cmluZ2AgZW5hYmxlcyBlbWJlZGRpbmcgQ0RLIHRva2VucyBpbiB0aGUgbWFuaWZlc3QgYW5kIHdpbGxcbiAgICAgICAgLy8gcmVuZGVyIGEgQ2xvdWRGb3JtYXRpb24tY29tcGF0aWJsZSBKU09OIHN0cmluZyAoc2ltaWxhciB0b1xuICAgICAgICAvLyBTdGVwRnVuY3Rpb25zLCBDbG91ZFdhdGNoIERhc2hib2FyZHMgZXRjKS5cbiAgICAgICAgTWFuaWZlc3Q6IHN0YWNrLnRvSnNvblN0cmluZyhwcm9wcy5tYW5pZmVzdCksXG4gICAgICAgIENsdXN0ZXJOYW1lOiBwcm9wcy5jbHVzdGVyLmNsdXN0ZXJOYW1lLFxuICAgICAgICBSb2xlQXJuOiBwcm92aWRlci5yb2xlQXJuLCAvLyBUT0RPOiBiYWtlIGludG8gcHJvdmlkZXIncyBlbnZpcm9ubWVudFxuICAgICAgICBQcnVuZUxhYmVsOiBwcnVuZUxhYmVsLFxuICAgICAgICBPdmVyd3JpdGU6IHByb3BzLm92ZXJ3cml0ZSxcbiAgICAgICAgU2tpcFZhbGlkYXRpb246IHByb3BzLnNraXBWYWxpZGF0aW9uLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMubm9kZS5kZWZhdWx0Q2hpbGQgPSBjdXN0b21SZXNvdXJjZS5ub2RlLmRlZmF1bHRDaGlsZDtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbmplY3RzIGEgZ2VuZXJhdGVkIHBydW5lIGxhYmVsIHRvIGFsbCByZXNvdXJjZXMgaW4gdGhpcyBtYW5pZmVzdC4gVGhlXG4gICAqIGxhYmVsIG5hbWUgd2lsbCBiZSBgYXdzY2RrLmVrcy9tYW5pZmVzdC1BRERSYCB3aGVyZSBgQUREUmAgaXMgdGhlIGFkZHJlc3NcbiAgICogb2YgdGhlIGNvbnN0cnVjdCBpbiB0aGUgY29uc3RydWN0IHRyZWUuXG4gICAqXG4gICAqIEByZXR1cm5zIHRoZSBsYWJlbCBuYW1lXG4gICAqL1xuICBwcml2YXRlIGluamVjdFBydW5lTGFiZWwobWFuaWZlc3Q6IFJlY29yZDxzdHJpbmcsIGFueT5bXSk6IHN0cmluZyB7XG4gICAgLy8gbWF4IGxhYmVsIG5hbWUgaXMgNjQgY2hhcnMgYW5kIGFkZHJzIGlzIGFsd2F5cyA0Mi5cbiAgICBjb25zdCBwcnVuZUxhYmVsID0gUFJVTkVfTEFCRUxfUFJFRklYICsgTm9kZS5vZih0aGlzKS5hZGRyO1xuXG4gICAgZm9yIChjb25zdCByZXNvdXJjZSBvZiBtYW5pZmVzdCkge1xuICAgICAgLy8gc2tpcCByZXNvdXJjZSBpZiBpdCdzIG5vdCBhbiBvYmplY3Qgb3IgaWYgaXQgZG9lcyBub3QgaGF2ZSBhIFwia2luZFwiXG4gICAgICBpZiAodHlwZW9mKHJlc291cmNlKSAhPT0gJ29iamVjdCcgfHwgIXJlc291cmNlLmtpbmQpIHtcbiAgICAgICAgY29udGludWU7XG4gICAgICB9XG5cbiAgICAgIGlmICghcmVzb3VyY2UubWV0YWRhdGEpIHtcbiAgICAgICAgcmVzb3VyY2UubWV0YWRhdGEgPSB7fTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFyZXNvdXJjZS5tZXRhZGF0YS5sYWJlbHMpIHtcbiAgICAgICAgcmVzb3VyY2UubWV0YWRhdGEubGFiZWxzID0ge307XG4gICAgICB9XG5cbiAgICAgIHJlc291cmNlLm1ldGFkYXRhLmxhYmVscyA9IHtcbiAgICAgICAgW3BydW5lTGFiZWxdOiAnJyxcbiAgICAgICAgLi4ucmVzb3VyY2UubWV0YWRhdGEubGFiZWxzLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICByZXR1cm4gcHJ1bmVMYWJlbDtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbmplY3QgdGhlIG5lY2Vzc2FyeSBpbmdyZXNzIGFubm9udGF0aW9ucyBpZiBwb3NzaWJsZSAoYW5kIHJlcXVlc3RlZCkuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLXNpZ3MuZ2l0aHViLmlvL2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXIvdjIuMi9ndWlkZS9pbmdyZXNzL2Fubm90YXRpb25zL1xuICAgKi9cbiAgcHJpdmF0ZSBpbmplY3RJbmdyZXNzQWxiQW5ub3RhdGlvbnMobWFuaWZlc3Q6IFJlY29yZDxzdHJpbmcsIGFueT5bXSwgc2NoZW1lOiBBbGJTY2hlbWUpIHtcblxuICAgIGZvciAoY29uc3QgcmVzb3VyY2Ugb2YgbWFuaWZlc3QpIHtcblxuICAgICAgLy8gc2tpcCByZXNvdXJjZSBpZiBpdCdzIG5vdCBhbiBvYmplY3Qgb3IgaWYgaXQgZG9lcyBub3QgaGF2ZSBhIFwia2luZFwiXG4gICAgICBpZiAodHlwZW9mKHJlc291cmNlKSAhPT0gJ29iamVjdCcgfHwgIXJlc291cmNlLmtpbmQpIHtcbiAgICAgICAgY29udGludWU7XG4gICAgICB9XG5cbiAgICAgIGlmIChyZXNvdXJjZS5raW5kID09PSAnSW5ncmVzcycpIHtcbiAgICAgICAgcmVzb3VyY2UubWV0YWRhdGEuYW5ub3RhdGlvbnMgPSB7XG4gICAgICAgICAgJ2t1YmVybmV0ZXMuaW8vaW5ncmVzcy5jbGFzcyc6ICdhbGInLFxuICAgICAgICAgICdhbGIuaW5ncmVzcy5rdWJlcm5ldGVzLmlvL3NjaGVtZSc6IHNjaGVtZSxcbiAgICAgICAgICAuLi5yZXNvdXJjZS5tZXRhZGF0YS5hbm5vdGF0aW9ucyxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9XG5cbiAgfVxufVxuIl19