<!--Thank you for opening a pull request!

We appreciate that you care about this project enough to fix it, and we welcome contributions. We will make every effort to review your pull request in a timely manner. Please help us by following the instructions below.
-->

## Purpose
<!--Describe the problem or feature.

Only address one feature per pull request. If the scope of a single pull request is small (less than 400 lines of code), reviewers can understand it more quickly.

Link to any existing Issues. Use the `Closes` keyword if this Pull closes any Issues.
-->

## Approach
<!--Describe how your changes address the problem.

Provide a brief summary of your algorithm(s) here.
-->

## Pre-Merge Checklists

### Submitter
- [ ] Write a helpfully descriptive pull request title.
- [ ] Organize changes into logically grouped commits with descriptive commit messages.
- [ ] Document all new functions.
- [ ] Click 'details' on the readthedocs check to view the updated docs.
- [ ] Write tests for new functions or explain why they are not needed.
- [ ] Address any complaints from pep8speaks.

### Reviewer
- [ ] Actually read all of the code.
- [ ] Run the new code yourself; the included tests should make this easy.
- [ ] Write a summary of the changes as you understand them.
- [ ] Thank the submitter.
