from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    IntegerType,
    DataType,
    FloatType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Sequence_QualitySchema:
    """
    Raw data describing a biological sequence.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Raw data describing a biological sequence.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        type: INDEL / SNP / Undefined variant.

        standardSequence: Gold standard sequence used for comparing against.

        start: Start position of the sequence. If the coordinate system is either 0-based or
            1-based, then start position is inclusive.

        end: End position of the sequence.If the coordinate system is 0-based then end is
            is exclusive and does not include the last position. If the coordinate system
            is 1-base, then end is inclusive and includes the last position.

        score: The score of an experimentally derived feature such as a p-value ([SO:0001685]
            (http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).

        method: Which method is used to get sequence quality.

        truthTP: True positives, from the perspective of the truth data, i.e. the number of
            sites in the Truth Call Set for which there are paths through the Query Call
            Set that are consistent with all of the alleles at this site, and for which
            there is an accurate genotype call for the event.

        queryTP: True positives, from the perspective of the query data, i.e. the number of
            sites in the Query Call Set for which there are paths through the Truth Call
            Set that are consistent with all of the alleles at this site, and for which
            there is an accurate genotype call for the event.

        truthFN: False negatives, i.e. the number of sites in the Truth Call Set for which
            there is no path through the Query Call Set that is consistent with all of the
            alleles at this site, or sites for which there is an inaccurate genotype call
            for the event. Sites with correct variant but incorrect genotype are counted
            here.

        queryFP: False positives, i.e. the number of sites in the Query Call Set for which
            there is no path through the Truth Call Set that is consistent with this site.
            Sites with correct variant but incorrect genotype are counted here.

        gtFP: The number of false positives where the non-REF alleles in the Truth and Query
            Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or
            similar).

        precision: QUERY.TP / (QUERY.TP + QUERY.FP).

        recall: TRUTH.TP / (TRUTH.TP + TRUTH.FN).

        fScore: Harmonic mean of Recall and Precision, computed as: 2 * precision * recall /
            (precision + recall).

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema

        if (
            max_recursion_limit
            and nesting_list.count("Sequence_Quality") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Sequence_Quality"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # INDEL / SNP / Undefined variant.
                StructField("type", StringType(), True),
                # Gold standard sequence used for comparing against.
                StructField(
                    "standardSequence",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Start position of the sequence. If the coordinate system is either 0-based or
                # 1-based, then start position is inclusive.
                StructField("start", IntegerType(), True),
                # End position of the sequence.If the coordinate system is 0-based then end is
                # is exclusive and does not include the last position. If the coordinate system
                # is 1-base, then end is inclusive and includes the last position.
                StructField("end", IntegerType(), True),
                # The score of an experimentally derived feature such as a p-value ([SO:0001685]
                # (http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).
                StructField(
                    "score",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Which method is used to get sequence quality.
                StructField(
                    "method",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # True positives, from the perspective of the truth data, i.e. the number of
                # sites in the Truth Call Set for which there are paths through the Query Call
                # Set that are consistent with all of the alleles at this site, and for which
                # there is an accurate genotype call for the event.
                StructField("truthTP", FloatType(), True),
                # True positives, from the perspective of the query data, i.e. the number of
                # sites in the Query Call Set for which there are paths through the Truth Call
                # Set that are consistent with all of the alleles at this site, and for which
                # there is an accurate genotype call for the event.
                StructField("queryTP", FloatType(), True),
                # False negatives, i.e. the number of sites in the Truth Call Set for which
                # there is no path through the Query Call Set that is consistent with all of the
                # alleles at this site, or sites for which there is an inaccurate genotype call
                # for the event. Sites with correct variant but incorrect genotype are counted
                # here.
                StructField("truthFN", FloatType(), True),
                # False positives, i.e. the number of sites in the Query Call Set for which
                # there is no path through the Truth Call Set that is consistent with this site.
                # Sites with correct variant but incorrect genotype are counted here.
                StructField("queryFP", FloatType(), True),
                # The number of false positives where the non-REF alleles in the Truth and Query
                # Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or
                # similar).
                StructField("gtFP", FloatType(), True),
                # QUERY.TP / (QUERY.TP + QUERY.FP).
                StructField("precision", FloatType(), True),
                # TRUTH.TP / (TRUTH.TP + TRUTH.FN).
                StructField("recall", FloatType(), True),
                # Harmonic mean of Recall and Precision, computed as: 2 * precision * recall /
                # (precision + recall).
                StructField("fScore", FloatType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
