"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var LifecycleLabel;
(function (LifecycleLabel) {
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
const DEFAULT_NODE_SELECTOR = { lifecycle: LifecycleLabel.SPOT };
function spotInterruptHandler(nodeSelector = DEFAULT_NODE_SELECTOR) {
    return [
        {
            kind: 'ClusterRole',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default'
            },
            rules: [
                {
                    apiGroups: [
                        'apps'
                    ],
                    resources: [
                        'daemonsets'
                    ],
                    verbs: [
                        'get',
                        'delete'
                    ]
                },
                {
                    apiGroups: [
                        ''
                    ],
                    resources: [
                        '*'
                    ],
                    verbs: [
                        '*'
                    ]
                },
                {
                    apiGroups: [
                        'rbac.authorization.k8s.io'
                    ],
                    resources: [
                        '*'
                    ],
                    verbs: [
                        '*'
                    ]
                },
                {
                    apiGroups: [
                        'apiextensions.k8s.io'
                    ],
                    resources: [
                        'customresourcedefinitions'
                    ],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                        'create',
                        'delete'
                    ]
                }
            ]
        },
        {
            apiVersion: 'v1',
            kind: 'ServiceAccount',
            metadata: {
                name: 'node-termination-handler'
            }
        },
        {
            kind: 'ClusterRoleBinding',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default'
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: 'node-termination-handler',
                    namespace: 'default'
                }
            ],
            roleRef: {
                kind: 'ClusterRole',
                name: 'node-termination-handler',
                apiGroup: 'rbac.authorization.k8s.io'
            }
        },
        {
            apiVersion: 'apps/v1beta2',
            kind: 'DaemonSet',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default'
            },
            spec: {
                selector: {
                    matchLabels: {
                        app: 'node-termination-handler'
                    }
                },
                template: {
                    metadata: {
                        labels: {
                            app: 'node-termination-handler'
                        }
                    },
                    spec: {
                        serviceAccountName: 'node-termination-handler',
                        containers: [
                            {
                                name: 'node-termination-handler',
                                image: 'amazon/aws-node-termination-handler:v1.0.0',
                                imagePullPolicy: 'Always',
                                env: [
                                    {
                                        name: 'NODE_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'spec.nodeName'
                                            }
                                        }
                                    },
                                    {
                                        name: 'POD_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.name'
                                            }
                                        }
                                    },
                                    {
                                        name: 'NAMESPACE',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.namespace'
                                            }
                                        }
                                    },
                                    {
                                        name: 'SPOT_POD_IP',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'status.podIP'
                                            }
                                        }
                                    }
                                ],
                                resources: {
                                    requests: {
                                        memory: '64Mi',
                                        cpu: '50m'
                                    },
                                    limits: {
                                        memory: '128Mi',
                                        cpu: '100m'
                                    }
                                }
                            }
                        ],
                        nodeSelector
                    }
                }
            }
        }
    ];
}
exports.spotInterruptHandler = spotInterruptHandler;
//# sourceMappingURL=data:application/json;base64,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