"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cloudformation_1 = require("@aws-cdk/aws-cloudformation");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(stack);
        new aws_cloudformation_1.CustomResource(this, 'Resource', {
            provider: provider.provider,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._getKubectlCreationRoleArn(provider.role),
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC
            }
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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