"use strict";
// tslint:disable:no-console
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const cluster_1 = require("./cluster");
const consts = require("./consts");
const fargate_1 = require("./fargate");
aws.config.logger = console;
let eks;
const defaultEksClient = {
    createCluster: req => getEksClient().createCluster(req).promise(),
    deleteCluster: req => getEksClient().deleteCluster(req).promise(),
    describeCluster: req => getEksClient().describeCluster(req).promise(),
    updateClusterConfig: req => getEksClient().updateClusterConfig(req).promise(),
    updateClusterVersion: req => getEksClient().updateClusterVersion(req).promise(),
    createFargateProfile: req => getEksClient().createFargateProfile(req).promise(),
    deleteFargateProfile: req => getEksClient().deleteFargateProfile(req).promise(),
    describeFargateProfile: req => getEksClient().describeFargateProfile(req).promise(),
    configureAssumeRole: req => {
        console.log(JSON.stringify({ assumeRole: req }, undefined, 2));
        const creds = new aws.ChainableTemporaryCredentials({
            params: req
        });
        eks = new aws.EKS({ credentials: creds });
    }
};
function getEksClient() {
    if (!eks) {
        throw new Error('EKS client not initialized (call "configureAssumeRole")');
    }
    return eks;
}
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case consts.CLUSTER_RESOURCE_TYPE: return new cluster_1.ClusterResourceHandler(defaultEksClient, event);
        case consts.FARGATE_PROFILE_RESOURCE_TYPE: return new fargate_1.FargateProfileResourceHandler(defaultEksClient, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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