import gensim
from compling.embeddings.documents.dembeddings import DocumentEmbeddings
from typing import *


class Doc2vec(DocumentEmbeddings):
    """
    Doc2vec is an unsupervised algorithm to generate vectors for sentence/paragraphs/documents. The algorithm is an adaptation of word2vec which can generate vectors for words.

    The vectors generated by doc2vec can be used for tasks like finding similarity between sentences/paragraphs/documents.
    """
    def __init__(self, index: Iterable[dict]=None, id_field:Union[str, List[str]]=None, output:str=None, text_field='text', skipgram_ws: int = None, processing:Callable=None):
        super().__init__(output=output, index=index, text_field=text_field, skipgram_ws=skipgram_ws, tag=True,
                         module=gensim.models.doc2vec.Doc2Vec, id_field=id_field, processing=processing)


