"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.rpc.status_pb2
import ondewo.nlu.context_pb2
import ondewo.nlu.session_pb2
import ondewo.s2t.speech_to_text_pb2
import ondewo.t2s.text_to_speech_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ControlStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ControlStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ControlStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OK: _ControlStatus.ValueType  # 0
    """Status that control stream is ok"""

    EMERGENCY_STOP: _ControlStatus.ValueType  # 1
    """Status that control stream needs to stop immediately"""

class ControlStatus(_ControlStatus, metaclass=_ControlStatusEnumTypeWrapper):
    """Control status"""
    pass

OK: ControlStatus.ValueType  # 0
"""Status that control stream is ok"""

EMERGENCY_STOP: ControlStatus.ValueType  # 1
"""Status that control stream needs to stop immediately"""

global___ControlStatus = ControlStatus


class _ControlMessageServiceName:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ControlMessageServiceNameEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ControlMessageServiceName.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWNNAME: _ControlMessageServiceName.ValueType  # 0
    """Unknown control message service name"""

    ondewo_s2t: _ControlMessageServiceName.ValueType  # 1
    """Speech-2-Text control message service name"""

    ondewo_t2s: _ControlMessageServiceName.ValueType  # 2
    """Text-2-Speech control message service name"""

    ondewo_nlu: _ControlMessageServiceName.ValueType  # 3
    """NLU control message service name"""

    ondewo_sip: _ControlMessageServiceName.ValueType  # 4
    """SIP control message service name"""

class ControlMessageServiceName(_ControlMessageServiceName, metaclass=_ControlMessageServiceNameEnumTypeWrapper):
    """Control message services"""
    pass

UNKNOWNNAME: ControlMessageServiceName.ValueType  # 0
"""Unknown control message service name"""

ondewo_s2t: ControlMessageServiceName.ValueType  # 1
"""Speech-2-Text control message service name"""

ondewo_t2s: ControlMessageServiceName.ValueType  # 2
"""Text-2-Speech control message service name"""

ondewo_nlu: ControlMessageServiceName.ValueType  # 3
"""NLU control message service name"""

ondewo_sip: ControlMessageServiceName.ValueType  # 4
"""SIP control message service name"""

global___ControlMessageServiceName = ControlMessageServiceName


class _ControlMessageServiceMethod:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ControlMessageServiceMethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ControlMessageServiceMethod.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWNMETHOD: _ControlMessageServiceMethod.ValueType  # 0
    """Unknown method (default)"""

    update_config: _ControlMessageServiceMethod.ValueType  # 1
    """CSI: update configuration

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_s2t",
       "method": "update_config",
       "parameters": [
           {
               // Speech2TextConfig object
               “s2tPipelineId” : “s2t_pipeline_german_1”,
               “languageModelName” : “language_model_german”
           },
           {
                // condition_start object => should take effect immediately
                "type": "immediate",
                “value”: “0”
           },
           {
                // condition_end object - s2t config will be changed back to
                // last valid configuration after 10 interactions of user with
                // the AI agent
                "type": "interactions",
    	           "value": 10
           },
       ]
    }
    </code></pre>
    """

    undo_config: _ControlMessageServiceMethod.ValueType  # 2
    """CSI: undo previous configuration update

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_s2t",
       "method": "undo_config",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
    	          // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    reset_config: _ControlMessageServiceMethod.ValueType  # 3
    """CSI: reset configuration to default

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_s2t",
       "method": "reset_config",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    end_call: _ControlMessageServiceMethod.ValueType  # 4
    """SIP: end conversation / hang up call

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "end_call",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    transfer_call: _ControlMessageServiceMethod.ValueType  # 5
    """SIP: transfer call

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "transfer_call",
       "parameters": [
           {
    	 	      "transfer_id": "+43123456789@127.0.0.10:5060",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    play_wav_files: _ControlMessageServiceMethod.ValueType  # 6
    """SIP: play wav files on the call

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "  "play_wav_files",
       "parameters": [
           {
    	 	      "wav_files":  [
                   <bytes_of_file_1>,
                   <bytes_of_file_2>,
                   <bytes_of_file_3>,
               ]
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    play_text: _ControlMessageServiceMethod.ValueType  # 7
    """SIP: play a certain text on the phone based on Text-2-Speech synthesis

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "play_text",
       "parameters": [
           {
    	 	      "text": "Welcome from ONDEWO AI Agent! How are you today?",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    mute: _ControlMessageServiceMethod.ValueType  # 8
    """SIP: mute microphone

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "mute",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    un_mute: _ControlMessageServiceMethod.ValueType  # 9
    """SIP: unmute microphone

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_sip",
       "method": "un_mute",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    stop_all_control_messages: _ControlMessageServiceMethod.ValueType  # 10
    """CSI: stop the execution of all running and scheduled control messages

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "",    <= empty string since it is for all services / no specific service
       "method": "stop_all_control_messages",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    train_agent: _ControlMessageServiceMethod.ValueType  # 11
    """NLU: train agent

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "train_agent",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    cancel_train_agent: _ControlMessageServiceMethod.ValueType  # 12
    """NLU: cancel the ongoing agent

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "cancel_train_agent",
       "parameters": [
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    delete_session: _ControlMessageServiceMethod.ValueType  # 13
    """NLU: delete session all all session-related information

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "delete_session",
       "parameters": [
           {
    	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    delete_all_contexts: _ControlMessageServiceMethod.ValueType  # 14
    """NLU: delete all context information in the current session

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "delete_all_contexts",
       "parameters": [
           {
    	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    create_context: _ControlMessageServiceMethod.ValueType  # 15
    """NLU: create a context based on the provided contextual information in the current session

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "create_context",
       "parameters": [
           {
    	 	      "context": {           <== <NLU Context Object as JSON object>
                   name": "projects/db46dcf8-2d2c-4115-ac38-eff443ea0e72/agent/sessions/ss2ea1a20-0784-442b-93c0-eb9e2469420e/contexts/78ea1a20-0784-442b-93c0-eb9e2469420e",
                   ...,
               }
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    update_context: _ControlMessageServiceMethod.ValueType  # 16
    """NLU: update an existing context based on the provided contextual information in the current session

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "update_context",
       "parameters": [
           {
    	 	      "context": {           <== <NLU Context Object as JSON object>
                   name": "projects/db46dcf8-2d2c-4115-ac38-eff443ea0e72/agent/sessions/2dea1a20-0784-442b-93c0-eb9e2469420e/contexts/78ea1a20-0784-442b-93c0-eb9e2469420e",
                   ...,
               }
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    delete_context: _ControlMessageServiceMethod.ValueType  # 17
    """NLU: delete an existing context including all contextual information in the current session

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
       "service": "ondewo_nlu",
       "method": "delete_context",
       "parameters": [
           {
    	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
    	 	      "context_name": "78ea1a20-0784-442b-93c0-eb9e2469420e",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

    detect_intent: _ControlMessageServiceMethod.ValueType  # 18
    """NLU: execute a detect intent request based on the provided information in the current session
    {
       "service": "ondewo_nlu",
       "method": "detect_intent",
       "parameters": [
           {
    	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
    	 	      "text": "Are you an artificial intelligence?",
           },
           {
    	 	      // condition_start object
           },
           {
    	 	      // condition_end object (OPTIONAL) - for permanent change
               // no condition_end needs to be supplied i.e.
    		      // this parameter is missing or empty “{}”
           },
       ]
    }
    </code></pre>
    """

class ControlMessageServiceMethod(_ControlMessageServiceMethod, metaclass=_ControlMessageServiceMethodEnumTypeWrapper):
    """Control message methods to control services during a conversation"""
    pass

UNKNOWNMETHOD: ControlMessageServiceMethod.ValueType  # 0
"""Unknown method (default)"""

update_config: ControlMessageServiceMethod.ValueType  # 1
"""CSI: update configuration

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_s2t",
   "method": "update_config",
   "parameters": [
       {
           // Speech2TextConfig object
           “s2tPipelineId” : “s2t_pipeline_german_1”,
           “languageModelName” : “language_model_german”
       },
       {
            // condition_start object => should take effect immediately
            "type": "immediate",
            “value”: “0”
       },
       {
            // condition_end object - s2t config will be changed back to
            // last valid configuration after 10 interactions of user with
            // the AI agent
            "type": "interactions",
	           "value": 10
       },
   ]
}
</code></pre>
"""

undo_config: ControlMessageServiceMethod.ValueType  # 2
"""CSI: undo previous configuration update

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_s2t",
   "method": "undo_config",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
	          // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

reset_config: ControlMessageServiceMethod.ValueType  # 3
"""CSI: reset configuration to default

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_s2t",
   "method": "reset_config",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

end_call: ControlMessageServiceMethod.ValueType  # 4
"""SIP: end conversation / hang up call

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "end_call",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

transfer_call: ControlMessageServiceMethod.ValueType  # 5
"""SIP: transfer call

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "transfer_call",
   "parameters": [
       {
	 	      "transfer_id": "+43123456789@127.0.0.10:5060",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

play_wav_files: ControlMessageServiceMethod.ValueType  # 6
"""SIP: play wav files on the call

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "  "play_wav_files",
   "parameters": [
       {
	 	      "wav_files":  [
               <bytes_of_file_1>,
               <bytes_of_file_2>,
               <bytes_of_file_3>,
           ]
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

play_text: ControlMessageServiceMethod.ValueType  # 7
"""SIP: play a certain text on the phone based on Text-2-Speech synthesis

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "play_text",
   "parameters": [
       {
	 	      "text": "Welcome from ONDEWO AI Agent! How are you today?",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

mute: ControlMessageServiceMethod.ValueType  # 8
"""SIP: mute microphone

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "mute",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

un_mute: ControlMessageServiceMethod.ValueType  # 9
"""SIP: unmute microphone

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_sip",
   "method": "un_mute",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

stop_all_control_messages: ControlMessageServiceMethod.ValueType  # 10
"""CSI: stop the execution of all running and scheduled control messages

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "",    <= empty string since it is for all services / no specific service
   "method": "stop_all_control_messages",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

train_agent: ControlMessageServiceMethod.ValueType  # 11
"""NLU: train agent

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "train_agent",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

cancel_train_agent: ControlMessageServiceMethod.ValueType  # 12
"""NLU: cancel the ongoing agent

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "cancel_train_agent",
   "parameters": [
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

delete_session: ControlMessageServiceMethod.ValueType  # 13
"""NLU: delete session all all session-related information

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "delete_session",
   "parameters": [
       {
	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

delete_all_contexts: ControlMessageServiceMethod.ValueType  # 14
"""NLU: delete all context information in the current session

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "delete_all_contexts",
   "parameters": [
       {
	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

create_context: ControlMessageServiceMethod.ValueType  # 15
"""NLU: create a context based on the provided contextual information in the current session

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "create_context",
   "parameters": [
       {
	 	      "context": {           <== <NLU Context Object as JSON object>
               name": "projects/db46dcf8-2d2c-4115-ac38-eff443ea0e72/agent/sessions/ss2ea1a20-0784-442b-93c0-eb9e2469420e/contexts/78ea1a20-0784-442b-93c0-eb9e2469420e",
               ...,
           }
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

update_context: ControlMessageServiceMethod.ValueType  # 16
"""NLU: update an existing context based on the provided contextual information in the current session

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "update_context",
   "parameters": [
       {
	 	      "context": {           <== <NLU Context Object as JSON object>
               name": "projects/db46dcf8-2d2c-4115-ac38-eff443ea0e72/agent/sessions/2dea1a20-0784-442b-93c0-eb9e2469420e/contexts/78ea1a20-0784-442b-93c0-eb9e2469420e",
               ...,
           }
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

delete_context: ControlMessageServiceMethod.ValueType  # 17
"""NLU: delete an existing context including all contextual information in the current session

<p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
<pre><code>
{
   "service": "ondewo_nlu",
   "method": "delete_context",
   "parameters": [
       {
	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
	 	      "context_name": "78ea1a20-0784-442b-93c0-eb9e2469420e",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

detect_intent: ControlMessageServiceMethod.ValueType  # 18
"""NLU: execute a detect intent request based on the provided information in the current session
{
   "service": "ondewo_nlu",
   "method": "detect_intent",
   "parameters": [
       {
	 	      "session_id": "97ea1a20-0784-442b-93c0-eb9e2469420e",
	 	      "text": "Are you an artificial intelligence?",
       },
       {
	 	      // condition_start object
       },
       {
	 	      // condition_end object (OPTIONAL) - for permanent change
           // no condition_end needs to be supplied i.e.
		      // this parameter is missing or empty “{}”
       },
   ]
}
</code></pre>
"""

global___ControlMessageServiceMethod = ControlMessageServiceMethod


class _ConditionType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ConditionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConditionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWTYPE: _ConditionType.ValueType  # 0
    """Unknown type"""

    immediate: _ConditionType.ValueType  # 1
    """Immediate execution of the control message
    Example value need be given as a string in the format: <pre><code>value="5"</code></pre>
    """

    duration: _ConditionType.ValueType  # 2
    """Duration in number of seconds after a control message should be executed,
    Example value need be given as a string in the format: <pre><code>value="10"</code></pre>
    """

    datetime: _ConditionType.ValueType  # 3
    """Date and time when a control message should be executed,
    Example value need be given as a string in the format: <pre><code>value="2021-12-23T13:45:00.000Z"</code></pre>
    """

    interactions: _ConditionType.ValueType  # 4
    """Number of interactions of the user with an ONDEWO AI agent after a control message should be executed
    Example value need be given as a string in the format: <pre><code>value="4"</code></pre>
    """

class ConditionType(_ConditionType, metaclass=_ConditionTypeEnumTypeWrapper):
    """Type of condition that need to be satisfied to execute a control message"""
    pass

UNKNOWTYPE: ConditionType.ValueType  # 0
"""Unknown type"""

immediate: ConditionType.ValueType  # 1
"""Immediate execution of the control message
Example value need be given as a string in the format: <pre><code>value="5"</code></pre>
"""

duration: ConditionType.ValueType  # 2
"""Duration in number of seconds after a control message should be executed,
Example value need be given as a string in the format: <pre><code>value="10"</code></pre>
"""

datetime: ConditionType.ValueType  # 3
"""Date and time when a control message should be executed,
Example value need be given as a string in the format: <pre><code>value="2021-12-23T13:45:00.000Z"</code></pre>
"""

interactions: ConditionType.ValueType  # 4
"""Number of interactions of the user with an ONDEWO AI agent after a control message should be executed
Example value need be given as a string in the format: <pre><code>value="4"</code></pre>
"""

global___ConditionType = ConditionType


class S2sPipeline(google.protobuf.message.Message):
    """The top-level message sent by client to `CreateS2sPipeline` and `UpdateS2sPipeline` endpoints and received from
    `GetS2sPipeline` endpoint.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    S2T_PIPELINE_ID_FIELD_NUMBER: builtins.int
    NLU_PROJECT_ID_FIELD_NUMBER: builtins.int
    NLU_LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    T2S_PIPELINE_ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Required. CSI pipeline identifier consisting of S2T, NLU and T2S configuration. ID can be any non-empty string."""

    s2t_pipeline_id: typing.Text
    """Required. S2T pipeline ID, e.g. "german_general" """

    nlu_project_id: typing.Text
    """Required. NLU project ID, usually a hash, e.g. "ae33586b-x2s2-494a-aa73-1af0589cfc56"."""

    nlu_language_code: typing.Text
    """Required. Language code present in the corresponding NLU project, e.g. "de"."""

    t2s_pipeline_id: typing.Text
    """Required. T2S pipeline ID, e.g. "kerstin"."""

    def __init__(self,
        *,
        id: typing.Text = ...,
        s2t_pipeline_id: typing.Text = ...,
        nlu_project_id: typing.Text = ...,
        nlu_language_code: typing.Text = ...,
        t2s_pipeline_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id","nlu_language_code",b"nlu_language_code","nlu_project_id",b"nlu_project_id","s2t_pipeline_id",b"s2t_pipeline_id","t2s_pipeline_id",b"t2s_pipeline_id"]) -> None: ...
global___S2sPipeline = S2sPipeline

class S2sPipelineId(google.protobuf.message.Message):
    """The top-level message sent by client to `GetS2sPipeline` and `DeleteS2sPipeline` endpoints."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Required. CSI pipeline identifier."""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___S2sPipelineId = S2sPipelineId

class ListS2sPipelinesRequest(google.protobuf.message.Message):
    """The top-level message sent by client to `ListS2sPipelines` endpoint. Currently without arguments.
    TODO: add filtering options
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(self,
        ) -> None: ...
global___ListS2sPipelinesRequest = ListS2sPipelinesRequest

class ListS2sPipelinesResponse(google.protobuf.message.Message):
    """The top-level message received from `ListS2sPipelines` endpoint."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PIPELINES_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S2sPipeline]:
        """Collection of S2S pipelines of the server."""
        pass
    def __init__(self,
        *,
        pipelines: typing.Optional[typing.Iterable[global___S2sPipeline]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipelines",b"pipelines"]) -> None: ...
global___ListS2sPipelinesResponse = ListS2sPipelinesResponse

class S2sStreamRequest(google.protobuf.message.Message):
    """The top-level message sent by the client to the
    `S2sStream` method.

    Multiple request messages should be sent in order:

    1.  The first message must contain `pipeline_id` and can contain `session_id` or `initial_intent_display_name`.
        The message must not contain `audio` nor `end_of_stream`.

    2.  All subsequent messages must contain `audio`. If `end_of_stream` is `true`, the stream is closed.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    AUDIO_FIELD_NUMBER: builtins.int
    END_OF_STREAM_FIELD_NUMBER: builtins.int
    INITIAL_INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    pipeline_id: typing.Text
    """Optional. The CSI pipeline ID specified in the initial request."""

    session_id: typing.Text
    """Optional. The session or call ID specified in the initial request. It’s up to the API caller to choose
    an appropriate string. It can be a random number or some type of user identifier (preferably hashed).
    """

    audio: builtins.bytes
    """Optional. The input audio content to be recognized.

    If `true`, the recognizer will not return
    any further hypotheses about this piece of the audio. May only be populated
    for `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
    """

    end_of_stream: builtins.bool
    initial_intent_display_name: typing.Text
    """Optional. Intent display name to trigger in NLU system in the beginning of the conversation."""

    def __init__(self,
        *,
        pipeline_id: typing.Text = ...,
        session_id: typing.Text = ...,
        audio: builtins.bytes = ...,
        end_of_stream: builtins.bool = ...,
        initial_intent_display_name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio",b"audio","end_of_stream",b"end_of_stream","initial_intent_display_name",b"initial_intent_display_name","pipeline_id",b"pipeline_id","session_id",b"session_id"]) -> None: ...
global___S2sStreamRequest = S2sStreamRequest

class S2sStreamResponse(google.protobuf.message.Message):
    """The top-level message returned from the
    `S2sStream` method.

    A response message is returned for each utterance of the input stream. It contains the full response from NLU system
    in `detect_intent_response` or the full T2S response in `synthesize_response`.
    Multiple response messages can be returned in order:

    1.  The first response message for an input utterance contains response from NLU system `detect_intent_response`
        with detected intent and N fulfillment messages (N >= 0).

    2.  The next N response messages contain for each fulfillment message one of the following:
         a. T2S response `synthesize_response` with synthesized audio
         b. SIP trigger message `sip_trigger` with SIP trigger extracted from the fulfillment message
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETECT_INTENT_RESPONSE_FIELD_NUMBER: builtins.int
    SYNTHESIZE_RESPONSE_FIELD_NUMBER: builtins.int
    SIP_TRIGGER_FIELD_NUMBER: builtins.int
    @property
    def detect_intent_response(self) -> ondewo.nlu.session_pb2.DetectIntentResponse:
        """full NLU detect intent response"""
        pass
    @property
    def synthesize_response(self) -> ondewo.t2s.text_to_speech_pb2.SynthesizeResponse:
        """full T2S synthesize response"""
        pass
    @property
    def sip_trigger(self) -> global___SipTrigger:
        """SIP trigger message"""
        pass
    def __init__(self,
        *,
        detect_intent_response: typing.Optional[ondewo.nlu.session_pb2.DetectIntentResponse] = ...,
        synthesize_response: typing.Optional[ondewo.t2s.text_to_speech_pb2.SynthesizeResponse] = ...,
        sip_trigger: typing.Optional[global___SipTrigger] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["detect_intent_response",b"detect_intent_response","response",b"response","sip_trigger",b"sip_trigger","synthesize_response",b"synthesize_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["detect_intent_response",b"detect_intent_response","response",b"response","sip_trigger",b"sip_trigger","synthesize_response",b"synthesize_response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response",b"response"]) -> typing.Optional[typing_extensions.Literal["detect_intent_response","synthesize_response","sip_trigger"]]: ...
global___S2sStreamResponse = S2sStreamResponse

class SipTrigger(google.protobuf.message.Message):
    """SIP trigger message"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _SipTriggerType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _SipTriggerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SipTrigger._SipTriggerType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: SipTrigger._SipTriggerType.ValueType  # 0
        """should never be used"""

        HANGUP: SipTrigger._SipTriggerType.ValueType  # 1
        """hard hangup"""

        HUMAN_HANDOVER: SipTrigger._SipTriggerType.ValueType  # 2
        """handover to human"""

        SEND_NOW: SipTrigger._SipTriggerType.ValueType  # 3
        """send now"""

        PAUSE: SipTrigger._SipTriggerType.ValueType  # 4
        """pause"""

    class SipTriggerType(_SipTriggerType, metaclass=_SipTriggerTypeEnumTypeWrapper):
        """type of the SIP trigger"""
        pass

    UNSPECIFIED: SipTrigger.SipTriggerType.ValueType  # 0
    """should never be used"""

    HANGUP: SipTrigger.SipTriggerType.ValueType  # 1
    """hard hangup"""

    HUMAN_HANDOVER: SipTrigger.SipTriggerType.ValueType  # 2
    """handover to human"""

    SEND_NOW: SipTrigger.SipTriggerType.ValueType  # 3
    """send now"""

    PAUSE: SipTrigger.SipTriggerType.ValueType  # 4
    """pause"""


    TYPE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    type: global___SipTrigger.SipTriggerType.ValueType
    @property
    def content(self) -> google.protobuf.struct_pb2.Struct:
        """extra parameters for the trigger"""
        pass
    def __init__(self,
        *,
        type: global___SipTrigger.SipTriggerType.ValueType = ...,
        content: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["content",b"content"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content",b"content","type",b"type"]) -> None: ...
global___SipTrigger = SipTrigger

class CheckUpstreamHealthResponse(google.protobuf.message.Message):
    """Health checks"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    S2T_STATUS_FIELD_NUMBER: builtins.int
    NLU_STATUS_FIELD_NUMBER: builtins.int
    T2S_STATUS_FIELD_NUMBER: builtins.int
    @property
    def s2t_status(self) -> google.rpc.status_pb2.Status:
        """Health checks for Speech-2-Text"""
        pass
    @property
    def nlu_status(self) -> google.rpc.status_pb2.Status:
        """Health checks for NLU"""
        pass
    @property
    def t2s_status(self) -> google.rpc.status_pb2.Status:
        """Health checks for Text-2-Speech"""
        pass
    def __init__(self,
        *,
        s2t_status: typing.Optional[google.rpc.status_pb2.Status] = ...,
        nlu_status: typing.Optional[google.rpc.status_pb2.Status] = ...,
        t2s_status: typing.Optional[google.rpc.status_pb2.Status] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["nlu_status",b"nlu_status","s2t_status",b"s2t_status","t2s_status",b"t2s_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["nlu_status",b"nlu_status","s2t_status",b"s2t_status","t2s_status",b"t2s_status"]) -> None: ...
global___CheckUpstreamHealthResponse = CheckUpstreamHealthResponse

class ControlStreamRequest(google.protobuf.message.Message):
    """Control stream message"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(self,
        ) -> None: ...
global___ControlStreamRequest = ControlStreamRequest

class ControlStreamResponse(google.protobuf.message.Message):
    """Control stream response message"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONTROL_STATUS_FIELD_NUMBER: builtins.int
    control_status: global___ControlStatus.ValueType
    """Control status"""

    def __init__(self,
        *,
        control_status: global___ControlStatus.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["control_status",b"control_status"]) -> None: ...
global___ControlStreamResponse = ControlStreamResponse

class SetControlStatusRequest(google.protobuf.message.Message):
    """Request to set control status"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONTROL_STATUS_FIELD_NUMBER: builtins.int
    control_status: global___ControlStatus.ValueType
    """Control status"""

    def __init__(self,
        *,
        control_status: global___ControlStatus.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["control_status",b"control_status"]) -> None: ...
global___SetControlStatusRequest = SetControlStatusRequest

class SetControlStatusResponse(google.protobuf.message.Message):
    """Response of setting the control status with the old and new status objects"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    OLD_CONTROL_STATUS_FIELD_NUMBER: builtins.int
    NEW_CONTROL_STATUS_FIELD_NUMBER: builtins.int
    old_control_status: global___ControlStatus.ValueType
    """Previous 'old' control status"""

    new_control_status: global___ControlStatus.ValueType
    """Current 'new' control status"""

    def __init__(self,
        *,
        old_control_status: global___ControlStatus.ValueType = ...,
        new_control_status: global___ControlStatus.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["new_control_status",b"new_control_status","old_control_status",b"old_control_status"]) -> None: ...
global___SetControlStatusResponse = SetControlStatusResponse

class Condition(google.protobuf.message.Message):
    """A condition message with its type and value

    A Condition can be of various types.
    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    immediate execution
    {
       "type": "immediate"
    }
    </code></pre>

    number of interactions of the user with the AI agent
    <pre><code>
    {
       "type": "interactions",
       "value": “10”
    }
    </code></pre>

     number of seconds
    <pre><code>
    {
       "type": "duration",
       "value": “3600”
    }
    </code></pre>

     at a specific date and time
    <pre><code>
    {
       "type": "datetime",
       "value": "2021-12-23T13:45:00.000Z"
    }
    </code></pre>
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    type: global___ConditionType.ValueType
    """Condition type"""

    value: typing.Text
    """Value of the condition.
    Examples of conditions values based on the condition type are given in the <pre>ConditionType</pre> documentation
    """

    def __init__(self,
        *,
        type: global___ConditionType.ValueType = ...,
        value: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type",b"type","value",b"value"]) -> None: ...
global___Condition = Condition

class ControlMessageServiceParameters(google.protobuf.message.Message):
    """Parameters of the control message passed to the service specified in the control message"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    T2S_CONFIG_FIELD_NUMBER: builtins.int
    S2T_CONFIG_FIELD_NUMBER: builtins.int
    TRANSFER_ID_FIELD_NUMBER: builtins.int
    WAV_FILES_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    CONTEXT_NAME_FIELD_NUMBER: builtins.int
    CONDITION_START_FIELD_NUMBER: builtins.int
    CONDITION_END_FIELD_NUMBER: builtins.int
    @property
    def t2s_config(self) -> ondewo.t2s.text_to_speech_pb2.RequestConfig:
        """Text-2-Speech: configuration to control the synthesis of a text into audio"""
        pass
    @property
    def s2t_config(self) -> ondewo.s2t.speech_to_text_pb2.TranscribeRequestConfig:
        """Speech-2-Text: configuration to control the recognition of text based on human voice audio"""
        pass
    transfer_id: typing.Text
    """SIP: callee id to transfer call to"""

    @property
    def wav_files(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """SIP: bytes of audio files to play to a caller"""
        pass
    text: typing.Text
    """text, e.g. for NLU detect intent response or Text-2-Speech voice synthesis"""

    @property
    def context(self) -> ondewo.nlu.context_pb2.Context:
        """NLU: context for creating, updating or deleting contextual information from a NLU session"""
        pass
    session_id: typing.Text
    """NLU: the session id of a NLU session"""

    context_name: typing.Text
    """NLU: the name of the context of a NLU session"""

    @property
    def condition_start(self) -> global___Condition:
        """CSI: the condition that defines when a control message should be executed"""
        pass
    @property
    def condition_end(self) -> global___Condition:
        """CSI: the condition that defines when a control message should stop its execution"""
        pass
    def __init__(self,
        *,
        t2s_config: typing.Optional[ondewo.t2s.text_to_speech_pb2.RequestConfig] = ...,
        s2t_config: typing.Optional[ondewo.s2t.speech_to_text_pb2.TranscribeRequestConfig] = ...,
        transfer_id: typing.Text = ...,
        wav_files: typing.Optional[typing.Iterable[builtins.bytes]] = ...,
        text: typing.Text = ...,
        context: typing.Optional[ondewo.nlu.context_pb2.Context] = ...,
        session_id: typing.Text = ...,
        context_name: typing.Text = ...,
        condition_start: typing.Optional[global___Condition] = ...,
        condition_end: typing.Optional[global___Condition] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["condition_end",b"condition_end","condition_start",b"condition_start","config",b"config","context",b"context","s2t_config",b"s2t_config","t2s_config",b"t2s_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["condition_end",b"condition_end","condition_start",b"condition_start","config",b"config","context",b"context","context_name",b"context_name","s2t_config",b"s2t_config","session_id",b"session_id","t2s_config",b"t2s_config","text",b"text","transfer_id",b"transfer_id","wav_files",b"wav_files"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["config",b"config"]) -> typing.Optional[typing_extensions.Literal["t2s_config","s2t_config"]]: ...
global___ControlMessageServiceParameters = ControlMessageServiceParameters

class ControlMessage(google.protobuf.message.Message):
    """A control message

    <p>Example of a JSON how to invoke a control message via ONDEWO RABBITMQ service:</p>
    <pre><code>
    {
      "service": "<SERVICE_NAME>", 			// e.g. ondewo_s2t
      "method": "<SERVICE_CONTROL_METHOD>", 	// e.g. update_config
      "parameters": [
          // primitive data types and JSON objects are possible
          1,
          1.0,
          -2.0,
          “string”,
          true,
      	 {
              // parameter JSON object
          },
          {
              // Condition start object
          },
          {
              // Condition end object [optional]
          },
       ]
    }
    </code></pre>
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVICE_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    service: global___ControlMessageServiceName.ValueType
    """Service to control.
    Valid service names are:'ondewo_nlu', 'ondewo_t2s', 'ondewo_s2t', 'ondewo_sip' and 'ondewo_csi'
    """

    method: global___ControlMessageServiceMethod.ValueType
    """Method to invoke on the service"""

    @property
    def parameters(self) -> global___ControlMessageServiceParameters:
        """Parameters to use to invoke the method of the service"""
        pass
    def __init__(self,
        *,
        service: global___ControlMessageServiceName.ValueType = ...,
        method: global___ControlMessageServiceMethod.ValueType = ...,
        parameters: typing.Optional[global___ControlMessageServiceParameters] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["parameters",b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["method",b"method","parameters",b"parameters","service",b"service"]) -> None: ...
global___ControlMessage = ControlMessage
