import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Represents a Public Key.
 *
 * @stability stable
 */
export interface IPublicKey extends IResource {
    /**
     * The ID of the key group.
     *
     * @stability stable
     * @attribute true
     */
    readonly publicKeyId: string;
}
/**
 * Properties for creating a Public Key.
 *
 * @stability stable
 */
export interface PublicKeyProps {
    /**
     * A name to identify the public key.
     *
     * @default - generated from the `id`
     * @stability stable
     */
    readonly publicKeyName?: string;
    /**
     * A comment to describe the public key.
     *
     * @default - no comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The public key that you can use with signed URLs and signed cookies, or with field-level encryption.
     *
     * The `encodedKey` parameter must include `-----BEGIN PUBLIC KEY-----` and `-----END PUBLIC KEY-----` lines.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
     * @stability stable
     */
    readonly encodedKey: string;
}
/**
 * A Public Key Configuration.
 *
 * @stability stable
 * @resource AWS::CloudFront::PublicKey
 */
export declare class PublicKey extends Resource implements IPublicKey {
    /**
     * Imports a Public Key from its id.
     *
     * @stability stable
     */
    static fromPublicKeyId(scope: Construct, id: string, publicKeyId: string): IPublicKey;
    /**
     * The ID of the key group.
     *
     * @stability stable
     */
    readonly publicKeyId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: PublicKeyProps);
    private generateName;
}
