/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import java.util.Arrays;

public class NumericFrame {
    private final MojoFrame frame;
    public final int columnCount;
    private final float[][] floatColumns;
    private final double[][] doubleColumns;

    private NumericFrame(MojoFrame frame, int[] indices) {
        this.frame = frame;
        this.columnCount = indices.length;
        if (indices.length == 0) {
            throw new IllegalArgumentException("Frame has no columns");
        }
        MojoColumn.Type type = frame.getColumnType(indices[0]);
        if (type == MojoColumn.Type.Float32) {
            this.floatColumns = new float[indices.length][];
            this.fillFrame(indices, this.floatColumns);
            this.doubleColumns = null;
        } else if (type == MojoColumn.Type.Float64) {
            this.doubleColumns = new double[indices.length][];
            this.fillFrame(indices, this.doubleColumns);
            this.floatColumns = null;
        } else {
            throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
        }
        for (int i2 = 1; i2 < indices.length; ++i2) {
            MojoColumn.Type type2 = frame.getColumnType(indices[i2]);
            if (type2.equals((Object)type)) continue;
            throw new IllegalArgumentException(String.format("Type of column %d is %s which does not match type of column 0 which is %s", new Object[]{i2, type2, type}));
        }
    }

    public static NumericFrame indexed(MojoFrame frame, int[] indices) {
        if (indices.length > frame.getNcols()) {
            throw new IllegalArgumentException(String.format("Number if indices exceeds number of frame columns: %d > %d", indices.length, frame.getNcols()));
        }
        return new NumericFrame(frame, indices);
    }

    public static NumericFrame linear(MojoFrame frame) {
        int[] nArray = new int[frame.getNcols()];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = n3;
        }
        return new NumericFrame(frame, nArray);
    }

    public MojoFrame getMojoFrame() {
        return this.frame;
    }

    public void fillFrame(int[] indices, float[][] framedata) {
        for (int i2 = 0; i2 < indices.length; ++i2) {
            int n2 = indices[i2];
            if (n2 < 0) continue;
            framedata[i2] = (float[])this.frame.getColumnData(n2);
        }
    }

    public void fillFrame(int[] indices, double[][] framedata) {
        for (int i2 = 0; i2 < indices.length; ++i2) {
            int n2 = indices[i2];
            if (n2 < 0) continue;
            framedata[i2] = (double[])this.frame.getColumnData(n2);
        }
    }

    public float[][] floatColumns() {
        if (this.isDouble()) {
            throw new IllegalArgumentException("Frame is not of type Float32: " + this.toString());
        }
        return this.floatColumns;
    }

    public double[][] doubleColumns() {
        if (!this.isDouble()) {
            throw new IllegalArgumentException("Frame is not of type Float64: " + this.toString());
        }
        return this.doubleColumns;
    }

    public double getValue(int column, int row) {
        if (this.isDouble()) {
            return this.doubleColumns[column][row];
        }
        return this.floatColumns[column][row];
    }

    public void fillColumn(int colIndex, double value) {
        if (this.isDouble()) {
            Arrays.fill(this.doubleColumns[colIndex], value);
            return;
        }
        Arrays.fill(this.floatColumns[colIndex], (float)value);
    }

    public void addConstantToColumn(int colIndex, double value) {
        if (this.isDouble()) {
            int n2 = 0;
            while (n2 < this.frame.getNrows()) {
                double[] dArray = this.doubleColumns[colIndex];
                int n3 = n2++;
                dArray[n3] = dArray[n3] + value;
            }
            return;
        }
        float f2 = (float)value;
        int n4 = 0;
        while (n4 < this.frame.getNrows()) {
            float[] fArray = this.floatColumns[colIndex];
            int n5 = n4++;
            fArray[n5] = fArray[n5] + f2;
        }
    }

    public boolean isDouble() {
        return this.floatColumns == null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FloatFrameWrapper{");
        stringBuilder.append("frame=").append(this.frame);
        stringBuilder.append(", columnCount=").append(this.columnCount);
        stringBuilder.append(", floatColumns=").append(Arrays.toString((Object[])this.floatColumns));
        stringBuilder.append(", doubleColumns=").append(Arrays.toString((Object[])this.doubleColumns));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

