#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

from setuptools import setup
from setuptools import find_packages

packages = find_packages()

setup(
    name = "typedb-ml",
    version = "0.3.0",
    description = "A Machine Learning Library for TypeDB.",
    long_description = open('README.md').read(),
    long_description_content_type="text/markdown",
    classifiers = ["Programming Language :: Python :: 3", "Programming Language :: Python :: 3.7", "License :: OSI Approved :: Apache Software License", "Operating System :: OS Independent", "Intended Audience :: Developers", "Intended Audience :: Science/Research", "Topic :: Scientific/Engineering", "Topic :: Scientific/Engineering :: Information Analysis", "Topic :: Scientific/Engineering :: Artificial Intelligence", "Topic :: Software Development :: Libraries", "Topic :: Software Development :: Libraries :: Python Modules"],
    keywords = "machine learning logical reasoning knowledege graph typedb database graph knowledgebase knowledge-engineering",
    url = "https://github.com/vaticle/typedb-ml",
    author = "Vaticle",
    author_email = "community@vaticle.com",
    license = "Apache-2.0",
    packages=packages,
    install_requires=['absl-py==1.2.0', 'cachetools==5.2.0', 'certifi==2022.6.15', 'charset-normalizer==2.1.0', 'decorator==5.1.1', 'google-auth==2.9.1', 'google-auth-oauthlib==0.4.6', 'grpcio==1.43.0', 'idna==3.3', 'importlib-metadata==4.12.0', 'Jinja2==3.1.2', 'joblib==1.1.0', 'Markdown==3.4.1', 'MarkupSafe==2.1.1', 'networkx==2.5', 'numpy==1.21.6', 'oauthlib==3.2.0', 'pandas==1.3.5', 'protobuf==3.15.5', 'pyasn1==0.4.8', 'pyasn1-modules==0.2.8', 'pyparsing==3.0.9', 'python-dateutil==2.8.2', 'pytz==2022.1', 'requests==2.28.1', 'requests-oauthlib==1.3.1', 'rsa==4.9', 'scikit-learn==1.0.2', 'scipy==1.7.3', 'six==1.16.0', 'tensorboard==2.9.1', 'tensorboard-data-server==0.6.1', 'tensorboard-plugin-wit==1.8.1', 'threadpoolctl==3.1.0', 'torch==1.11.0', 'torch-geometric==2.0.4', 'torch-scatter==2.0.9', 'torch-sparse==0.6.14', 'tqdm==4.64.0', 'typedb-client==2.9.0', 'typedb-protocol==2.9.0', 'typing-extensions==4.3.0', 'urllib3==1.26.10', 'Werkzeug==2.1.2', 'zipp==3.8.1'],
    zip_safe=False,
)
