# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyboxen']

package_data = \
{'': ['*']}

install_requires = \
['rich>=12.5.1,<13.0.0']

setup_kwargs = {
    'name': 'pyboxen',
    'version': '1.1.0',
    'description': 'Beautiful, customizable boxes in your terminal using Python',
    'long_description': '# pyboxen\n<!-- markdownlint-disable MD010 MD033 MD001 MD003 -->\n\n> **Create beautiful boxes in the terminal using Python**\n\nThis package is a Python "port" of the popular NPM package [boxen](https://github.com/sindresorhus/boxen/).\n\nIt\'s built on top of [Rich](https://github.com/Textualize/rich/), and features an API that would be familiar to the users of the NPM boxen package.\n\n## 🛠️ Install\n\nUsing [pip](https://pypi.org/)\n\n```text\npip install pyboxen\n```\n\n---\n\n## 🔗 Usage\n\n- Simplest of simple boxes\n\n```py\nfrom pyboxen import boxen\n\nprint(boxen("Python is cool!"))\n```\n\n> ![image](https://user-images.githubusercontent.com/38729705/198232802-e41575c6-abd6-416d-9ba6-d1b1c31a2660.png)\n\n- Define options\n\n```py\nfrom pyboxen import boxen\n\nprint(\n    boxen(\n        "Python is cool!",\n        padding=1,\n        margin=1,\n        color="cyan",\n    )\n)\n```\n\n> ![image](https://user-images.githubusercontent.com/38729705/198233490-52feeeba-efd3-4fe4-93cf-641d0f58fbf4.png)\n\n- Multiple texts and [Rich Renderables](https://github.com/Textualize/rich#rich-library)\n\n> You can even use Rich\'s special color style syntax for the text, title and subtitle as well\n>\n> Example: `[red]Hello[/red] [bold italic]World[/]`\n\n```py\nfrom pyboxen import boxen\n\n# Multiple texts\n\nprint(\n    boxen(\n        "Python is cool!",\n        "Yeah it totally is!",\n        "I [red]:heart:[/red]  [yellow bold]Python[/]!",  # You can even use Rich syntax here too!\n        padding=1,\n        margin=1,\n        color="cyan",\n    )\n)\n\n# Rich renderables, with a mix of strings and renderables\n\nfrom rich.table import Table\n\ntable = Table(show_header=True, header_style="bold magenta")\n\ntable.add_column("Date", style="dim", width=12)\ntable.add_column("Title")\ntable.add_column("Production Budget", justify="right")\ntable.add_column("Box Office", justify="right")\ntable.add_row(\n    "Dec 20, 2019", "Star Wars: The Rise of Skywalker", "$275,000,000", "$375,126,118"\n)\ntable.add_row(\n    "May 25, 2018",\n    "[red]Solo[/red]: A Star Wars Story",\n    "$275,000,000",\n    "$393,151,347",\n)\ntable.add_row(\n    "Dec 15, 2017",\n    "Star Wars Ep. VIII: The Last Jedi",\n    "$262,000,000",\n    "[bold]$1,332,539,889[/bold]",\n)\n\nprint(\n    boxen(\n        "Python is cool!",\n        table\n    )\n)\n```\n\n> ![image](https://user-images.githubusercontent.com/38729705/198234218-0a4ccfd8-a858-4f84-a99d-f804b926f684.png)\n\n- Title and subtitles\n\n```py\nfrom pyboxen import boxen\n\nprint(\n    boxen(\n        "Titles and subtitles!",\n        title="Hello, [black on cyan] World [/]",\n        subtitle="Cool subtitle goes here",\n        subtitle_alignment="center",\n        color="yellow",\n        padding=1,\n    )\n)\n```\n\n> ![image](https://user-images.githubusercontent.com/38729705/198237935-d01857b8-f61a-42de-b7e5-9fdff59a9739.png)\n---\n\n## 🔮 API\n\n### `boxen(*text, **kwargs)`\n\n#### text\n\nA variable (infinite) amount of text strings or [Rich Renderables](https://github.com/Textualize/rich#rich-library), or a mix of both.\n\n#### kwargs\n\nCustomize options for the box\n\nAvailable options include:\n\n```py\ncolor: str = "white",\nstyle: str = "rounded",\npadding: Union[int, tuple[int]] = 0,\nmargin: Union[int, tuple[int]] = 0,\ntext_alignment: Literal["left", "center", "right"] = "center",\nbox_alignment: Literal["left", "center", "right"] = "left",\ntitle: str = None,\ntitle_alignment: Literal["left", "center", "right"] = "left",\nsubtitle: str = None,\nsubtitle_alignment: Literal["left", "center", "right"] = "left",\nfullwidth: bool = False,\n```\n\n#### color\n\nThe color of the box in color or hex code starting with #, defaults to white\n\n#### style\n\nThe style of the box, defaults to rounded\n\n#### padding\n\nThe padding between the text and the box in int or tuple of ints, defaults to 0\n\n#### margin\n\nThe margin around the box in int or tuple of ints, defaults to 0\n\n#### text_alignment\n\nThe alignment of the text inside the box, defaults to center\n\n#### box_alignment\n\nThe alignment of the box in the terminal, defaults to left\n\n#### title\n\nThe title of the box, displayed on the top of the box, if provided\n\n#### title_alignment\n\nThe alignment of the title, defaults to left\n\n#### subtitle\n\nThe subtitle of the box, displayed on the bottom of the box, if provided\n\n#### subtitle_alignment\n\nThe alignment of the subtitle, defaults to left\n\n#### fullwidth\n\nIf True, the box will expand to fill the entire terminal width, defaults to False\n\n> **Note**\n> `padding` and `margin` attributes can be either an int, a tuple of ints (with a total of either 2 elements or 4 elements)\n> Example:\n>\n> `2` - all of top, right, bottom, left\n>\n> `(2, 4)` - (top = bottom, right = left)\n>\n> `(2, 4, 6, 8)` - (top, right, bottom, left)\n\n---\n\n## ❤️ Support\n\nYou can support further development of this project by **giving it a 🌟** and help me make even better stuff in the future by **buying me a ☕**\n\n<a href="https://www.buymeacoffee.com/savioxavier">\n<img src="https://cdn.buymeacoffee.com/buttons/v2/default-blue.png" height="50px">\n</a>\n\n<br>\n\n**Also, if you liked this repo, consider checking out my other projects, that would be real cool!**\n\n---\n\n## 💫 Attributions and special thanks\n\n- [boxen](https://github.com/sindresorhus/boxen/) - the NPM package I was inspired from\n- [rich](https://github.com/Textualize/rich) - for making such an incredibly powerful text customization tool\n',
    'author': 'Skyascii',
    'author_email': 'savioxavier112@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/savioxavier/pyboxen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
