Lovely Tensors
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install lovely-tensors
```

## How to use

How often do you find yourself debuggin a PyTorch code? You dump a
tensor to the cell output, and see this:

``` python
numbers
```

    tensor[3, 196, 196] n=115248 x∈[-2.118, 2.640] μ=-0.388 σ=1.073

Was it really useful?

What is the shape?  
What are the statistics?  
Are any of the values `nan` or `inf`?  
Is it an image of a man holding a tench?

``` python
import lovely_tensors.tensors as lt
```

``` python
lt.PRINT_OPTS.color=True
lt.monkey_patch()
```

## `__repr__()`

``` python
# A very short tensor - no min/max
numbers.flatten()[:2]
```

    tensor[2] μ=-0.345 σ=0.012 [-0.354, -0.337]

``` python
# A slightly longer one
numbers.flatten()[:6].view(2,3)
```

    tensor[2, 3] n=6 x∈[-0.440, -0.337] μ=-0.388 σ=0.038 [[-0.354, -0.337, -0.405], [-0.440, -0.388, -0.405]]

``` python
# Too long to show the values
numbers
```

    tensor[3, 196, 196] n=115248 x∈[-2.118, 2.640] μ=-0.388 σ=1.073

``` python
spicy = numbers.flatten()[:12].clone()

spicy[0] *= 10000
spicy[1] /= 10000
spicy[2] = float('inf')
spicy[3] = float('-inf')
spicy[4] = float('nan')

spicy = spicy.reshape((2,6))
spicy
```

    tensor[2, 6] n=12 x∈[-3.541e+03, -3.369e-05] μ=-393.776 σ=1.180e+03 +inf! -inf! nan!

``` python
# A zero tensor
torch.zeros(10, 10)
```

    tensor[10, 10] n=100 all_zeros

``` python
spicy.verbose
```

    tensor[2, 6] n=12 x∈[-3.541e+03, -3.369e-05] μ=-393.776 σ=1.180e+03 +inf! -inf! nan!
    [[-3.5405e+03, -3.3693e-05,         inf,        -inf,         nan, -4.0543e-01],
     [-4.2255e-01, -4.9105e-01, -5.0818e-01, -5.5955e-01, -5.4243e-01, -5.0818e-01]]

``` python
spicy.plain
```

    [[-3.5405e+03, -3.3693e-05,         inf,        -inf,         nan, -4.0543e-01],
     [-4.2255e-01, -4.9105e-01, -5.0818e-01, -5.5955e-01, -5.4243e-01, -5.0818e-01]]

## Going `.deeper`

``` python
numbers.deeper
```

    tensor[3, 196, 196] n=115248 x∈[-2.118, 2.640] μ=-0.388 σ=1.073
      tensor[196, 196] n=38416 x∈[-2.118, 2.249] μ=-0.324 σ=1.036
      tensor[196, 196] n=38416 x∈[-1.966, 2.429] μ=-0.274 σ=0.973
      tensor[196, 196] n=38416 x∈[-1.804, 2.640] μ=-0.567 σ=1.178

``` python
# You can go deeper if you need to
dt = torch.randn(3, 3, 5)
dt.deeper(2)
```

    tensor[3, 3, 5] n=45 x∈[-2.201, 1.498] μ=-0.151 σ=0.927
      tensor[3, 5] n=15 x∈[-1.864, 1.498] μ=0.176 σ=0.973
        tensor[5] x∈[-0.805, 1.408] μ=0.470 σ=0.917 [0.092, 0.346, 1.308, -0.805, 1.408]
        tensor[5] x∈[-0.678, 0.909] μ=0.358 σ=0.689 [0.909, -0.024, 0.818, 0.765, -0.678]
        tensor[5] x∈[-1.864, 1.498] μ=-0.299 σ=1.252 [0.239, 1.498, -1.864, -0.640, -0.726]
      tensor[3, 5] n=15 x∈[-2.201, 1.155] μ=-0.421 σ=0.954
        tensor[5] x∈[-0.667, 1.155] μ=0.201 σ=0.732 [-0.391, 0.468, -0.667, 1.155, 0.441]
        tensor[5] x∈[-2.201, -0.012] μ=-1.358 σ=0.844 [-1.926, -1.329, -2.201, -0.012, -1.318]
        tensor[5] x∈[-0.503, 0.723] μ=-0.108 σ=0.488 [-0.334, -0.503, -0.341, 0.723, -0.083]
      tensor[3, 5] n=15 x∈[-1.292, 1.120] μ=-0.208 σ=0.803
        tensor[5] x∈[-1.292, 0.886] μ=-0.284 σ=0.951 [-1.292, 0.886, 0.146, 0.082, -1.242]
        tensor[5] x∈[-1.160, 1.120] μ=-0.130 σ=0.924 [-1.160, 0.359, -0.873, 1.120, -0.095]
        tensor[5] x∈[-0.982, 0.572] μ=-0.211 σ=0.694 [0.572, 0.407, -0.982, -0.261, -0.790]

## Now in `.rgb` colour

The important queston - is it our man?

``` python
numbers.rgb
```

![](index_files/figure-gfm/cell-14-output-1.png)

*Maaaaybe?* Looks like someone normalized him.

``` python
in_stats = { "mean": (0.485, 0.456, 0.406),
             "std": (0.229, 0.224, 0.225) }
numbers.rgb(in_stats)
```

![](index_files/figure-gfm/cell-15-output-1.png)

It’s indeed our hero, the Tenchman!

## `.plt` the statistics

``` python
(numbers+3).plt
```

![](index_files/figure-gfm/cell-16-output-1.svg)

``` python
(numbers+3).plt(center="mean")
```

![](index_files/figure-gfm/cell-17-output-1.svg)

``` python
(numbers+3).plt(center="range")
```

![](index_files/figure-gfm/cell-18-output-1.svg)

## Without `.monkey_patch`

``` python
lt.lovely(spicy)
```

    tensor[2, 6] n=12 x∈[-3.541e+03, -3.369e-05] μ=-393.776 σ=1.180e+03 +inf! -inf! nan!

``` python
lt.lovely(spicy, verbose=True)
```

    tensor[2, 6] n=12 x∈[-3.541e+03, -3.369e-05] μ=-393.776 σ=1.180e+03 +inf! -inf! nan!
    [[-3.5405e+03, -3.3693e-05,         inf,        -inf,         nan, -4.0543e-01],
     [-4.2255e-01, -4.9105e-01, -5.0818e-01, -5.5955e-01, -5.4243e-01, -5.0818e-01]]

``` python
lt.lovely(numbers, depth=1)
```

    tensor[3, 196, 196] n=115248 x∈[-2.118, 2.640] μ=-0.388 σ=1.073
      tensor[196, 196] n=38416 x∈[-2.118, 2.249] μ=-0.324 σ=1.036
      tensor[196, 196] n=38416 x∈[-1.966, 2.429] μ=-0.274 σ=0.973
      tensor[196, 196] n=38416 x∈[-1.804, 2.640] μ=-0.567 σ=1.178

``` python
lt.rgb(numbers, in_stats)
```

![](index_files/figure-gfm/cell-22-output-1.png)

``` python
lt.plot(numbers, center="mean")
```

![](index_files/figure-gfm/cell-23-output-1.svg)
