#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pydantic_i18n']

package_data = \
{'': ['*']}

install_requires = \
['pydantic >=1.8.2', 'Babel >=2.9.1']

extras_require = \
{'dev': ['autoflake >=1.3.1,<2.0.0',
         'flake8 >=3.8.3,<4.0.0',
         'pre-commit',
         'tox >=3.23.1'],
 'doc': ['mkdocs ==1.1.2',
         'mkdocs-material ==7.1.4',
         'markdown-include ==0.5.1',
         'mkdocs-markdownextradata-plugin ==0.1.9',
         'typer-cli ==0.0.9',
         'pyyaml ==5.4.1'],
 'test': ['pytest ==5.4.3',
          'pytest-cov ==2.10.0',
          'pytest-lazy-fixture ==0.6.3',
          'mypy ==0.812',
          'flake8 >=3.8.3,<4.0.0',
          'black ==20.8b1',
          'isort >=5.0.6,<6.0.0']}

setup(name='pydantic-i18n',
      version='0.2.0',
      description='pydantic-i18n is an extension to support an i18n for the pydantic error messages.',
      author='Roman Sadzhenytsia',
      author_email='urchin.dukkee@gmail.com',
      url='https://github.com/boardpack/pydantic-i18n',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
