"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterAutoScaler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
__exportStar(require("./policy"), exports);
/**
 * @experimental
 */
class ClusterAutoScaler extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e;
        super(scope, name);
        this.serviceAccountName = (_b = opts.serviceAccountName) !== null && _b !== void 0 ? _b : 'cluster-autoscaler';
        this.namespace = (_c = opts.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.image = (_d = opts.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/autoscaling/cluster-autoscaler:v1.17.3';
        this.createServiceAccount = (_e = opts === null || opts === void 0 ? void 0 : opts.createServiceAccount) !== null && _e !== void 0 ? _e : true;
        if (opts.createServiceAccount === true) {
            new cdk8s.ApiObject(this, 'sa', {
                apiVersion: 'v1',
                kind: 'ServiceAccount',
                metadata: {
                    labels: {
                        'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                        'k8s-app': 'cluster-autoscaler',
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new cdk8s.ApiObject(this, 'cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRole',
            metadata: {
                name: 'cluster-autoscaler',
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: [
                        'events',
                        'endpoints',
                    ],
                    verbs: [
                        'create',
                        'patch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/eviction'],
                    verbs: ['create'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: ['update'],
                },
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    resourceNames: ['cluster-autoscaler'],
                    verbs: [
                        'get',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: [
                        'pods',
                        'services',
                        'replicationcontrollers',
                        'persistentvolumeclaims',
                        'persistentvolumes',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: [
                        'replicasets',
                        'daemonsets',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['policy'],
                    resources: ['poddisruptionbudgets'],
                    verbs: [
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: ['apps'],
                    resources: [
                        'statefulsets',
                        'replicasets',
                        'daemonsets',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: ['storage.k8s.io'],
                    resources: [
                        'storageclasses',
                        'csinodes',
                    ],
                    verbs: [
                        'watch',
                        'list',
                        'get',
                    ],
                },
                {
                    apiGroups: [
                        'batch',
                        'extensions',
                    ],
                    resources: ['jobs'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                        'patch',
                    ],
                },
                {
                    apiGroups: ['coordination.k8s.io'],
                    resources: ['leases'],
                    verbs: ['create'],
                },
                {
                    apiGroups: ['coordination.k8s.io'],
                    resourceNames: ['cluster-autoscaler'],
                    resources: ['leases'],
                    verbs: [
                        'get',
                        'update',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'cluster-role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRoleBinding',
            metadata: {
                name: 'cluster-autoscaler',
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'cluster-autoscaler',
            },
            subjects: [{
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                }],
        });
        new cdk8s.ApiObject(this, 'role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'Role',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: this.namespace,
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: [
                        'create',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: [
                        'cluster-autoscaler-status',
                        'cluster-autoscaler-priority-expander',
                    ],
                    verbs: [
                        'delete',
                        'get',
                        'update',
                        'watch',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'RoleBinding',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: this.namespace,
                labels: {
                    'k8s-addon': 'cluster-autoscaler.addons.k8s.io',
                    'k8s-app': 'cluster-autoscaler',
                },
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'cluster-autoscaler',
            },
            subjects: [{
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                }],
        });
        new cdk8s.ApiObject(this, 'deployment', {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                name: 'cluster-autoscaler',
                namespace: 'kube-system',
                labels: {
                    app: 'cluster-autoscaler',
                },
            },
            spec: {
                replicas: 1,
                selector: {
                    matchLabels: {
                        app: 'cluster-autoscaler',
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: 'cluster-autoscaler',
                        },
                        annotations: {
                            'prometheus.io/scrape': 'true',
                            'prometheus.io/port': '8085',
                        },
                    },
                    spec: {
                        serviceAccountName: 'cluster-autoscaler',
                        containers: [{
                                image: this.image,
                                name: 'cluster-autoscaler',
                                resources: {
                                    limits: {
                                        cpu: '100m',
                                        memory: '300Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '300Mi',
                                    },
                                },
                                command: this.commandFunc(opts.command),
                                volumeMounts: [{
                                        name: 'ssl-certs',
                                        mountPath: '/etc/ssl/certs/ca-certificates.crt',
                                        readOnly: true,
                                    }],
                                imagePullPolicy: 'Always',
                            }],
                        volumes: [{
                                name: 'ssl-certs',
                                hostPath: {
                                    path: '/etc/ssl/certs/ca-bundle.crt',
                                },
                            }],
                    },
                },
            },
        });
    }
    commandFunc(comm) {
        const defaultCommand = [
            './cluster-autoscaler',
            '--v=4',
            '--stderrthreshold=info',
            '--cloud-provider=aws',
            '--skip-nodes-with-local-storage=false',
            '--expander=least-waste',
        ];
        if (comm) {
            comm.forEach(e => defaultCommand.push(e));
        }
        return defaultCommand;
    }
}
exports.ClusterAutoScaler = ClusterAutoScaler;
_a = JSII_RTTI_SYMBOL_1;
ClusterAutoScaler[_a] = { fqn: "@opencdk8s/cdk8s-cluster-autoscaler-aws.ClusterAutoScaler", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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