import { Construct } from 'constructs';
export * from './policy';
/**
 * @experimental
 */
export interface ClusterAutoScalerOptions {
    /**
     * (experimental) service account for aws-load-balancer-controller.
     *
     * @default - true
     * @experimental
     */
    readonly createServiceAccount?: boolean;
    /**
     * (experimental) Service Account Name.
     *
     * @default - cluster-autoscaler
     * @experimental
     */
    readonly serviceAccountName?: string;
    /**
     * (experimental) Extra commands for controller.
     *
     * @default - [
     * './cluster-autoscaler',
     * '--v=4',
     * '----stderrthreshold=info',
     * '--cloud-provider=aws',
     * '--skip-nodes-with-local-storage=false',
     * '--expander=least-waste'
     * ]
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) Namespace.
     *
     * @default - kube-system
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) image for deployment.
     *
     * @experimental
     */
    readonly image?: string;
}
/**
 * @experimental
 */
export declare class ClusterAutoScaler extends Construct {
    /**
     * (experimental) service account for aws-load-balancer-controller.
     *
     * @default - true
     * @experimental
     */
    readonly createServiceAccount?: boolean;
    /**
     * (experimental) Service Account Name.
     *
     * @default - cluster-autoscaler
     * @experimental
     */
    readonly serviceAccountName?: string;
    /**
     * (experimental) Extra commands for controller.
     *
     * @default - [
     * './cluster-autoscaler',
     * '--v=4',
     * '----stderrthreshold=info',
     * '--cloud-provider=aws',
     * '--skip-nodes-with-local-storage=false',
     * '--expander=least-waste'
     * ]
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) Namespace.
     *
     * @default - kube-system
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) image for deployment.
     *
     * @experimental
     */
    readonly image?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, name: string, opts: ClusterAutoScalerOptions);
    private commandFunc;
}
