# Generated by Plain 0.52.2 on 2025-07-08 01:17

import uuid

import plain.models.deletion
from plain import models
from plain.models import migrations
from plain.runtime import settings


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.settings_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SupportFormEntry",
            fields=[
                ("id", models.PrimaryKeyField()),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                ("name", models.CharField(max_length=255)),
                ("email", models.EmailField(max_length=254)),
                ("message", models.TextField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("form_slug", models.CharField(max_length=255)),
                (
                    "user",
                    models.ForeignKey(
                        allow_null=True,
                        on_delete=plain.models.deletion.SET_NULL,
                        related_name="support_form_entries",
                        required=False,
                        to="users.user",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
            },
        ),
        migrations.AddIndex(
            model_name="supportformentry",
            index=models.Index(
                fields=["created_at"], name="plainsuppor_created_bda60d_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="supportformentry",
            constraint=models.UniqueConstraint(
                fields=("uuid",), name="plainsupport_supportformentry_unique_uuid"
            ),
        ),
    ]
