import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Batch::ComputeEnvironment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export interface CfnComputeEnvironmentProps {
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    readonly serviceRole: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    readonly type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    readonly computeEnvironmentName?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    readonly computeResources?: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    readonly state?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export declare class CfnComputeEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::ComputeEnvironment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComputeEnvironment;
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    serviceRole: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    computeEnvironmentName: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    computeResources: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    state: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Batch::ComputeEnvironment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComputeEnvironmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export declare namespace CfnComputeEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html
     */
    interface ComputeResourcesProperty {
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.AllocationStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.BidPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage
         */
        readonly bidPercentage?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.DesiredvCpus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-desiredvcpus
         */
        readonly desiredvCpus?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration
         */
        readonly ec2Configuration?: Array<CfnComputeEnvironment.Ec2ConfigurationObjectProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2KeyPair`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair
         */
        readonly ec2KeyPair?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.ImageId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid
         */
        readonly imageId?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole
         */
        readonly instanceRole?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes
         */
        readonly instanceTypes?: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate
         */
        readonly launchTemplate?: CfnComputeEnvironment.LaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MaxvCpus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus
         */
        readonly maxvCpus: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MinvCpus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus
         */
        readonly minvCpus?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.PlacementGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup
         */
        readonly placementGroup?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SpotIamFleetRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-spotiamfleetrole
         */
        readonly spotIamFleetRole?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets
         */
        readonly subnets: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags
         */
        readonly tags?: any;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export declare namespace CfnComputeEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html
     */
    interface Ec2ConfigurationObjectProperty {
        /**
         * `CfnComputeEnvironment.Ec2ConfigurationObjectProperty.ImageIdOverride`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html#cfn-batch-computeenvironment-ec2configurationobject-imageidoverride
         */
        readonly imageIdOverride?: string;
        /**
         * `CfnComputeEnvironment.Ec2ConfigurationObjectProperty.ImageType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html#cfn-batch-computeenvironment-ec2configurationobject-imagetype
         */
        readonly imageType: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
export declare namespace CfnComputeEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-version
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::Batch::JobDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export interface CfnJobDefinitionProps {
    /**
     * `AWS::Batch::JobDefinition.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    readonly type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    readonly containerProperties?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    readonly nodeProperties?: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.PlatformCapabilities`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities
     */
    readonly platformCapabilities?: string[];
    /**
     * `AWS::Batch::JobDefinition.PropagateTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags
     */
    readonly propagateTags?: boolean | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    readonly retryStrategy?: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    readonly timeout?: CfnJobDefinition.TimeoutProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare class CfnJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJobDefinition;
    /**
     * `AWS::Batch::JobDefinition.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    containerProperties: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    nodeProperties: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.PlatformCapabilities`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities
     */
    platformCapabilities: string[] | undefined;
    /**
     * `AWS::Batch::JobDefinition.PropagateTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags
     */
    propagateTags: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    retryStrategy: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    timeout: CfnJobDefinition.TimeoutProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Batch::JobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html
     */
    interface ContainerPropertiesProperty {
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Command`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command
         */
        readonly command?: string[];
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment
         */
        readonly environment?: Array<CfnJobDefinition.EnvironmentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ExecutionRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-executionrolearn
         */
        readonly executionRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.FargatePlatformConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration
         */
        readonly fargatePlatformConfiguration?: CfnJobDefinition.FargatePlatformConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Image`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image
         */
        readonly image: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.JobRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn
         */
        readonly jobRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters
         */
        readonly linuxParameters?: CfnJobDefinition.LinuxParametersProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LogConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-logconfiguration
         */
        readonly logConfiguration?: CfnJobDefinition.LogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Memory`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory
         */
        readonly memory?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints
         */
        readonly mountPoints?: Array<CfnJobDefinition.MountPointsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.NetworkConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration
         */
        readonly networkConfiguration?: CfnJobDefinition.NetworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Privileged`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged
         */
        readonly privileged?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem
         */
        readonly readonlyRootFilesystem?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements
         */
        readonly resourceRequirements?: Array<CfnJobDefinition.ResourceRequirementProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Secrets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-secrets
         */
        readonly secrets?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits
         */
        readonly ulimits?: Array<CfnJobDefinition.UlimitProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.User`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user
         */
        readonly user?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Vcpus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus
         */
        readonly vcpus?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Volumes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes
         */
        readonly volumes?: Array<CfnJobDefinition.VolumesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html
     */
    interface DeviceProperty {
        /**
         * `CfnJobDefinition.DeviceProperty.ContainerPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.HostPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath
         */
        readonly hostPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.Permissions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions
         */
        readonly permissions?: string[];
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnJobDefinition.EnvironmentProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name
         */
        readonly name?: string;
        /**
         * `CfnJobDefinition.EnvironmentProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html
     */
    interface EvaluateOnExitProperty {
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-action
         */
        readonly action: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnExitCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onexitcode
         */
        readonly onExitCode?: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnReason`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onreason
         */
        readonly onReason?: string;
        /**
         * `CfnJobDefinition.EvaluateOnExitProperty.OnStatusReason`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-evaluateonexit.html#cfn-batch-jobdefinition-evaluateonexit-onstatusreason
         */
        readonly onStatusReason?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-fargateplatformconfiguration.html
     */
    interface FargatePlatformConfigurationProperty {
        /**
         * `CfnJobDefinition.FargatePlatformConfigurationProperty.PlatformVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-fargateplatformconfiguration.html#cfn-batch-jobdefinition-containerproperties-fargateplatformconfiguration-platformversion
         */
        readonly platformVersion?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html
     */
    interface LinuxParametersProperty {
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Devices`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-devices
         */
        readonly devices?: Array<CfnJobDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.InitProcessEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-initprocessenabled
         */
        readonly initProcessEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.MaxSwap`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-maxswap
         */
        readonly maxSwap?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.SharedMemorySize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-sharedmemorysize
         */
        readonly sharedMemorySize?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Swappiness`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-swappiness
         */
        readonly swappiness?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Tmpfs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-tmpfs
         */
        readonly tmpfs?: Array<CfnJobDefinition.TmpfsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html
     */
    interface LogConfigurationProperty {
        /**
         * `CfnJobDefinition.LogConfigurationProperty.LogDriver`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-logdriver
         */
        readonly logDriver: string;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.Options`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-options
         */
        readonly options?: any | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.SecretOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-secretoptions
         */
        readonly secretOptions?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html
     */
    interface MountPointsProperty {
        /**
         * `CfnJobDefinition.MountPointsProperty.ContainerPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.MountPointsProperty.ReadOnly`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.MountPointsProperty.SourceVolume`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume
         */
        readonly sourceVolume?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-networkconfiguration.html
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnJobDefinition.NetworkConfigurationProperty.AssignPublicIp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-networkconfiguration.html#cfn-batch-jobdefinition-containerproperties-networkconfiguration-assignpublicip
         */
        readonly assignPublicIp?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html
     */
    interface NodePropertiesProperty {
        /**
         * `CfnJobDefinition.NodePropertiesProperty.MainNode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode
         */
        readonly mainNode: number;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties
         */
        readonly nodeRangeProperties: Array<CfnJobDefinition.NodeRangePropertyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NumNodes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes
         */
        readonly numNodes: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html
     */
    interface NodeRangePropertyProperty {
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.Container`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container
         */
        readonly container?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.TargetNodes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes
         */
        readonly targetNodes: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html
     */
    interface ResourceRequirementProperty {
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type
         */
        readonly type?: string;
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html
     */
    interface RetryStrategyProperty {
        /**
         * `CfnJobDefinition.RetryStrategyProperty.Attempts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts
         */
        readonly attempts?: number;
        /**
         * `CfnJobDefinition.RetryStrategyProperty.EvaluateOnExit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-evaluateonexit
         */
        readonly evaluateOnExit?: Array<CfnJobDefinition.EvaluateOnExitProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html
     */
    interface SecretProperty {
        /**
         * `CfnJobDefinition.SecretProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-name
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.SecretProperty.ValueFrom`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-valuefrom
         */
        readonly valueFrom: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html
     */
    interface TimeoutProperty {
        /**
         * `CfnJobDefinition.TimeoutProperty.AttemptDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds
         */
        readonly attemptDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html
     */
    interface TmpfsProperty {
        /**
         * `CfnJobDefinition.TmpfsProperty.ContainerPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-containerpath
         */
        readonly containerPath: string;
        /**
         * `CfnJobDefinition.TmpfsProperty.MountOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-mountoptions
         */
        readonly mountOptions?: string[];
        /**
         * `CfnJobDefinition.TmpfsProperty.Size`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-size
         */
        readonly size: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html
     */
    interface UlimitProperty {
        /**
         * `CfnJobDefinition.UlimitProperty.HardLimit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit
         */
        readonly hardLimit: number;
        /**
         * `CfnJobDefinition.UlimitProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.UlimitProperty.SoftLimit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit
         */
        readonly softLimit: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html
     */
    interface VolumesProperty {
        /**
         * `CfnJobDefinition.VolumesProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host
         */
        readonly host?: CfnJobDefinition.VolumesHostProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.VolumesProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
export declare namespace CfnJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html
     */
    interface VolumesHostProperty {
        /**
         * `CfnJobDefinition.VolumesHostProperty.SourcePath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath
         */
        readonly sourcePath?: string;
    }
}
/**
 * Properties for defining a `AWS::Batch::JobQueue`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 */
export interface CfnJobQueueProps {
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     */
    readonly computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     */
    readonly priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     */
    readonly jobQueueName?: string;
    /**
     * `AWS::Batch::JobQueue.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     */
    readonly state?: string;
    /**
     * `AWS::Batch::JobQueue.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Batch::JobQueue`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobQueue
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 */
export declare class CfnJobQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobQueue";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJobQueue;
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     */
    computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     */
    priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     */
    jobQueueName: string | undefined;
    /**
     * `AWS::Batch::JobQueue.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     */
    state: string | undefined;
    /**
     * `AWS::Batch::JobQueue.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Batch::JobQueue`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobQueueProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::JobQueue`.
 *
 * @external
 * @cloudformationResource AWS::Batch::JobQueue
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 */
export declare namespace CfnJobQueue {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html
     */
    interface ComputeEnvironmentOrderProperty {
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.ComputeEnvironment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-computeenvironment
         */
        readonly computeEnvironment: string;
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.Order`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-order
         */
        readonly order: number;
    }
}
