from enum import Enum
from typing import Optional, Dict, List, Tuple

from pydantic.main import BaseModel

TextureMeta = Optional[Dict[str, str]]


class TextureType(Enum):
    SKIN = "SKIN"
    CAPE = "CAPE"
    ELYTRA = "ELYTRA"


class TextureItem(BaseModel):
    url: str
    metadata: TextureMeta = None

    class Config:
        allow_mutation = False


class TextureRequest(BaseModel):
    uuid: str
    texture_types: List[TextureType] = [TextureType.SKIN]

    class Config:
        allow_mutation = False


class TextureUploadRequest(BaseModel):
    uuid: str
    data: str
    kind: TextureType
    metadata: TextureMeta

    class Config:
        allow_mutation = False


class TextureResponse(BaseModel):
    textures: List[Tuple[TextureType, TextureItem]]

    class Config:
        allow_mutation = False
