"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from gram_ai.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class HTTPToolDefinitionTypedDict(TypedDict):
    created_at: datetime
    r"""The creation date of the tool."""
    deployment_id: str
    r"""The ID of the deployment"""
    description: str
    r"""Description of the tool"""
    http_method: str
    r"""HTTP method for the request"""
    id: str
    r"""The ID of the HTTP tool"""
    name: str
    r"""The name of the tool"""
    path: str
    r"""Path for the request"""
    project_id: str
    r"""The ID of the project"""
    schema_: str
    r"""JSON schema for the request"""
    summary: str
    r"""Summary of the tool"""
    tags: List[str]
    r"""The tags list for this http tool"""
    updated_at: datetime
    r"""The last update date of the tool."""
    openapiv3_document_id: NotRequired[str]
    r"""The ID of the OpenAPI v3 document"""
    openapiv3_operation: NotRequired[str]
    r"""OpenAPI v3 operation"""
    schema_version: NotRequired[str]
    r"""Version of the schema"""
    security: NotRequired[str]
    r"""Security requirements for the underlying HTTP endpoint"""


class HTTPToolDefinition(BaseModel):
    created_at: datetime
    r"""The creation date of the tool."""

    deployment_id: str
    r"""The ID of the deployment"""

    description: str
    r"""Description of the tool"""

    http_method: str
    r"""HTTP method for the request"""

    id: str
    r"""The ID of the HTTP tool"""

    name: str
    r"""The name of the tool"""

    path: str
    r"""Path for the request"""

    project_id: str
    r"""The ID of the project"""

    schema_: Annotated[str, pydantic.Field(alias="schema")]
    r"""JSON schema for the request"""

    summary: str
    r"""Summary of the tool"""

    tags: List[str]
    r"""The tags list for this http tool"""

    updated_at: datetime
    r"""The last update date of the tool."""

    openapiv3_document_id: Optional[str] = None
    r"""The ID of the OpenAPI v3 document"""

    openapiv3_operation: Optional[str] = None
    r"""OpenAPI v3 operation"""

    schema_version: Optional[str] = None
    r"""Version of the schema"""

    security: Optional[str] = None
    r"""Security requirements for the underlying HTTP endpoint"""
