"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gram_ai.types import BaseModel
from gram_ai.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    SecurityMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetInstanceSecurityOption1TypedDict(TypedDict):
    project_slug_header_gram_project: str
    session_header_gram_session: str


class GetInstanceSecurityOption1(BaseModel):
    project_slug_header_gram_project: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="Gram-Project",
            )
        ),
    ]

    session_header_gram_session: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="Gram-Session",
            )
        ),
    ]


class GetInstanceSecurityOption2TypedDict(TypedDict):
    apikey_header_gram_key: str
    project_slug_header_gram_project: str


class GetInstanceSecurityOption2(BaseModel):
    apikey_header_gram_key: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="Gram-Key",
            )
        ),
    ]

    project_slug_header_gram_project: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="Gram-Project",
            )
        ),
    ]


class GetInstanceSecurityTypedDict(TypedDict):
    option1: NotRequired[GetInstanceSecurityOption1TypedDict]
    option2: NotRequired[GetInstanceSecurityOption2TypedDict]


class GetInstanceSecurity(BaseModel):
    option1: Annotated[
        Optional[GetInstanceSecurityOption1],
        FieldMetadata(security=SecurityMetadata(option=True)),
    ] = None

    option2: Annotated[
        Optional[GetInstanceSecurityOption2],
        FieldMetadata(security=SecurityMetadata(option=True)),
    ] = None


class GetInstanceRequestTypedDict(TypedDict):
    toolset_slug: str
    r"""The slug of the toolset to load"""
    environment_slug: NotRequired[str]
    r"""The slug of the environment to load"""
    gram_session: NotRequired[str]
    r"""Session header"""
    gram_project: NotRequired[str]
    r"""project header"""
    gram_key: NotRequired[str]
    r"""API Key header"""


class GetInstanceRequest(BaseModel):
    toolset_slug: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The slug of the toolset to load"""

    environment_slug: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The slug of the environment to load"""

    gram_session: Annotated[
        Optional[str],
        pydantic.Field(alias="Gram-Session"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Session header"""

    gram_project: Annotated[
        Optional[str],
        pydantic.Field(alias="Gram-Project"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""project header"""

    gram_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Gram-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""API Key header"""
