"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .environmententry import EnvironmentEntry, EnvironmentEntryTypedDict
from datetime import datetime
from gram_ai.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class EnvironmentTypedDict(TypedDict):
    r"""Model representing an environment"""

    created_at: datetime
    r"""The creation date of the environment"""
    entries: List[EnvironmentEntryTypedDict]
    r"""List of environment entries"""
    id: str
    r"""The ID of the environment"""
    name: str
    r"""The name of the environment"""
    organization_id: str
    r"""The organization ID this environment belongs to"""
    project_id: str
    r"""The project ID this environment belongs to"""
    slug: str
    r"""A short url-friendly label that uniquely identifies a resource."""
    updated_at: datetime
    r"""When the environment was last updated"""
    description: NotRequired[str]
    r"""The description of the environment"""


class Environment(BaseModel):
    r"""Model representing an environment"""

    created_at: datetime
    r"""The creation date of the environment"""

    entries: List[EnvironmentEntry]
    r"""List of environment entries"""

    id: str
    r"""The ID of the environment"""

    name: str
    r"""The name of the environment"""

    organization_id: str
    r"""The organization ID this environment belongs to"""

    project_id: str
    r"""The project ID this environment belongs to"""

    slug: str
    r"""A short url-friendly label that uniquely identifies a resource."""

    updated_at: datetime
    r"""When the environment was last updated"""

    description: Optional[str] = None
    r"""The description of the environment"""
