"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from gram_ai import models, utils
from gram_ai._hooks import HookContext
from gram_ai.types import OptionalNullable, UNSET
from typing import Mapping, Optional, Union


class Instances(BaseSDK):
    r"""Consumer APIs for interacting with all relevant data for an instance of a toolset and environment."""

    def get_by_slug(
        self,
        *,
        security: Union[
            models.GetInstanceSecurity, models.GetInstanceSecurityTypedDict
        ],
        toolset_slug: str,
        environment_slug: Optional[str] = None,
        gram_session: Optional[str] = None,
        gram_project: Optional[str] = None,
        gram_key: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetInstanceResult:
        r"""getInstance instances

        Load all relevant data for an instance of a toolset and environment

        :param security:
        :param toolset_slug: The slug of the toolset to load
        :param environment_slug: The slug of the environment to load
        :param gram_session: Session header
        :param gram_project: project header
        :param gram_key: API Key header
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetInstanceRequest(
            toolset_slug=toolset_slug,
            environment_slug=environment_slug,
            gram_session=gram_session,
            gram_project=gram_project,
            gram_key=gram_key,
        )

        req = self._build_request(
            method="GET",
            path="/rpc/instances.get",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(security, models.GetInstanceSecurity),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="getInstance",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GetInstanceResult)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_by_slug_async(
        self,
        *,
        security: Union[
            models.GetInstanceSecurity, models.GetInstanceSecurityTypedDict
        ],
        toolset_slug: str,
        environment_slug: Optional[str] = None,
        gram_session: Optional[str] = None,
        gram_project: Optional[str] = None,
        gram_key: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetInstanceResult:
        r"""getInstance instances

        Load all relevant data for an instance of a toolset and environment

        :param security:
        :param toolset_slug: The slug of the toolset to load
        :param environment_slug: The slug of the environment to load
        :param gram_session: Session header
        :param gram_project: project header
        :param gram_key: API Key header
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetInstanceRequest(
            toolset_slug=toolset_slug,
            environment_slug=environment_slug,
            gram_session=gram_session,
            gram_project=gram_project,
            gram_key=gram_key,
        )

        req = self._build_request_async(
            method="GET",
            path="/rpc/instances.get",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(security, models.GetInstanceSecurity),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="getInstance",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GetInstanceResult)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
