# mypy-boto3-workdocs<a id="mypy-boto3-workdocs"></a>

[![PyPI - mypy-boto3-workdocs](https://img.shields.io/pypi/v/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-workdocs?color=blue)](https://pypistats.org/packages/mypy-boto3-workdocs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WorkDocs 1.17.90](https://boto3.amazonaws.com/v1/documentation/api/1.17.90/reference/services/workdocs.html#WorkDocs)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.15.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-workdocs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-workdocs](#mypy-boto3-workdocs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `WorkDocs` service.

```bash
python -m pip install boto3-stubs[workdocs]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`

Both type checking and auto-complete should work for `WorkDocs` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`

Both type checking and auto-complete should work for `WorkDocs` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`
- Run `mypy` as usual

Type checking should work for `WorkDocs` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WorkDocs` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`WorkDocsClient` provides annotations for `boto3.client("workdocs")`.

```python
import boto3

from mypy_boto3_workdocs import WorkDocsClient

client: WorkDocsClient = boto3.client("workdocs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkDocsClient = session.client("workdocs")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_workdocs.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_workdocs import WorkDocsClient
from mypy_boto3_workdocs.paginator import (
    DescribeActivitiesPaginator,
    DescribeCommentsPaginator,
    DescribeDocumentVersionsPaginator,
    DescribeFolderContentsPaginator,
    DescribeGroupsPaginator,
    DescribeNotificationSubscriptionsPaginator,
    DescribeResourcePermissionsPaginator,
    DescribeRootFoldersPaginator,
    DescribeUsersPaginator,
)

client: WorkDocsClient = boto3.client("workdocs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activities_paginator: DescribeActivitiesPaginator = client.get_paginator("describe_activities")
describe_comments_paginator: DescribeCommentsPaginator = client.get_paginator("describe_comments")
describe_document_versions_paginator: DescribeDocumentVersionsPaginator = client.get_paginator("describe_document_versions")
describe_folder_contents_paginator: DescribeFolderContentsPaginator = client.get_paginator("describe_folder_contents")
describe_groups_paginator: DescribeGroupsPaginator = client.get_paginator("describe_groups")
describe_notification_subscriptions_paginator: DescribeNotificationSubscriptionsPaginator = client.get_paginator("describe_notification_subscriptions")
describe_resource_permissions_paginator: DescribeResourcePermissionsPaginator = client.get_paginator("describe_resource_permissions")
describe_root_folders_paginator: DescribeRootFoldersPaginator = client.get_paginator("describe_root_folders")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
```

### Literals<a id="literals"></a>

`mypy_boto3_workdocs.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_workdocs.literals import (
    ActivityTypeType,
    BooleanEnumTypeType,
    CommentStatusTypeType,
    CommentVisibilityTypeType,
    DescribeActivitiesPaginatorName,
    DescribeCommentsPaginatorName,
    DescribeDocumentVersionsPaginatorName,
    DescribeFolderContentsPaginatorName,
    DescribeGroupsPaginatorName,
    DescribeNotificationSubscriptionsPaginatorName,
    DescribeResourcePermissionsPaginatorName,
    DescribeRootFoldersPaginatorName,
    DescribeUsersPaginatorName,
    DocumentSourceTypeType,
    DocumentStatusTypeType,
    DocumentThumbnailTypeType,
    DocumentVersionStatusType,
    FolderContentTypeType,
    LocaleTypeType,
    OrderTypeType,
    PrincipalTypeType,
    ResourceCollectionTypeType,
    ResourceSortTypeType,
    ResourceStateTypeType,
    ResourceTypeType,
    RolePermissionTypeType,
    RoleTypeType,
    ShareStatusTypeType,
    StorageTypeType,
    SubscriptionProtocolTypeType,
    SubscriptionTypeType,
    UserFilterTypeType,
    UserSortTypeType,
    UserStatusTypeType,
    UserTypeType,
)

def check_value(value: ActivityTypeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_workdocs.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_workdocs.type_defs import (
    ActivateUserResponseTypeDef,
    ActivityTypeDef,
    AddResourcePermissionsResponseTypeDef,
    CommentMetadataTypeDef,
    CommentTypeDef,
    CreateCommentResponseTypeDef,
    CreateFolderResponseTypeDef,
    CreateNotificationSubscriptionResponseTypeDef,
    CreateUserResponseTypeDef,
    DescribeActivitiesResponseTypeDef,
    DescribeCommentsResponseTypeDef,
    DescribeDocumentVersionsResponseTypeDef,
    DescribeFolderContentsResponseTypeDef,
    DescribeGroupsResponseTypeDef,
    DescribeNotificationSubscriptionsResponseTypeDef,
    DescribeResourcePermissionsResponseTypeDef,
    DescribeRootFoldersResponseTypeDef,
    DescribeUsersResponseTypeDef,
    DocumentMetadataTypeDef,
    DocumentVersionMetadataTypeDef,
    FolderMetadataTypeDef,
    GetCurrentUserResponseTypeDef,
    GetDocumentPathResponseTypeDef,
    GetDocumentResponseTypeDef,
    GetDocumentVersionResponseTypeDef,
    GetFolderPathResponseTypeDef,
    GetFolderResponseTypeDef,
    GetResourcesResponseTypeDef,
    GroupMetadataTypeDef,
    InitiateDocumentVersionUploadResponseTypeDef,
    NotificationOptionsTypeDef,
    PaginatorConfigTypeDef,
    ParticipantsTypeDef,
    PermissionInfoTypeDef,
    PrincipalTypeDef,
    ResourceMetadataTypeDef,
    ResourcePathComponentTypeDef,
    ResourcePathTypeDef,
    SharePrincipalTypeDef,
    ShareResultTypeDef,
    StorageRuleTypeTypeDef,
    SubscriptionTypeDef,
    UpdateUserResponseTypeDef,
    UploadMetadataTypeDef,
    UserMetadataTypeDef,
    UserStorageMetadataTypeDef,
    UserTypeDef,
)

def get_structure() -> ActivateUserResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-workdocs` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-workdocs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
