# coding: utf-8

"""
    Model Catalog

    This is the API of the Software Description Ontology at [https://w3id.org/okn/o/sdm](https://w3id.org/okn/o/sdm)  # noqa: E501

    The version of the OpenAPI document: v1.7.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ModelConfiguration(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'author': 'list[object]',
        'citation': 'list[str]',
        'compatible_visualization_software': 'list[Software]',
        'contributor': 'list[Person]',
        'copyright_holder': 'list[object]',
        'date_created': 'list[str]',
        'date_published': 'list[str]',
        'description': 'list[str]',
        'doi': 'list[str]',
        'had_primary_source': 'list[object]',
        'has_assumption': 'list[str]',
        'has_build_file': 'list[str]',
        'has_causal_diagram': 'list[CausalDiagram]',
        'has_component_location': 'list[str]',
        'has_constraint': 'list[str]',
        'has_contact_person': 'list[object]',
        'has_documentation': 'list[str]',
        'has_download_instructions': 'list[str]',
        'has_download_url': 'list[str]',
        'has_equation': 'list[Equation]',
        'has_example': 'list[str]',
        'has_executable_instructions': 'list[str]',
        'has_executable_notebook': 'list[str]',
        'has_execution_command': 'list[str]',
        'has_explanation_diagram': 'list[Image]',
        'has_faq': 'list[str]',
        'has_funding': 'list[FundingInformation]',
        'has_grid': 'list[Grid]',
        'has_implementation_script_location': 'list[str]',
        'has_input': 'list[DatasetSpecification]',
        'has_input_variable': 'list[VariablePresentation]',
        'has_installation_instructions': 'list[str]',
        'has_model_category': 'list[ModelCategory]',
        'has_model_result_table': 'list[str]',
        'has_output': 'list[DatasetSpecification]',
        'has_output_time_interval': 'list[TimeInterval]',
        'has_output_variable': 'list[VariablePresentation]',
        'has_parameter': 'list[Parameter]',
        'has_process': 'list[Process]',
        'has_purpose': 'list[str]',
        'has_region': 'list[Region]',
        'has_sample_execution': 'list[SampleExecution]',
        'has_sample_result': 'list[SampleResource]',
        'has_sample_visualization': 'list[Visualization]',
        'has_setup': 'list[ConfigurationSetup]',
        'has_software_image': 'list[SoftwareImage]',
        'has_source_code': 'list[SourceCode]',
        'has_support_script_location': 'list[str]',
        'has_typical_data_source': 'list[str]',
        'has_usage_notes': 'list[str]',
        'has_version': 'list[SoftwareVersion]',
        'id': 'str',
        'identifier': 'list[str]',
        'issue_tracker': 'list[str]',
        'keywords': 'list[str]',
        'label': 'list[str]',
        'license': 'list[str]',
        'limitations': 'list[str]',
        'logo': 'list[Image]',
        'memory_requirements': 'list[str]',
        'operating_systems': 'list[str]',
        'parameterization': 'list[str]',
        'processor_requirements': 'list[str]',
        'publisher': 'list[object]',
        'readme': 'list[str]',
        'reference_publication': 'list[str]',
        'runtime_estimation': 'list[str]',
        'screenshot': 'list[Image]',
        'short_description': 'list[str]',
        'software_requirements': 'list[str]',
        'support_details': 'list[str]',
        'tag': 'list[str]',
        'theoretical_basis': 'list[str]',
        'type': 'list[str]',
        'useful_for_calculating_index': 'list[NumericalIndex]',
        'website': 'list[str]'
    }

    attribute_map = {
        'author': 'author',
        'citation': 'citation',
        'compatible_visualization_software': 'compatibleVisualizationSoftware',
        'contributor': 'contributor',
        'copyright_holder': 'copyrightHolder',
        'date_created': 'dateCreated',
        'date_published': 'datePublished',
        'description': 'description',
        'doi': 'doi',
        'had_primary_source': 'hadPrimarySource',
        'has_assumption': 'hasAssumption',
        'has_build_file': 'hasBuildFile',
        'has_causal_diagram': 'hasCausalDiagram',
        'has_component_location': 'hasComponentLocation',
        'has_constraint': 'hasConstraint',
        'has_contact_person': 'hasContactPerson',
        'has_documentation': 'hasDocumentation',
        'has_download_instructions': 'hasDownloadInstructions',
        'has_download_url': 'hasDownloadURL',
        'has_equation': 'hasEquation',
        'has_example': 'hasExample',
        'has_executable_instructions': 'hasExecutableInstructions',
        'has_executable_notebook': 'hasExecutableNotebook',
        'has_execution_command': 'hasExecutionCommand',
        'has_explanation_diagram': 'hasExplanationDiagram',
        'has_faq': 'hasFAQ',
        'has_funding': 'hasFunding',
        'has_grid': 'hasGrid',
        'has_implementation_script_location': 'hasImplementationScriptLocation',
        'has_input': 'hasInput',
        'has_input_variable': 'hasInputVariable',
        'has_installation_instructions': 'hasInstallationInstructions',
        'has_model_category': 'hasModelCategory',
        'has_model_result_table': 'hasModelResultTable',
        'has_output': 'hasOutput',
        'has_output_time_interval': 'hasOutputTimeInterval',
        'has_output_variable': 'hasOutputVariable',
        'has_parameter': 'hasParameter',
        'has_process': 'hasProcess',
        'has_purpose': 'hasPurpose',
        'has_region': 'hasRegion',
        'has_sample_execution': 'hasSampleExecution',
        'has_sample_result': 'hasSampleResult',
        'has_sample_visualization': 'hasSampleVisualization',
        'has_setup': 'hasSetup',
        'has_software_image': 'hasSoftwareImage',
        'has_source_code': 'hasSourceCode',
        'has_support_script_location': 'hasSupportScriptLocation',
        'has_typical_data_source': 'hasTypicalDataSource',
        'has_usage_notes': 'hasUsageNotes',
        'has_version': 'hasVersion',
        'id': 'id',
        'identifier': 'identifier',
        'issue_tracker': 'issueTracker',
        'keywords': 'keywords',
        'label': 'label',
        'license': 'license',
        'limitations': 'limitations',
        'logo': 'logo',
        'memory_requirements': 'memoryRequirements',
        'operating_systems': 'operatingSystems',
        'parameterization': 'parameterization',
        'processor_requirements': 'processorRequirements',
        'publisher': 'publisher',
        'readme': 'readme',
        'reference_publication': 'referencePublication',
        'runtime_estimation': 'runtimeEstimation',
        'screenshot': 'screenshot',
        'short_description': 'shortDescription',
        'software_requirements': 'softwareRequirements',
        'support_details': 'supportDetails',
        'tag': 'tag',
        'theoretical_basis': 'theoreticalBasis',
        'type': 'type',
        'useful_for_calculating_index': 'usefulForCalculatingIndex',
        'website': 'website'
    }

    def __init__(self, author=None, citation=None, compatible_visualization_software=None, contributor=None, copyright_holder=None, date_created=None, date_published=None, description=None, doi=None, had_primary_source=None, has_assumption=None, has_build_file=None, has_causal_diagram=None, has_component_location=None, has_constraint=None, has_contact_person=None, has_documentation=None, has_download_instructions=None, has_download_url=None, has_equation=None, has_example=None, has_executable_instructions=None, has_executable_notebook=None, has_execution_command=None, has_explanation_diagram=None, has_faq=None, has_funding=None, has_grid=None, has_implementation_script_location=None, has_input=None, has_input_variable=None, has_installation_instructions=None, has_model_category=None, has_model_result_table=None, has_output=None, has_output_time_interval=None, has_output_variable=None, has_parameter=None, has_process=None, has_purpose=None, has_region=None, has_sample_execution=None, has_sample_result=None, has_sample_visualization=None, has_setup=None, has_software_image=None, has_source_code=None, has_support_script_location=None, has_typical_data_source=None, has_usage_notes=None, has_version=None, id=None, identifier=None, issue_tracker=None, keywords=None, label=None, license=None, limitations=None, logo=None, memory_requirements=None, operating_systems=None, parameterization=None, processor_requirements=None, publisher=None, readme=None, reference_publication=None, runtime_estimation=None, screenshot=None, short_description=None, software_requirements=None, support_details=None, tag=None, theoretical_basis=None, type=None, useful_for_calculating_index=None, website=None):  # noqa: E501
        """ModelConfiguration - a model defined in OpenAPI"""  # noqa: E501

        self._author = None
        self._citation = None
        self._compatible_visualization_software = None
        self._contributor = None
        self._copyright_holder = None
        self._date_created = None
        self._date_published = None
        self._description = None
        self._doi = None
        self._had_primary_source = None
        self._has_assumption = None
        self._has_build_file = None
        self._has_causal_diagram = None
        self._has_component_location = None
        self._has_constraint = None
        self._has_contact_person = None
        self._has_documentation = None
        self._has_download_instructions = None
        self._has_download_url = None
        self._has_equation = None
        self._has_example = None
        self._has_executable_instructions = None
        self._has_executable_notebook = None
        self._has_execution_command = None
        self._has_explanation_diagram = None
        self._has_faq = None
        self._has_funding = None
        self._has_grid = None
        self._has_implementation_script_location = None
        self._has_input = None
        self._has_input_variable = None
        self._has_installation_instructions = None
        self._has_model_category = None
        self._has_model_result_table = None
        self._has_output = None
        self._has_output_time_interval = None
        self._has_output_variable = None
        self._has_parameter = None
        self._has_process = None
        self._has_purpose = None
        self._has_region = None
        self._has_sample_execution = None
        self._has_sample_result = None
        self._has_sample_visualization = None
        self._has_setup = None
        self._has_software_image = None
        self._has_source_code = None
        self._has_support_script_location = None
        self._has_typical_data_source = None
        self._has_usage_notes = None
        self._has_version = None
        self._id = None
        self._identifier = None
        self._issue_tracker = None
        self._keywords = None
        self._label = None
        self._license = None
        self._limitations = None
        self._logo = None
        self._memory_requirements = None
        self._operating_systems = None
        self._parameterization = None
        self._processor_requirements = None
        self._publisher = None
        self._readme = None
        self._reference_publication = None
        self._runtime_estimation = None
        self._screenshot = None
        self._short_description = None
        self._software_requirements = None
        self._support_details = None
        self._tag = None
        self._theoretical_basis = None
        self._type = None
        self._useful_for_calculating_index = None
        self._website = None
        self.discriminator = None

        self.author = author
        self.citation = citation
        self.compatible_visualization_software = compatible_visualization_software
        self.contributor = contributor
        self.copyright_holder = copyright_holder
        self.date_created = date_created
        self.date_published = date_published
        self.description = description
        self.doi = doi
        self.had_primary_source = had_primary_source
        self.has_assumption = has_assumption
        self.has_build_file = has_build_file
        self.has_causal_diagram = has_causal_diagram
        self.has_component_location = has_component_location
        self.has_constraint = has_constraint
        self.has_contact_person = has_contact_person
        self.has_documentation = has_documentation
        self.has_download_instructions = has_download_instructions
        self.has_download_url = has_download_url
        self.has_equation = has_equation
        self.has_example = has_example
        self.has_executable_instructions = has_executable_instructions
        self.has_executable_notebook = has_executable_notebook
        self.has_execution_command = has_execution_command
        self.has_explanation_diagram = has_explanation_diagram
        self.has_faq = has_faq
        self.has_funding = has_funding
        self.has_grid = has_grid
        self.has_implementation_script_location = has_implementation_script_location
        self.has_input = has_input
        self.has_input_variable = has_input_variable
        self.has_installation_instructions = has_installation_instructions
        self.has_model_category = has_model_category
        self.has_model_result_table = has_model_result_table
        self.has_output = has_output
        self.has_output_time_interval = has_output_time_interval
        self.has_output_variable = has_output_variable
        self.has_parameter = has_parameter
        self.has_process = has_process
        self.has_purpose = has_purpose
        self.has_region = has_region
        self.has_sample_execution = has_sample_execution
        self.has_sample_result = has_sample_result
        self.has_sample_visualization = has_sample_visualization
        self.has_setup = has_setup
        self.has_software_image = has_software_image
        self.has_source_code = has_source_code
        self.has_support_script_location = has_support_script_location
        self.has_typical_data_source = has_typical_data_source
        self.has_usage_notes = has_usage_notes
        self.has_version = has_version
        if id is not None:
            self.id = id
        self.identifier = identifier
        self.issue_tracker = issue_tracker
        self.keywords = keywords
        self.label = label
        self.license = license
        self.limitations = limitations
        self.logo = logo
        self.memory_requirements = memory_requirements
        self.operating_systems = operating_systems
        self.parameterization = parameterization
        self.processor_requirements = processor_requirements
        self.publisher = publisher
        self.readme = readme
        self.reference_publication = reference_publication
        self.runtime_estimation = runtime_estimation
        self.screenshot = screenshot
        self.short_description = short_description
        self.software_requirements = software_requirements
        self.support_details = support_details
        self.tag = tag
        self.theoretical_basis = theoretical_basis
        self.type = type
        self.useful_for_calculating_index = useful_for_calculating_index
        self.website = website

    @property
    def author(self):
        """Gets the author of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The author of this ModelConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this ModelConfiguration.

        Description not available  # noqa: E501

        :param author: The author of this ModelConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._author = author

    @property
    def citation(self):
        """Gets the citation of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The citation of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._citation

    @citation.setter
    def citation(self, citation):
        """Sets the citation of this ModelConfiguration.

        Description not available  # noqa: E501

        :param citation: The citation of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._citation = citation

    @property
    def compatible_visualization_software(self):
        """Gets the compatible_visualization_software of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The compatible_visualization_software of this ModelConfiguration.  # noqa: E501
        :rtype: list[Software]
        """
        return self._compatible_visualization_software

    @compatible_visualization_software.setter
    def compatible_visualization_software(self, compatible_visualization_software):
        """Sets the compatible_visualization_software of this ModelConfiguration.

        Description not available  # noqa: E501

        :param compatible_visualization_software: The compatible_visualization_software of this ModelConfiguration.  # noqa: E501
        :type: list[Software]
        """

        self._compatible_visualization_software = compatible_visualization_software

    @property
    def contributor(self):
        """Gets the contributor of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The contributor of this ModelConfiguration.  # noqa: E501
        :rtype: list[Person]
        """
        return self._contributor

    @contributor.setter
    def contributor(self, contributor):
        """Sets the contributor of this ModelConfiguration.

        Description not available  # noqa: E501

        :param contributor: The contributor of this ModelConfiguration.  # noqa: E501
        :type: list[Person]
        """

        self._contributor = contributor

    @property
    def copyright_holder(self):
        """Gets the copyright_holder of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The copyright_holder of this ModelConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._copyright_holder

    @copyright_holder.setter
    def copyright_holder(self, copyright_holder):
        """Sets the copyright_holder of this ModelConfiguration.

        Description not available  # noqa: E501

        :param copyright_holder: The copyright_holder of this ModelConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._copyright_holder = copyright_holder

    @property
    def date_created(self):
        """Gets the date_created of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The date_created of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this ModelConfiguration.

        Description not available  # noqa: E501

        :param date_created: The date_created of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._date_created = date_created

    @property
    def date_published(self):
        """Gets the date_published of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The date_published of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """Sets the date_published of this ModelConfiguration.

        Description not available  # noqa: E501

        :param date_published: The date_published of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._date_published = date_published

    @property
    def description(self):
        """Gets the description of this ModelConfiguration.  # noqa: E501

        small description  # noqa: E501

        :return: The description of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ModelConfiguration.

        small description  # noqa: E501

        :param description: The description of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._description = description

    @property
    def doi(self):
        """Gets the doi of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The doi of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._doi

    @doi.setter
    def doi(self, doi):
        """Sets the doi of this ModelConfiguration.

        Description not available  # noqa: E501

        :param doi: The doi of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._doi = doi

    @property
    def had_primary_source(self):
        """Gets the had_primary_source of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The had_primary_source of this ModelConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._had_primary_source

    @had_primary_source.setter
    def had_primary_source(self, had_primary_source):
        """Sets the had_primary_source of this ModelConfiguration.

        Description not available  # noqa: E501

        :param had_primary_source: The had_primary_source of this ModelConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._had_primary_source = had_primary_source

    @property
    def has_assumption(self):
        """Gets the has_assumption of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_assumption of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_assumption

    @has_assumption.setter
    def has_assumption(self, has_assumption):
        """Sets the has_assumption of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_assumption: The has_assumption of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_assumption = has_assumption

    @property
    def has_build_file(self):
        """Gets the has_build_file of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_build_file of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_build_file

    @has_build_file.setter
    def has_build_file(self, has_build_file):
        """Sets the has_build_file of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_build_file: The has_build_file of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_build_file = has_build_file

    @property
    def has_causal_diagram(self):
        """Gets the has_causal_diagram of this ModelConfiguration.  # noqa: E501

        Diagram associated to a model configuration  # noqa: E501

        :return: The has_causal_diagram of this ModelConfiguration.  # noqa: E501
        :rtype: list[CausalDiagram]
        """
        return self._has_causal_diagram

    @has_causal_diagram.setter
    def has_causal_diagram(self, has_causal_diagram):
        """Sets the has_causal_diagram of this ModelConfiguration.

        Diagram associated to a model configuration  # noqa: E501

        :param has_causal_diagram: The has_causal_diagram of this ModelConfiguration.  # noqa: E501
        :type: list[CausalDiagram]
        """

        self._has_causal_diagram = has_causal_diagram

    @property
    def has_component_location(self):
        """Gets the has_component_location of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_component_location of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_component_location

    @has_component_location.setter
    def has_component_location(self, has_component_location):
        """Sets the has_component_location of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_component_location: The has_component_location of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_component_location = has_component_location

    @property
    def has_constraint(self):
        """Gets the has_constraint of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_constraint of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_constraint

    @has_constraint.setter
    def has_constraint(self, has_constraint):
        """Sets the has_constraint of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_constraint: The has_constraint of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_constraint = has_constraint

    @property
    def has_contact_person(self):
        """Gets the has_contact_person of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_contact_person of this ModelConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._has_contact_person

    @has_contact_person.setter
    def has_contact_person(self, has_contact_person):
        """Sets the has_contact_person of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_contact_person: The has_contact_person of this ModelConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._has_contact_person = has_contact_person

    @property
    def has_documentation(self):
        """Gets the has_documentation of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_documentation of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_documentation

    @has_documentation.setter
    def has_documentation(self, has_documentation):
        """Sets the has_documentation of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_documentation: The has_documentation of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_documentation = has_documentation

    @property
    def has_download_instructions(self):
        """Gets the has_download_instructions of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_download_instructions of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_download_instructions

    @has_download_instructions.setter
    def has_download_instructions(self, has_download_instructions):
        """Sets the has_download_instructions of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_download_instructions: The has_download_instructions of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_download_instructions = has_download_instructions

    @property
    def has_download_url(self):
        """Gets the has_download_url of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_download_url of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_download_url

    @has_download_url.setter
    def has_download_url(self, has_download_url):
        """Sets the has_download_url of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_download_url: The has_download_url of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_download_url = has_download_url

    @property
    def has_equation(self):
        """Gets the has_equation of this ModelConfiguration.  # noqa: E501

        Equations used in the model  # noqa: E501

        :return: The has_equation of this ModelConfiguration.  # noqa: E501
        :rtype: list[Equation]
        """
        return self._has_equation

    @has_equation.setter
    def has_equation(self, has_equation):
        """Sets the has_equation of this ModelConfiguration.

        Equations used in the model  # noqa: E501

        :param has_equation: The has_equation of this ModelConfiguration.  # noqa: E501
        :type: list[Equation]
        """

        self._has_equation = has_equation

    @property
    def has_example(self):
        """Gets the has_example of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_example of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_example

    @has_example.setter
    def has_example(self, has_example):
        """Sets the has_example of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_example: The has_example of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_example = has_example

    @property
    def has_executable_instructions(self):
        """Gets the has_executable_instructions of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_executable_instructions of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_executable_instructions

    @has_executable_instructions.setter
    def has_executable_instructions(self, has_executable_instructions):
        """Sets the has_executable_instructions of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_executable_instructions: The has_executable_instructions of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_executable_instructions = has_executable_instructions

    @property
    def has_executable_notebook(self):
        """Gets the has_executable_notebook of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_executable_notebook of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_executable_notebook

    @has_executable_notebook.setter
    def has_executable_notebook(self, has_executable_notebook):
        """Sets the has_executable_notebook of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_executable_notebook: The has_executable_notebook of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_executable_notebook = has_executable_notebook

    @property
    def has_execution_command(self):
        """Gets the has_execution_command of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_execution_command of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_execution_command

    @has_execution_command.setter
    def has_execution_command(self, has_execution_command):
        """Sets the has_execution_command of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_execution_command: The has_execution_command of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_execution_command = has_execution_command

    @property
    def has_explanation_diagram(self):
        """Gets the has_explanation_diagram of this ModelConfiguration.  # noqa: E501

        Diagram used to explain the behavior of the model  # noqa: E501

        :return: The has_explanation_diagram of this ModelConfiguration.  # noqa: E501
        :rtype: list[Image]
        """
        return self._has_explanation_diagram

    @has_explanation_diagram.setter
    def has_explanation_diagram(self, has_explanation_diagram):
        """Sets the has_explanation_diagram of this ModelConfiguration.

        Diagram used to explain the behavior of the model  # noqa: E501

        :param has_explanation_diagram: The has_explanation_diagram of this ModelConfiguration.  # noqa: E501
        :type: list[Image]
        """

        self._has_explanation_diagram = has_explanation_diagram

    @property
    def has_faq(self):
        """Gets the has_faq of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_faq of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_faq

    @has_faq.setter
    def has_faq(self, has_faq):
        """Sets the has_faq of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_faq: The has_faq of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_faq = has_faq

    @property
    def has_funding(self):
        """Gets the has_funding of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_funding of this ModelConfiguration.  # noqa: E501
        :rtype: list[FundingInformation]
        """
        return self._has_funding

    @has_funding.setter
    def has_funding(self, has_funding):
        """Sets the has_funding of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_funding: The has_funding of this ModelConfiguration.  # noqa: E501
        :type: list[FundingInformation]
        """

        self._has_funding = has_funding

    @property
    def has_grid(self):
        """Gets the has_grid of this ModelConfiguration.  # noqa: E501

        Grid information about the model  # noqa: E501

        :return: The has_grid of this ModelConfiguration.  # noqa: E501
        :rtype: list[Grid]
        """
        return self._has_grid

    @has_grid.setter
    def has_grid(self, has_grid):
        """Sets the has_grid of this ModelConfiguration.

        Grid information about the model  # noqa: E501

        :param has_grid: The has_grid of this ModelConfiguration.  # noqa: E501
        :type: list[Grid]
        """

        self._has_grid = has_grid

    @property
    def has_implementation_script_location(self):
        """Gets the has_implementation_script_location of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_implementation_script_location of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_implementation_script_location

    @has_implementation_script_location.setter
    def has_implementation_script_location(self, has_implementation_script_location):
        """Sets the has_implementation_script_location of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_implementation_script_location: The has_implementation_script_location of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_implementation_script_location = has_implementation_script_location

    @property
    def has_input(self):
        """Gets the has_input of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_input of this ModelConfiguration.  # noqa: E501
        :rtype: list[DatasetSpecification]
        """
        return self._has_input

    @has_input.setter
    def has_input(self, has_input):
        """Sets the has_input of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_input: The has_input of this ModelConfiguration.  # noqa: E501
        :type: list[DatasetSpecification]
        """

        self._has_input = has_input

    @property
    def has_input_variable(self):
        """Gets the has_input_variable of this ModelConfiguration.  # noqa: E501

        Variable that is used as input for this model  # noqa: E501

        :return: The has_input_variable of this ModelConfiguration.  # noqa: E501
        :rtype: list[VariablePresentation]
        """
        return self._has_input_variable

    @has_input_variable.setter
    def has_input_variable(self, has_input_variable):
        """Sets the has_input_variable of this ModelConfiguration.

        Variable that is used as input for this model  # noqa: E501

        :param has_input_variable: The has_input_variable of this ModelConfiguration.  # noqa: E501
        :type: list[VariablePresentation]
        """

        self._has_input_variable = has_input_variable

    @property
    def has_installation_instructions(self):
        """Gets the has_installation_instructions of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_installation_instructions of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_installation_instructions

    @has_installation_instructions.setter
    def has_installation_instructions(self, has_installation_instructions):
        """Sets the has_installation_instructions of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_installation_instructions: The has_installation_instructions of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_installation_instructions = has_installation_instructions

    @property
    def has_model_category(self):
        """Gets the has_model_category of this ModelConfiguration.  # noqa: E501

        Category associated with a model (e.g., Hydrology, etc.)  # noqa: E501

        :return: The has_model_category of this ModelConfiguration.  # noqa: E501
        :rtype: list[ModelCategory]
        """
        return self._has_model_category

    @has_model_category.setter
    def has_model_category(self, has_model_category):
        """Sets the has_model_category of this ModelConfiguration.

        Category associated with a model (e.g., Hydrology, etc.)  # noqa: E501

        :param has_model_category: The has_model_category of this ModelConfiguration.  # noqa: E501
        :type: list[ModelCategory]
        """

        self._has_model_category = has_model_category

    @property
    def has_model_result_table(self):
        """Gets the has_model_result_table of this ModelConfiguration.  # noqa: E501

        Sample result table associated with a model configuration  # noqa: E501

        :return: The has_model_result_table of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_model_result_table

    @has_model_result_table.setter
    def has_model_result_table(self, has_model_result_table):
        """Sets the has_model_result_table of this ModelConfiguration.

        Sample result table associated with a model configuration  # noqa: E501

        :param has_model_result_table: The has_model_result_table of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_model_result_table = has_model_result_table

    @property
    def has_output(self):
        """Gets the has_output of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_output of this ModelConfiguration.  # noqa: E501
        :rtype: list[DatasetSpecification]
        """
        return self._has_output

    @has_output.setter
    def has_output(self, has_output):
        """Sets the has_output of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_output: The has_output of this ModelConfiguration.  # noqa: E501
        :type: list[DatasetSpecification]
        """

        self._has_output = has_output

    @property
    def has_output_time_interval(self):
        """Gets the has_output_time_interval of this ModelConfiguration.  # noqa: E501

        Time interval used in the model configuration  # noqa: E501

        :return: The has_output_time_interval of this ModelConfiguration.  # noqa: E501
        :rtype: list[TimeInterval]
        """
        return self._has_output_time_interval

    @has_output_time_interval.setter
    def has_output_time_interval(self, has_output_time_interval):
        """Sets the has_output_time_interval of this ModelConfiguration.

        Time interval used in the model configuration  # noqa: E501

        :param has_output_time_interval: The has_output_time_interval of this ModelConfiguration.  # noqa: E501
        :type: list[TimeInterval]
        """

        self._has_output_time_interval = has_output_time_interval

    @property
    def has_output_variable(self):
        """Gets the has_output_variable of this ModelConfiguration.  # noqa: E501

        Variable that is used as output for this model  # noqa: E501

        :return: The has_output_variable of this ModelConfiguration.  # noqa: E501
        :rtype: list[VariablePresentation]
        """
        return self._has_output_variable

    @has_output_variable.setter
    def has_output_variable(self, has_output_variable):
        """Sets the has_output_variable of this ModelConfiguration.

        Variable that is used as output for this model  # noqa: E501

        :param has_output_variable: The has_output_variable of this ModelConfiguration.  # noqa: E501
        :type: list[VariablePresentation]
        """

        self._has_output_variable = has_output_variable

    @property
    def has_parameter(self):
        """Gets the has_parameter of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_parameter of this ModelConfiguration.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._has_parameter

    @has_parameter.setter
    def has_parameter(self, has_parameter):
        """Sets the has_parameter of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_parameter: The has_parameter of this ModelConfiguration.  # noqa: E501
        :type: list[Parameter]
        """

        self._has_parameter = has_parameter

    @property
    def has_process(self):
        """Gets the has_process of this ModelConfiguration.  # noqa: E501

        Property that indicates which physical processes (if any) are associated with a model  # noqa: E501

        :return: The has_process of this ModelConfiguration.  # noqa: E501
        :rtype: list[Process]
        """
        return self._has_process

    @has_process.setter
    def has_process(self, has_process):
        """Sets the has_process of this ModelConfiguration.

        Property that indicates which physical processes (if any) are associated with a model  # noqa: E501

        :param has_process: The has_process of this ModelConfiguration.  # noqa: E501
        :type: list[Process]
        """

        self._has_process = has_process

    @property
    def has_purpose(self):
        """Gets the has_purpose of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_purpose of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_purpose

    @has_purpose.setter
    def has_purpose(self, has_purpose):
        """Sets the has_purpose of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_purpose: The has_purpose of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_purpose = has_purpose

    @property
    def has_region(self):
        """Gets the has_region of this ModelConfiguration.  # noqa: E501

        Property linking a region to a model configuration/calibration. This property implies that the described model configuration is prepared to execute in that target region  # noqa: E501

        :return: The has_region of this ModelConfiguration.  # noqa: E501
        :rtype: list[Region]
        """
        return self._has_region

    @has_region.setter
    def has_region(self, has_region):
        """Sets the has_region of this ModelConfiguration.

        Property linking a region to a model configuration/calibration. This property implies that the described model configuration is prepared to execute in that target region  # noqa: E501

        :param has_region: The has_region of this ModelConfiguration.  # noqa: E501
        :type: list[Region]
        """

        self._has_region = has_region

    @property
    def has_sample_execution(self):
        """Gets the has_sample_execution of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_sample_execution of this ModelConfiguration.  # noqa: E501
        :rtype: list[SampleExecution]
        """
        return self._has_sample_execution

    @has_sample_execution.setter
    def has_sample_execution(self, has_sample_execution):
        """Sets the has_sample_execution of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_sample_execution: The has_sample_execution of this ModelConfiguration.  # noqa: E501
        :type: list[SampleExecution]
        """

        self._has_sample_execution = has_sample_execution

    @property
    def has_sample_result(self):
        """Gets the has_sample_result of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_sample_result of this ModelConfiguration.  # noqa: E501
        :rtype: list[SampleResource]
        """
        return self._has_sample_result

    @has_sample_result.setter
    def has_sample_result(self, has_sample_result):
        """Sets the has_sample_result of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_sample_result: The has_sample_result of this ModelConfiguration.  # noqa: E501
        :type: list[SampleResource]
        """

        self._has_sample_result = has_sample_result

    @property
    def has_sample_visualization(self):
        """Gets the has_sample_visualization of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_sample_visualization of this ModelConfiguration.  # noqa: E501
        :rtype: list[Visualization]
        """
        return self._has_sample_visualization

    @has_sample_visualization.setter
    def has_sample_visualization(self, has_sample_visualization):
        """Sets the has_sample_visualization of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_sample_visualization: The has_sample_visualization of this ModelConfiguration.  # noqa: E501
        :type: list[Visualization]
        """

        self._has_sample_visualization = has_sample_visualization

    @property
    def has_setup(self):
        """Gets the has_setup of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_setup of this ModelConfiguration.  # noqa: E501
        :rtype: list[ConfigurationSetup]
        """
        return self._has_setup

    @has_setup.setter
    def has_setup(self, has_setup):
        """Sets the has_setup of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_setup: The has_setup of this ModelConfiguration.  # noqa: E501
        :type: list[ConfigurationSetup]
        """

        self._has_setup = has_setup

    @property
    def has_software_image(self):
        """Gets the has_software_image of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_software_image of this ModelConfiguration.  # noqa: E501
        :rtype: list[SoftwareImage]
        """
        return self._has_software_image

    @has_software_image.setter
    def has_software_image(self, has_software_image):
        """Sets the has_software_image of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_software_image: The has_software_image of this ModelConfiguration.  # noqa: E501
        :type: list[SoftwareImage]
        """

        self._has_software_image = has_software_image

    @property
    def has_source_code(self):
        """Gets the has_source_code of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_source_code of this ModelConfiguration.  # noqa: E501
        :rtype: list[SourceCode]
        """
        return self._has_source_code

    @has_source_code.setter
    def has_source_code(self, has_source_code):
        """Sets the has_source_code of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_source_code: The has_source_code of this ModelConfiguration.  # noqa: E501
        :type: list[SourceCode]
        """

        self._has_source_code = has_source_code

    @property
    def has_support_script_location(self):
        """Gets the has_support_script_location of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_support_script_location of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_support_script_location

    @has_support_script_location.setter
    def has_support_script_location(self, has_support_script_location):
        """Sets the has_support_script_location of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_support_script_location: The has_support_script_location of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_support_script_location = has_support_script_location

    @property
    def has_typical_data_source(self):
        """Gets the has_typical_data_source of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_typical_data_source of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_typical_data_source

    @has_typical_data_source.setter
    def has_typical_data_source(self, has_typical_data_source):
        """Sets the has_typical_data_source of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_typical_data_source: The has_typical_data_source of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_typical_data_source = has_typical_data_source

    @property
    def has_usage_notes(self):
        """Gets the has_usage_notes of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_usage_notes of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_usage_notes

    @has_usage_notes.setter
    def has_usage_notes(self, has_usage_notes):
        """Sets the has_usage_notes of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_usage_notes: The has_usage_notes of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_usage_notes = has_usage_notes

    @property
    def has_version(self):
        """Gets the has_version of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The has_version of this ModelConfiguration.  # noqa: E501
        :rtype: list[SoftwareVersion]
        """
        return self._has_version

    @has_version.setter
    def has_version(self, has_version):
        """Sets the has_version of this ModelConfiguration.

        Description not available  # noqa: E501

        :param has_version: The has_version of this ModelConfiguration.  # noqa: E501
        :type: list[SoftwareVersion]
        """

        self._has_version = has_version

    @property
    def id(self):
        """Gets the id of this ModelConfiguration.  # noqa: E501

        identifier  # noqa: E501

        :return: The id of this ModelConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ModelConfiguration.

        identifier  # noqa: E501

        :param id: The id of this ModelConfiguration.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def identifier(self):
        """Gets the identifier of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The identifier of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this ModelConfiguration.

        Description not available  # noqa: E501

        :param identifier: The identifier of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._identifier = identifier

    @property
    def issue_tracker(self):
        """Gets the issue_tracker of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The issue_tracker of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._issue_tracker

    @issue_tracker.setter
    def issue_tracker(self, issue_tracker):
        """Sets the issue_tracker of this ModelConfiguration.

        Description not available  # noqa: E501

        :param issue_tracker: The issue_tracker of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._issue_tracker = issue_tracker

    @property
    def keywords(self):
        """Gets the keywords of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The keywords of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """Sets the keywords of this ModelConfiguration.

        Description not available  # noqa: E501

        :param keywords: The keywords of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._keywords = keywords

    @property
    def label(self):
        """Gets the label of this ModelConfiguration.  # noqa: E501

        short description of the resource  # noqa: E501

        :return: The label of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this ModelConfiguration.

        short description of the resource  # noqa: E501

        :param label: The label of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._label = label

    @property
    def license(self):
        """Gets the license of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The license of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._license

    @license.setter
    def license(self, license):
        """Sets the license of this ModelConfiguration.

        Description not available  # noqa: E501

        :param license: The license of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._license = license

    @property
    def limitations(self):
        """Gets the limitations of this ModelConfiguration.  # noqa: E501

        Known restrictions (i.e. cases where the model is known not to be reliable or shouldn't be used)  # noqa: E501

        :return: The limitations of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._limitations

    @limitations.setter
    def limitations(self, limitations):
        """Sets the limitations of this ModelConfiguration.

        Known restrictions (i.e. cases where the model is known not to be reliable or shouldn't be used)  # noqa: E501

        :param limitations: The limitations of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._limitations = limitations

    @property
    def logo(self):
        """Gets the logo of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The logo of this ModelConfiguration.  # noqa: E501
        :rtype: list[Image]
        """
        return self._logo

    @logo.setter
    def logo(self, logo):
        """Sets the logo of this ModelConfiguration.

        Description not available  # noqa: E501

        :param logo: The logo of this ModelConfiguration.  # noqa: E501
        :type: list[Image]
        """

        self._logo = logo

    @property
    def memory_requirements(self):
        """Gets the memory_requirements of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The memory_requirements of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._memory_requirements

    @memory_requirements.setter
    def memory_requirements(self, memory_requirements):
        """Sets the memory_requirements of this ModelConfiguration.

        Description not available  # noqa: E501

        :param memory_requirements: The memory_requirements of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._memory_requirements = memory_requirements

    @property
    def operating_systems(self):
        """Gets the operating_systems of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The operating_systems of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._operating_systems

    @operating_systems.setter
    def operating_systems(self, operating_systems):
        """Sets the operating_systems of this ModelConfiguration.

        Description not available  # noqa: E501

        :param operating_systems: The operating_systems of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._operating_systems = operating_systems

    @property
    def parameterization(self):
        """Gets the parameterization of this ModelConfiguration.  # noqa: E501

        Were there any simplifications made to processes to make the model more efficient  # noqa: E501

        :return: The parameterization of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._parameterization

    @parameterization.setter
    def parameterization(self, parameterization):
        """Sets the parameterization of this ModelConfiguration.

        Were there any simplifications made to processes to make the model more efficient  # noqa: E501

        :param parameterization: The parameterization of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._parameterization = parameterization

    @property
    def processor_requirements(self):
        """Gets the processor_requirements of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The processor_requirements of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._processor_requirements

    @processor_requirements.setter
    def processor_requirements(self, processor_requirements):
        """Sets the processor_requirements of this ModelConfiguration.

        Description not available  # noqa: E501

        :param processor_requirements: The processor_requirements of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._processor_requirements = processor_requirements

    @property
    def publisher(self):
        """Gets the publisher of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The publisher of this ModelConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._publisher

    @publisher.setter
    def publisher(self, publisher):
        """Sets the publisher of this ModelConfiguration.

        Description not available  # noqa: E501

        :param publisher: The publisher of this ModelConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._publisher = publisher

    @property
    def readme(self):
        """Gets the readme of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The readme of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._readme

    @readme.setter
    def readme(self, readme):
        """Sets the readme of this ModelConfiguration.

        Description not available  # noqa: E501

        :param readme: The readme of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._readme = readme

    @property
    def reference_publication(self):
        """Gets the reference_publication of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The reference_publication of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._reference_publication

    @reference_publication.setter
    def reference_publication(self, reference_publication):
        """Sets the reference_publication of this ModelConfiguration.

        Description not available  # noqa: E501

        :param reference_publication: The reference_publication of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._reference_publication = reference_publication

    @property
    def runtime_estimation(self):
        """Gets the runtime_estimation of this ModelConfiguration.  # noqa: E501

        An estimate of the time required to run example codes or other known configurations  # noqa: E501

        :return: The runtime_estimation of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._runtime_estimation

    @runtime_estimation.setter
    def runtime_estimation(self, runtime_estimation):
        """Sets the runtime_estimation of this ModelConfiguration.

        An estimate of the time required to run example codes or other known configurations  # noqa: E501

        :param runtime_estimation: The runtime_estimation of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._runtime_estimation = runtime_estimation

    @property
    def screenshot(self):
        """Gets the screenshot of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The screenshot of this ModelConfiguration.  # noqa: E501
        :rtype: list[Image]
        """
        return self._screenshot

    @screenshot.setter
    def screenshot(self, screenshot):
        """Sets the screenshot of this ModelConfiguration.

        Description not available  # noqa: E501

        :param screenshot: The screenshot of this ModelConfiguration.  # noqa: E501
        :type: list[Image]
        """

        self._screenshot = screenshot

    @property
    def short_description(self):
        """Gets the short_description of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The short_description of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this ModelConfiguration.

        Description not available  # noqa: E501

        :param short_description: The short_description of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._short_description = short_description

    @property
    def software_requirements(self):
        """Gets the software_requirements of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The software_requirements of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._software_requirements

    @software_requirements.setter
    def software_requirements(self, software_requirements):
        """Sets the software_requirements of this ModelConfiguration.

        Description not available  # noqa: E501

        :param software_requirements: The software_requirements of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._software_requirements = software_requirements

    @property
    def support_details(self):
        """Gets the support_details of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The support_details of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._support_details

    @support_details.setter
    def support_details(self, support_details):
        """Sets the support_details of this ModelConfiguration.

        Description not available  # noqa: E501

        :param support_details: The support_details of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._support_details = support_details

    @property
    def tag(self):
        """Gets the tag of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The tag of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this ModelConfiguration.

        Description not available  # noqa: E501

        :param tag: The tag of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._tag = tag

    @property
    def theoretical_basis(self):
        """Gets the theoretical_basis of this ModelConfiguration.  # noqa: E501

        What is the theory behind the processes described in the model  # noqa: E501

        :return: The theoretical_basis of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._theoretical_basis

    @theoretical_basis.setter
    def theoretical_basis(self, theoretical_basis):
        """Sets the theoretical_basis of this ModelConfiguration.

        What is the theory behind the processes described in the model  # noqa: E501

        :param theoretical_basis: The theoretical_basis of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._theoretical_basis = theoretical_basis

    @property
    def type(self):
        """Gets the type of this ModelConfiguration.  # noqa: E501

        type of the resource  # noqa: E501

        :return: The type of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ModelConfiguration.

        type of the resource  # noqa: E501

        :param type: The type of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._type = type

    @property
    def useful_for_calculating_index(self):
        """Gets the useful_for_calculating_index of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The useful_for_calculating_index of this ModelConfiguration.  # noqa: E501
        :rtype: list[NumericalIndex]
        """
        return self._useful_for_calculating_index

    @useful_for_calculating_index.setter
    def useful_for_calculating_index(self, useful_for_calculating_index):
        """Sets the useful_for_calculating_index of this ModelConfiguration.

        Description not available  # noqa: E501

        :param useful_for_calculating_index: The useful_for_calculating_index of this ModelConfiguration.  # noqa: E501
        :type: list[NumericalIndex]
        """

        self._useful_for_calculating_index = useful_for_calculating_index

    @property
    def website(self):
        """Gets the website of this ModelConfiguration.  # noqa: E501

        Description not available  # noqa: E501

        :return: The website of this ModelConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this ModelConfiguration.

        Description not available  # noqa: E501

        :param website: The website of this ModelConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._website = website

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModelConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
