# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['InquirerPy', 'InquirerPy.base', 'InquirerPy.containers', 'InquirerPy.prompts']

package_data = \
{'': ['*']}

install_requires = \
['pfzy>=0.3.1,<0.4.0', 'prompt-toolkit>=3.0.1,<4.0.0']

extras_require = \
{'docs': ['Sphinx>=4.1.2,<5.0.0',
          'furo>=2021.8.17-beta.43,<2022.0.0',
          'sphinx-copybutton>=0.4.0,<0.5.0',
          'sphinx-autobuild>=2021.3.14,<2022.0.0',
          'myst-parser>=0.15.1,<0.16.0']}

setup_kwargs = {
    'name': 'inquirerpy',
    'version': '0.3.2',
    'description': 'Python port of Inquirer.js (A collection of common interactive command-line user interfaces)',
    'long_description': '# InquirerPy\n\n[![Test](https://github.com/kazhala/InquirerPy/workflows/Test/badge.svg)](https://github.com/kazhala/InquirerPy/actions?query=workflow%3ATest)\n[![Lint](https://github.com/kazhala/InquirerPy/workflows/Lint/badge.svg)](https://github.com/kazhala/InquirerPy/actions?query=workflow%3ALint)\n[![Build](https://codebuild.ap-southeast-2.amazonaws.com/badges?uuid=eyJlbmNyeXB0ZWREYXRhIjoiUUYyRUIxOXBWZ0hKcUhrbXplQklMemRsTVBxbUk3bFlTdldnRGpxeEpQSXJidEtmVEVzbVNCTE1UR3VoRSt2N0NQV0VaUXlCUzNackFBNzRVUFBBS1FnPSIsIml2UGFyYW1ldGVyU3BlYyI6IloxREtFeWY4WkhxV0NFWU0iLCJtYXRlcmlhbFNldFNlcmlhbCI6MX0%3D&branch=master)](https://ap-southeast-2.console.aws.amazon.com/codesuite/codebuild/378756445655/projects/InquirerPy/history?region=ap-southeast-2&builds-meta=eyJmIjp7InRleHQiOiIifSwicyI6e30sIm4iOjIwLCJpIjowfQ)\n[![Coverage](https://img.shields.io/coveralls/github/kazhala/InquirerPy?logo=coveralls)](https://coveralls.io/github/kazhala/InquirerPy?branch=master)\n[![Version](https://img.shields.io/pypi/pyversions/InquirerPy)](https://pypi.org/project/InquirerPy/)\n[![PyPi](https://img.shields.io/pypi/v/InquirerPy)](https://pypi.org/project/InquirerPy/)\n\nDocumentation: [inquirerpy.readthedocs.io](https://inquirerpy.readthedocs.io/)\n\n<!-- start intro -->\n\n## Introduction\n\n`InquirerPy` is a Python port of the famous [Inquirer.js](https://github.com/SBoudrias/Inquirer.js/) (A collection of common interactive command line user interfaces).\nThis project is a re-implementation of the [PyInquirer](https://github.com/CITGuru/PyInquirer) project, with bug fixes of known issues, new prompts, backward compatible APIs\nas well as more customisation options.\n\n<!-- end intro -->\n\n![Demo](https://github.com/kazhala/gif/blob/master/InquirerPy-demo.gif)\n\n## Motivation\n\n[PyInquirer](https://github.com/CITGuru/PyInquirer) is a great Python port of [Inquirer.js](https://github.com/SBoudrias/Inquirer.js/), however, the project is slowly reaching\nto an unmaintained state with various issues left behind and no intention to implement more feature requests. I was heavily relying on this library for other projects but\ncould not proceed due to the limitations.\n\nSome noticeable ones that bother me the most:\n\n- hard limit on `prompt_toolkit` version 1.0.3\n- various color issues\n- various cursor issues\n- No options for VI/Emacs navigation key bindings\n- Pagination option doesn\'t work\n\nThis project uses python3.7+ type hinting with focus on resolving above issues while providing greater customisation options.\n\n## Requirements\n\n### OS\n\nLeveraging [prompt_toolkit](https://github.com/prompt-toolkit/python-prompt-toolkit), `InquirerPy` works cross platform for all OS. Although Unix platform may have a better experience than Windows.\n\n### Python\n\n```\npython >= 3.7\n```\n\n## Getting Started\n\nCheckout full documentation **[here](https://inquirerpy.readthedocs.io/)**.\n\n### Install\n\n```sh\npip3 install InquirerPy\n```\n\n### Quick Start\n\n#### Classic Syntax (PyInquirer)\n\n```python\nfrom InquirerPy import prompt\n\nquestions = [\n    {"type": "input", "message": "What\'s your name:", "name": "name"},\n    {"type": "confirm", "message": "Confirm?", "name": "confirm"},\n]\nresult = prompt(questions)\nname = result["name"]\nconfirm = result["confirm"]\n```\n\n#### Alternate Syntax\n\n```python\nfrom InquirerPy import inquirer\n\nname = inquirer.text(message="What\'s your name:").execute()\nconfirm = inquirer.confirm(message="Confirm?").execute()\n```\n\n<!-- start migration -->\n\n## Migrating from PyInquirer\n\nMost APIs from [PyInquirer](https://github.com/CITGuru/PyInquirer) should be compatible with `InquirerPy`. If you have discovered more incompatible APIs, please\ncreate an issue or directly update README via a pull request.\n\n### EditorPrompt\n\n`InquirerPy` does not support [editor](https://github.com/CITGuru/PyInquirer#editor---type-editor) prompt as of now.\n\n### CheckboxPrompt\n\nThe following table contains the mapping of incompatible parameters.\n\n| PyInquirer      | InquirerPy      |\n| --------------- | --------------- |\n| pointer_sign    | pointer         |\n| selected_sign   | enabled_symbol  |\n| unselected_sign | disabled_symbol |\n\n### Style\n\nEvery style keys from [PyInquirer](https://github.com/CITGuru/PyInquirer) is present in `InquirerPy` except the ones in the following table.\n\n| PyInquirer | InquirerPy |\n| ---------- | ---------- |\n| selected   | pointer    |\n\nAlthough `InquirerPy` support all the keys from [PyInquirer](https://github.com/CITGuru/PyInquirer), the styling works slightly different.\nPlease refer to the [Style](https://inquirerpy.readthedocs.io/en/latest/pages/style.html) documentation for detailed information.\n\n<!-- end migration -->\n\n## Similar projects\n\n### questionary\n\n[questionary](https://github.com/tmbo/questionary) is a fantastic fork which supports `prompt_toolkit` 3.0.0+ with performance improvement and more customisation options.\nIt\'s already a well established and stable library.\n\nComparing with [questionary](https://github.com/tmbo/questionary), `InquirerPy` offers even more customisation options in styles, UI as well as key bindings. `InquirerPy` also provides a new\nand powerful [fuzzy](https://inquirerpy.readthedocs.io/en/latest/pages/prompts/fuzzy.html) prompt.\n\n### python-inquirer\n\n[python-inquirer](https://github.com/magmax/python-inquirer) is another great Python port of [Inquirer.js](https://github.com/SBoudrias/Inquirer.js/). Instead of using `prompt_toolkit`, it\nleverages the library `blessed` to implement the UI.\n\nBefore implementing `InquirerPy`, this library came up as an alternative. It\'s a more stable library comparing to the original [PyInquirer](https://github.com/CITGuru/PyInquirer), however\nit has a rather limited customisation options and an older UI which did not solve the issues I was facing described in the [Motivation](#Motivation) section.\n\nComparing with [python-inquirer](https://github.com/magmax/python-inquirer), `InquirerPy` offers a slightly better UI,\nmore customisation options in key bindings and styles, providing pagination as well as more prompts.\n\n## Credit\n\nThis project is based on the great work done by the following projects & their authors.\n\n- [PyInquirer](https://github.com/CITGuru/PyInquirer)\n- [prompt_toolkit](https://github.com/prompt-toolkit/python-prompt-toolkit)\n\n## License\n\nThis project is licensed under [MIT](https://github.com/kazhala/InquirerPy/blob/master/LICENSE).\n',
    'author': 'Kevin Zhuang',
    'author_email': 'kevin7441@gmail.com',
    'maintainer': 'Kevin Zhuang',
    'maintainer_email': 'kevin7441@gmail.com',
    'url': 'https://github.com/kazhala/InquirerPy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
