# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['airflow_oracle_snowflake_plugin',
 'airflow_oracle_snowflake_plugin.hooks',
 'airflow_oracle_snowflake_plugin.utils']

package_data = \
{'': ['*']}

install_requires = \
['apache-airflow-providers-oracle>=3.4.0,<4.0.0',
 'apache-airflow-providers-snowflake>=3.3.0,<4.0.0',
 'oracledb>=1.2.0,<2.0.0']

setup_kwargs = {
    'name': 'airflow-oracle-snowflake-plugin',
    'version': '0.1.2',
    'description': 'Packag for airflow operator which copies tables from oracle database to snowflake.',
    'long_description': "# airflow-oracle-snowflake-plugin\n\n### Steps to use the OracleToSnowflake from the plugin\n\n1. Install the plugin by `pip install airflow-oracle-snowflake-plugin`. You can put `airflow-oracle-snowflake-plugin` in the requirements.txt file for CI/CD operations. This plugin will also install the following dependencies if not already satisfied:\n\n    * oracledb\n    * apache-airflow-providers-oracle\n    * apache-airflow-providers-snowflake\n\n\n2. Create `config.py` inside `dags/table_config` directory. This file will include the necessary information about the source and destination database table specifications. It will have the structure as follows:\n\n```py\n  CONFIG = [\n    {\n        'source_schema': 'ADMIN',\n        'source_table': 'CUSTOMERS',\n        'destination_schema': 'PUBLIC',\n        'destination_table': 'CUSTOMERS',\n        'columns': [\n            ('ID', 'varchar'),\n            ('FULL_NAME', 'varchar'),\n            ('ADDRESS', 'varchar'),\n            ('EMAIL', 'varchar'),\n            ('PHONE_NUMBER', 'varchar'),\n        ]\n    },\n]\n```\n\n3. Import the operator, sql_utils and the config in your DAG python file by including the following statements:\n\n```\nfrom airflow_oracle_snowflake_plugin.oracle_to_snowflake_operator import OracleToSnowflake\nimport airflow_oracle_snowflake_plugin.utils.sql_utils as sql_utils\nfrom table_config.config import CONFIG\n```\n    \n4. Implement a for loop to iterate over all the table configurations and create DAG tasks using the operator as follows:\n\n```py\nfor config in CONFIG:\n    create_table_statement = sql_utils.get_create_statement(\n        table_name=config.get('destination_table'),\n        columns_definition=config.get('columns')\n    )\n    create_table_if_not_exists = SnowflakeOperator(\n        task_id='create_{}'.format(config.get('destination_table')),\n        snowflake_conn_id='SNOWFLAKE',\n        sql=create_table_statement,\n        warehouse='LANDING',\n        database='LANDING_DEV',\n        role='ACCOUNTADMIN',\n        schema=config.get('destination_schema'),\n        dag=dag\n    )\n\n    fill_table_statement = sql_utils.get_select_statement(\n        table_name=config.get('source_table'),\n        schema_name=config.get('source_schema'),\n        columns_definition=config.get('columns'),\n        sql_server_syntax=False\n    )\n\n    oracle_to_snowflake_operator = OracleToSnowflake(\n        task_id = 'recreate_{}'.format(config.get('destination_table')),\n        dag = dag,\n        warehouse='LANDING',\n        database='LANDING_DEV',\n        role='ACCOUNTADMIN',\n        schema='PUBLIC',\n        source_schema=config.get('source_schema'),\n        source_table=config.get('source_table'),\n        destination_schema=config.get('destination_schema'),\n        destination_table=config.get('destination_table'),\n        fill_table_statement=fill_table_statement,\n        snowflake_conn_id='SNOWFLAKE',\n        oracle_conn_id='ORACLE',\n        recreate_table=True\n    )\n    create_table_if_not_exists >> oracle_to_snowflake_operator\n```\n\nThis script will create two tasks for each table in Oracle database that you want to migrate. This will be determined by the `CONFIG` array in `config.py`.\n\n#### First Task\n\nFirst task creates the table in the Snowflake database if it doesn't exist already using the SnowflakeOperator. It requires:\n\n* An existing airflow connection to your Snowflake account\n* Name of the warehouse to use ('LANDING' in the example above)\n* Name of the database to use ('LANDING_DEV' in the example above)\n* Name of the role to use ('ACCOUNTADMIN' in the example above). \n* It takes an SQL statement which we have provided as the `create_table_statement` generated by the `sql_utils.get_create_statement` method. The method uses `CONFIG` and extracts the table name, columns, and their data types.\n\n#### Second Task\n\nThe second task uses the `OracleToSnowflake` operator from the plugin. It creates a temporary csv file after selecting the rows from the source table, uploads it to a Snowflake stage, and finally uploads it to the destination table in Snowflake. It requires:\n\n* An existing airflow connection id to your Snowflake account as well as your Oracle database instance. The connection IDs will default to `SNOWFLAKE` and `ORACLE` if not provided. \n* Inside the operator, a custom Snowflake hook is used which will upload the csv file to a Snowflake table. This hook requires:\n    * Name of the warehouse to use (defaults to 'LANDING' if not provided)\n    * Name of the database to use (defaults to'LANDING_DEV' if not provided)\n    * Name of the role to use (defaults to 'ACCOUNTADMIN' if not provided).\n* It takes an SQL statement which we have provided as the `fill_table_statement` generated by the `sql_utils.get_select_statement` method. The method uses `CONFIG` and extracts the table name, schema, and the columns.\n\n### Note\n\nAdded tags to facilitate version releasing and CI/CD operations ",
    'author': 'Ali Bhayani',
    'author_email': 'ali@cloudshuttle.com.au',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
