# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_vpc20160428 import models as vpc_20160428_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'vpc.aliyuncs.com',
            'cn-beijing': 'vpc.aliyuncs.com',
            'cn-hangzhou': 'vpc.aliyuncs.com',
            'cn-shanghai': 'vpc.aliyuncs.com',
            'cn-shenzhen': 'vpc.aliyuncs.com',
            'cn-hongkong': 'vpc.aliyuncs.com',
            'ap-southeast-1': 'vpc.aliyuncs.com',
            'us-east-1': 'vpc.aliyuncs.com',
            'us-west-1': 'vpc.aliyuncs.com',
            'cn-shanghai-finance-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-finance-1': 'vpc.aliyuncs.com',
            'cn-north-2-gov-1': 'vpc.aliyuncs.com',
            'ap-northeast-2-pop': 'vpc.aliyuncs.com',
            'cn-beijing-finance-pop': 'vpc.aliyuncs.com',
            'cn-beijing-gov-1': 'vpc.aliyuncs.com',
            'cn-beijing-nu16-b01': 'vpc.aliyuncs.com',
            'cn-edge-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-fujian': 'vpc.aliyuncs.com',
            'cn-haidian-cm12-c01': 'vpc.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'vpc.aliyuncs.com',
            'cn-hangzhou-finance': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'vpc.aliyuncs.com',
            'cn-hangzhou-test-306': 'vpc.aliyuncs.com',
            'cn-hongkong-finance-pop': 'vpc.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-qingdao-nebula': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-shanghai-et15-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-et2-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-inner': 'vpc.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-inner': 'vpc.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'vpc.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'vpc.aliyuncs.com',
            'cn-wuhan': 'vpc.aliyuncs.com',
            'cn-yushanfang': 'vpc.aliyuncs.com',
            'cn-zhangbei': 'vpc.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'vpc.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'vpc.cn-zhangjiakou.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'eu-west-1-oxs': 'vpc-nebula.cn-shenzhen-cloudstone.aliyuncs.com',
            'rus-west-1-pop': 'vpc.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('vpc', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def activate_router_interface_with_options(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Activating** state. After the router interface is activated, it enters the **Active** state.
        >  You cannot activate a router interface that has overdue payments.
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def activate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Activating** state. After the router interface is activated, it enters the **Active** state.
        >  You cannot activate a router interface that has overdue payments.
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def activate_router_interface(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Activating** state. After the router interface is activated, it enters the **Active** state.
        >  You cannot activate a router interface that has overdue payments.
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.activate_router_interface_with_options(request, runtime)

    async def activate_router_interface_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Activating** state. After the router interface is activated, it enters the **Active** state.
        >  You cannot activate a router interface that has overdue payments.
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.activate_router_interface_with_options_async(request, runtime)

    def active_flow_log_with_options(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        """
        The **ActiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being started.
        *   If the flow log is in the **Active** state, the flow log is started.
        *   You cannot repeatedly call the **ActiveFlowLog** operation to start a flow log within the specified period of time.
        
        @param request: ActiveFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActiveFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def active_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        """
        The **ActiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being started.
        *   If the flow log is in the **Active** state, the flow log is started.
        *   You cannot repeatedly call the **ActiveFlowLog** operation to start a flow log within the specified period of time.
        
        @param request: ActiveFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActiveFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def active_flow_log(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        """
        The **ActiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being started.
        *   If the flow log is in the **Active** state, the flow log is started.
        *   You cannot repeatedly call the **ActiveFlowLog** operation to start a flow log within the specified period of time.
        
        @param request: ActiveFlowLogRequest
        @return: ActiveFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.active_flow_log_with_options(request, runtime)

    async def active_flow_log_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        """
        The **ActiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being started.
        *   If the flow log is in the **Active** state, the flow log is started.
        *   You cannot repeatedly call the **ActiveFlowLog** operation to start a flow log within the specified period of time.
        
        @param request: ActiveFlowLogRequest
        @return: ActiveFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.active_flow_log_with_options_async(request, runtime)

    def add_bgp_network_with_options(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_bgp_network(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_bgp_network_with_options(request, runtime)

    async def add_bgp_network_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_bgp_network_with_options_async(request, runtime)

    def add_common_bandwidth_package_ip_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        """
        When you call this operation to associate an EIP with an EIP bandwidth plan, make sure that the EIP meets the following requirements:
        *   The EIP uses the pay-as-you-go billing method.
        *   The EIP and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIP is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIp** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIP is being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIP is associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCommonBandwidthPackageIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        """
        When you call this operation to associate an EIP with an EIP bandwidth plan, make sure that the EIP meets the following requirements:
        *   The EIP uses the pay-as-you-go billing method.
        *   The EIP and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIP is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIp** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIP is being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIP is associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCommonBandwidthPackageIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ip(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        """
        When you call this operation to associate an EIP with an EIP bandwidth plan, make sure that the EIP meets the following requirements:
        *   The EIP uses the pay-as-you-go billing method.
        *   The EIP and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIP is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIp** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIP is being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIP is associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpRequest
        @return: AddCommonBandwidthPackageIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ip_with_options(request, runtime)

    async def add_common_bandwidth_package_ip_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        """
        When you call this operation to associate an EIP with an EIP bandwidth plan, make sure that the EIP meets the following requirements:
        *   The EIP uses the pay-as-you-go billing method.
        *   The EIP and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIP is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIp** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIP is being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIP is associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpRequest
        @return: AddCommonBandwidthPackageIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ip_with_options_async(request, runtime)

    def add_common_bandwidth_package_ips_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        """
        When you call this operation to associate EIPs with an EIP bandwidth plan, make sure that the EIPs meet the following requirements:
        *   The EIPs use the pay-as-you-go billing method.
        *   The EIPs and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIPs is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIps** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIPs are being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIPs are associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCommonBandwidthPackageIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_ids):
            query['IpInstanceIds'] = request.ip_instance_ids
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ips_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        """
        When you call this operation to associate EIPs with an EIP bandwidth plan, make sure that the EIPs meet the following requirements:
        *   The EIPs use the pay-as-you-go billing method.
        *   The EIPs and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIPs is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIps** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIPs are being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIPs are associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCommonBandwidthPackageIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_ids):
            query['IpInstanceIds'] = request.ip_instance_ids
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ips(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        """
        When you call this operation to associate EIPs with an EIP bandwidth plan, make sure that the EIPs meet the following requirements:
        *   The EIPs use the pay-as-you-go billing method.
        *   The EIPs and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIPs is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIps** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIPs are being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIPs are associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpsRequest
        @return: AddCommonBandwidthPackageIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ips_with_options(request, runtime)

    async def add_common_bandwidth_package_ips_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        """
        When you call this operation to associate EIPs with an EIP bandwidth plan, make sure that the EIPs meet the following requirements:
        *   The EIPs use the pay-as-you-go billing method.
        *   The EIPs and the EIP bandwidth plan belong to the same region.
        *   The line type of the EIPs is the same as that of the EIP bandwidth plan.
        *   The **AddCommonBandwidthPackageIps** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeCommonBandwidthPackages](~~120309~~) operation to query the status of an EIP bandwidth plan:
        *   If the EIP bandwidth plan is in the **BINDING** state, the EIPs are being associated with the EIP bandwidth plan. In this state, you can only query the EIP bandwidth plan and cannot perform other operations.
        *   If the EIP bandwidth plan is in the **BINDED** state, the EIPs are associated with the EIP bandwidth plan.
        
        @param request: AddCommonBandwidthPackageIpsRequest
        @return: AddCommonBandwidthPackageIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ips_with_options_async(request, runtime)

    def add_global_acceleration_instance_ip_with_options(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_global_acceleration_instance_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_global_acceleration_instance_ip(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_global_acceleration_instance_ip_with_options(request, runtime)

    async def add_global_acceleration_instance_ip_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_global_acceleration_instance_ip_with_options_async(request, runtime)

    def add_ipv_6translator_acl_list_entry_with_options(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_entry_comment):
            query['AclEntryComment'] = request.acl_entry_comment
        if not UtilClient.is_unset(request.acl_entry_ip):
            query['AclEntryIp'] = request.acl_entry_ip
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_ipv_6translator_acl_list_entry_with_options_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_entry_comment):
            query['AclEntryComment'] = request.acl_entry_comment
        if not UtilClient.is_unset(request.acl_entry_ip):
            query['AclEntryIp'] = request.acl_entry_ip
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_ipv_6translator_acl_list_entry(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_ipv_6translator_acl_list_entry_with_options(request, runtime)

    async def add_ipv_6translator_acl_list_entry_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_ipv_6translator_acl_list_entry_with_options_async(request, runtime)

    def add_public_ip_address_pool_cidr_block_with_options(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        """
        Before you call this operation, take note of the following limits:
        *   The CIDR block and the IP address pool must belong to the same region.
        *   The CIDR block and the IP address pool must use the same line type.
        *   The **AddPublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Modifying** state, the CIDR block is being added. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If the CIDR block is in the **Created** state, the CIDR block is added.
        *   You cannot repeatedly call the **AddPublicIpAddressPoolCidrBlock** operation to add a CIDR block to an IP address pool within the specified period of time.
        
        @param request: AddPublicIpAddressPoolCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPublicIpAddressPoolCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.cidr_mask):
            query['CidrMask'] = request.cidr_mask
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_public_ip_address_pool_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        """
        Before you call this operation, take note of the following limits:
        *   The CIDR block and the IP address pool must belong to the same region.
        *   The CIDR block and the IP address pool must use the same line type.
        *   The **AddPublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Modifying** state, the CIDR block is being added. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If the CIDR block is in the **Created** state, the CIDR block is added.
        *   You cannot repeatedly call the **AddPublicIpAddressPoolCidrBlock** operation to add a CIDR block to an IP address pool within the specified period of time.
        
        @param request: AddPublicIpAddressPoolCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPublicIpAddressPoolCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.cidr_mask):
            query['CidrMask'] = request.cidr_mask
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_public_ip_address_pool_cidr_block(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        """
        Before you call this operation, take note of the following limits:
        *   The CIDR block and the IP address pool must belong to the same region.
        *   The CIDR block and the IP address pool must use the same line type.
        *   The **AddPublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Modifying** state, the CIDR block is being added. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If the CIDR block is in the **Created** state, the CIDR block is added.
        *   You cannot repeatedly call the **AddPublicIpAddressPoolCidrBlock** operation to add a CIDR block to an IP address pool within the specified period of time.
        
        @param request: AddPublicIpAddressPoolCidrBlockRequest
        @return: AddPublicIpAddressPoolCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_public_ip_address_pool_cidr_block_with_options(request, runtime)

    async def add_public_ip_address_pool_cidr_block_async(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        """
        Before you call this operation, take note of the following limits:
        *   The CIDR block and the IP address pool must belong to the same region.
        *   The CIDR block and the IP address pool must use the same line type.
        *   The **AddPublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Modifying** state, the CIDR block is being added. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If the CIDR block is in the **Created** state, the CIDR block is added.
        *   You cannot repeatedly call the **AddPublicIpAddressPoolCidrBlock** operation to add a CIDR block to an IP address pool within the specified period of time.
        
        @param request: AddPublicIpAddressPoolCidrBlockRequest
        @return: AddPublicIpAddressPoolCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_public_ip_address_pool_cidr_block_with_options_async(request, runtime)

    def add_sources_to_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        """
        The **AddSourcesToTrafficMirrorSession** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Modifying** state, the traffic mirror source is being added to the traffic mirror session.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror source is being added to the traffic mirror session.
        *   You cannot repeatedly call the **AddSourcesToTrafficMirrorSession** operation to add a traffic mirror source to a traffic mirror session within the specified period of time.
        
        @param request: AddSourcesToTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSourcesToTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sources_to_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        """
        The **AddSourcesToTrafficMirrorSession** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Modifying** state, the traffic mirror source is being added to the traffic mirror session.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror source is being added to the traffic mirror session.
        *   You cannot repeatedly call the **AddSourcesToTrafficMirrorSession** operation to add a traffic mirror source to a traffic mirror session within the specified period of time.
        
        @param request: AddSourcesToTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSourcesToTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sources_to_traffic_mirror_session(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        """
        The **AddSourcesToTrafficMirrorSession** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Modifying** state, the traffic mirror source is being added to the traffic mirror session.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror source is being added to the traffic mirror session.
        *   You cannot repeatedly call the **AddSourcesToTrafficMirrorSession** operation to add a traffic mirror source to a traffic mirror session within the specified period of time.
        
        @param request: AddSourcesToTrafficMirrorSessionRequest
        @return: AddSourcesToTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_sources_to_traffic_mirror_session_with_options(request, runtime)

    async def add_sources_to_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        """
        The **AddSourcesToTrafficMirrorSession** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Modifying** state, the traffic mirror source is being added to the traffic mirror session.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror source is being added to the traffic mirror session.
        *   You cannot repeatedly call the **AddSourcesToTrafficMirrorSession** operation to add a traffic mirror source to a traffic mirror session within the specified period of time.
        
        @param request: AddSourcesToTrafficMirrorSessionRequest
        @return: AddSourcesToTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_sources_to_traffic_mirror_session_with_options_async(request, runtime)

    def allocate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        """
        Before you call this operation, make sure that you understand the billing methods and pricing of EIPs. For more information, see [Billing overview](~~122035~~).
        After you call this operation, the system randomly allocates an EIP that is in the **Available** state in the specified region. EIPs support only ICMP, TCP, and UDP at the transport layer. IGMP and SCTP are not supported.
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        """
        Before you call this operation, make sure that you understand the billing methods and pricing of EIPs. For more information, see [Billing overview](~~122035~~).
        After you call this operation, the system randomly allocates an EIP that is in the **Available** state in the specified region. EIPs support only ICMP, TCP, and UDP at the transport layer. IGMP and SCTP are not supported.
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        """
        Before you call this operation, make sure that you understand the billing methods and pricing of EIPs. For more information, see [Billing overview](~~122035~~).
        After you call this operation, the system randomly allocates an EIP that is in the **Available** state in the specified region. EIPs support only ICMP, TCP, and UDP at the transport layer. IGMP and SCTP are not supported.
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_with_options(request, runtime)

    async def allocate_eip_address_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        """
        Before you call this operation, make sure that you understand the billing methods and pricing of EIPs. For more information, see [Billing overview](~~122035~~).
        After you call this operation, the system randomly allocates an EIP that is in the **Available** state in the specified region. EIPs support only ICMP, TCP, and UDP at the transport layer. IGMP and SCTP are not supported.
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_with_options_async(request, runtime)

    def allocate_eip_address_pro_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_pro_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address_pro(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_pro_with_options(request, runtime)

    async def allocate_eip_address_pro_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_pro_with_options_async(request, runtime)

    def allocate_eip_segment_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        """
        *AllocateEipSegmentAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipSegment](/help/en/elastic-ip-address/latest/156063) operation to query the status of a contiguous EIP group:
        - If the contiguous EIP group is in the **Allocating** state, the EIPs are being allocated. In this case, you can only perform the query operation and cannot perform other operations.
        - If the contiguous EIP group is in the **Allocated** state, the EIPs are allocated.
        
        @param request: AllocateEipSegmentAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipSegmentAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_mask):
            query['EipMask'] = request.eip_mask
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_segment_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        """
        *AllocateEipSegmentAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipSegment](/help/en/elastic-ip-address/latest/156063) operation to query the status of a contiguous EIP group:
        - If the contiguous EIP group is in the **Allocating** state, the EIPs are being allocated. In this case, you can only perform the query operation and cannot perform other operations.
        - If the contiguous EIP group is in the **Allocated** state, the EIPs are allocated.
        
        @param request: AllocateEipSegmentAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipSegmentAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_mask):
            query['EipMask'] = request.eip_mask
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_segment_address(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        """
        *AllocateEipSegmentAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipSegment](/help/en/elastic-ip-address/latest/156063) operation to query the status of a contiguous EIP group:
        - If the contiguous EIP group is in the **Allocating** state, the EIPs are being allocated. In this case, you can only perform the query operation and cannot perform other operations.
        - If the contiguous EIP group is in the **Allocated** state, the EIPs are allocated.
        
        @param request: AllocateEipSegmentAddressRequest
        @return: AllocateEipSegmentAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_segment_address_with_options(request, runtime)

    async def allocate_eip_segment_address_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        """
        *AllocateEipSegmentAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipSegment](/help/en/elastic-ip-address/latest/156063) operation to query the status of a contiguous EIP group:
        - If the contiguous EIP group is in the **Allocating** state, the EIPs are being allocated. In this case, you can only perform the query operation and cannot perform other operations.
        - If the contiguous EIP group is in the **Allocated** state, the EIPs are allocated.
        
        @param request: AllocateEipSegmentAddressRequest
        @return: AllocateEipSegmentAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_segment_address_with_options_async(request, runtime)

    def allocate_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        """
        You cannot call the *AllocateIpv6InternetBandwidth** operation to purchase Internet bandwidth for an IPv6 gateway at the same time.
        
        @param request: AllocateIpv6InternetBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateIpv6InternetBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        """
        You cannot call the *AllocateIpv6InternetBandwidth** operation to purchase Internet bandwidth for an IPv6 gateway at the same time.
        
        @param request: AllocateIpv6InternetBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateIpv6InternetBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        """
        You cannot call the *AllocateIpv6InternetBandwidth** operation to purchase Internet bandwidth for an IPv6 gateway at the same time.
        
        @param request: AllocateIpv6InternetBandwidthRequest
        @return: AllocateIpv6InternetBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_ipv_6internet_bandwidth_with_options(request, runtime)

    async def allocate_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        """
        You cannot call the *AllocateIpv6InternetBandwidth** operation to purchase Internet bandwidth for an IPv6 gateway at the same time.
        
        @param request: AllocateIpv6InternetBandwidthRequest
        @return: AllocateIpv6InternetBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def allocate_vpc_ipv_6cidr_with_options(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        """
        The following section describes how to allocate an IPv6 CIDR block to a virtual private cloud (VPC):
        1\\. Call the AllocateVpcIpv6Cidr operation to reserve an IPv6 CIDR block.
        2\\. If you want to allocate the reserved IPv6 CIDR block to an existing VPC, call the [AssociateVpcCidrBlock](~~146745~~) operation, specify the **RegionId** and **VpcId** parameters, and set the **IPv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **IpVersion** parameter to **IPV6**. If you want to allocate the reserved IPv6 CIDR block to a new VPC, call the [CreateVpc](~~35737~~) operation, specify the **RegionId** parameter, and set the **Ipv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **EnableIpv6** parameter to **true**.
        
        @param request: AllocateVpcIpv6CidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateVpcIpv6CidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_pool_type):
            query['AddressPoolType'] = request.address_pool_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateVpcIpv6Cidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateVpcIpv6CidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_vpc_ipv_6cidr_with_options_async(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        """
        The following section describes how to allocate an IPv6 CIDR block to a virtual private cloud (VPC):
        1\\. Call the AllocateVpcIpv6Cidr operation to reserve an IPv6 CIDR block.
        2\\. If you want to allocate the reserved IPv6 CIDR block to an existing VPC, call the [AssociateVpcCidrBlock](~~146745~~) operation, specify the **RegionId** and **VpcId** parameters, and set the **IPv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **IpVersion** parameter to **IPV6**. If you want to allocate the reserved IPv6 CIDR block to a new VPC, call the [CreateVpc](~~35737~~) operation, specify the **RegionId** parameter, and set the **Ipv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **EnableIpv6** parameter to **true**.
        
        @param request: AllocateVpcIpv6CidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateVpcIpv6CidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_pool_type):
            query['AddressPoolType'] = request.address_pool_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateVpcIpv6Cidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateVpcIpv6CidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_vpc_ipv_6cidr(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        """
        The following section describes how to allocate an IPv6 CIDR block to a virtual private cloud (VPC):
        1\\. Call the AllocateVpcIpv6Cidr operation to reserve an IPv6 CIDR block.
        2\\. If you want to allocate the reserved IPv6 CIDR block to an existing VPC, call the [AssociateVpcCidrBlock](~~146745~~) operation, specify the **RegionId** and **VpcId** parameters, and set the **IPv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **IpVersion** parameter to **IPV6**. If you want to allocate the reserved IPv6 CIDR block to a new VPC, call the [CreateVpc](~~35737~~) operation, specify the **RegionId** parameter, and set the **Ipv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **EnableIpv6** parameter to **true**.
        
        @param request: AllocateVpcIpv6CidrRequest
        @return: AllocateVpcIpv6CidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_vpc_ipv_6cidr_with_options(request, runtime)

    async def allocate_vpc_ipv_6cidr_async(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        """
        The following section describes how to allocate an IPv6 CIDR block to a virtual private cloud (VPC):
        1\\. Call the AllocateVpcIpv6Cidr operation to reserve an IPv6 CIDR block.
        2\\. If you want to allocate the reserved IPv6 CIDR block to an existing VPC, call the [AssociateVpcCidrBlock](~~146745~~) operation, specify the **RegionId** and **VpcId** parameters, and set the **IPv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **IpVersion** parameter to **IPV6**. If you want to allocate the reserved IPv6 CIDR block to a new VPC, call the [CreateVpc](~~35737~~) operation, specify the **RegionId** parameter, and set the **Ipv6CidrBlock** parameter to the reserved IPv6 CIDR block and the **EnableIpv6** parameter to **true**.
        
        @param request: AllocateVpcIpv6CidrRequest
        @return: AllocateVpcIpv6CidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_vpc_ipv_6cidr_with_options_async(request, runtime)

    def apply_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.company_name):
            query['CompanyName'] = request.company_name
        if not UtilClient.is_unset(request.construction_time):
            query['ConstructionTime'] = request.construction_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_type):
            query['LineType'] = request.line_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pminfo):
            query['PMInfo'] = request.pminfo
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.si):
            query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.company_name):
            query['CompanyName'] = request.company_name
        if not UtilClient.is_unset(request.construction_time):
            query['ConstructionTime'] = request.construction_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_type):
            query['LineType'] = request.line_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pminfo):
            query['PMInfo'] = request.pminfo
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.si):
            query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_physical_connection_loa(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.apply_physical_connection_loawith_options(request, runtime)

    async def apply_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.apply_physical_connection_loawith_options_async(request, runtime)

    def associate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        """
        You can associate an EIP with an Elastic Compute Service (ECS) instance, a Classic Load Balancer (CLB) instance, a secondary elastic network interface (ENI), a NAT gateway, or a high-availability virtual IP address (HAVIP) in the same region. The ECS instance and CLB instance must be deployed in a virtual private cloud (VPC).
        *   **AssociateEipAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddress** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_region_id):
            query['InstanceRegionId'] = request.instance_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        """
        You can associate an EIP with an Elastic Compute Service (ECS) instance, a Classic Load Balancer (CLB) instance, a secondary elastic network interface (ENI), a NAT gateway, or a high-availability virtual IP address (HAVIP) in the same region. The ECS instance and CLB instance must be deployed in a virtual private cloud (VPC).
        *   **AssociateEipAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddress** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_region_id):
            query['InstanceRegionId'] = request.instance_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        """
        You can associate an EIP with an Elastic Compute Service (ECS) instance, a Classic Load Balancer (CLB) instance, a secondary elastic network interface (ENI), a NAT gateway, or a high-availability virtual IP address (HAVIP) in the same region. The ECS instance and CLB instance must be deployed in a virtual private cloud (VPC).
        *   **AssociateEipAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddress** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_with_options(request, runtime)

    async def associate_eip_address_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        """
        You can associate an EIP with an Elastic Compute Service (ECS) instance, a Classic Load Balancer (CLB) instance, a secondary elastic network interface (ENI), a NAT gateway, or a high-availability virtual IP address (HAVIP) in the same region. The ECS instance and CLB instance must be deployed in a virtual private cloud (VPC).
        *   **AssociateEipAddress** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddress** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_with_options_async(request, runtime)

    def associate_eip_address_batch_with_options(
        self,
        request: vpc_20160428_models.AssociateEipAddressBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressBatchResponse:
        """
        You can call the **AssociateEipAddressBatch** operation to associate EIPs with a NAT gateway or a secondary elastic network interface (ENI) in the same region. For more information about how to associate EIPs with other instances, see [AssociateEipAddress](~~120195~~).
        *   The **AssociateEipAddressBatch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddressBatch** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.binded_instance_id):
            query['BindedInstanceId'] = request.binded_instance_id
        if not UtilClient.is_unset(request.binded_instance_type):
            query['BindedInstanceType'] = request.binded_instance_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddressBatch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressBatchResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_batch_with_options_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressBatchResponse:
        """
        You can call the **AssociateEipAddressBatch** operation to associate EIPs with a NAT gateway or a secondary elastic network interface (ENI) in the same region. For more information about how to associate EIPs with other instances, see [AssociateEipAddress](~~120195~~).
        *   The **AssociateEipAddressBatch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddressBatch** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.binded_instance_id):
            query['BindedInstanceId'] = request.binded_instance_id
        if not UtilClient.is_unset(request.binded_instance_type):
            query['BindedInstanceType'] = request.binded_instance_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddressBatch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressBatchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address_batch(
        self,
        request: vpc_20160428_models.AssociateEipAddressBatchRequest,
    ) -> vpc_20160428_models.AssociateEipAddressBatchResponse:
        """
        You can call the **AssociateEipAddressBatch** operation to associate EIPs with a NAT gateway or a secondary elastic network interface (ENI) in the same region. For more information about how to associate EIPs with other instances, see [AssociateEipAddress](~~120195~~).
        *   The **AssociateEipAddressBatch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddressBatch** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressBatchRequest
        @return: AssociateEipAddressBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_batch_with_options(request, runtime)

    async def associate_eip_address_batch_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressBatchRequest,
    ) -> vpc_20160428_models.AssociateEipAddressBatchResponse:
        """
        You can call the **AssociateEipAddressBatch** operation to associate EIPs with a NAT gateway or a secondary elastic network interface (ENI) in the same region. For more information about how to associate EIPs with other instances, see [AssociateEipAddress](~~120195~~).
        *   The **AssociateEipAddressBatch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeEipAddresses](~~120193~~) operation to query the status of an EIP.
        *   If the EIP is in the **Associating** state, the EIP is being associated. In this state, you can only query the EIP and cannot perform other operations.
        *   If the EIP is in the **InUse** state, the EIP is associated.
        *   You cannot repeatedly call **AssociateEipAddressBatch** to associate an EIP with an instance within the specified period of time.
        
        @param request: AssociateEipAddressBatchRequest
        @return: AssociateEipAddressBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_batch_with_options_async(request, runtime)

    def associate_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_id):
            query['BackendServerId'] = request.backend_server_id
        if not UtilClient.is_unset(request.backend_server_region_id):
            query['BackendServerRegionId'] = request.backend_server_region_id
        if not UtilClient.is_unset(request.backend_server_type):
            query['BackendServerType'] = request.backend_server_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_id):
            query['BackendServerId'] = request.backend_server_id
        if not UtilClient.is_unset(request.backend_server_region_id):
            query['BackendServerRegionId'] = request.backend_server_region_id
        if not UtilClient.is_unset(request.backend_server_type):
            query['BackendServerType'] = request.backend_server_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_global_acceleration_instance(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_global_acceleration_instance_with_options(request, runtime)

    async def associate_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_global_acceleration_instance_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        """
        When you call this operation, take note of the following limits:
        *   An HAVIP immediately takes effect after it is associated. You do not need to restart the ECS instance. However, you must associate the HAVIP with the ENI of the ECS instance.
        *   The HAVIP and ECS instance must belong to the same vSwitch.
        *   You can associate an HAVIP with at most two ECS instances.
        *   The ECS instance must be in the **Running** or **Stopped** state.
        *   The HAVIP must be in the **Available** or **InUse** state.
        *   The **AssociateHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Associating** state, the HAVIP is being associated.
        *   If the HAVIP is in the **InUse** state, the HAVIP is associated.
        *   You cannot repeatedly call the **AssociateHaVip** operation to associate an HAVIP within the specified period of time.
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        """
        When you call this operation, take note of the following limits:
        *   An HAVIP immediately takes effect after it is associated. You do not need to restart the ECS instance. However, you must associate the HAVIP with the ENI of the ECS instance.
        *   The HAVIP and ECS instance must belong to the same vSwitch.
        *   You can associate an HAVIP with at most two ECS instances.
        *   The ECS instance must be in the **Running** or **Stopped** state.
        *   The HAVIP must be in the **Available** or **InUse** state.
        *   The **AssociateHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Associating** state, the HAVIP is being associated.
        *   If the HAVIP is in the **InUse** state, the HAVIP is associated.
        *   You cannot repeatedly call the **AssociateHaVip** operation to associate an HAVIP within the specified period of time.
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        """
        When you call this operation, take note of the following limits:
        *   An HAVIP immediately takes effect after it is associated. You do not need to restart the ECS instance. However, you must associate the HAVIP with the ENI of the ECS instance.
        *   The HAVIP and ECS instance must belong to the same vSwitch.
        *   You can associate an HAVIP with at most two ECS instances.
        *   The ECS instance must be in the **Running** or **Stopped** state.
        *   The HAVIP must be in the **Available** or **InUse** state.
        *   The **AssociateHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Associating** state, the HAVIP is being associated.
        *   If the HAVIP is in the **InUse** state, the HAVIP is associated.
        *   You cannot repeatedly call the **AssociateHaVip** operation to associate an HAVIP within the specified period of time.
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        """
        When you call this operation, take note of the following limits:
        *   An HAVIP immediately takes effect after it is associated. You do not need to restart the ECS instance. However, you must associate the HAVIP with the ENI of the ECS instance.
        *   The HAVIP and ECS instance must belong to the same vSwitch.
        *   You can associate an HAVIP with at most two ECS instances.
        *   The ECS instance must be in the **Running** or **Stopped** state.
        *   The HAVIP must be in the **Available** or **InUse** state.
        *   The **AssociateHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Associating** state, the HAVIP is being associated.
        *   If the HAVIP is in the **InUse** state, the HAVIP is associated.
        *   You cannot repeatedly call the **AssociateHaVip** operation to associate an HAVIP within the specified period of time.
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def associate_network_acl_with_options(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        """
        The **AssociateNetworkAcl** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **BINDING** state, the network ACL is being associated.
        *   If the network ACL is in the **BINDED** state, the network ACL is associated.
        *   You cannot repeatedly call the **AssociateNetworkAcl** operation to associate a network ACL within the specified period of time.
        
        @param request: AssociateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        """
        The **AssociateNetworkAcl** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **BINDING** state, the network ACL is being associated.
        *   If the network ACL is in the **BINDED** state, the network ACL is associated.
        *   You cannot repeatedly call the **AssociateNetworkAcl** operation to associate a network ACL within the specified period of time.
        
        @param request: AssociateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_network_acl(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        """
        The **AssociateNetworkAcl** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **BINDING** state, the network ACL is being associated.
        *   If the network ACL is in the **BINDED** state, the network ACL is associated.
        *   You cannot repeatedly call the **AssociateNetworkAcl** operation to associate a network ACL within the specified period of time.
        
        @param request: AssociateNetworkAclRequest
        @return: AssociateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_network_acl_with_options(request, runtime)

    async def associate_network_acl_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        """
        The **AssociateNetworkAcl** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **BINDING** state, the network ACL is being associated.
        *   If the network ACL is in the **BINDED** state, the network ACL is associated.
        *   You cannot repeatedly call the **AssociateNetworkAcl** operation to associate a network ACL within the specified period of time.
        
        @param request: AssociateNetworkAclRequest
        @return: AssociateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_network_acl_with_options_async(request, runtime)

    def associate_physical_connection_to_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_physical_connection_to_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_physical_connection_to_virtual_border_router(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_physical_connection_to_virtual_border_router_with_options(request, runtime)

    async def associate_physical_connection_to_virtual_border_router_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_physical_connection_to_virtual_border_router_with_options_async(request, runtime)

    def associate_route_table_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        """
        The *AssociateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the route table is being associated with the vSwitch.
        *   If the vSwitch is in the **Available** state, the route table is associated with the vSwitch.
        
        @param request: AssociateRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        """
        The *AssociateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the route table is being associated with the vSwitch.
        *   If the vSwitch is in the **Available** state, the route table is associated with the vSwitch.
        
        @param request: AssociateRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        """
        The *AssociateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the route table is being associated with the vSwitch.
        *   If the vSwitch is in the **Available** state, the route table is associated with the vSwitch.
        
        @param request: AssociateRouteTableRequest
        @return: AssociateRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_options(request, runtime)

    async def associate_route_table_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        """
        The *AssociateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the route table is being associated with the vSwitch.
        *   If the vSwitch is in the **Available** state, the route table is associated with the vSwitch.
        
        @param request: AssociateRouteTableRequest
        @return: AssociateRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_options_async(request, runtime)

    def associate_route_table_with_gateway_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_gateway_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table_with_gateway(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_gateway_with_options(request, runtime)

    async def associate_route_table_with_gateway_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_gateway_with_options_async(request, runtime)

    def associate_route_tables_with_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        """
        When you call this operation, take note of the following limits:
        *   The gateway endpoint to be associated with the route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The gateway endpoint and route table must belong to the same virtual private cloud (VPC).
        *   The route table cannot be shared.
        *   You cannot associate a gateway endpoint with a virtual border router (VBR) route table.
        *   You can associate a gateway endpoint with at most 20 route tables at a time.
        *   **AssociateRouteTablesWithVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetVpcGatewayEndpointAttribute](~~311017~~) operation to query whether a route table is associated with a gateway endpoint.
        *   If the **Associating** status is returned, the route table is being associated with the gateway endpoint.
        *   If the **Created** status is returned, the route table is associated with the gateway endpoint.
        *   You cannot repeatedly call the **AssociateRouteTablesWithVpcGatewayEndpoint** operation within a specific period of time.
        
        @param request: AssociateRouteTablesWithVpcGatewayEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateRouteTablesWithVpcGatewayEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_tables_with_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        """
        When you call this operation, take note of the following limits:
        *   The gateway endpoint to be associated with the route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The gateway endpoint and route table must belong to the same virtual private cloud (VPC).
        *   The route table cannot be shared.
        *   You cannot associate a gateway endpoint with a virtual border router (VBR) route table.
        *   You can associate a gateway endpoint with at most 20 route tables at a time.
        *   **AssociateRouteTablesWithVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetVpcGatewayEndpointAttribute](~~311017~~) operation to query whether a route table is associated with a gateway endpoint.
        *   If the **Associating** status is returned, the route table is being associated with the gateway endpoint.
        *   If the **Created** status is returned, the route table is associated with the gateway endpoint.
        *   You cannot repeatedly call the **AssociateRouteTablesWithVpcGatewayEndpoint** operation within a specific period of time.
        
        @param request: AssociateRouteTablesWithVpcGatewayEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateRouteTablesWithVpcGatewayEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_tables_with_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        """
        When you call this operation, take note of the following limits:
        *   The gateway endpoint to be associated with the route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The gateway endpoint and route table must belong to the same virtual private cloud (VPC).
        *   The route table cannot be shared.
        *   You cannot associate a gateway endpoint with a virtual border router (VBR) route table.
        *   You can associate a gateway endpoint with at most 20 route tables at a time.
        *   **AssociateRouteTablesWithVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetVpcGatewayEndpointAttribute](~~311017~~) operation to query whether a route table is associated with a gateway endpoint.
        *   If the **Associating** status is returned, the route table is being associated with the gateway endpoint.
        *   If the **Created** status is returned, the route table is associated with the gateway endpoint.
        *   You cannot repeatedly call the **AssociateRouteTablesWithVpcGatewayEndpoint** operation within a specific period of time.
        
        @param request: AssociateRouteTablesWithVpcGatewayEndpointRequest
        @return: AssociateRouteTablesWithVpcGatewayEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_route_tables_with_vpc_gateway_endpoint_with_options(request, runtime)

    async def associate_route_tables_with_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        """
        When you call this operation, take note of the following limits:
        *   The gateway endpoint to be associated with the route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The route table cannot be in one of the following states: **Creating**, **Modifying**, **Associating**, **Dissociating**, or **Deleting**.
        *   The gateway endpoint and route table must belong to the same virtual private cloud (VPC).
        *   The route table cannot be shared.
        *   You cannot associate a gateway endpoint with a virtual border router (VBR) route table.
        *   You can associate a gateway endpoint with at most 20 route tables at a time.
        *   **AssociateRouteTablesWithVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetVpcGatewayEndpointAttribute](~~311017~~) operation to query whether a route table is associated with a gateway endpoint.
        *   If the **Associating** status is returned, the route table is being associated with the gateway endpoint.
        *   If the **Created** status is returned, the route table is associated with the gateway endpoint.
        *   You cannot repeatedly call the **AssociateRouteTablesWithVpcGatewayEndpoint** operation within a specific period of time.
        
        @param request: AssociateRouteTablesWithVpcGatewayEndpointRequest
        @return: AssociateRouteTablesWithVpcGatewayEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_tables_with_vpc_gateway_endpoint_with_options_async(request, runtime)

    def associate_vpc_cidr_block_with_options(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        """
        The following list describes the limits on the maximum number of secondary CIDR blocks that can be added:
        *   You can add up to five secondary IPv4 CIDR blocks to each VPC.
        *   You can add up to three secondary IPv6 CIDR blocks to each VPC.
        *   You cannot repeatedly call the **AssociateVpcCidrBlock** operation to add secondary CIDR blocks to a VPC within the specified period of time.
        
        @param request: AssociateVpcCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateVpcCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['IPv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_cidr_block):
            query['SecondaryCidrBlock'] = request.secondary_cidr_block
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpc_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        """
        The following list describes the limits on the maximum number of secondary CIDR blocks that can be added:
        *   You can add up to five secondary IPv4 CIDR blocks to each VPC.
        *   You can add up to three secondary IPv6 CIDR blocks to each VPC.
        *   You cannot repeatedly call the **AssociateVpcCidrBlock** operation to add secondary CIDR blocks to a VPC within the specified period of time.
        
        @param request: AssociateVpcCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateVpcCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['IPv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_cidr_block):
            query['SecondaryCidrBlock'] = request.secondary_cidr_block
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpc_cidr_block(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        """
        The following list describes the limits on the maximum number of secondary CIDR blocks that can be added:
        *   You can add up to five secondary IPv4 CIDR blocks to each VPC.
        *   You can add up to three secondary IPv6 CIDR blocks to each VPC.
        *   You cannot repeatedly call the **AssociateVpcCidrBlock** operation to add secondary CIDR blocks to a VPC within the specified period of time.
        
        @param request: AssociateVpcCidrBlockRequest
        @return: AssociateVpcCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_vpc_cidr_block_with_options(request, runtime)

    async def associate_vpc_cidr_block_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        """
        The following list describes the limits on the maximum number of secondary CIDR blocks that can be added:
        *   You can add up to five secondary IPv4 CIDR blocks to each VPC.
        *   You can add up to three secondary IPv6 CIDR blocks to each VPC.
        *   You cannot repeatedly call the **AssociateVpcCidrBlock** operation to add secondary CIDR blocks to a VPC within the specified period of time.
        
        @param request: AssociateVpcCidrBlockRequest
        @return: AssociateVpcCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpc_cidr_block_with_options_async(request, runtime)

    def associate_vpn_gateway_with_certificate_with_options(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpn_gateway_with_certificate_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpn_gateway_with_certificate(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_vpn_gateway_with_certificate_with_options(request, runtime)

    async def associate_vpn_gateway_with_certificate_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpn_gateway_with_certificate_with_options_async(request, runtime)

    def attach_dhcp_options_set_to_vpc_with_options(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        """
        The **AttachDhcpOptionsSetToVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Pending** state, the DHCP options set is being associated.
        *   If the DHCP options set is in the **InUse** state, the DHCP options set is associated.
        *   You cannot repeatedly call the **AttachDhcpOptionsSetToVpc** operation to associate DHCP options sets with a VPC within the specified period of time.
        
        @param request: AttachDhcpOptionsSetToVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDhcpOptionsSetToVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_dhcp_options_set_to_vpc_with_options_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        """
        The **AttachDhcpOptionsSetToVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Pending** state, the DHCP options set is being associated.
        *   If the DHCP options set is in the **InUse** state, the DHCP options set is associated.
        *   You cannot repeatedly call the **AttachDhcpOptionsSetToVpc** operation to associate DHCP options sets with a VPC within the specified period of time.
        
        @param request: AttachDhcpOptionsSetToVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDhcpOptionsSetToVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_dhcp_options_set_to_vpc(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        """
        The **AttachDhcpOptionsSetToVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Pending** state, the DHCP options set is being associated.
        *   If the DHCP options set is in the **InUse** state, the DHCP options set is associated.
        *   You cannot repeatedly call the **AttachDhcpOptionsSetToVpc** operation to associate DHCP options sets with a VPC within the specified period of time.
        
        @param request: AttachDhcpOptionsSetToVpcRequest
        @return: AttachDhcpOptionsSetToVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_dhcp_options_set_to_vpc_with_options(request, runtime)

    async def attach_dhcp_options_set_to_vpc_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        """
        The **AttachDhcpOptionsSetToVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Pending** state, the DHCP options set is being associated.
        *   If the DHCP options set is in the **InUse** state, the DHCP options set is associated.
        *   You cannot repeatedly call the **AttachDhcpOptionsSetToVpc** operation to associate DHCP options sets with a VPC within the specified period of time.
        
        @param request: AttachDhcpOptionsSetToVpcRequest
        @return: AttachDhcpOptionsSetToVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_dhcp_options_set_to_vpc_with_options_async(request, runtime)

    def attach_vbr_to_vpconn_with_options(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vpconn_id):
            query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_vbr_to_vpconn_with_options_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vpconn_id):
            query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_vbr_to_vpconn(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_vbr_to_vpconn_with_options(request, runtime)

    async def attach_vbr_to_vpconn_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_vbr_to_vpconn_with_options_async(request, runtime)

    def cancel_common_bandwidth_package_ip_bandwidth_with_options(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        """
        After this operation is performed, the maximum bandwidth of the EIP equals that of the EIP bandwidth plan.
        *   You cannot repeatedly call the **CancelCommonBandwidthPackageIpBandwidth** operation to remove the maximum bandwidth configured for an EIP within the specified period of time.
        
        @param request: CancelCommonBandwidthPackageIpBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCommonBandwidthPackageIpBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.eip_id):
            query['EipId'] = request.eip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_common_bandwidth_package_ip_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        """
        After this operation is performed, the maximum bandwidth of the EIP equals that of the EIP bandwidth plan.
        *   You cannot repeatedly call the **CancelCommonBandwidthPackageIpBandwidth** operation to remove the maximum bandwidth configured for an EIP within the specified period of time.
        
        @param request: CancelCommonBandwidthPackageIpBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCommonBandwidthPackageIpBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.eip_id):
            query['EipId'] = request.eip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_common_bandwidth_package_ip_bandwidth(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        """
        After this operation is performed, the maximum bandwidth of the EIP equals that of the EIP bandwidth plan.
        *   You cannot repeatedly call the **CancelCommonBandwidthPackageIpBandwidth** operation to remove the maximum bandwidth configured for an EIP within the specified period of time.
        
        @param request: CancelCommonBandwidthPackageIpBandwidthRequest
        @return: CancelCommonBandwidthPackageIpBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_common_bandwidth_package_ip_bandwidth_with_options(request, runtime)

    async def cancel_common_bandwidth_package_ip_bandwidth_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        """
        After this operation is performed, the maximum bandwidth of the EIP equals that of the EIP bandwidth plan.
        *   You cannot repeatedly call the **CancelCommonBandwidthPackageIpBandwidth** operation to remove the maximum bandwidth configured for an EIP within the specified period of time.
        
        @param request: CancelCommonBandwidthPackageIpBandwidthRequest
        @return: CancelCommonBandwidthPackageIpBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_common_bandwidth_package_ip_bandwidth_with_options_async(request, runtime)

    def cancel_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        """
        ## Limits
        You can cancel only an Express Connect circuit that is in the **Initial**, **Approved**, **Allocated**, or **Confirmed** state.
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        """
        ## Limits
        You can cancel only an Express Connect circuit that is in the **Initial**, **Approved**, **Allocated**, or **Confirmed** state.
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_physical_connection(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        """
        ## Limits
        You can cancel only an Express Connect circuit that is in the **Initial**, **Approved**, **Allocated**, or **Confirmed** state.
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_physical_connection_with_options(request, runtime)

    async def cancel_physical_connection_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        """
        ## Limits
        You can cancel only an Express Connect circuit that is in the **Initial**, **Approved**, **Allocated**, or **Confirmed** state.
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_physical_connection_with_options_async(request, runtime)

    def change_resource_group_with_options(
        self,
        request: vpc_20160428_models.ChangeResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ChangeResourceGroupResponse:
        """
        You cannot repeatedly call the *ChangeResourceGroup** operation within the specified period of time.
        
        @param request: ChangeResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeResourceGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ChangeResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_resource_group_with_options_async(
        self,
        request: vpc_20160428_models.ChangeResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ChangeResourceGroupResponse:
        """
        You cannot repeatedly call the *ChangeResourceGroup** operation within the specified period of time.
        
        @param request: ChangeResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeResourceGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ChangeResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_resource_group(
        self,
        request: vpc_20160428_models.ChangeResourceGroupRequest,
    ) -> vpc_20160428_models.ChangeResourceGroupResponse:
        """
        You cannot repeatedly call the *ChangeResourceGroup** operation within the specified period of time.
        
        @param request: ChangeResourceGroupRequest
        @return: ChangeResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_resource_group_with_options(request, runtime)

    async def change_resource_group_async(
        self,
        request: vpc_20160428_models.ChangeResourceGroupRequest,
    ) -> vpc_20160428_models.ChangeResourceGroupResponse:
        """
        You cannot repeatedly call the *ChangeResourceGroup** operation within the specified period of time.
        
        @param request: ChangeResourceGroupRequest
        @return: ChangeResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_resource_group_with_options_async(request, runtime)

    def check_can_allocate_vpc_private_ip_address_with_options(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckCanAllocateVpcPrivateIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_can_allocate_vpc_private_ip_address_with_options_async(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckCanAllocateVpcPrivateIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_can_allocate_vpc_private_ip_address(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_can_allocate_vpc_private_ip_address_with_options(request, runtime)

    async def check_can_allocate_vpc_private_ip_address_async(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_can_allocate_vpc_private_ip_address_with_options_async(request, runtime)

    def check_vpn_bgp_enabled_with_options(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckVpnBgpEnabled',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckVpnBgpEnabledResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_vpn_bgp_enabled_with_options_async(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckVpnBgpEnabled',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckVpnBgpEnabledResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_vpn_bgp_enabled(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_vpn_bgp_enabled_with_options(request, runtime)

    async def check_vpn_bgp_enabled_async(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_vpn_bgp_enabled_with_options_async(request, runtime)

    def complete_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_code):
            query['LineCode'] = request.line_code
        if not UtilClient.is_unset(request.line_label):
            query['LineLabel'] = request.line_label
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def complete_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_code):
            query['LineCode'] = request.line_code
        if not UtilClient.is_unset(request.line_label):
            query['LineLabel'] = request.line_label
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def complete_physical_connection_loa(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.complete_physical_connection_loawith_options(request, runtime)

    async def complete_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.complete_physical_connection_loawith_options_async(request, runtime)

    def confirm_physical_connection_with_options(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def confirm_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def confirm_physical_connection(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.confirm_physical_connection_with_options(request, runtime)

    async def confirm_physical_connection_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.confirm_physical_connection_with_options_async(request, runtime)

    def connect_router_interface_with_options(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Connecting** state. When the connection is established, it enters the **Active** state.
        When you call this operation, take note of the following rules:
        *   Only an initiator router interface in the **Idle** state can initiate a connection.
        *   You can create only one pair of connected router interfaces between two routers.
        *   You cannot initiate a connection if your Alibaba Cloud account has a router interface with overdue payments.
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def connect_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Connecting** state. When the connection is established, it enters the **Active** state.
        When you call this operation, take note of the following rules:
        *   Only an initiator router interface in the **Idle** state can initiate a connection.
        *   You can create only one pair of connected router interfaces between two routers.
        *   You cannot initiate a connection if your Alibaba Cloud account has a router interface with overdue payments.
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def connect_router_interface(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Connecting** state. When the connection is established, it enters the **Active** state.
        When you call this operation, take note of the following rules:
        *   Only an initiator router interface in the **Idle** state can initiate a connection.
        *   You can create only one pair of connected router interfaces between two routers.
        *   You cannot initiate a connection if your Alibaba Cloud account has a router interface with overdue payments.
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.connect_router_interface_with_options(request, runtime)

    async def connect_router_interface_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        """
        After you call this operation, the router interface enters the *Connecting** state. When the connection is established, it enters the **Active** state.
        When you call this operation, take note of the following rules:
        *   Only an initiator router interface in the **Idle** state can initiate a connection.
        *   You can create only one pair of connected router interfaces between two routers.
        *   You cannot initiate a connection if your Alibaba Cloud account has a router interface with overdue payments.
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.connect_router_interface_with_options_async(request, runtime)

    def convert_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        """
        Before you convert a NAT bandwidth package to an Internet Shared Bandwidth instance, make sure you are aware of the following:
        *   The conversion does not incur any additional fees.
        *   The conversion does not affect the SNAT or DNAT entries of the NAT Gateway, and has no impact on the running services. However, we recommend that you perform the conversion during off-peak hours.
        *   After the conversion, the public IP address in the NAT bandwidth package is converted to an EIP. The peak bandwidth and billing method of the Internet Shared Bandwidth instance are consistent with those of the original NAT bandwidth package.
        
        @param request: ConvertBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertBandwidthPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def convert_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        """
        Before you convert a NAT bandwidth package to an Internet Shared Bandwidth instance, make sure you are aware of the following:
        *   The conversion does not incur any additional fees.
        *   The conversion does not affect the SNAT or DNAT entries of the NAT Gateway, and has no impact on the running services. However, we recommend that you perform the conversion during off-peak hours.
        *   After the conversion, the public IP address in the NAT bandwidth package is converted to an EIP. The peak bandwidth and billing method of the Internet Shared Bandwidth instance are consistent with those of the original NAT bandwidth package.
        
        @param request: ConvertBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertBandwidthPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def convert_bandwidth_package(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        """
        Before you convert a NAT bandwidth package to an Internet Shared Bandwidth instance, make sure you are aware of the following:
        *   The conversion does not incur any additional fees.
        *   The conversion does not affect the SNAT or DNAT entries of the NAT Gateway, and has no impact on the running services. However, we recommend that you perform the conversion during off-peak hours.
        *   After the conversion, the public IP address in the NAT bandwidth package is converted to an EIP. The peak bandwidth and billing method of the Internet Shared Bandwidth instance are consistent with those of the original NAT bandwidth package.
        
        @param request: ConvertBandwidthPackageRequest
        @return: ConvertBandwidthPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.convert_bandwidth_package_with_options(request, runtime)

    async def convert_bandwidth_package_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        """
        Before you convert a NAT bandwidth package to an Internet Shared Bandwidth instance, make sure you are aware of the following:
        *   The conversion does not incur any additional fees.
        *   The conversion does not affect the SNAT or DNAT entries of the NAT Gateway, and has no impact on the running services. However, we recommend that you perform the conversion during off-peak hours.
        *   After the conversion, the public IP address in the NAT bandwidth package is converted to an EIP. The peak bandwidth and billing method of the Internet Shared Bandwidth instance are consistent with those of the original NAT bandwidth package.
        
        @param request: ConvertBandwidthPackageRequest
        @return: ConvertBandwidthPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.convert_bandwidth_package_with_options_async(request, runtime)

    def copy_network_acl_entries_with_options(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        """
        The **CopyNetworkAclEntries** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **Modifying** state, the rules of the network ACL are being copied.
        *   If the network ACL is in the **Available** state, the rules of the network ACL are copied.
        *   You cannot repeatedly call the **CopyNetworkAclEntries** operation to copy the rules of a network ACL within the specified period of time.
        
        @param request: CopyNetworkAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyNetworkAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_network_acl_id):
            query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_network_acl_entries_with_options_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        """
        The **CopyNetworkAclEntries** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **Modifying** state, the rules of the network ACL are being copied.
        *   If the network ACL is in the **Available** state, the rules of the network ACL are copied.
        *   You cannot repeatedly call the **CopyNetworkAclEntries** operation to copy the rules of a network ACL within the specified period of time.
        
        @param request: CopyNetworkAclEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyNetworkAclEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_network_acl_id):
            query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_network_acl_entries(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        """
        The **CopyNetworkAclEntries** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **Modifying** state, the rules of the network ACL are being copied.
        *   If the network ACL is in the **Available** state, the rules of the network ACL are copied.
        *   You cannot repeatedly call the **CopyNetworkAclEntries** operation to copy the rules of a network ACL within the specified period of time.
        
        @param request: CopyNetworkAclEntriesRequest
        @return: CopyNetworkAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_network_acl_entries_with_options(request, runtime)

    async def copy_network_acl_entries_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        """
        The **CopyNetworkAclEntries** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeNetworkAclAttributes](~~116542~~) operation to query the status of a network ACL:
        *   If the network ACL is in the **Modifying** state, the rules of the network ACL are being copied.
        *   If the network ACL is in the **Available** state, the rules of the network ACL are copied.
        *   You cannot repeatedly call the **CopyNetworkAclEntries** operation to copy the rules of a network ACL within the specified period of time.
        
        @param request: CopyNetworkAclEntriesRequest
        @return: CopyNetworkAclEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_network_acl_entries_with_options_async(request, runtime)

    def create_bgp_group_with_options(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        """
        You can use BGP to connect a VBR to a data center. Each BGP group is associated with a VBR. You can add a BGP peer that needs to communicate with a VBR to a BGP group and advertise the BGP network in the VBR.
        BGP groups are used to simplify BGP configurations. You can add BGP peers that use the same configurations to one BGP group. Before you start, you must create a BGP group with the requested autonomous system number (ASN).
        When you call this operation, take note of the following limits:
        *   You can specify only the data center that is connected to the VBR through an Express Connect circuit as a BGP peer.
        *   VBRs support only BGP-4.
        *   You can create at most eight BGP peers for each VBR.
        *   Each BGP peer supports at most 110 dynamic routes.
        *   The ASN of Alibaba Cloud is 45104. You can specify a 2-byte or 4-byte ASN for the data center.
        
        @param request: CreateBgpGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBgpGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.is_fake_asn):
            query['IsFakeAsn'] = request.is_fake_asn
        if not UtilClient.is_unset(request.local_asn):
            query['LocalAsn'] = request.local_asn
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_asn):
            query['PeerAsn'] = request.peer_asn
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_quota):
            query['RouteQuota'] = request.route_quota
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        """
        You can use BGP to connect a VBR to a data center. Each BGP group is associated with a VBR. You can add a BGP peer that needs to communicate with a VBR to a BGP group and advertise the BGP network in the VBR.
        BGP groups are used to simplify BGP configurations. You can add BGP peers that use the same configurations to one BGP group. Before you start, you must create a BGP group with the requested autonomous system number (ASN).
        When you call this operation, take note of the following limits:
        *   You can specify only the data center that is connected to the VBR through an Express Connect circuit as a BGP peer.
        *   VBRs support only BGP-4.
        *   You can create at most eight BGP peers for each VBR.
        *   Each BGP peer supports at most 110 dynamic routes.
        *   The ASN of Alibaba Cloud is 45104. You can specify a 2-byte or 4-byte ASN for the data center.
        
        @param request: CreateBgpGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBgpGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.is_fake_asn):
            query['IsFakeAsn'] = request.is_fake_asn
        if not UtilClient.is_unset(request.local_asn):
            query['LocalAsn'] = request.local_asn
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_asn):
            query['PeerAsn'] = request.peer_asn
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_quota):
            query['RouteQuota'] = request.route_quota
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_group(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        """
        You can use BGP to connect a VBR to a data center. Each BGP group is associated with a VBR. You can add a BGP peer that needs to communicate with a VBR to a BGP group and advertise the BGP network in the VBR.
        BGP groups are used to simplify BGP configurations. You can add BGP peers that use the same configurations to one BGP group. Before you start, you must create a BGP group with the requested autonomous system number (ASN).
        When you call this operation, take note of the following limits:
        *   You can specify only the data center that is connected to the VBR through an Express Connect circuit as a BGP peer.
        *   VBRs support only BGP-4.
        *   You can create at most eight BGP peers for each VBR.
        *   Each BGP peer supports at most 110 dynamic routes.
        *   The ASN of Alibaba Cloud is 45104. You can specify a 2-byte or 4-byte ASN for the data center.
        
        @param request: CreateBgpGroupRequest
        @return: CreateBgpGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_group_with_options(request, runtime)

    async def create_bgp_group_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        """
        You can use BGP to connect a VBR to a data center. Each BGP group is associated with a VBR. You can add a BGP peer that needs to communicate with a VBR to a BGP group and advertise the BGP network in the VBR.
        BGP groups are used to simplify BGP configurations. You can add BGP peers that use the same configurations to one BGP group. Before you start, you must create a BGP group with the requested autonomous system number (ASN).
        When you call this operation, take note of the following limits:
        *   You can specify only the data center that is connected to the VBR through an Express Connect circuit as a BGP peer.
        *   VBRs support only BGP-4.
        *   You can create at most eight BGP peers for each VBR.
        *   Each BGP peer supports at most 110 dynamic routes.
        *   The ASN of Alibaba Cloud is 45104. You can specify a 2-byte or 4-byte ASN for the data center.
        
        @param request: CreateBgpGroupRequest
        @return: CreateBgpGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_group_with_options_async(request, runtime)

    def create_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bfd_multi_hop):
            query['BfdMultiHop'] = request.bfd_multi_hop
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_bfd):
            query['EnableBfd'] = request.enable_bfd
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_ip_address):
            query['PeerIpAddress'] = request.peer_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bfd_multi_hop):
            query['BfdMultiHop'] = request.bfd_multi_hop
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_bfd):
            query['EnableBfd'] = request.enable_bfd
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_ip_address):
            query['PeerIpAddress'] = request.peer_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_peer(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_peer_with_options(request, runtime)

    async def create_bgp_peer_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_peer_with_options_async(request, runtime)

    def create_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.ratio):
            query['Ratio'] = request.ratio
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        if not UtilClient.is_unset(request.zone):
            query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.ratio):
            query['Ratio'] = request.ratio
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        if not UtilClient.is_unset(request.zone):
            query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_common_bandwidth_package(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_common_bandwidth_package_with_options(request, runtime)

    async def create_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_common_bandwidth_package_with_options_async(request, runtime)

    def create_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asn):
            query['Asn'] = request.asn
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asn):
            query['Asn'] = request.asn
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_customer_gateway(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_customer_gateway_with_options(request, runtime)

    async def create_customer_gateway_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_customer_gateway_with_options_async(request, runtime)

    def create_default_vswitch_with_options(
        self,
        request: vpc_20160428_models.CreateDefaultVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDefaultVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDefaultVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDefaultVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_default_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.CreateDefaultVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDefaultVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDefaultVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDefaultVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_default_vswitch(
        self,
        request: vpc_20160428_models.CreateDefaultVSwitchRequest,
    ) -> vpc_20160428_models.CreateDefaultVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_default_vswitch_with_options(request, runtime)

    async def create_default_vswitch_async(
        self,
        request: vpc_20160428_models.CreateDefaultVSwitchRequest,
    ) -> vpc_20160428_models.CreateDefaultVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_default_vswitch_with_options_async(request, runtime)

    def create_default_vpc_with_options(
        self,
        request: vpc_20160428_models.CreateDefaultVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDefaultVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDefaultVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDefaultVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_default_vpc_with_options_async(
        self,
        request: vpc_20160428_models.CreateDefaultVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDefaultVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDefaultVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDefaultVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_default_vpc(
        self,
        request: vpc_20160428_models.CreateDefaultVpcRequest,
    ) -> vpc_20160428_models.CreateDefaultVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_default_vpc_with_options(request, runtime)

    async def create_default_vpc_async(
        self,
        request: vpc_20160428_models.CreateDefaultVpcRequest,
    ) -> vpc_20160428_models.CreateDefaultVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_default_vpc_with_options_async(request, runtime)

    def create_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_description):
            query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        if not UtilClient.is_unset(request.dhcp_options_set_name):
            query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_name_servers):
            query['DomainNameServers'] = request.domain_name_servers
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_6lease_time):
            query['Ipv6LeaseTime'] = request.ipv_6lease_time
        if not UtilClient.is_unset(request.lease_time):
            query['LeaseTime'] = request.lease_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_description):
            query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        if not UtilClient.is_unset(request.dhcp_options_set_name):
            query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_name_servers):
            query['DomainNameServers'] = request.domain_name_servers
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_6lease_time):
            query['Ipv6LeaseTime'] = request.ipv_6lease_time
        if not UtilClient.is_unset(request.lease_time):
            query['LeaseTime'] = request.lease_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dhcp_options_set(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_dhcp_options_set_with_options(request, runtime)

    async def create_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_dhcp_options_set_with_options_async(request, runtime)

    def create_express_cloud_connection_with_options(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.contact_mail):
            query['ContactMail'] = request.contact_mail
        if not UtilClient.is_unset(request.contact_tel):
            query['ContactTel'] = request.contact_tel
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.idcard_no):
            query['IDCardNo'] = request.idcard_no
        if not UtilClient.is_unset(request.idc_sp):
            query['IdcSP'] = request.idc_sp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_city):
            query['PeerCity'] = request.peer_city
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_ecc_id):
            query['RedundantEccId'] = request.redundant_ecc_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_express_cloud_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.contact_mail):
            query['ContactMail'] = request.contact_mail
        if not UtilClient.is_unset(request.contact_tel):
            query['ContactTel'] = request.contact_tel
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.idcard_no):
            query['IDCardNo'] = request.idcard_no
        if not UtilClient.is_unset(request.idc_sp):
            query['IdcSP'] = request.idc_sp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_city):
            query['PeerCity'] = request.peer_city
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_ecc_id):
            query['RedundantEccId'] = request.redundant_ecc_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_express_cloud_connection(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_express_cloud_connection_with_options(request, runtime)

    async def create_express_cloud_connection_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_express_cloud_connection_with_options_async(request, runtime)

    def create_flow_log_with_options(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        """
        *CreateFlowLog** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being created.
        *   If the flow log is in the **Active** state, the flow log is created and started.
        
        @param request: CreateFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aggregation_interval):
            query['AggregationInterval'] = request.aggregation_interval
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.traffic_path):
            query['TrafficPath'] = request.traffic_path
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        """
        *CreateFlowLog** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being created.
        *   If the flow log is in the **Active** state, the flow log is created and started.
        
        @param request: CreateFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aggregation_interval):
            query['AggregationInterval'] = request.aggregation_interval
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.traffic_path):
            query['TrafficPath'] = request.traffic_path
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_log(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        """
        *CreateFlowLog** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being created.
        *   If the flow log is in the **Active** state, the flow log is created and started.
        
        @param request: CreateFlowLogRequest
        @return: CreateFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_flow_log_with_options(request, runtime)

    async def create_flow_log_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        """
        *CreateFlowLog** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Activating** state, the flow log is being created.
        *   If the flow log is in the **Active** state, the flow log is created and started.
        
        @param request: CreateFlowLogRequest
        @return: CreateFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_flow_log_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        """
        Each DNAT entry consists of the following parameters: *ExternalIp**, **ExternalPort**, **IpProtocol**, **InternalIp**, and **InternalPort**. After you add a DNAT entry, the NAT gateway forwards packets of the specified protocol from **ExternalIp:ExternalPort** to **InternalIp:InternalPort** and sends responses back through the same route.
        When you call this operation, take note of the following limits:
        *   **CreateForwardEntry** is an asynchronous operation. After you make a request, a DNAT entry ID is returned but the specified DNAT entry is not added. The system adds the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Pending** state, the system is adding the DNAT entry. You can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry is in the **Available** state, the DNAT entry is added.
        *   You cannot repeatedly call the **CreateForwardEntry** operation to add a DNAT entry within the specified period of time.
        *   All combinations of **ExternalIp**, **ExternalPort**, and **IpProtocol** used in DNAT entries must be unique. You cannot distribute requests to more than one Elastic Compute Service (ECS) instance if these requests are initiated from the same source IP address, received on the same port, and use the same protocol.
        *   The combinations of **IpProtocol**, **InternalIp**, and **InternalPort** must be unique.
        *   If one or more DNAT entries in the DNAT table are in the **Pending** or **Modifying** state, you cannot add DNAT entries to the DNAT table.
        *   You can add at most 100 DNAT entries to a DNAT table.
        *   For an elastic IP address (EIP) used by an Internet NAT gateway or a NAT IP address used by a Virtual Private Cloud (VPC) NAT gateway, take note of the following limit: If the IP address has IP mapping enabled and is specified in a DNAT entry, the IP address cannot be used by another DNAT or SNAT entry.
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_break):
            query['PortBreak'] = request.port_break
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        """
        Each DNAT entry consists of the following parameters: *ExternalIp**, **ExternalPort**, **IpProtocol**, **InternalIp**, and **InternalPort**. After you add a DNAT entry, the NAT gateway forwards packets of the specified protocol from **ExternalIp:ExternalPort** to **InternalIp:InternalPort** and sends responses back through the same route.
        When you call this operation, take note of the following limits:
        *   **CreateForwardEntry** is an asynchronous operation. After you make a request, a DNAT entry ID is returned but the specified DNAT entry is not added. The system adds the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Pending** state, the system is adding the DNAT entry. You can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry is in the **Available** state, the DNAT entry is added.
        *   You cannot repeatedly call the **CreateForwardEntry** operation to add a DNAT entry within the specified period of time.
        *   All combinations of **ExternalIp**, **ExternalPort**, and **IpProtocol** used in DNAT entries must be unique. You cannot distribute requests to more than one Elastic Compute Service (ECS) instance if these requests are initiated from the same source IP address, received on the same port, and use the same protocol.
        *   The combinations of **IpProtocol**, **InternalIp**, and **InternalPort** must be unique.
        *   If one or more DNAT entries in the DNAT table are in the **Pending** or **Modifying** state, you cannot add DNAT entries to the DNAT table.
        *   You can add at most 100 DNAT entries to a DNAT table.
        *   For an elastic IP address (EIP) used by an Internet NAT gateway or a NAT IP address used by a Virtual Private Cloud (VPC) NAT gateway, take note of the following limit: If the IP address has IP mapping enabled and is specified in a DNAT entry, the IP address cannot be used by another DNAT or SNAT entry.
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_break):
            query['PortBreak'] = request.port_break
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        """
        Each DNAT entry consists of the following parameters: *ExternalIp**, **ExternalPort**, **IpProtocol**, **InternalIp**, and **InternalPort**. After you add a DNAT entry, the NAT gateway forwards packets of the specified protocol from **ExternalIp:ExternalPort** to **InternalIp:InternalPort** and sends responses back through the same route.
        When you call this operation, take note of the following limits:
        *   **CreateForwardEntry** is an asynchronous operation. After you make a request, a DNAT entry ID is returned but the specified DNAT entry is not added. The system adds the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Pending** state, the system is adding the DNAT entry. You can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry is in the **Available** state, the DNAT entry is added.
        *   You cannot repeatedly call the **CreateForwardEntry** operation to add a DNAT entry within the specified period of time.
        *   All combinations of **ExternalIp**, **ExternalPort**, and **IpProtocol** used in DNAT entries must be unique. You cannot distribute requests to more than one Elastic Compute Service (ECS) instance if these requests are initiated from the same source IP address, received on the same port, and use the same protocol.
        *   The combinations of **IpProtocol**, **InternalIp**, and **InternalPort** must be unique.
        *   If one or more DNAT entries in the DNAT table are in the **Pending** or **Modifying** state, you cannot add DNAT entries to the DNAT table.
        *   You can add at most 100 DNAT entries to a DNAT table.
        *   For an elastic IP address (EIP) used by an Internet NAT gateway or a NAT IP address used by a Virtual Private Cloud (VPC) NAT gateway, take note of the following limit: If the IP address has IP mapping enabled and is specified in a DNAT entry, the IP address cannot be used by another DNAT or SNAT entry.
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        """
        Each DNAT entry consists of the following parameters: *ExternalIp**, **ExternalPort**, **IpProtocol**, **InternalIp**, and **InternalPort**. After you add a DNAT entry, the NAT gateway forwards packets of the specified protocol from **ExternalIp:ExternalPort** to **InternalIp:InternalPort** and sends responses back through the same route.
        When you call this operation, take note of the following limits:
        *   **CreateForwardEntry** is an asynchronous operation. After you make a request, a DNAT entry ID is returned but the specified DNAT entry is not added. The system adds the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Pending** state, the system is adding the DNAT entry. You can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry is in the **Available** state, the DNAT entry is added.
        *   You cannot repeatedly call the **CreateForwardEntry** operation to add a DNAT entry within the specified period of time.
        *   All combinations of **ExternalIp**, **ExternalPort**, and **IpProtocol** used in DNAT entries must be unique. You cannot distribute requests to more than one Elastic Compute Service (ECS) instance if these requests are initiated from the same source IP address, received on the same port, and use the same protocol.
        *   The combinations of **IpProtocol**, **InternalIp**, and **InternalPort** must be unique.
        *   If one or more DNAT entries in the DNAT table are in the **Pending** or **Modifying** state, you cannot add DNAT entries to the DNAT table.
        *   You can add at most 100 DNAT entries to a DNAT table.
        *   For an elastic IP address (EIP) used by an Internet NAT gateway or a NAT IP address used by a Virtual Private Cloud (VPC) NAT gateway, take note of the following limit: If the IP address has IP mapping enabled and is specified in a DNAT entry, the IP address cannot be used by another DNAT or SNAT entry.
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        """
        **CreateFullNatEntry** is an asynchronous operation. After you make a request, a FULLNAT entry ID is returned but the specified FULLNAT entry is not added. The system adds the entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Pending** state, the system is adding the FULLNAT entry. You can only query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry is in the **Available** state, the FULLNAT entry is added.
        *   You cannot repeatedly call the **CreateFullNatEntry** operation to add a FULLNAT entry to the FULLNAT table within the specified period of time.
        
        @param request: CreateFullNatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFullNatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_ip):
            query['AccessIp'] = request.access_ip
        if not UtilClient.is_unset(request.access_port):
            query['AccessPort'] = request.access_port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_description):
            query['FullNatEntryDescription'] = request.full_nat_entry_description
        if not UtilClient.is_unset(request.full_nat_entry_name):
            query['FullNatEntryName'] = request.full_nat_entry_name
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_port):
            query['NatIpPort'] = request.nat_ip_port
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        """
        **CreateFullNatEntry** is an asynchronous operation. After you make a request, a FULLNAT entry ID is returned but the specified FULLNAT entry is not added. The system adds the entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Pending** state, the system is adding the FULLNAT entry. You can only query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry is in the **Available** state, the FULLNAT entry is added.
        *   You cannot repeatedly call the **CreateFullNatEntry** operation to add a FULLNAT entry to the FULLNAT table within the specified period of time.
        
        @param request: CreateFullNatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFullNatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_ip):
            query['AccessIp'] = request.access_ip
        if not UtilClient.is_unset(request.access_port):
            query['AccessPort'] = request.access_port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_description):
            query['FullNatEntryDescription'] = request.full_nat_entry_description
        if not UtilClient.is_unset(request.full_nat_entry_name):
            query['FullNatEntryName'] = request.full_nat_entry_name
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_port):
            query['NatIpPort'] = request.nat_ip_port
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_full_nat_entry(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        """
        **CreateFullNatEntry** is an asynchronous operation. After you make a request, a FULLNAT entry ID is returned but the specified FULLNAT entry is not added. The system adds the entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Pending** state, the system is adding the FULLNAT entry. You can only query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry is in the **Available** state, the FULLNAT entry is added.
        *   You cannot repeatedly call the **CreateFullNatEntry** operation to add a FULLNAT entry to the FULLNAT table within the specified period of time.
        
        @param request: CreateFullNatEntryRequest
        @return: CreateFullNatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_full_nat_entry_with_options(request, runtime)

    async def create_full_nat_entry_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        """
        **CreateFullNatEntry** is an asynchronous operation. After you make a request, a FULLNAT entry ID is returned but the specified FULLNAT entry is not added. The system adds the entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Pending** state, the system is adding the FULLNAT entry. You can only query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry is in the **Available** state, the FULLNAT entry is added.
        *   You cannot repeatedly call the **CreateFullNatEntry** operation to add a FULLNAT entry to the FULLNAT table within the specified period of time.
        
        @param request: CreateFullNatEntryRequest
        @return: CreateFullNatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_full_nat_entry_with_options_async(request, runtime)

    def create_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_acceleration_instance(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_global_acceleration_instance_with_options(request, runtime)

    async def create_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_global_acceleration_instance_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        """
        *CreateHaVip** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Creating** state, the HAVIP is being created.
        *   If the HAVIP is in the **Available** state, the HAVIP is created.
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        """
        *CreateHaVip** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Creating** state, the HAVIP is being created.
        *   If the HAVIP is in the **Available** state, the HAVIP is created.
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        """
        *CreateHaVip** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Creating** state, the HAVIP is being created.
        *   If the HAVIP is in the **Available** state, the HAVIP is created.
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        """
        *CreateHaVip** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Creating** state, the HAVIP is being created.
        *   If the HAVIP is in the **Available** state, the HAVIP is created.
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_with_options(request, runtime)

    async def create_ipv_6translator_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_with_options_async(request, runtime)

    def create_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_acl_list_with_options(request, runtime)

    async def create_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_acl_list_with_options_async(request, runtime)

    def create_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.entry_bandwidth):
            query['EntryBandwidth'] = request.entry_bandwidth
        if not UtilClient.is_unset(request.entry_description):
            query['EntryDescription'] = request.entry_description
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.entry_bandwidth):
            query['EntryBandwidth'] = request.entry_bandwidth
        if not UtilClient.is_unset(request.entry_description):
            query['EntryDescription'] = request.entry_description
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_entry_with_options(request, runtime)

    async def create_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_entry_with_options_async(request, runtime)

    def create_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        """
        Before you create an IPsec server, you must create a VPN gateway and enable the SSL-VPN feature for the VPN gateway. For more information, see [CreateVpnGateway](~~120363~~).
        *   The **CreateIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec server is being created.
        *   If the VPN gateway is in the **active** state, the IPsec server is created.
        *   You cannot repeatedly call **CreateIpsecServer** to create an IPsec server for a VPN gateway within the specified period of time.
        
        @param request: CreateIpsecServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpsecServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ip_sec_server_name):
            query['IpSecServerName'] = request.ip_sec_server_name
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.psk):
            query['Psk'] = request.psk
        if not UtilClient.is_unset(request.psk_enabled):
            query['PskEnabled'] = request.psk_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        """
        Before you create an IPsec server, you must create a VPN gateway and enable the SSL-VPN feature for the VPN gateway. For more information, see [CreateVpnGateway](~~120363~~).
        *   The **CreateIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec server is being created.
        *   If the VPN gateway is in the **active** state, the IPsec server is created.
        *   You cannot repeatedly call **CreateIpsecServer** to create an IPsec server for a VPN gateway within the specified period of time.
        
        @param request: CreateIpsecServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpsecServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ip_sec_server_name):
            query['IpSecServerName'] = request.ip_sec_server_name
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.psk):
            query['Psk'] = request.psk
        if not UtilClient.is_unset(request.psk_enabled):
            query['PskEnabled'] = request.psk_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipsec_server(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        """
        Before you create an IPsec server, you must create a VPN gateway and enable the SSL-VPN feature for the VPN gateway. For more information, see [CreateVpnGateway](~~120363~~).
        *   The **CreateIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec server is being created.
        *   If the VPN gateway is in the **active** state, the IPsec server is created.
        *   You cannot repeatedly call **CreateIpsecServer** to create an IPsec server for a VPN gateway within the specified period of time.
        
        @param request: CreateIpsecServerRequest
        @return: CreateIpsecServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ipsec_server_with_options(request, runtime)

    async def create_ipsec_server_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        """
        Before you create an IPsec server, you must create a VPN gateway and enable the SSL-VPN feature for the VPN gateway. For more information, see [CreateVpnGateway](~~120363~~).
        *   The **CreateIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec server is being created.
        *   If the VPN gateway is in the **active** state, the IPsec server is created.
        *   You cannot repeatedly call **CreateIpsecServer** to create an IPsec server for a VPN gateway within the specified period of time.
        
        @param request: CreateIpsecServerRequest
        @return: CreateIpsecServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ipsec_server_with_options_async(request, runtime)

    def create_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        """
        **CreateIpv4Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of an IPv4 gateway:
        *   If the IPv4 gateway is in the **Creating** state, the IPv4 gateway is being created.
        *   If the IPv4 gateway is in the **Created** state, the IPv4 gateway is created.
        *   You cannot repeatedly call the **CreateIpv4Gateway** operation to create IPv4 gateways in a virtual private cloud (VPC) within the specified period of time.
        
        @param request: CreateIpv4GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv4GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_description):
            query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        if not UtilClient.is_unset(request.ipv_4gateway_name):
            query['Ipv4GatewayName'] = request.ipv_4gateway_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        """
        **CreateIpv4Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of an IPv4 gateway:
        *   If the IPv4 gateway is in the **Creating** state, the IPv4 gateway is being created.
        *   If the IPv4 gateway is in the **Created** state, the IPv4 gateway is created.
        *   You cannot repeatedly call the **CreateIpv4Gateway** operation to create IPv4 gateways in a virtual private cloud (VPC) within the specified period of time.
        
        @param request: CreateIpv4GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv4GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_description):
            query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        if not UtilClient.is_unset(request.ipv_4gateway_name):
            query['Ipv4GatewayName'] = request.ipv_4gateway_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_4gateway(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        """
        **CreateIpv4Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of an IPv4 gateway:
        *   If the IPv4 gateway is in the **Creating** state, the IPv4 gateway is being created.
        *   If the IPv4 gateway is in the **Created** state, the IPv4 gateway is created.
        *   You cannot repeatedly call the **CreateIpv4Gateway** operation to create IPv4 gateways in a virtual private cloud (VPC) within the specified period of time.
        
        @param request: CreateIpv4GatewayRequest
        @return: CreateIpv4GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_4gateway_with_options(request, runtime)

    async def create_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        """
        **CreateIpv4Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of an IPv4 gateway:
        *   If the IPv4 gateway is in the **Creating** state, the IPv4 gateway is being created.
        *   If the IPv4 gateway is in the **Created** state, the IPv4 gateway is created.
        *   You cannot repeatedly call the **CreateIpv4Gateway** operation to create IPv4 gateways in a virtual private cloud (VPC) within the specified period of time.
        
        @param request: CreateIpv4GatewayRequest
        @return: CreateIpv4GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_4gateway_with_options_async(request, runtime)

    def create_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        """
        The **CreateIpv6EgressOnlyRule** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query the status of an egress-only rule.
        *   If the egress-only rule is in the **Creating** state, the egress-only rule is being created.
        *   If the egress-only rule is in the **Created** state, the egress-only rule is created.
        *   You cannot repeatedly call the **CreateIpv6EgressOnlyRule** operation to add egress-only rules for an IPv6 address within the specified period of time.
        
        @param request: CreateIpv6EgressOnlyRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv6EgressOnlyRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        """
        The **CreateIpv6EgressOnlyRule** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query the status of an egress-only rule.
        *   If the egress-only rule is in the **Creating** state, the egress-only rule is being created.
        *   If the egress-only rule is in the **Created** state, the egress-only rule is created.
        *   You cannot repeatedly call the **CreateIpv6EgressOnlyRule** operation to add egress-only rules for an IPv6 address within the specified period of time.
        
        @param request: CreateIpv6EgressOnlyRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv6EgressOnlyRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        """
        The **CreateIpv6EgressOnlyRule** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query the status of an egress-only rule.
        *   If the egress-only rule is in the **Creating** state, the egress-only rule is being created.
        *   If the egress-only rule is in the **Created** state, the egress-only rule is created.
        *   You cannot repeatedly call the **CreateIpv6EgressOnlyRule** operation to add egress-only rules for an IPv6 address within the specified period of time.
        
        @param request: CreateIpv6EgressOnlyRuleRequest
        @return: CreateIpv6EgressOnlyRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6egress_only_rule_with_options(request, runtime)

    async def create_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        """
        The **CreateIpv6EgressOnlyRule** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query the status of an egress-only rule.
        *   If the egress-only rule is in the **Creating** state, the egress-only rule is being created.
        *   If the egress-only rule is in the **Created** state, the egress-only rule is created.
        *   You cannot repeatedly call the **CreateIpv6EgressOnlyRule** operation to add egress-only rules for an IPv6 address within the specified period of time.
        
        @param request: CreateIpv6EgressOnlyRuleRequest
        @return: CreateIpv6EgressOnlyRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6egress_only_rule_with_options_async(request, runtime)

    def create_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        """
        **CreateIpv6Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeIpv6GatewayAttribute](~~102226~~) operation to query the state of an IPv6 gateway.
        *   If the IPv6 gateway is in the **Creating** state, the IPv6 gateway is being created.
        *   If the IPv6 gateway is in the **Created** state, the IPv6 gateway is created.
        *   You cannot call the **CreateIpv6Gateway** operation to create multiple IPv6 gateways in a virtual private cloud (VPC) at the same time.
        
        @param request: CreateIpv6GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv6GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        """
        **CreateIpv6Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeIpv6GatewayAttribute](~~102226~~) operation to query the state of an IPv6 gateway.
        *   If the IPv6 gateway is in the **Creating** state, the IPv6 gateway is being created.
        *   If the IPv6 gateway is in the **Created** state, the IPv6 gateway is created.
        *   You cannot call the **CreateIpv6Gateway** operation to create multiple IPv6 gateways in a virtual private cloud (VPC) at the same time.
        
        @param request: CreateIpv6GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpv6GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6gateway(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        """
        **CreateIpv6Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeIpv6GatewayAttribute](~~102226~~) operation to query the state of an IPv6 gateway.
        *   If the IPv6 gateway is in the **Creating** state, the IPv6 gateway is being created.
        *   If the IPv6 gateway is in the **Created** state, the IPv6 gateway is created.
        *   You cannot call the **CreateIpv6Gateway** operation to create multiple IPv6 gateways in a virtual private cloud (VPC) at the same time.
        
        @param request: CreateIpv6GatewayRequest
        @return: CreateIpv6GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6gateway_with_options(request, runtime)

    async def create_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        """
        **CreateIpv6Gateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeIpv6GatewayAttribute](~~102226~~) operation to query the state of an IPv6 gateway.
        *   If the IPv6 gateway is in the **Creating** state, the IPv6 gateway is being created.
        *   If the IPv6 gateway is in the **Created** state, the IPv6 gateway is created.
        *   You cannot call the **CreateIpv6Gateway** operation to create multiple IPv6 gateways in a virtual private cloud (VPC) at the same time.
        
        @param request: CreateIpv6GatewayRequest
        @return: CreateIpv6GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6gateway_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        """
        Before you call this operation, take note of the following items:
        *   When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see [Service-linked roles](~~174251~~).
        *   After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.
        *   **CreateNatGateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeNatGateways](~~36054~~) operation to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Creating** state, the NAT gateway is being created. In this case, you can query the NAT gateway but cannot perform other operations.
        *   If a NAT gateway is in the **Available** state, the NAT gateway is created.
        It takes 1 to 3 minutes to create a NAT gateway.
        *   You cannot repeatedly call the **CreateNatGateway** operation to create a VPC NAT gateway or an Internet NAT gateway within the specified period of time.
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.eip_bind_mode):
            query['EipBindMode'] = request.eip_bind_mode
        if not UtilClient.is_unset(request.icmp_reply_enabled):
            query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        """
        Before you call this operation, take note of the following items:
        *   When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see [Service-linked roles](~~174251~~).
        *   After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.
        *   **CreateNatGateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeNatGateways](~~36054~~) operation to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Creating** state, the NAT gateway is being created. In this case, you can query the NAT gateway but cannot perform other operations.
        *   If a NAT gateway is in the **Available** state, the NAT gateway is created.
        It takes 1 to 3 minutes to create a NAT gateway.
        *   You cannot repeatedly call the **CreateNatGateway** operation to create a VPC NAT gateway or an Internet NAT gateway within the specified period of time.
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.eip_bind_mode):
            query['EipBindMode'] = request.eip_bind_mode
        if not UtilClient.is_unset(request.icmp_reply_enabled):
            query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        """
        Before you call this operation, take note of the following items:
        *   When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see [Service-linked roles](~~174251~~).
        *   After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.
        *   **CreateNatGateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeNatGateways](~~36054~~) operation to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Creating** state, the NAT gateway is being created. In this case, you can query the NAT gateway but cannot perform other operations.
        *   If a NAT gateway is in the **Available** state, the NAT gateway is created.
        It takes 1 to 3 minutes to create a NAT gateway.
        *   You cannot repeatedly call the **CreateNatGateway** operation to create a VPC NAT gateway or an Internet NAT gateway within the specified period of time.
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        """
        Before you call this operation, take note of the following items:
        *   When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see [Service-linked roles](~~174251~~).
        *   After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.
        *   **CreateNatGateway** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeNatGateways](~~36054~~) operation to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Creating** state, the NAT gateway is being created. In this case, you can query the NAT gateway but cannot perform other operations.
        *   If a NAT gateway is in the **Available** state, the NAT gateway is created.
        It takes 1 to 3 minutes to create a NAT gateway.
        *   You cannot repeatedly call the **CreateNatGateway** operation to create a VPC NAT gateway or an Internet NAT gateway within the specified period of time.
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_nat_ip_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        """
        *CreateNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT IP address is not created. The system creates the NAT IP address in the background. You can call the [ListNatIps](~~287000~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Creating** state, the NAT IP address is being created. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If a NAT IP address is in the **Available** state, the NAT IP address is created.
        You cannot repeatedly call the **CreateNatIp** operation to create a NAT IP address within the specified period of time.
        
        @param request: CreateNatIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_id):
            query['NatIpCidrId'] = request.nat_ip_cidr_id
        if not UtilClient.is_unset(request.nat_ip_description):
            query['NatIpDescription'] = request.nat_ip_description
        if not UtilClient.is_unset(request.nat_ip_name):
            query['NatIpName'] = request.nat_ip_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        """
        *CreateNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT IP address is not created. The system creates the NAT IP address in the background. You can call the [ListNatIps](~~287000~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Creating** state, the NAT IP address is being created. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If a NAT IP address is in the **Available** state, the NAT IP address is created.
        You cannot repeatedly call the **CreateNatIp** operation to create a NAT IP address within the specified period of time.
        
        @param request: CreateNatIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_id):
            query['NatIpCidrId'] = request.nat_ip_cidr_id
        if not UtilClient.is_unset(request.nat_ip_description):
            query['NatIpDescription'] = request.nat_ip_description
        if not UtilClient.is_unset(request.nat_ip_name):
            query['NatIpName'] = request.nat_ip_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        """
        *CreateNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT IP address is not created. The system creates the NAT IP address in the background. You can call the [ListNatIps](~~287000~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Creating** state, the NAT IP address is being created. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If a NAT IP address is in the **Available** state, the NAT IP address is created.
        You cannot repeatedly call the **CreateNatIp** operation to create a NAT IP address within the specified period of time.
        
        @param request: CreateNatIpRequest
        @return: CreateNatIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_with_options(request, runtime)

    async def create_nat_ip_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        """
        *CreateNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT IP address is not created. The system creates the NAT IP address in the background. You can call the [ListNatIps](~~287000~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Creating** state, the NAT IP address is being created. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If a NAT IP address is in the **Available** state, the NAT IP address is created.
        You cannot repeatedly call the **CreateNatIp** operation to create a NAT IP address within the specified period of time.
        
        @param request: CreateNatIpRequest
        @return: CreateNatIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_with_options_async(request, runtime)

    def create_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        """
        You cannot repeatedly call the *CreateNatIpCidr** operation to create a NAT CIDR block within the specified period of time.
        
        @param request: CreateNatIpCidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatIpCidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_description):
            query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        if not UtilClient.is_unset(request.nat_ip_cidr_name):
            query['NatIpCidrName'] = request.nat_ip_cidr_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        """
        You cannot repeatedly call the *CreateNatIpCidr** operation to create a NAT CIDR block within the specified period of time.
        
        @param request: CreateNatIpCidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatIpCidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_description):
            query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        if not UtilClient.is_unset(request.nat_ip_cidr_name):
            query['NatIpCidrName'] = request.nat_ip_cidr_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip_cidr(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        """
        You cannot repeatedly call the *CreateNatIpCidr** operation to create a NAT CIDR block within the specified period of time.
        
        @param request: CreateNatIpCidrRequest
        @return: CreateNatIpCidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_cidr_with_options(request, runtime)

    async def create_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        """
        You cannot repeatedly call the *CreateNatIpCidr** operation to create a NAT CIDR block within the specified period of time.
        
        @param request: CreateNatIpCidrRequest
        @return: CreateNatIpCidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_cidr_with_options_async(request, runtime)

    def create_network_acl_with_options(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_acl(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_network_acl_with_options(request, runtime)

    async def create_network_acl_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_network_acl_with_options_async(request, runtime)

    def create_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        """
        You can apply for a dedicated Express Connect circuit for yourself or create a hosted connection for a tenant. After your application is approved, the Express Connect circuit changes to the *Initial** state. You can contact the connectivity provider to start construction.
        When you call this operation, take note of the following limits:
        *   If your Alibaba Cloud account has more than five Express Connect circuits that are not in the **Enabled** state, you cannot apply for another Express Connect circuit.
        *   If your Alibaba Cloud account has an Express Connect circuit with overdue payments, you cannot apply for another Express Connect circuit.
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        """
        You can apply for a dedicated Express Connect circuit for yourself or create a hosted connection for a tenant. After your application is approved, the Express Connect circuit changes to the *Initial** state. You can contact the connectivity provider to start construction.
        When you call this operation, take note of the following limits:
        *   If your Alibaba Cloud account has more than five Express Connect circuits that are not in the **Enabled** state, you cannot apply for another Express Connect circuit.
        *   If your Alibaba Cloud account has an Express Connect circuit with overdue payments, you cannot apply for another Express Connect circuit.
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        """
        You can apply for a dedicated Express Connect circuit for yourself or create a hosted connection for a tenant. After your application is approved, the Express Connect circuit changes to the *Initial** state. You can contact the connectivity provider to start construction.
        When you call this operation, take note of the following limits:
        *   If your Alibaba Cloud account has more than five Express Connect circuits that are not in the **Enabled** state, you cannot apply for another Express Connect circuit.
        *   If your Alibaba Cloud account has an Express Connect circuit with overdue payments, you cannot apply for another Express Connect circuit.
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_with_options(request, runtime)

    async def create_physical_connection_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        """
        You can apply for a dedicated Express Connect circuit for yourself or create a hosted connection for a tenant. After your application is approved, the Express Connect circuit changes to the *Initial** state. You can contact the connectivity provider to start construction.
        When you call this operation, take note of the following limits:
        *   If your Alibaba Cloud account has more than five Express Connect circuits that are not in the **Enabled** state, you cannot apply for another Express Connect circuit.
        *   If your Alibaba Cloud account has an Express Connect circuit with overdue payments, you cannot apply for another Express Connect circuit.
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_with_options_async(request, runtime)

    def create_physical_connection_occupancy_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        """
        >  You can call this operation only when the Express Connect circuit is in the *Complete** state.
        
        @param request: CreatePhysicalConnectionOccupancyOrderRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionOccupancyOrderResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_occupancy_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        """
        >  You can call this operation only when the Express Connect circuit is in the *Complete** state.
        
        @param request: CreatePhysicalConnectionOccupancyOrderRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionOccupancyOrderResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_occupancy_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        """
        >  You can call this operation only when the Express Connect circuit is in the *Complete** state.
        
        @param request: CreatePhysicalConnectionOccupancyOrderRequest
        @return: CreatePhysicalConnectionOccupancyOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_occupancy_order_with_options(request, runtime)

    async def create_physical_connection_occupancy_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        """
        >  You can call this operation only when the Express Connect circuit is in the *Complete** state.
        
        @param request: CreatePhysicalConnectionOccupancyOrderRequest
        @return: CreatePhysicalConnectionOccupancyOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_occupancy_order_with_options_async(request, runtime)

    def create_physical_connection_setup_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_setup_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_setup_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_setup_order_with_options(request, runtime)

    async def create_physical_connection_setup_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_setup_order_with_options_async(request, runtime)

    def create_public_ip_address_pool_with_options(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        """
        ## Limits
        By default, the IP address pool feature is unavailable. You can apply for the privilege to use the **IP address pool feature** on the Quota Center page. For more information, see [Request a quota increase in the Quota Center console](~~108213~~).
        
        @param request: CreatePublicIpAddressPoolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePublicIpAddressPoolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePublicIpAddressPoolResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_public_ip_address_pool_with_options_async(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        """
        ## Limits
        By default, the IP address pool feature is unavailable. You can apply for the privilege to use the **IP address pool feature** on the Quota Center page. For more information, see [Request a quota increase in the Quota Center console](~~108213~~).
        
        @param request: CreatePublicIpAddressPoolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePublicIpAddressPoolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePublicIpAddressPoolResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_public_ip_address_pool(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        """
        ## Limits
        By default, the IP address pool feature is unavailable. You can apply for the privilege to use the **IP address pool feature** on the Quota Center page. For more information, see [Request a quota increase in the Quota Center console](~~108213~~).
        
        @param request: CreatePublicIpAddressPoolRequest
        @return: CreatePublicIpAddressPoolResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_public_ip_address_pool_with_options(request, runtime)

    async def create_public_ip_address_pool_async(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        """
        ## Limits
        By default, the IP address pool feature is unavailable. You can apply for the privilege to use the **IP address pool feature** on the Quota Center page. For more information, see [Request a quota increase in the Quota Center console](~~108213~~).
        
        @param request: CreatePublicIpAddressPoolRequest
        @return: CreatePublicIpAddressPoolResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_public_ip_address_pool_with_options_async(request, runtime)

    def create_route_entries_with_options(
        self,
        request: vpc_20160428_models.CreateRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntriesResponse:
        """
        **CreateRouteEntries** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry:
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntries** operation to create the same route entry within the specified period of time.
        **When you call this operation to add custom route entries to the route table of a vRouter, take note of the following items:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or its subnets.
        *   The destination CIDR blocks (**DstCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DstCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHop**).
        *   The next hop (**NextHop**) of a custom route entry must belong to the same VPC as the route table.
        
        @param request: CreateRouteEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entries):
            query['RouteEntries'] = request.route_entries
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntriesResponse:
        """
        **CreateRouteEntries** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry:
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntries** operation to create the same route entry within the specified period of time.
        **When you call this operation to add custom route entries to the route table of a vRouter, take note of the following items:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or its subnets.
        *   The destination CIDR blocks (**DstCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DstCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHop**).
        *   The next hop (**NextHop**) of a custom route entry must belong to the same VPC as the route table.
        
        @param request: CreateRouteEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entries):
            query['RouteEntries'] = request.route_entries
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entries(
        self,
        request: vpc_20160428_models.CreateRouteEntriesRequest,
    ) -> vpc_20160428_models.CreateRouteEntriesResponse:
        """
        **CreateRouteEntries** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry:
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntries** operation to create the same route entry within the specified period of time.
        **When you call this operation to add custom route entries to the route table of a vRouter, take note of the following items:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or its subnets.
        *   The destination CIDR blocks (**DstCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DstCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHop**).
        *   The next hop (**NextHop**) of a custom route entry must belong to the same VPC as the route table.
        
        @param request: CreateRouteEntriesRequest
        @return: CreateRouteEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_route_entries_with_options(request, runtime)

    async def create_route_entries_async(
        self,
        request: vpc_20160428_models.CreateRouteEntriesRequest,
    ) -> vpc_20160428_models.CreateRouteEntriesResponse:
        """
        **CreateRouteEntries** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry:
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntries** operation to create the same route entry within the specified period of time.
        **When you call this operation to add custom route entries to the route table of a vRouter, take note of the following items:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DstCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or its subnets.
        *   The destination CIDR blocks (**DstCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DstCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHop**).
        *   The next hop (**NextHop**) of a custom route entry must belong to the same VPC as the route table.
        
        @param request: CreateRouteEntriesRequest
        @return: CreateRouteEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entries_with_options_async(request, runtime)

    def create_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        """
        **CreateRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntry** operation to add a custom route entry to the route table of a vRouter or a VBR within the specified period of time.
        **When you call this operation to add a custom route entry to the route table of a vRouter, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must belong to the same VPC as the route table.
        *   Equal-cost multi-path (ECMP) routing can be configured by specifying the **NextHopList** parameter.
        *   When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you must not specify **NextHopList**.
        *   When you add route entries for ECMP routing, you must specify **DestinationCidrBlock** and **NextHopList**, and you must not specify **NextHopType** or **NextHopId**.
        **When you call this operation to add a custom route entry to the route table of a VBR, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The **NextHopList** parameter is not supported.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must be a router interface associated with the VBR.
        *   You can add route entries only when the VBR is in the **Active** state, and the Express Connect circuit associated with the VBR is in the **Enabled** state and is not locked due to overdue payments.
        *   Only non-ECMP route entries are supported. When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you cannot specify **NextHopList**.
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        """
        **CreateRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntry** operation to add a custom route entry to the route table of a vRouter or a VBR within the specified period of time.
        **When you call this operation to add a custom route entry to the route table of a vRouter, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must belong to the same VPC as the route table.
        *   Equal-cost multi-path (ECMP) routing can be configured by specifying the **NextHopList** parameter.
        *   When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you must not specify **NextHopList**.
        *   When you add route entries for ECMP routing, you must specify **DestinationCidrBlock** and **NextHopList**, and you must not specify **NextHopType** or **NextHopId**.
        **When you call this operation to add a custom route entry to the route table of a VBR, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The **NextHopList** parameter is not supported.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must be a router interface associated with the VBR.
        *   You can add route entries only when the VBR is in the **Active** state, and the Express Connect circuit associated with the VBR is in the **Enabled** state and is not locked due to overdue payments.
        *   Only non-ECMP route entries are supported. When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you cannot specify **NextHopList**.
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entry(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        """
        **CreateRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntry** operation to add a custom route entry to the route table of a vRouter or a VBR within the specified period of time.
        **When you call this operation to add a custom route entry to the route table of a vRouter, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must belong to the same VPC as the route table.
        *   Equal-cost multi-path (ECMP) routing can be configured by specifying the **NextHopList** parameter.
        *   When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you must not specify **NextHopList**.
        *   When you add route entries for ECMP routing, you must specify **DestinationCidrBlock** and **NextHopList**, and you must not specify **NextHopType** or **NextHopId**.
        **When you call this operation to add a custom route entry to the route table of a VBR, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The **NextHopList** parameter is not supported.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must be a router interface associated with the VBR.
        *   You can add route entries only when the VBR is in the **Active** state, and the Express Connect circuit associated with the VBR is in the **Enabled** state and is not locked due to overdue payments.
        *   Only non-ECMP route entries are supported. When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you cannot specify **NextHopList**.
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_route_entry_with_options(request, runtime)

    async def create_route_entry_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        """
        **CreateRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Creating** state, the route entry is being created.
        *   If the route entry is in the **Created** state, the route entry is created.
        *   You cannot repeatedly call the **CreateRouteEntry** operation to add a custom route entry to the route table of a vRouter or a VBR within the specified period of time.
        **When you call this operation to add a custom route entry to the route table of a vRouter, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be the same as or overlap with the CIDR block of a vSwitch in the virtual private cloud (VPC).
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must belong to the same VPC as the route table.
        *   Equal-cost multi-path (ECMP) routing can be configured by specifying the **NextHopList** parameter.
        *   When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you must not specify **NextHopList**.
        *   When you add route entries for ECMP routing, you must specify **DestinationCidrBlock** and **NextHopList**, and you must not specify **NextHopType** or **NextHopId**.
        **When you call this operation to add a custom route entry to the route table of a VBR, take note of the following limits:**\
        *   A route table can contain up to 200 custom route entries.
        *   The **NextHopList** parameter is not supported.
        *   The destination CIDR block (**DestinationCidrBlock**) of a custom route entry cannot be 100.64.0.0/10 or a subset of it.
        *   The destination CIDR blocks (**DestinationCidrBlock**) of route entries in the same route table must be unique.
        *   If you do not include the mask length when you specify the destination CIDR block (**DestinationCidrBlock**), the destination CIDR block is considered a host IP address whose mask length is 32 bits.
        *   Multiple custom route entries can point to the same next hop (**NextHopId**).
        *   The next hop (**NextHopId**) of a custom route entry must be a router interface associated with the VBR.
        *   You can add route entries only when the VBR is in the **Active** state, and the Express Connect circuit associated with the VBR is in the **Enabled** state and is not locked due to overdue payments.
        *   Only non-ECMP route entries are supported. When you add non-ECMP route entries, you must specify **DestinationCidrBlock**, **NextHopType**, and **NextHopId**, and you cannot specify **NextHopList**.
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entry_with_options_async(request, runtime)

    def create_route_table_with_options(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        """
        The **CreateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Creating** state, the custom route table is being created.
        *   If the custom route table is in the **Created** state, the custom route table is created.
        *   You cannot repeatedly call the **CreateRouteTable** operation to create a custom route table within the specified period of time.
        
        @param request: CreateRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_table_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        """
        The **CreateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Creating** state, the custom route table is being created.
        *   If the custom route table is in the **Created** state, the custom route table is created.
        *   You cannot repeatedly call the **CreateRouteTable** operation to create a custom route table within the specified period of time.
        
        @param request: CreateRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_table(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        """
        The **CreateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Creating** state, the custom route table is being created.
        *   If the custom route table is in the **Created** state, the custom route table is created.
        *   You cannot repeatedly call the **CreateRouteTable** operation to create a custom route table within the specified period of time.
        
        @param request: CreateRouteTableRequest
        @return: CreateRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_route_table_with_options(request, runtime)

    async def create_route_table_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        """
        The **CreateRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Creating** state, the custom route table is being created.
        *   If the custom route table is in the **Created** state, the custom route table is created.
        *   You cannot repeatedly call the **CreateRouteTable** operation to create a custom route table within the specified period of time.
        
        @param request: CreateRouteTableRequest
        @return: CreateRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_route_table_with_options_async(request, runtime)

    def create_router_interface_with_options(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create only one pair of interfaces to be connected between two routers.
        *   You can create a maximum of five router interfaces for a router.
        *   If your Alibaba Cloud account has a router interface with overdue payments, you cannot create new router interfaces.
        *   Each destination CIDR block of route entries in the same route table must be unique.
        *   A virtual border router (VBR) can serve only as a requester. The VBR must be in the Activated state.
        *   You can call this operation to create subscription and pay-as-you-go router interfaces.
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.fast_link_mode):
            query['FastLinkMode'] = request.fast_link_mode
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create only one pair of interfaces to be connected between two routers.
        *   You can create a maximum of five router interfaces for a router.
        *   If your Alibaba Cloud account has a router interface with overdue payments, you cannot create new router interfaces.
        *   Each destination CIDR block of route entries in the same route table must be unique.
        *   A virtual border router (VBR) can serve only as a requester. The VBR must be in the Activated state.
        *   You can call this operation to create subscription and pay-as-you-go router interfaces.
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.fast_link_mode):
            query['FastLinkMode'] = request.fast_link_mode
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_router_interface(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create only one pair of interfaces to be connected between two routers.
        *   You can create a maximum of five router interfaces for a router.
        *   If your Alibaba Cloud account has a router interface with overdue payments, you cannot create new router interfaces.
        *   Each destination CIDR block of route entries in the same route table must be unique.
        *   A virtual border router (VBR) can serve only as a requester. The VBR must be in the Activated state.
        *   You can call this operation to create subscription and pay-as-you-go router interfaces.
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_router_interface_with_options(request, runtime)

    async def create_router_interface_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create only one pair of interfaces to be connected between two routers.
        *   You can create a maximum of five router interfaces for a router.
        *   If your Alibaba Cloud account has a router interface with overdue payments, you cannot create new router interfaces.
        *   Each destination CIDR block of route entries in the same route table must be unique.
        *   A virtual border router (VBR) can serve only as a requester. The VBR must be in the Activated state.
        *   You can call this operation to create subscription and pay-as-you-go router interfaces.
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_router_interface_with_options_async(request, runtime)

    def create_snat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        """
        You can call this operation to add SNAT entries to Internet NAT gateways and Virtual Private Cloud (VPC) NAT gateways. In this topic, a NAT gateway refers to both gateway types.
        Before you call this operation, take note of the following limits:
        *   **CreateSnatEntry** is an asynchronous operation. After you make a request, an SNAT entry ID is returned but the specified SNAT entry is not added. The system adds the entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of the SNAT entry.
        *   If the SNAT entry is in the **Pending** state, the system is adding the SNAT entry. You can only query the status of the SNAT entry, but cannot perform other operations.
        *   If the SNAT entry is in the **Available** state, the SNAT entry is added.
        *   You cannot repeatedly call the **CreateSnatEntry** operation to add an SNAT entry to an SNAT table within the specified period of time.
        *   The vSwitch and Elastic Compute Service (ECS) instance specified in an SNAT entry must be created in the virtual private cloud (VPC) where the NAT gateway is deployed.
        *   Each vSwitch or ECS instance can be specified in only one SNAT entry.
        *   If a high-availability virtual IP address (HAVIP) exists in a vSwitch, you cannot create SNAT entries.
        
        @param request: CreateSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        """
        You can call this operation to add SNAT entries to Internet NAT gateways and Virtual Private Cloud (VPC) NAT gateways. In this topic, a NAT gateway refers to both gateway types.
        Before you call this operation, take note of the following limits:
        *   **CreateSnatEntry** is an asynchronous operation. After you make a request, an SNAT entry ID is returned but the specified SNAT entry is not added. The system adds the entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of the SNAT entry.
        *   If the SNAT entry is in the **Pending** state, the system is adding the SNAT entry. You can only query the status of the SNAT entry, but cannot perform other operations.
        *   If the SNAT entry is in the **Available** state, the SNAT entry is added.
        *   You cannot repeatedly call the **CreateSnatEntry** operation to add an SNAT entry to an SNAT table within the specified period of time.
        *   The vSwitch and Elastic Compute Service (ECS) instance specified in an SNAT entry must be created in the virtual private cloud (VPC) where the NAT gateway is deployed.
        *   Each vSwitch or ECS instance can be specified in only one SNAT entry.
        *   If a high-availability virtual IP address (HAVIP) exists in a vSwitch, you cannot create SNAT entries.
        
        @param request: CreateSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snat_entry(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        """
        You can call this operation to add SNAT entries to Internet NAT gateways and Virtual Private Cloud (VPC) NAT gateways. In this topic, a NAT gateway refers to both gateway types.
        Before you call this operation, take note of the following limits:
        *   **CreateSnatEntry** is an asynchronous operation. After you make a request, an SNAT entry ID is returned but the specified SNAT entry is not added. The system adds the entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of the SNAT entry.
        *   If the SNAT entry is in the **Pending** state, the system is adding the SNAT entry. You can only query the status of the SNAT entry, but cannot perform other operations.
        *   If the SNAT entry is in the **Available** state, the SNAT entry is added.
        *   You cannot repeatedly call the **CreateSnatEntry** operation to add an SNAT entry to an SNAT table within the specified period of time.
        *   The vSwitch and Elastic Compute Service (ECS) instance specified in an SNAT entry must be created in the virtual private cloud (VPC) where the NAT gateway is deployed.
        *   Each vSwitch or ECS instance can be specified in only one SNAT entry.
        *   If a high-availability virtual IP address (HAVIP) exists in a vSwitch, you cannot create SNAT entries.
        
        @param request: CreateSnatEntryRequest
        @return: CreateSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snat_entry_with_options(request, runtime)

    async def create_snat_entry_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        """
        You can call this operation to add SNAT entries to Internet NAT gateways and Virtual Private Cloud (VPC) NAT gateways. In this topic, a NAT gateway refers to both gateway types.
        Before you call this operation, take note of the following limits:
        *   **CreateSnatEntry** is an asynchronous operation. After you make a request, an SNAT entry ID is returned but the specified SNAT entry is not added. The system adds the entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of the SNAT entry.
        *   If the SNAT entry is in the **Pending** state, the system is adding the SNAT entry. You can only query the status of the SNAT entry, but cannot perform other operations.
        *   If the SNAT entry is in the **Available** state, the SNAT entry is added.
        *   You cannot repeatedly call the **CreateSnatEntry** operation to add an SNAT entry to an SNAT table within the specified period of time.
        *   The vSwitch and Elastic Compute Service (ECS) instance specified in an SNAT entry must be created in the virtual private cloud (VPC) where the NAT gateway is deployed.
        *   Each vSwitch or ECS instance can be specified in only one SNAT entry.
        *   If a high-availability virtual IP address (HAVIP) exists in a vSwitch, you cannot create SNAT entries.
        
        @param request: CreateSnatEntryRequest
        @return: CreateSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snat_entry_with_options_async(request, runtime)

    def create_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_client_cert_with_options(request, runtime)

    async def create_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_client_cert_with_options_async(request, runtime)

    def create_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        """
        The **CreateSslVpnServer** operation is asynchronous. After you send the request, the system returns a request ID, but the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of the associated VPN gateway and determine whether the SSL server is created.
        *   If the VPN gateway is in the **updating** state, the SSL server is being created.
        *   If the VPN gateway is in the **active** state, the SSL server is created.
        *   You cannot repeatedly call the **CreateSslVpnServer** operation for the same VPN gateway within the specified period of time.
        
        @param request: CreateSslVpnServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSslVpnServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cipher):
            query['Cipher'] = request.cipher
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.compress):
            query['Compress'] = request.compress
        if not UtilClient.is_unset(request.enable_multi_factor_auth):
            query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        if not UtilClient.is_unset(request.idaa_sinstance_id):
            query['IDaaSInstanceId'] = request.idaa_sinstance_id
        if not UtilClient.is_unset(request.idaa_sregion_id):
            query['IDaaSRegionId'] = request.idaa_sregion_id
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        """
        The **CreateSslVpnServer** operation is asynchronous. After you send the request, the system returns a request ID, but the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of the associated VPN gateway and determine whether the SSL server is created.
        *   If the VPN gateway is in the **updating** state, the SSL server is being created.
        *   If the VPN gateway is in the **active** state, the SSL server is created.
        *   You cannot repeatedly call the **CreateSslVpnServer** operation for the same VPN gateway within the specified period of time.
        
        @param request: CreateSslVpnServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSslVpnServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cipher):
            query['Cipher'] = request.cipher
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.compress):
            query['Compress'] = request.compress
        if not UtilClient.is_unset(request.enable_multi_factor_auth):
            query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        if not UtilClient.is_unset(request.idaa_sinstance_id):
            query['IDaaSInstanceId'] = request.idaa_sinstance_id
        if not UtilClient.is_unset(request.idaa_sregion_id):
            query['IDaaSRegionId'] = request.idaa_sregion_id
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_server(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        """
        The **CreateSslVpnServer** operation is asynchronous. After you send the request, the system returns a request ID, but the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of the associated VPN gateway and determine whether the SSL server is created.
        *   If the VPN gateway is in the **updating** state, the SSL server is being created.
        *   If the VPN gateway is in the **active** state, the SSL server is created.
        *   You cannot repeatedly call the **CreateSslVpnServer** operation for the same VPN gateway within the specified period of time.
        
        @param request: CreateSslVpnServerRequest
        @return: CreateSslVpnServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_server_with_options(request, runtime)

    async def create_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        """
        The **CreateSslVpnServer** operation is asynchronous. After you send the request, the system returns a request ID, but the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of the associated VPN gateway and determine whether the SSL server is created.
        *   If the VPN gateway is in the **updating** state, the SSL server is being created.
        *   If the VPN gateway is in the **active** state, the SSL server is created.
        *   You cannot repeatedly call the **CreateSslVpnServer** operation for the same VPN gateway within the specified period of time.
        
        @param request: CreateSslVpnServerRequest
        @return: CreateSslVpnServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_server_with_options_async(request, runtime)

    def create_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        """
        *CreateTrafficMirrorFilter** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter.
        *   If the filter is in the **Creating** state, the filter is being created.
        *   If the filter is in the **Created** state, the filter is created.
        
        @param request: CreateTrafficMirrorFilterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorFilterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_description):
            query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        if not UtilClient.is_unset(request.traffic_mirror_filter_name):
            query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        """
        *CreateTrafficMirrorFilter** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter.
        *   If the filter is in the **Creating** state, the filter is being created.
        *   If the filter is in the **Created** state, the filter is created.
        
        @param request: CreateTrafficMirrorFilterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorFilterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_description):
            query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        if not UtilClient.is_unset(request.traffic_mirror_filter_name):
            query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        """
        *CreateTrafficMirrorFilter** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter.
        *   If the filter is in the **Creating** state, the filter is being created.
        *   If the filter is in the **Created** state, the filter is created.
        
        @param request: CreateTrafficMirrorFilterRequest
        @return: CreateTrafficMirrorFilterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_with_options(request, runtime)

    async def create_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        """
        *CreateTrafficMirrorFilter** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter.
        *   If the filter is in the **Creating** state, the filter is being created.
        *   If the filter is in the **Created** state, the filter is created.
        
        @param request: CreateTrafficMirrorFilterRequest
        @return: CreateTrafficMirrorFilterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_with_options_async(request, runtime)

    def create_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        """
        The **CreateTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Creating** state, the rule is being created.
        *   If the rule is in the **Created** state, the rule is created.
        *   You cannot repeatedly call the **CreateTrafficMirrorFilterRules** operation to create an inbound or outbound rule for a traffic mirroring filter.
        
        @param request: CreateTrafficMirrorFilterRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorFilterRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        """
        The **CreateTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Creating** state, the rule is being created.
        *   If the rule is in the **Created** state, the rule is created.
        *   You cannot repeatedly call the **CreateTrafficMirrorFilterRules** operation to create an inbound or outbound rule for a traffic mirroring filter.
        
        @param request: CreateTrafficMirrorFilterRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorFilterRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        """
        The **CreateTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Creating** state, the rule is being created.
        *   If the rule is in the **Created** state, the rule is created.
        *   You cannot repeatedly call the **CreateTrafficMirrorFilterRules** operation to create an inbound or outbound rule for a traffic mirroring filter.
        
        @param request: CreateTrafficMirrorFilterRulesRequest
        @return: CreateTrafficMirrorFilterRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_rules_with_options(request, runtime)

    async def create_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        """
        The **CreateTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Creating** state, the rule is being created.
        *   If the rule is in the **Created** state, the rule is created.
        *   You cannot repeatedly call the **CreateTrafficMirrorFilterRules** operation to create an inbound or outbound rule for a traffic mirroring filter.
        
        @param request: CreateTrafficMirrorFilterRulesRequest
        @return: CreateTrafficMirrorFilterRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def create_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        """
        *CreateTrafficMirrorSession** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Creating** state, the traffic mirror session is being created.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror session is created.
        
        @param request: CreateTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.packet_length):
            query['PacketLength'] = request.packet_length
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_session_description):
            query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        if not UtilClient.is_unset(request.traffic_mirror_session_name):
            query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        if not UtilClient.is_unset(request.traffic_mirror_target_id):
            query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        if not UtilClient.is_unset(request.traffic_mirror_target_type):
            query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        if not UtilClient.is_unset(request.virtual_network_id):
            query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        """
        *CreateTrafficMirrorSession** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Creating** state, the traffic mirror session is being created.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror session is created.
        
        @param request: CreateTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.packet_length):
            query['PacketLength'] = request.packet_length
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_session_description):
            query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        if not UtilClient.is_unset(request.traffic_mirror_session_name):
            query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        if not UtilClient.is_unset(request.traffic_mirror_target_id):
            query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        if not UtilClient.is_unset(request.traffic_mirror_target_type):
            query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        if not UtilClient.is_unset(request.virtual_network_id):
            query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_session(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        """
        *CreateTrafficMirrorSession** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Creating** state, the traffic mirror session is being created.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror session is created.
        
        @param request: CreateTrafficMirrorSessionRequest
        @return: CreateTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_session_with_options(request, runtime)

    async def create_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        """
        *CreateTrafficMirrorSession** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session:
        *   If the traffic mirror session is in the **Creating** state, the traffic mirror session is being created.
        *   If the traffic mirror session is in the **Created** state, the traffic mirror session is created.
        
        @param request: CreateTrafficMirrorSessionRequest
        @return: CreateTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_session_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create at most 150 vSwitches in a virtual private cloud (VPC).
        *   The first IP address and last three IP addresses of each vSwitch CIDR block are reserved. For example, if the CIDR block of a vSwitch is 192.168.1.0/24, the IP addresses 192.168.1.0, 192.168.1.253, 192.168.1.254, and 192.168.1.255 are reserved.
        *   The number of instances in a vSwitch cannot exceed the remaining capacity of the VPC. The remaining capacity is the difference between 15,000 and the current number of instances.
        *   Each instance can belong to only one vSwitch.
        *   vSwitches do not support multicast or broadcast.
        *   After you create a vSwitch, you cannot modify its CIDR block.
        *   The **CreateVSwitch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being configured.
        *   If the vSwitch is in the **Available** state, the vSwitch is available.
        *   You cannot repeatedly call the **CreateVSwitch** operation to create a vSwitch in a VPC within the specified period of time.
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_ipv_6cidr_block):
            query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create at most 150 vSwitches in a virtual private cloud (VPC).
        *   The first IP address and last three IP addresses of each vSwitch CIDR block are reserved. For example, if the CIDR block of a vSwitch is 192.168.1.0/24, the IP addresses 192.168.1.0, 192.168.1.253, 192.168.1.254, and 192.168.1.255 are reserved.
        *   The number of instances in a vSwitch cannot exceed the remaining capacity of the VPC. The remaining capacity is the difference between 15,000 and the current number of instances.
        *   Each instance can belong to only one vSwitch.
        *   vSwitches do not support multicast or broadcast.
        *   After you create a vSwitch, you cannot modify its CIDR block.
        *   The **CreateVSwitch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being configured.
        *   If the vSwitch is in the **Available** state, the vSwitch is available.
        *   You cannot repeatedly call the **CreateVSwitch** operation to create a vSwitch in a VPC within the specified period of time.
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_ipv_6cidr_block):
            query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create at most 150 vSwitches in a virtual private cloud (VPC).
        *   The first IP address and last three IP addresses of each vSwitch CIDR block are reserved. For example, if the CIDR block of a vSwitch is 192.168.1.0/24, the IP addresses 192.168.1.0, 192.168.1.253, 192.168.1.254, and 192.168.1.255 are reserved.
        *   The number of instances in a vSwitch cannot exceed the remaining capacity of the VPC. The remaining capacity is the difference between 15,000 and the current number of instances.
        *   Each instance can belong to only one vSwitch.
        *   vSwitches do not support multicast or broadcast.
        *   After you create a vSwitch, you cannot modify its CIDR block.
        *   The **CreateVSwitch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being configured.
        *   If the vSwitch is in the **Available** state, the vSwitch is available.
        *   You cannot repeatedly call the **CreateVSwitch** operation to create a vSwitch in a VPC within the specified period of time.
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can create at most 150 vSwitches in a virtual private cloud (VPC).
        *   The first IP address and last three IP addresses of each vSwitch CIDR block are reserved. For example, if the CIDR block of a vSwitch is 192.168.1.0/24, the IP addresses 192.168.1.0, 192.168.1.253, 192.168.1.254, and 192.168.1.255 are reserved.
        *   The number of instances in a vSwitch cannot exceed the remaining capacity of the VPC. The remaining capacity is the difference between 15,000 and the current number of instances.
        *   Each instance can belong to only one vSwitch.
        *   vSwitches do not support multicast or broadcast.
        *   After you create a vSwitch, you cannot modify its CIDR block.
        *   The **CreateVSwitch** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being configured.
        *   If the vSwitch is in the **Available** state, the vSwitch is available.
        *   You cannot repeatedly call the **CreateVSwitch** operation to create a vSwitch in a VPC within the specified period of time.
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def create_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_vbr_id):
            query['PeerVbrId'] = request.peer_vbr_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_vbr_id):
            query['PeerVbrId'] = request.peer_vbr_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vbr_ha(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vbr_ha_with_options(request, runtime)

    async def create_vbr_ha_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vbr_ha_with_options_async(request, runtime)

    def create_vco_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        """
        You cannot create a destination-based route whose destination CIDR block is 0.0.0.0/0.
        *   When you create a destination-based route for an IPsec-VPN connection, do not create a route that meets the following conditions: The destination CIDR block is 100.64.0.0/10 or one of its subnets. The next hop is the IPsec-VPN connection. Such a route results in one of the following errors: The status of the IPsec-VPN connection cannot be displayed in the console. The negotiations of the IPsec-VPN connection fail.
        *   **CreateVcoRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being created.
        *   If the IPsec-VPN connection is in the **attached** state, the route is created.
        *   You cannot repeatedly call **CreateVcoRouteEntry** to create a route for the same IPsec-VPN connection within the specified period of time.
        
        @param request: CreateVcoRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVcoRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVcoRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vco_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        """
        You cannot create a destination-based route whose destination CIDR block is 0.0.0.0/0.
        *   When you create a destination-based route for an IPsec-VPN connection, do not create a route that meets the following conditions: The destination CIDR block is 100.64.0.0/10 or one of its subnets. The next hop is the IPsec-VPN connection. Such a route results in one of the following errors: The status of the IPsec-VPN connection cannot be displayed in the console. The negotiations of the IPsec-VPN connection fail.
        *   **CreateVcoRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being created.
        *   If the IPsec-VPN connection is in the **attached** state, the route is created.
        *   You cannot repeatedly call **CreateVcoRouteEntry** to create a route for the same IPsec-VPN connection within the specified period of time.
        
        @param request: CreateVcoRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVcoRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVcoRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vco_route_entry(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        """
        You cannot create a destination-based route whose destination CIDR block is 0.0.0.0/0.
        *   When you create a destination-based route for an IPsec-VPN connection, do not create a route that meets the following conditions: The destination CIDR block is 100.64.0.0/10 or one of its subnets. The next hop is the IPsec-VPN connection. Such a route results in one of the following errors: The status of the IPsec-VPN connection cannot be displayed in the console. The negotiations of the IPsec-VPN connection fail.
        *   **CreateVcoRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being created.
        *   If the IPsec-VPN connection is in the **attached** state, the route is created.
        *   You cannot repeatedly call **CreateVcoRouteEntry** to create a route for the same IPsec-VPN connection within the specified period of time.
        
        @param request: CreateVcoRouteEntryRequest
        @return: CreateVcoRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vco_route_entry_with_options(request, runtime)

    async def create_vco_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        """
        You cannot create a destination-based route whose destination CIDR block is 0.0.0.0/0.
        *   When you create a destination-based route for an IPsec-VPN connection, do not create a route that meets the following conditions: The destination CIDR block is 100.64.0.0/10 or one of its subnets. The next hop is the IPsec-VPN connection. Such a route results in one of the following errors: The status of the IPsec-VPN connection cannot be displayed in the console. The negotiations of the IPsec-VPN connection fail.
        *   **CreateVcoRouteEntry** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being created.
        *   If the IPsec-VPN connection is in the **attached** state, the route is created.
        *   You cannot repeatedly call **CreateVcoRouteEntry** to create a route for the same IPsec-VPN connection within the specified period of time.
        
        @param request: CreateVcoRouteEntryRequest
        @return: CreateVcoRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vco_route_entry_with_options_async(request, runtime)

    def create_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        """
        When you create a VBR, the VBR is in the *Enabled** state by default.
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        """
        When you create a VBR, the VBR is in the *Enabled** state by default.
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_border_router(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        """
        When you create a VBR, the VBR is in the *Enabled** state by default.
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_border_router_with_options(request, runtime)

    async def create_virtual_border_router_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        """
        When you create a VBR, the VBR is in the *Enabled** state by default.
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_border_router_with_options_async(request, runtime)

    def create_virtual_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        """
        Before you call this API operation, familiarize yourself with the workflow for creating a hosted connection and the environment requirements. For more information, see [Overview](~~146571~~) and [Operation guide for Express Connect partners](~~155987~~).
        
        @param request: CreateVirtualPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualPhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.vpconn_ali_uid):
            query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        """
        Before you call this API operation, familiarize yourself with the workflow for creating a hosted connection and the environment requirements. For more information, see [Overview](~~146571~~) and [Operation guide for Express Connect partners](~~155987~~).
        
        @param request: CreateVirtualPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualPhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.vpconn_ali_uid):
            query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_physical_connection(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        """
        Before you call this API operation, familiarize yourself with the workflow for creating a hosted connection and the environment requirements. For more information, see [Overview](~~146571~~) and [Operation guide for Express Connect partners](~~155987~~).
        
        @param request: CreateVirtualPhysicalConnectionRequest
        @return: CreateVirtualPhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_physical_connection_with_options(request, runtime)

    async def create_virtual_physical_connection_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        """
        Before you call this API operation, familiarize yourself with the workflow for creating a hosted connection and the environment requirements. For more information, see [Overview](~~146571~~) and [Operation guide for Express Connect partners](~~155987~~).
        
        @param request: CreateVirtualPhysicalConnectionRequest
        @return: CreateVirtualPhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_physical_connection_with_options_async(request, runtime)

    def create_vpc_with_options(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can specify only one CIDR block for each VPC.
        *   After you create a VPC, you cannot change its CIDR block. However, you can add secondary IPv4 CIDR blocks to the VPC.
        *   In each VPC, cloud services can use a maximum of 60,000 private IP addresses. You cannot increase the quota.
        *   After you create a VPC, a vRouter and a route table are automatically created.
        *   At most three user CIDR blocks can be added to a VPC. If a user CIDR block includes another user CIDR block, the one with the shorter subnet mask takes effect. For example, if 10.0.0.0/8 and 10.1.0.0/16 are specified, only 10.0.0.0/8 takes effect.
        *   The **CreateVpc** operation is asynchronous. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Creating** state, the VPC is being created.
        *   If the VPC is in the **Created** state, the VPC is created.
        *   You cannot repeatedly call the **CreateVpc** operation to create default VPCs within the specified period of time. However, you can repeatedly call this operation to create custom VPCs within the specified period of time.
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can specify only one CIDR block for each VPC.
        *   After you create a VPC, you cannot change its CIDR block. However, you can add secondary IPv4 CIDR blocks to the VPC.
        *   In each VPC, cloud services can use a maximum of 60,000 private IP addresses. You cannot increase the quota.
        *   After you create a VPC, a vRouter and a route table are automatically created.
        *   At most three user CIDR blocks can be added to a VPC. If a user CIDR block includes another user CIDR block, the one with the shorter subnet mask takes effect. For example, if 10.0.0.0/8 and 10.1.0.0/16 are specified, only 10.0.0.0/8 takes effect.
        *   The **CreateVpc** operation is asynchronous. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Creating** state, the VPC is being created.
        *   If the VPC is in the **Created** state, the VPC is created.
        *   You cannot repeatedly call the **CreateVpc** operation to create default VPCs within the specified period of time. However, you can repeatedly call this operation to create custom VPCs within the specified period of time.
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can specify only one CIDR block for each VPC.
        *   After you create a VPC, you cannot change its CIDR block. However, you can add secondary IPv4 CIDR blocks to the VPC.
        *   In each VPC, cloud services can use a maximum of 60,000 private IP addresses. You cannot increase the quota.
        *   After you create a VPC, a vRouter and a route table are automatically created.
        *   At most three user CIDR blocks can be added to a VPC. If a user CIDR block includes another user CIDR block, the one with the shorter subnet mask takes effect. For example, if 10.0.0.0/8 and 10.1.0.0/16 are specified, only 10.0.0.0/8 takes effect.
        *   The **CreateVpc** operation is asynchronous. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Creating** state, the VPC is being created.
        *   If the VPC is in the **Created** state, the VPC is created.
        *   You cannot repeatedly call the **CreateVpc** operation to create default VPCs within the specified period of time. However, you can repeatedly call this operation to create custom VPCs within the specified period of time.
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_with_options(request, runtime)

    async def create_vpc_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can specify only one CIDR block for each VPC.
        *   After you create a VPC, you cannot change its CIDR block. However, you can add secondary IPv4 CIDR blocks to the VPC.
        *   In each VPC, cloud services can use a maximum of 60,000 private IP addresses. You cannot increase the quota.
        *   After you create a VPC, a vRouter and a route table are automatically created.
        *   At most three user CIDR blocks can be added to a VPC. If a user CIDR block includes another user CIDR block, the one with the shorter subnet mask takes effect. For example, if 10.0.0.0/8 and 10.1.0.0/16 are specified, only 10.0.0.0/8 takes effect.
        *   The **CreateVpc** operation is asynchronous. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Creating** state, the VPC is being created.
        *   If the VPC is in the **Created** state, the VPC is created.
        *   You cannot repeatedly call the **CreateVpc** operation to create default VPCs within the specified period of time. However, you can repeatedly call this operation to create custom VPCs within the specified period of time.
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_with_options_async(request, runtime)

    def create_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        """
        **CreateVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns an **EndpointId** and runs the task in the background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a gateway endpoint.
        *   If the gateway endpoint is in the **Creating** state, the gateway endpoint is being created.
        *   If the gateway endpoint is in the **Created** state, the gateway endpoint is created.
        *   You cannot repeatedly call the **CreateVpcGatewayEndpoint** operation for the same endpoint service within the specified period of time.
        
        @param request: CreateVpcGatewayEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcGatewayEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_description):
            query['EndpointDescription'] = request.endpoint_description
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy_document):
            query['PolicyDocument'] = request.policy_document
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        """
        **CreateVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns an **EndpointId** and runs the task in the background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a gateway endpoint.
        *   If the gateway endpoint is in the **Creating** state, the gateway endpoint is being created.
        *   If the gateway endpoint is in the **Created** state, the gateway endpoint is created.
        *   You cannot repeatedly call the **CreateVpcGatewayEndpoint** operation for the same endpoint service within the specified period of time.
        
        @param request: CreateVpcGatewayEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcGatewayEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_description):
            query['EndpointDescription'] = request.endpoint_description
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy_document):
            query['PolicyDocument'] = request.policy_document
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        """
        **CreateVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns an **EndpointId** and runs the task in the background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a gateway endpoint.
        *   If the gateway endpoint is in the **Creating** state, the gateway endpoint is being created.
        *   If the gateway endpoint is in the **Created** state, the gateway endpoint is created.
        *   You cannot repeatedly call the **CreateVpcGatewayEndpoint** operation for the same endpoint service within the specified period of time.
        
        @param request: CreateVpcGatewayEndpointRequest
        @return: CreateVpcGatewayEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_gateway_endpoint_with_options(request, runtime)

    async def create_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        """
        **CreateVpcGatewayEndpoint** is an asynchronous operation. After you send a request, the system returns an **EndpointId** and runs the task in the background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a gateway endpoint.
        *   If the gateway endpoint is in the **Creating** state, the gateway endpoint is being created.
        *   If the gateway endpoint is in the **Created** state, the gateway endpoint is created.
        *   You cannot repeatedly call the **CreateVpcGatewayEndpoint** operation for the same endpoint service within the specified period of time.
        
        @param request: CreateVpcGatewayEndpointRequest
        @return: CreateVpcGatewayEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_gateway_endpoint_with_options_async(request, runtime)

    def create_vpc_prefix_list_with_options(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        """
        You cannot repeatedly call the *CreateVpcPrefixList** operation to create a prefix list in a region within the specified period of time.
        
        @param request: CreateVpcPrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcPrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_description):
            query['PrefixListDescription'] = request.prefix_list_description
        if not UtilClient.is_unset(request.prefix_list_entries):
            query['PrefixListEntries'] = request.prefix_list_entries
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcPrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_prefix_list_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        """
        You cannot repeatedly call the *CreateVpcPrefixList** operation to create a prefix list in a region within the specified period of time.
        
        @param request: CreateVpcPrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcPrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_description):
            query['PrefixListDescription'] = request.prefix_list_description
        if not UtilClient.is_unset(request.prefix_list_entries):
            query['PrefixListEntries'] = request.prefix_list_entries
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcPrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_prefix_list(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        """
        You cannot repeatedly call the *CreateVpcPrefixList** operation to create a prefix list in a region within the specified period of time.
        
        @param request: CreateVpcPrefixListRequest
        @return: CreateVpcPrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_prefix_list_with_options(request, runtime)

    async def create_vpc_prefix_list_async(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        """
        You cannot repeatedly call the *CreateVpcPrefixList** operation to create a prefix list in a region within the specified period of time.
        
        @param request: CreateVpcPrefixListRequest
        @return: CreateVpcPrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_prefix_list_with_options_async(request, runtime)

    def create_vpconn_from_vbr_with_options(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        """
        If an Express Connect partner has created a virtual border router (VBR) for a tenant before, the Express Connect partner can push the Express Connect circuit that is associated with the VBR to the tenant account by adding a shared port for the tenant account. The service of the tenant is not interrupted in this process.
        Preparations:
        Before the Express Connect partner performs the operation, the Express Connect partner must notify the tenant and request the tenant to enable outbound data transfer billing. For more information, see [Enable outbound data transfer billing](~~274385~~).
        What to do next:
        1\\. After the Express Connect partner performs the operation, a shared port is added for the tenant account. The tenant must call the [ConfirmPhysicalConnection](~~324198~~) operation to accept the shared port.
        2\\. Then, the Express Connect partner must call the [AttachVbrToVpconn](~~324191~~) operation to associate the VBR with the newly added shared port that belongs to the tenant account.
        
        @param request: CreateVpconnFromVbrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpconnFromVbrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpconn_from_vbr_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        """
        If an Express Connect partner has created a virtual border router (VBR) for a tenant before, the Express Connect partner can push the Express Connect circuit that is associated with the VBR to the tenant account by adding a shared port for the tenant account. The service of the tenant is not interrupted in this process.
        Preparations:
        Before the Express Connect partner performs the operation, the Express Connect partner must notify the tenant and request the tenant to enable outbound data transfer billing. For more information, see [Enable outbound data transfer billing](~~274385~~).
        What to do next:
        1\\. After the Express Connect partner performs the operation, a shared port is added for the tenant account. The tenant must call the [ConfirmPhysicalConnection](~~324198~~) operation to accept the shared port.
        2\\. Then, the Express Connect partner must call the [AttachVbrToVpconn](~~324191~~) operation to associate the VBR with the newly added shared port that belongs to the tenant account.
        
        @param request: CreateVpconnFromVbrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpconnFromVbrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpconn_from_vbr(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        """
        If an Express Connect partner has created a virtual border router (VBR) for a tenant before, the Express Connect partner can push the Express Connect circuit that is associated with the VBR to the tenant account by adding a shared port for the tenant account. The service of the tenant is not interrupted in this process.
        Preparations:
        Before the Express Connect partner performs the operation, the Express Connect partner must notify the tenant and request the tenant to enable outbound data transfer billing. For more information, see [Enable outbound data transfer billing](~~274385~~).
        What to do next:
        1\\. After the Express Connect partner performs the operation, a shared port is added for the tenant account. The tenant must call the [ConfirmPhysicalConnection](~~324198~~) operation to accept the shared port.
        2\\. Then, the Express Connect partner must call the [AttachVbrToVpconn](~~324191~~) operation to associate the VBR with the newly added shared port that belongs to the tenant account.
        
        @param request: CreateVpconnFromVbrRequest
        @return: CreateVpconnFromVbrResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpconn_from_vbr_with_options(request, runtime)

    async def create_vpconn_from_vbr_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        """
        If an Express Connect partner has created a virtual border router (VBR) for a tenant before, the Express Connect partner can push the Express Connect circuit that is associated with the VBR to the tenant account by adding a shared port for the tenant account. The service of the tenant is not interrupted in this process.
        Preparations:
        Before the Express Connect partner performs the operation, the Express Connect partner must notify the tenant and request the tenant to enable outbound data transfer billing. For more information, see [Enable outbound data transfer billing](~~274385~~).
        What to do next:
        1\\. After the Express Connect partner performs the operation, a shared port is added for the tenant account. The tenant must call the [ConfirmPhysicalConnection](~~324198~~) operation to accept the shared port.
        2\\. Then, the Express Connect partner must call the [AttachVbrToVpconn](~~324191~~) operation to associate the VBR with the newly added shared port that belongs to the tenant account.
        
        @param request: CreateVpconnFromVbrRequest
        @return: CreateVpconnFromVbrResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpconn_from_vbr_with_options_async(request, runtime)

    def create_vpn_attachment_with_options(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        """
        By default, an IPsec-VPN connection created by calling the `CreateVpnAttachment` operation is not associated with a resource. You can associate an IPsec-VPN connection with a transit router by calling the [CreateTransitRouterVpnAttachment](~~443993~~) operation.
        ## Prerequisites
        Before you create an IPsec-VPN connection, make sure that you created a customer gateway in the region where you want to create the IPsec-VPN connection. For more information, see [CreateCustomerGateway](/help/en/vpn-gateway/latest/createcustomergateway).
        If you want to add BGP configurations to an IPsec-VPN connection, make sure that an autonomous system number (ASN) is assigned to the customer gateway.
        
        @param request: CreateVpnAttachmentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnAttachmentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_cert):
            query['RemoteCaCert'] = request.remote_ca_cert
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnAttachmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_attachment_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        """
        By default, an IPsec-VPN connection created by calling the `CreateVpnAttachment` operation is not associated with a resource. You can associate an IPsec-VPN connection with a transit router by calling the [CreateTransitRouterVpnAttachment](~~443993~~) operation.
        ## Prerequisites
        Before you create an IPsec-VPN connection, make sure that you created a customer gateway in the region where you want to create the IPsec-VPN connection. For more information, see [CreateCustomerGateway](/help/en/vpn-gateway/latest/createcustomergateway).
        If you want to add BGP configurations to an IPsec-VPN connection, make sure that an autonomous system number (ASN) is assigned to the customer gateway.
        
        @param request: CreateVpnAttachmentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnAttachmentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_cert):
            query['RemoteCaCert'] = request.remote_ca_cert
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnAttachmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_attachment(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        """
        By default, an IPsec-VPN connection created by calling the `CreateVpnAttachment` operation is not associated with a resource. You can associate an IPsec-VPN connection with a transit router by calling the [CreateTransitRouterVpnAttachment](~~443993~~) operation.
        ## Prerequisites
        Before you create an IPsec-VPN connection, make sure that you created a customer gateway in the region where you want to create the IPsec-VPN connection. For more information, see [CreateCustomerGateway](/help/en/vpn-gateway/latest/createcustomergateway).
        If you want to add BGP configurations to an IPsec-VPN connection, make sure that an autonomous system number (ASN) is assigned to the customer gateway.
        
        @param request: CreateVpnAttachmentRequest
        @return: CreateVpnAttachmentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_attachment_with_options(request, runtime)

    async def create_vpn_attachment_async(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        """
        By default, an IPsec-VPN connection created by calling the `CreateVpnAttachment` operation is not associated with a resource. You can associate an IPsec-VPN connection with a transit router by calling the [CreateTransitRouterVpnAttachment](~~443993~~) operation.
        ## Prerequisites
        Before you create an IPsec-VPN connection, make sure that you created a customer gateway in the region where you want to create the IPsec-VPN connection. For more information, see [CreateCustomerGateway](/help/en/vpn-gateway/latest/createcustomergateway).
        If you want to add BGP configurations to an IPsec-VPN connection, make sure that an autonomous system number (ASN) is assigned to the customer gateway.
        
        @param request: CreateVpnAttachmentRequest
        @return: CreateVpnAttachmentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_attachment_with_options_async(request, runtime)

    def create_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        """
        **CreateVpnConnection** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being created.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection has been created.
        *   You cannot repeatedly call **CreateVpnConnection** to create an IPsec-VPN connection on a VPN gateway within the specified period of time.
        
        @param request: CreateVpnConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_certificate):
            query['RemoteCaCertificate'] = request.remote_ca_certificate
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        """
        **CreateVpnConnection** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being created.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection has been created.
        *   You cannot repeatedly call **CreateVpnConnection** to create an IPsec-VPN connection on a VPN gateway within the specified period of time.
        
        @param request: CreateVpnConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_certificate):
            query['RemoteCaCertificate'] = request.remote_ca_certificate
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_connection(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        """
        **CreateVpnConnection** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being created.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection has been created.
        *   You cannot repeatedly call **CreateVpnConnection** to create an IPsec-VPN connection on a VPN gateway within the specified period of time.
        
        @param request: CreateVpnConnectionRequest
        @return: CreateVpnConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_connection_with_options(request, runtime)

    async def create_vpn_connection_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        """
        **CreateVpnConnection** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being created.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection has been created.
        *   You cannot repeatedly call **CreateVpnConnection** to create an IPsec-VPN connection on a VPN gateway within the specified period of time.
        
        @param request: CreateVpnConnectionRequest
        @return: CreateVpnConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_connection_with_options_async(request, runtime)

    def create_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        """
        Before you create a VPN gateway, we recommend that you understand its limits. For more information, see [Limits on VPN gateways](~~65290~~).
        *   The **CreateVpnGateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **provisioning** state, the VPN gateway is being created.
        *   If the VPN gateway is in the **active** state, the VPN gateway is created.
        
        @param request: CreateVpnGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipsec):
            query['EnableIpsec'] = request.enable_ipsec
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSsl'] = request.enable_ssl
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_connections):
            query['SslConnections'] = request.ssl_connections
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_type):
            query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        """
        Before you create a VPN gateway, we recommend that you understand its limits. For more information, see [Limits on VPN gateways](~~65290~~).
        *   The **CreateVpnGateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **provisioning** state, the VPN gateway is being created.
        *   If the VPN gateway is in the **active** state, the VPN gateway is created.
        
        @param request: CreateVpnGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipsec):
            query['EnableIpsec'] = request.enable_ipsec
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSsl'] = request.enable_ssl
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_connections):
            query['SslConnections'] = request.ssl_connections
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_type):
            query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_gateway(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        """
        Before you create a VPN gateway, we recommend that you understand its limits. For more information, see [Limits on VPN gateways](~~65290~~).
        *   The **CreateVpnGateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **provisioning** state, the VPN gateway is being created.
        *   If the VPN gateway is in the **active** state, the VPN gateway is created.
        
        @param request: CreateVpnGatewayRequest
        @return: CreateVpnGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_gateway_with_options(request, runtime)

    async def create_vpn_gateway_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        """
        Before you create a VPN gateway, we recommend that you understand its limits. For more information, see [Limits on VPN gateways](~~65290~~).
        *   The **CreateVpnGateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If the VPN gateway is in the **provisioning** state, the VPN gateway is being created.
        *   If the VPN gateway is in the **active** state, the VPN gateway is created.
        
        @param request: CreateVpnGatewayRequest
        @return: CreateVpnGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_gateway_with_options_async(request, runtime)

    def create_vpn_pbr_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        """
        Before you call this operation, we recommend that you learn about the match rules of policy-based routes and limits on policy-based routes. For more information, see [Work with policy-based routes](~~110777~~).
        *   Before you create a policy-based route, make sure that an IPsec-VPN connection is created. For more information, see [CreateVpnConnection](~~120391~~).
        *   **CreateVpnPbrRouteEntry** is an asynchronous operation. After you send the request, the route information is returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the policy-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the policy-based route entry is created.
        *   You cannot repeatedly call **CreateVpnPbrRouteEntry** to create a policy-based route for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnPbrRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnPbrRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_pbr_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        """
        Before you call this operation, we recommend that you learn about the match rules of policy-based routes and limits on policy-based routes. For more information, see [Work with policy-based routes](~~110777~~).
        *   Before you create a policy-based route, make sure that an IPsec-VPN connection is created. For more information, see [CreateVpnConnection](~~120391~~).
        *   **CreateVpnPbrRouteEntry** is an asynchronous operation. After you send the request, the route information is returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the policy-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the policy-based route entry is created.
        *   You cannot repeatedly call **CreateVpnPbrRouteEntry** to create a policy-based route for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnPbrRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnPbrRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_pbr_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        """
        Before you call this operation, we recommend that you learn about the match rules of policy-based routes and limits on policy-based routes. For more information, see [Work with policy-based routes](~~110777~~).
        *   Before you create a policy-based route, make sure that an IPsec-VPN connection is created. For more information, see [CreateVpnConnection](~~120391~~).
        *   **CreateVpnPbrRouteEntry** is an asynchronous operation. After you send the request, the route information is returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the policy-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the policy-based route entry is created.
        *   You cannot repeatedly call **CreateVpnPbrRouteEntry** to create a policy-based route for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnPbrRouteEntryRequest
        @return: CreateVpnPbrRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_pbr_route_entry_with_options(request, runtime)

    async def create_vpn_pbr_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        """
        Before you call this operation, we recommend that you learn about the match rules of policy-based routes and limits on policy-based routes. For more information, see [Work with policy-based routes](~~110777~~).
        *   Before you create a policy-based route, make sure that an IPsec-VPN connection is created. For more information, see [CreateVpnConnection](~~120391~~).
        *   **CreateVpnPbrRouteEntry** is an asynchronous operation. After you send the request, the route information is returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the policy-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the policy-based route entry is created.
        *   You cannot repeatedly call **CreateVpnPbrRouteEntry** to create a policy-based route for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnPbrRouteEntryRequest
        @return: CreateVpnPbrRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_pbr_route_entry_with_options_async(request, runtime)

    def create_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        """
        **CreateVpnRouteEntry** is an asynchronous operation. After you call the operation, the route configurations are returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a destination-based route entry.
        *   If a VPN gateway is in the **updating** state, the destination-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the destination-based route entry has been created.
        *   You cannot repeatedly call **CreateVpnRouteEntry** to create a destination-based route entry for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        """
        **CreateVpnRouteEntry** is an asynchronous operation. After you call the operation, the route configurations are returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a destination-based route entry.
        *   If a VPN gateway is in the **updating** state, the destination-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the destination-based route entry has been created.
        *   You cannot repeatedly call **CreateVpnRouteEntry** to create a destination-based route entry for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpnRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        """
        **CreateVpnRouteEntry** is an asynchronous operation. After you call the operation, the route configurations are returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a destination-based route entry.
        *   If a VPN gateway is in the **updating** state, the destination-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the destination-based route entry has been created.
        *   You cannot repeatedly call **CreateVpnRouteEntry** to create a destination-based route entry for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnRouteEntryRequest
        @return: CreateVpnRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_route_entry_with_options(request, runtime)

    async def create_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        """
        **CreateVpnRouteEntry** is an asynchronous operation. After you call the operation, the route configurations are returned but the operation is still being performed in the background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a destination-based route entry.
        *   If a VPN gateway is in the **updating** state, the destination-based route entry is being created.
        *   If a VPN gateway is in the **active** state, the destination-based route entry has been created.
        *   You cannot repeatedly call **CreateVpnRouteEntry** to create a destination-based route entry for a VPN gateway within the specified period of time.
        
        @param request: CreateVpnRouteEntryRequest
        @return: CreateVpnRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_route_entry_with_options_async(request, runtime)

    def deactivate_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactivate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactivate_router_interface(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.deactivate_router_interface_with_options(request, runtime)

    async def deactivate_router_interface_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deactivate_router_interface_with_options_async(request, runtime)

    def deactive_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        """
        The **DeactiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deactivating** state, the flow log is being disabled.
        *   If the flow log is in the **Inactive** state, the flow log is disabled.
        *   You cannot repeatedly call the **DeactiveFlowLog** operation to disable a flow log within the specified period of time.
        
        @param request: DeactiveFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactiveFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactive_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        """
        The **DeactiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deactivating** state, the flow log is being disabled.
        *   If the flow log is in the **Inactive** state, the flow log is disabled.
        *   You cannot repeatedly call the **DeactiveFlowLog** operation to disable a flow log within the specified period of time.
        
        @param request: DeactiveFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactiveFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactive_flow_log(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        """
        The **DeactiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deactivating** state, the flow log is being disabled.
        *   If the flow log is in the **Inactive** state, the flow log is disabled.
        *   You cannot repeatedly call the **DeactiveFlowLog** operation to disable a flow log within the specified period of time.
        
        @param request: DeactiveFlowLogRequest
        @return: DeactiveFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.deactive_flow_log_with_options(request, runtime)

    async def deactive_flow_log_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        """
        The **DeactiveFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deactivating** state, the flow log is being disabled.
        *   If the flow log is in the **Inactive** state, the flow log is disabled.
        *   You cannot repeatedly call the **DeactiveFlowLog** operation to disable a flow log within the specified period of time.
        
        @param request: DeactiveFlowLogRequest
        @return: DeactiveFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.deactive_flow_log_with_options_async(request, runtime)

    def delete_bgp_group_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_group(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_group_with_options(request, runtime)

    async def delete_bgp_group_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_group_with_options_async(request, runtime)

    def delete_bgp_network_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_network(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_network_with_options(request, runtime)

    async def delete_bgp_network_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_network_with_options_async(request, runtime)

    def delete_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_peer(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_peer_with_options(request, runtime)

    async def delete_bgp_peer_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_peer_with_options_async(request, runtime)

    def delete_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        """
        You cannot repeatedly call the *DeleteCommonBandwidthPackage** operation to delete an EIP bandwidth plan within the specified period of time.
        
        @param request: DeleteCommonBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCommonBandwidthPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        """
        You cannot repeatedly call the *DeleteCommonBandwidthPackage** operation to delete an EIP bandwidth plan within the specified period of time.
        
        @param request: DeleteCommonBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCommonBandwidthPackageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_common_bandwidth_package(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        """
        You cannot repeatedly call the *DeleteCommonBandwidthPackage** operation to delete an EIP bandwidth plan within the specified period of time.
        
        @param request: DeleteCommonBandwidthPackageRequest
        @return: DeleteCommonBandwidthPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_common_bandwidth_package_with_options(request, runtime)

    async def delete_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        """
        You cannot repeatedly call the *DeleteCommonBandwidthPackage** operation to delete an EIP bandwidth plan within the specified period of time.
        
        @param request: DeleteCommonBandwidthPackageRequest
        @return: DeleteCommonBandwidthPackageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_common_bandwidth_package_with_options_async(request, runtime)

    def delete_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customer_gateway(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_customer_gateway_with_options(request, runtime)

    async def delete_customer_gateway_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_customer_gateway_with_options_async(request, runtime)

    def delete_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        """
        The **DeleteDhcpOptionsSet** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Deleting** state, the DHCP options set is being deleted.
        *   If you cannot query the DHCP options set, the DHCP options set is deleted.
        *   You cannot repeatedly call the **DeleteDhcpOptionsSet** operation to delete a DHCP options set within the specified period of time.
        
        @param request: DeleteDhcpOptionsSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDhcpOptionsSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        """
        The **DeleteDhcpOptionsSet** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Deleting** state, the DHCP options set is being deleted.
        *   If you cannot query the DHCP options set, the DHCP options set is deleted.
        *   You cannot repeatedly call the **DeleteDhcpOptionsSet** operation to delete a DHCP options set within the specified period of time.
        
        @param request: DeleteDhcpOptionsSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDhcpOptionsSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dhcp_options_set(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        """
        The **DeleteDhcpOptionsSet** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Deleting** state, the DHCP options set is being deleted.
        *   If you cannot query the DHCP options set, the DHCP options set is deleted.
        *   You cannot repeatedly call the **DeleteDhcpOptionsSet** operation to delete a DHCP options set within the specified period of time.
        
        @param request: DeleteDhcpOptionsSetRequest
        @return: DeleteDhcpOptionsSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dhcp_options_set_with_options(request, runtime)

    async def delete_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        """
        The **DeleteDhcpOptionsSet** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [GetDhcpOptionsSet](~~189208~~) operation to query the status of a DHCP options set:
        *   If the DHCP options set is in the **Deleting** state, the DHCP options set is being deleted.
        *   If you cannot query the DHCP options set, the DHCP options set is deleted.
        *   You cannot repeatedly call the **DeleteDhcpOptionsSet** operation to delete a DHCP options set within the specified period of time.
        
        @param request: DeleteDhcpOptionsSetRequest
        @return: DeleteDhcpOptionsSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dhcp_options_set_with_options_async(request, runtime)

    def delete_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        """
        The **DeleteFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deleting** state, the flow log is being deleted.
        *   If you cannot query the flow log, the flow log is deleted.
        *   You cannot repeatedly call the **DeleteFlowLog** operation to delete a flow log within the specified period of time.
        
        @param request: DeleteFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        """
        The **DeleteFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deleting** state, the flow log is being deleted.
        *   If you cannot query the flow log, the flow log is deleted.
        *   You cannot repeatedly call the **DeleteFlowLog** operation to delete a flow log within the specified period of time.
        
        @param request: DeleteFlowLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_log(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        """
        The **DeleteFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deleting** state, the flow log is being deleted.
        *   If you cannot query the flow log, the flow log is deleted.
        *   You cannot repeatedly call the **DeleteFlowLog** operation to delete a flow log within the specified period of time.
        
        @param request: DeleteFlowLogRequest
        @return: DeleteFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_flow_log_with_options(request, runtime)

    async def delete_flow_log_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        """
        The **DeleteFlowLog** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeFlowLogs](~~87923~~) operation to query the status of a flow log:
        *   If the flow log is in the **Deleting** state, the flow log is being deleted.
        *   If you cannot query the flow log, the flow log is deleted.
        *   You cannot repeatedly call the **DeleteFlowLog** operation to delete a flow log within the specified period of time.
        
        @param request: DeleteFlowLogRequest
        @return: DeleteFlowLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_flow_log_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        """
        **DeleteForwardEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified DNAT entry is not deleted. The system deletes the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Deleting** state, the system is deleting the DNAT entry. In this case, you can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry cannot be found, it is deleted.
        >  If a DNAT table has DNAT entries in the **Pending** state, you cannot delete the DNAT entries.
        *   You cannot repeatedly call the **DeleteForwardEntry** operation to delete a DNAT entry within the specified period of time.
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        """
        **DeleteForwardEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified DNAT entry is not deleted. The system deletes the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Deleting** state, the system is deleting the DNAT entry. In this case, you can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry cannot be found, it is deleted.
        >  If a DNAT table has DNAT entries in the **Pending** state, you cannot delete the DNAT entries.
        *   You cannot repeatedly call the **DeleteForwardEntry** operation to delete a DNAT entry within the specified period of time.
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        """
        **DeleteForwardEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified DNAT entry is not deleted. The system deletes the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Deleting** state, the system is deleting the DNAT entry. In this case, you can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry cannot be found, it is deleted.
        >  If a DNAT table has DNAT entries in the **Pending** state, you cannot delete the DNAT entries.
        *   You cannot repeatedly call the **DeleteForwardEntry** operation to delete a DNAT entry within the specified period of time.
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        """
        **DeleteForwardEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified DNAT entry is not deleted. The system deletes the entry in the background. You can call the [DescribeForwardTableEntries](~~36053~~) operation to query the status of a DNAT entry.
        *   If the DNAT entry is in the **Deleting** state, the system is deleting the DNAT entry. In this case, you can only query the status of the DNAT entry, but cannot perform other operations.
        *   If the DNAT entry cannot be found, it is deleted.
        >  If a DNAT table has DNAT entries in the **Pending** state, you cannot delete the DNAT entries.
        *   You cannot repeatedly call the **DeleteForwardEntry** operation to delete a DNAT entry within the specified period of time.
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        """
        *DeleteFullNatEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the FULLNAT entry is not deleted. The system deletes the FULLNAT entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Deleting** state, the system is deleting the FULLNAT entry. In this case, you can query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry cannot be found, the FULLNAT entry is deleted.
        You cannot repeatedly call the **DeleteFullNatEntry** operation to delete a FULLNAT entry within the specified period of time.
        
        @param request: DeleteFullNatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFullNatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_id):
            query['FullNatEntryId'] = request.full_nat_entry_id
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        """
        *DeleteFullNatEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the FULLNAT entry is not deleted. The system deletes the FULLNAT entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Deleting** state, the system is deleting the FULLNAT entry. In this case, you can query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry cannot be found, the FULLNAT entry is deleted.
        You cannot repeatedly call the **DeleteFullNatEntry** operation to delete a FULLNAT entry within the specified period of time.
        
        @param request: DeleteFullNatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFullNatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_id):
            query['FullNatEntryId'] = request.full_nat_entry_id
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_full_nat_entry(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        """
        *DeleteFullNatEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the FULLNAT entry is not deleted. The system deletes the FULLNAT entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Deleting** state, the system is deleting the FULLNAT entry. In this case, you can query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry cannot be found, the FULLNAT entry is deleted.
        You cannot repeatedly call the **DeleteFullNatEntry** operation to delete a FULLNAT entry within the specified period of time.
        
        @param request: DeleteFullNatEntryRequest
        @return: DeleteFullNatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_full_nat_entry_with_options(request, runtime)

    async def delete_full_nat_entry_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        """
        *DeleteFullNatEntry** is an asynchronous operation. After you make a request, the ID of the request is returned but the FULLNAT entry is not deleted. The system deletes the FULLNAT entry in the background. You can call the [ListFullNatEntries](~~348779~~) operation to query the status of a FULLNAT entry.
        *   If the FULLNAT entry is in the **Deleting** state, the system is deleting the FULLNAT entry. In this case, you can query the status of the FULLNAT entry, but cannot perform other operations.
        *   If the FULLNAT entry cannot be found, the FULLNAT entry is deleted.
        You cannot repeatedly call the **DeleteFullNatEntry** operation to delete a FULLNAT entry within the specified period of time.
        
        @param request: DeleteFullNatEntryRequest
        @return: DeleteFullNatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_full_nat_entry_with_options_async(request, runtime)

    def delete_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_acceleration_instance(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_global_acceleration_instance_with_options(request, runtime)

    async def delete_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_acceleration_instance_with_options_async(request, runtime)

    def delete_ha_vip_with_options(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only HAVIPs that are in the Available state.
        *   Make sure that no route points to the HAVIP that you want to delete.
        *   Make sure that no elastic IP address (EIP) is associated with the HAVIP that you want to delete.
        *   The **DeleteHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Deleting** state, the HAVIP is being deleted.
        *   If you cannot query the HAVIP, the HAVIP is deleted.
        *   You cannot repeatedly call the **DeleteHaVip** operation to delete an HAVIP within the specified period of time.
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only HAVIPs that are in the Available state.
        *   Make sure that no route points to the HAVIP that you want to delete.
        *   Make sure that no elastic IP address (EIP) is associated with the HAVIP that you want to delete.
        *   The **DeleteHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Deleting** state, the HAVIP is being deleted.
        *   If you cannot query the HAVIP, the HAVIP is deleted.
        *   You cannot repeatedly call the **DeleteHaVip** operation to delete an HAVIP within the specified period of time.
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vip(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only HAVIPs that are in the Available state.
        *   Make sure that no route points to the HAVIP that you want to delete.
        *   Make sure that no elastic IP address (EIP) is associated with the HAVIP that you want to delete.
        *   The **DeleteHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Deleting** state, the HAVIP is being deleted.
        *   If you cannot query the HAVIP, the HAVIP is deleted.
        *   You cannot repeatedly call the **DeleteHaVip** operation to delete an HAVIP within the specified period of time.
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vip_with_options(request, runtime)

    async def delete_ha_vip_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only HAVIPs that are in the Available state.
        *   Make sure that no route points to the HAVIP that you want to delete.
        *   Make sure that no elastic IP address (EIP) is associated with the HAVIP that you want to delete.
        *   The **DeleteHaVip** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeHaVips](~~114611~~) operation to query the status of an HAVIP:
        *   If the HAVIP is in the **Deleting** state, the HAVIP is being deleted.
        *   If you cannot query the HAVIP, the HAVIP is deleted.
        *   You cannot repeatedly call the **DeleteHaVip** operation to delete an HAVIP within the specified period of time.
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vip_with_options_async(request, runtime)

    def delete_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_with_options(request, runtime)

    async def delete_ipv_6translator_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_with_options_async(request, runtime)

    def delete_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_acl_list_with_options(request, runtime)

    async def delete_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_acl_list_with_options_async(request, runtime)

    def delete_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_entry_with_options(request, runtime)

    async def delete_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_entry_with_options_async(request, runtime)

    def delete_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        """
        The **DeleteIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the IPsec server is being deleted.
        *   If a VPN gateway is in the **active** state, the IPsec server has been deleted.
        *   You cannot repeatedly call **DeleteIpsecServer** to delete an IPsec server from a VPN gateway within the specified period of time.
        
        @param request: DeleteIpsecServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpsecServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipsec_server_id):
            query['IpsecServerId'] = request.ipsec_server_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        """
        The **DeleteIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the IPsec server is being deleted.
        *   If a VPN gateway is in the **active** state, the IPsec server has been deleted.
        *   You cannot repeatedly call **DeleteIpsecServer** to delete an IPsec server from a VPN gateway within the specified period of time.
        
        @param request: DeleteIpsecServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpsecServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipsec_server_id):
            query['IpsecServerId'] = request.ipsec_server_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipsec_server(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        """
        The **DeleteIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the IPsec server is being deleted.
        *   If a VPN gateway is in the **active** state, the IPsec server has been deleted.
        *   You cannot repeatedly call **DeleteIpsecServer** to delete an IPsec server from a VPN gateway within the specified period of time.
        
        @param request: DeleteIpsecServerRequest
        @return: DeleteIpsecServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ipsec_server_with_options(request, runtime)

    async def delete_ipsec_server_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        """
        The **DeleteIpsecServer** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway.
        *   If a VPN gateway is in the **updating** state, the IPsec server is being deleted.
        *   If a VPN gateway is in the **active** state, the IPsec server has been deleted.
        *   You cannot repeatedly call **DeleteIpsecServer** to delete an IPsec server from a VPN gateway within the specified period of time.
        
        @param request: DeleteIpsecServerRequest
        @return: DeleteIpsecServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipsec_server_with_options_async(request, runtime)

    def delete_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        """
        Before you delete an IPv4 gateway, make sure that no route tables are associated with the IPv4 gateway.
        *   The **DeleteIpv4Gateway** operation is an asynchronous operation. After you call this operation, the system returns a **request ID**. However, the deletion task is still being run in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of the IPv4 gateway.
        *   If the IPv4 gateway is in the **Deleting** state, the IPv4 gateway is being deleted.
        *   If the IPv4 gateway cannot be queried, the deletion is complete.
        *   After you call the **DeleteIpv4Gateway** operation to delete an IPv4 gateway, you cannot call the operation again to delete the IPv4 gateway until the deletion task is complete.
        
        @param request: DeleteIpv4GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv4GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        """
        Before you delete an IPv4 gateway, make sure that no route tables are associated with the IPv4 gateway.
        *   The **DeleteIpv4Gateway** operation is an asynchronous operation. After you call this operation, the system returns a **request ID**. However, the deletion task is still being run in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of the IPv4 gateway.
        *   If the IPv4 gateway is in the **Deleting** state, the IPv4 gateway is being deleted.
        *   If the IPv4 gateway cannot be queried, the deletion is complete.
        *   After you call the **DeleteIpv4Gateway** operation to delete an IPv4 gateway, you cannot call the operation again to delete the IPv4 gateway until the deletion task is complete.
        
        @param request: DeleteIpv4GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv4GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_4gateway(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        """
        Before you delete an IPv4 gateway, make sure that no route tables are associated with the IPv4 gateway.
        *   The **DeleteIpv4Gateway** operation is an asynchronous operation. After you call this operation, the system returns a **request ID**. However, the deletion task is still being run in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of the IPv4 gateway.
        *   If the IPv4 gateway is in the **Deleting** state, the IPv4 gateway is being deleted.
        *   If the IPv4 gateway cannot be queried, the deletion is complete.
        *   After you call the **DeleteIpv4Gateway** operation to delete an IPv4 gateway, you cannot call the operation again to delete the IPv4 gateway until the deletion task is complete.
        
        @param request: DeleteIpv4GatewayRequest
        @return: DeleteIpv4GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_4gateway_with_options(request, runtime)

    async def delete_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        """
        Before you delete an IPv4 gateway, make sure that no route tables are associated with the IPv4 gateway.
        *   The **DeleteIpv4Gateway** operation is an asynchronous operation. After you call this operation, the system returns a **request ID**. However, the deletion task is still being run in the background. You can call the [GetIpv4GatewayAttribute](~~407670~~) operation to query the status of the IPv4 gateway.
        *   If the IPv4 gateway is in the **Deleting** state, the IPv4 gateway is being deleted.
        *   If the IPv4 gateway cannot be queried, the deletion is complete.
        *   After you call the **DeleteIpv4Gateway** operation to delete an IPv4 gateway, you cannot call the operation again to delete the IPv4 gateway until the deletion task is complete.
        
        @param request: DeleteIpv4GatewayRequest
        @return: DeleteIpv4GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_4gateway_with_options_async(request, runtime)

    def delete_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        """
        **DeleteIpv6EgressOnlyRule** is an asynchronous operation. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query whether the egress-only rule is deleted.
        *   If the egress-only rule is in the **Deleting** state, it indicates that the egress-only rule is being deleted.
        *   If you cannot query the egress-only rule, it indicates that the egress-only rule is deleted.
        *   You cannot call the **DeleteIpv6EgressOnlyRule** operation to delete an egress-only rule again when the rule is being deleted.
        
        @param request: DeleteIpv6EgressOnlyRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6EgressOnlyRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        """
        **DeleteIpv6EgressOnlyRule** is an asynchronous operation. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query whether the egress-only rule is deleted.
        *   If the egress-only rule is in the **Deleting** state, it indicates that the egress-only rule is being deleted.
        *   If you cannot query the egress-only rule, it indicates that the egress-only rule is deleted.
        *   You cannot call the **DeleteIpv6EgressOnlyRule** operation to delete an egress-only rule again when the rule is being deleted.
        
        @param request: DeleteIpv6EgressOnlyRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6EgressOnlyRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        """
        **DeleteIpv6EgressOnlyRule** is an asynchronous operation. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query whether the egress-only rule is deleted.
        *   If the egress-only rule is in the **Deleting** state, it indicates that the egress-only rule is being deleted.
        *   If you cannot query the egress-only rule, it indicates that the egress-only rule is deleted.
        *   You cannot call the **DeleteIpv6EgressOnlyRule** operation to delete an egress-only rule again when the rule is being deleted.
        
        @param request: DeleteIpv6EgressOnlyRuleRequest
        @return: DeleteIpv6EgressOnlyRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6egress_only_rule_with_options(request, runtime)

    async def delete_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        """
        **DeleteIpv6EgressOnlyRule** is an asynchronous operation. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6EgressOnlyRules](~~102208~~) operation to query whether the egress-only rule is deleted.
        *   If the egress-only rule is in the **Deleting** state, it indicates that the egress-only rule is being deleted.
        *   If you cannot query the egress-only rule, it indicates that the egress-only rule is deleted.
        *   You cannot call the **DeleteIpv6EgressOnlyRule** operation to delete an egress-only rule again when the rule is being deleted.
        
        @param request: DeleteIpv6EgressOnlyRuleRequest
        @return: DeleteIpv6EgressOnlyRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6egress_only_rule_with_options_async(request, runtime)

    def delete_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        """
        - The *DeleteIpv6Gateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6GatewayAttribute](/help/en/virtual-private-cloud/latest/describeipv6gatewayattribute) operation to query the status of an IPv6 gateway:   - If the IPv6 gateway is in the **Deleting** state, the IPv6 gateway is being deleted.
        - If you cannot query the IPv6 gateway, the IPv6 gateway is deleted.
        - After you call the **DeleteIpv6Gateway** operation to delete an IPv6 gateway, you cannot call the operation again to delete the IPv6 gateway until the deletion task is complete.
        ## Prerequisites
        Before you delete an IPv6 gateway, you must delete the egress-only rules of the IPv6 gateway. For more information, see [DeleteIpv6EgressOnlyRule](~~102201~~).
        
        @param request: DeleteIpv6GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        """
        - The *DeleteIpv6Gateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6GatewayAttribute](/help/en/virtual-private-cloud/latest/describeipv6gatewayattribute) operation to query the status of an IPv6 gateway:   - If the IPv6 gateway is in the **Deleting** state, the IPv6 gateway is being deleted.
        - If you cannot query the IPv6 gateway, the IPv6 gateway is deleted.
        - After you call the **DeleteIpv6Gateway** operation to delete an IPv6 gateway, you cannot call the operation again to delete the IPv6 gateway until the deletion task is complete.
        ## Prerequisites
        Before you delete an IPv6 gateway, you must delete the egress-only rules of the IPv6 gateway. For more information, see [DeleteIpv6EgressOnlyRule](~~102201~~).
        
        @param request: DeleteIpv6GatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6GatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6gateway(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        """
        - The *DeleteIpv6Gateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6GatewayAttribute](/help/en/virtual-private-cloud/latest/describeipv6gatewayattribute) operation to query the status of an IPv6 gateway:   - If the IPv6 gateway is in the **Deleting** state, the IPv6 gateway is being deleted.
        - If you cannot query the IPv6 gateway, the IPv6 gateway is deleted.
        - After you call the **DeleteIpv6Gateway** operation to delete an IPv6 gateway, you cannot call the operation again to delete the IPv6 gateway until the deletion task is complete.
        ## Prerequisites
        Before you delete an IPv6 gateway, you must delete the egress-only rules of the IPv6 gateway. For more information, see [DeleteIpv6EgressOnlyRule](~~102201~~).
        
        @param request: DeleteIpv6GatewayRequest
        @return: DeleteIpv6GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6gateway_with_options(request, runtime)

    async def delete_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        """
        - The *DeleteIpv6Gateway** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeIpv6GatewayAttribute](/help/en/virtual-private-cloud/latest/describeipv6gatewayattribute) operation to query the status of an IPv6 gateway:   - If the IPv6 gateway is in the **Deleting** state, the IPv6 gateway is being deleted.
        - If you cannot query the IPv6 gateway, the IPv6 gateway is deleted.
        - After you call the **DeleteIpv6Gateway** operation to delete an IPv6 gateway, you cannot call the operation again to delete the IPv6 gateway until the deletion task is complete.
        ## Prerequisites
        Before you delete an IPv6 gateway, you must delete the egress-only rules of the IPv6 gateway. For more information, see [DeleteIpv6EgressOnlyRule](~~102201~~).
        
        @param request: DeleteIpv6GatewayRequest
        @return: DeleteIpv6GatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6gateway_with_options_async(request, runtime)

    def delete_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        """
        You cannot call the *DeleteIpv6InternetBandwidth** operation to delete the same Internet bandwidth at the same time.
        
        @param request: DeleteIpv6InternetBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6InternetBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        """
        You cannot call the *DeleteIpv6InternetBandwidth** operation to delete the same Internet bandwidth at the same time.
        
        @param request: DeleteIpv6InternetBandwidthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpv6InternetBandwidthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        """
        You cannot call the *DeleteIpv6InternetBandwidth** operation to delete the same Internet bandwidth at the same time.
        
        @param request: DeleteIpv6InternetBandwidthRequest
        @return: DeleteIpv6InternetBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6internet_bandwidth_with_options(request, runtime)

    async def delete_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        """
        You cannot call the *DeleteIpv6InternetBandwidth** operation to delete the same Internet bandwidth at the same time.
        
        @param request: DeleteIpv6InternetBandwidthRequest
        @return: DeleteIpv6InternetBandwidthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        """
        **DeleteNatGateway** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT gateway is not deleted. The system deletes the NAT gateway in the background. You can call the [DescribeNatGateways](~~36054~~) to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Deleting** state, the NAT gateway is being deleted. In this case, you can query the NAT gateway but you cannot perform other operations.
        *   If the NAY gateway cannot be found, the NAT gateway is deleted.
        After you delete a NAT gateway, you cannot restore the NAT gateway. Proceed with caution.
        *   You cannot repeatedly call the **DeleteNatGateway** operation to delete a NAT gateway within the specified period of time.
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        """
        **DeleteNatGateway** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT gateway is not deleted. The system deletes the NAT gateway in the background. You can call the [DescribeNatGateways](~~36054~~) to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Deleting** state, the NAT gateway is being deleted. In this case, you can query the NAT gateway but you cannot perform other operations.
        *   If the NAY gateway cannot be found, the NAT gateway is deleted.
        After you delete a NAT gateway, you cannot restore the NAT gateway. Proceed with caution.
        *   You cannot repeatedly call the **DeleteNatGateway** operation to delete a NAT gateway within the specified period of time.
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        """
        **DeleteNatGateway** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT gateway is not deleted. The system deletes the NAT gateway in the background. You can call the [DescribeNatGateways](~~36054~~) to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Deleting** state, the NAT gateway is being deleted. In this case, you can query the NAT gateway but you cannot perform other operations.
        *   If the NAY gateway cannot be found, the NAT gateway is deleted.
        After you delete a NAT gateway, you cannot restore the NAT gateway. Proceed with caution.
        *   You cannot repeatedly call the **DeleteNatGateway** operation to delete a NAT gateway within the specified period of time.
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        """
        **DeleteNatGateway** is an asynchronous operation. After you make a request, the ID of the request is returned but the NAT gateway is not deleted. The system deletes the NAT gateway in the background. You can call the [DescribeNatGateways](~~36054~~) to query the status of a NAT gateway.
        *   If a NAT gateway is in the **Deleting** state, the NAT gateway is being deleted. In this case, you can query the NAT gateway but you cannot perform other operations.
        *   If the NAY gateway cannot be found, the NAT gateway is deleted.
        After you delete a NAT gateway, you cannot restore the NAT gateway. Proceed with caution.
        *   You cannot repeatedly call the **DeleteNatGateway** operation to delete a NAT gateway within the specified period of time.
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_nat_ip_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        """
        **DeleteNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified NAT IP address is not deleted. The system deletes the NAT IP address in the background. You can call the [ListNatIps](~~281979~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Deleting** state, the NAT IP address is being deleted. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If the NAT IP address cannot be found, it is deleted.
        *   You cannot repeatedly call the **DeleteNatIp** operation to delete a NAT IP address within the specified period of time.
        
        @param request: DeleteNatIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_ip_id):
            query['NatIpId'] = request.nat_ip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        """
        **DeleteNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified NAT IP address is not deleted. The system deletes the NAT IP address in the background. You can call the [ListNatIps](~~281979~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Deleting** state, the NAT IP address is being deleted. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If the NAT IP address cannot be found, it is deleted.
        *   You cannot repeatedly call the **DeleteNatIp** operation to delete a NAT IP address within the specified period of time.
        
        @param request: DeleteNatIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_ip_id):
            query['NatIpId'] = request.nat_ip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        """
        **DeleteNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified NAT IP address is not deleted. The system deletes the NAT IP address in the background. You can call the [ListNatIps](~~281979~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Deleting** state, the NAT IP address is being deleted. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If the NAT IP address cannot be found, it is deleted.
        *   You cannot repeatedly call the **DeleteNatIp** operation to delete a NAT IP address within the specified period of time.
        
        @param request: DeleteNatIpRequest
        @return: DeleteNatIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_with_options(request, runtime)

    async def delete_nat_ip_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        """
        **DeleteNatIp** is an asynchronous operation. After you make a request, the ID of the request is returned but the specified NAT IP address is not deleted. The system deletes the NAT IP address in the background. You can call the [ListNatIps](~~281979~~) operation to query the status of a NAT IP address.
        *   If a NAT IP address is in the **Deleting** state, the NAT IP address is being deleted. In this case, you can only query the NAT IP address but cannot perform other operations.
        *   If the NAT IP address cannot be found, it is deleted.
        *   You cannot repeatedly call the **DeleteNatIp** operation to delete a NAT IP address within the specified period of time.
        
        @param request: DeleteNatIpRequest
        @return: DeleteNatIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_with_options_async(request, runtime)

    def delete_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        """
        You cannot repeatedly call the *DeleteNatIpCidr** operation to delete a NAT CIDR block within the specified period of time.
        
        @param request: DeleteNatIpCidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatIpCidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        """
        You cannot repeatedly call the *DeleteNatIpCidr** operation to delete a NAT CIDR block within the specified period of time.
        
        @param request: DeleteNatIpCidrRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatIpCidrResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip_cidr(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        """
        You cannot repeatedly call the *DeleteNatIpCidr** operation to delete a NAT CIDR block within the specified period of time.
        
        @param request: DeleteNatIpCidrRequest
        @return: DeleteNatIpCidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_cidr_with_options(request, runtime)

    async def delete_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        """
        You cannot repeatedly call the *DeleteNatIpCidr** operation to delete a NAT CIDR block within the specified period of time.
        
        @param request: DeleteNatIpCidrRequest
        @return: DeleteNatIpCidrResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_cidr_with_options_async(request, runtime)

    def delete_network_acl_with_options(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        """
        You cannot repeatedly call the *DeleteNetworkAcl** operation to delete a network ACL within the specified period of time.
        
        @param request: DeleteNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        """
        You cannot repeatedly call the *DeleteNetworkAcl** operation to delete a network ACL within the specified period of time.
        
        @param request: DeleteNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_acl(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        """
        You cannot repeatedly call the *DeleteNetworkAcl** operation to delete a network ACL within the specified period of time.
        
        @param request: DeleteNetworkAclRequest
        @return: DeleteNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_acl_with_options(request, runtime)

    async def delete_network_acl_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        """
        You cannot repeatedly call the *DeleteNetworkAcl** operation to delete a network ACL within the specified period of time.
        
        @param request: DeleteNetworkAclRequest
        @return: DeleteNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_acl_with_options_async(request, runtime)

    def delete_physical_connection_with_options(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        """
        ## Limit
        You can only delete a connection over an Express Connect circuit that is in the **Rejected**, **Canceled**, **AllocationFailed**, or **Terminated** state.
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        """
        ## Limit
        You can only delete a connection over an Express Connect circuit that is in the **Rejected**, **Canceled**, **AllocationFailed**, or **Terminated** state.
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_physical_connection(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        """
        ## Limit
        You can only delete a connection over an Express Connect circuit that is in the **Rejected**, **Canceled**, **AllocationFailed**, or **Terminated** state.
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_physical_connection_with_options(request, runtime)

    async def delete_physical_connection_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        """
        ## Limit
        You can only delete a connection over an Express Connect circuit that is in the **Rejected**, **Canceled**, **AllocationFailed**, or **Terminated** state.
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_physical_connection_with_options_async(request, runtime)

    def delete_public_ip_address_pool_with_options(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        """
        The **DeletePublicIpAddressPool** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPools](~~429433~~) operation to query the status of an IP address pool:
        *   If the IP address pool is in the **Deleting** state, the IP address pool is being deleted. In this state. you can only query the IP address pool and cannot perform other operations.
        *   If you cannot query the IP address pool, the IP address pool is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPool** operation to delete an IP address pool within the specified period of time.
        ## Prerequisites
        Before you delete an IP address pool, make sure that no IP address in the pool is being used.
        
        @param request: DeletePublicIpAddressPoolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePublicIpAddressPoolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_public_ip_address_pool_with_options_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        """
        The **DeletePublicIpAddressPool** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPools](~~429433~~) operation to query the status of an IP address pool:
        *   If the IP address pool is in the **Deleting** state, the IP address pool is being deleted. In this state. you can only query the IP address pool and cannot perform other operations.
        *   If you cannot query the IP address pool, the IP address pool is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPool** operation to delete an IP address pool within the specified period of time.
        ## Prerequisites
        Before you delete an IP address pool, make sure that no IP address in the pool is being used.
        
        @param request: DeletePublicIpAddressPoolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePublicIpAddressPoolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_public_ip_address_pool(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        """
        The **DeletePublicIpAddressPool** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPools](~~429433~~) operation to query the status of an IP address pool:
        *   If the IP address pool is in the **Deleting** state, the IP address pool is being deleted. In this state. you can only query the IP address pool and cannot perform other operations.
        *   If you cannot query the IP address pool, the IP address pool is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPool** operation to delete an IP address pool within the specified period of time.
        ## Prerequisites
        Before you delete an IP address pool, make sure that no IP address in the pool is being used.
        
        @param request: DeletePublicIpAddressPoolRequest
        @return: DeletePublicIpAddressPoolResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_public_ip_address_pool_with_options(request, runtime)

    async def delete_public_ip_address_pool_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        """
        The **DeletePublicIpAddressPool** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPools](~~429433~~) operation to query the status of an IP address pool:
        *   If the IP address pool is in the **Deleting** state, the IP address pool is being deleted. In this state. you can only query the IP address pool and cannot perform other operations.
        *   If you cannot query the IP address pool, the IP address pool is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPool** operation to delete an IP address pool within the specified period of time.
        ## Prerequisites
        Before you delete an IP address pool, make sure that no IP address in the pool is being used.
        
        @param request: DeletePublicIpAddressPoolRequest
        @return: DeletePublicIpAddressPoolResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_public_ip_address_pool_with_options_async(request, runtime)

    def delete_public_ip_address_pool_cidr_block_with_options(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        """
        The **DeletePublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Deleting** state, the CIDR block is being deleted. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If you cannot query the CIDR block, the CIDR block is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPoolCidrBlock** operation to delete a CIDR block within the specified period of time.
        ## Prerequisites
        Before you delete a CIDR block, make sure that it is not being used.
        
        @param request: DeletePublicIpAddressPoolCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePublicIpAddressPoolCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_public_ip_address_pool_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        """
        The **DeletePublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Deleting** state, the CIDR block is being deleted. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If you cannot query the CIDR block, the CIDR block is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPoolCidrBlock** operation to delete a CIDR block within the specified period of time.
        ## Prerequisites
        Before you delete a CIDR block, make sure that it is not being used.
        
        @param request: DeletePublicIpAddressPoolCidrBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePublicIpAddressPoolCidrBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_public_ip_address_pool_cidr_block(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        """
        The **DeletePublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Deleting** state, the CIDR block is being deleted. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If you cannot query the CIDR block, the CIDR block is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPoolCidrBlock** operation to delete a CIDR block within the specified period of time.
        ## Prerequisites
        Before you delete a CIDR block, make sure that it is not being used.
        
        @param request: DeletePublicIpAddressPoolCidrBlockRequest
        @return: DeletePublicIpAddressPoolCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_public_ip_address_pool_cidr_block_with_options(request, runtime)

    async def delete_public_ip_address_pool_cidr_block_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        """
        The **DeletePublicIpAddressPoolCidrBlock** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListPublicIpAddressPoolCidrBlocks](~~429436~~) operation to query the status of a CIDR block in an IP address pool:
        *   If the CIDR block is in the **Deleting** state, the CIDR block is being deleted. In this state, you can only query the CIDR block and cannot perform other operations.
        *   If you cannot query the CIDR block, the CIDR block is deleted.
        *   You cannot repeatedly call the **DeletePublicIpAddressPoolCidrBlock** operation to delete a CIDR block within the specified period of time.
        ## Prerequisites
        Before you delete a CIDR block, make sure that it is not being used.
        
        @param request: DeletePublicIpAddressPoolCidrBlockRequest
        @return: DeletePublicIpAddressPoolCidrBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_public_ip_address_pool_cidr_block_with_options_async(request, runtime)

    def delete_route_entries_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntriesResponse:
        """
        When you call this operation, take note of the following items:
        *   You can delete only route entries that are in the **Available** state.
        *   You cannot delete a route entry of a virtual private cloud (VPC) in which a vSwitch or another route entry is being created or deleted.
        *   **DeleteRouteEntries** is an asynchronous operation. After you call this operation, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Deleting** state, the route entry is being deleted.
        *   If you cannot query the route entry, the route entry is deleted.
        *   You cannot repeatedly call **DeleteRouteEntries** within a specific period of time.
        
        @param request: DeleteRouteEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entries):
            query['RouteEntries'] = request.route_entries
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntriesResponse:
        """
        When you call this operation, take note of the following items:
        *   You can delete only route entries that are in the **Available** state.
        *   You cannot delete a route entry of a virtual private cloud (VPC) in which a vSwitch or another route entry is being created or deleted.
        *   **DeleteRouteEntries** is an asynchronous operation. After you call this operation, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Deleting** state, the route entry is being deleted.
        *   If you cannot query the route entry, the route entry is deleted.
        *   You cannot repeatedly call **DeleteRouteEntries** within a specific period of time.
        
        @param request: DeleteRouteEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entries):
            query['RouteEntries'] = request.route_entries
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entries(
        self,
        request: vpc_20160428_models.DeleteRouteEntriesRequest,
    ) -> vpc_20160428_models.DeleteRouteEntriesResponse:
        """
        When you call this operation, take note of the following items:
        *   You can delete only route entries that are in the **Available** state.
        *   You cannot delete a route entry of a virtual private cloud (VPC) in which a vSwitch or another route entry is being created or deleted.
        *   **DeleteRouteEntries** is an asynchronous operation. After you call this operation, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Deleting** state, the route entry is being deleted.
        *   If you cannot query the route entry, the route entry is deleted.
        *   You cannot repeatedly call **DeleteRouteEntries** within a specific period of time.
        
        @param request: DeleteRouteEntriesRequest
        @return: DeleteRouteEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entries_with_options(request, runtime)

    async def delete_route_entries_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntriesRequest,
    ) -> vpc_20160428_models.DeleteRouteEntriesResponse:
        """
        When you call this operation, take note of the following items:
        *   You can delete only route entries that are in the **Available** state.
        *   You cannot delete a route entry of a virtual private cloud (VPC) in which a vSwitch or another route entry is being created or deleted.
        *   **DeleteRouteEntries** is an asynchronous operation. After you call this operation, the system returns a request ID and runs the task in the background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route entry.
        *   If the route entry is in the **Deleting** state, the route entry is being deleted.
        *   If you cannot query the route entry, the route entry is deleted.
        *   You cannot repeatedly call **DeleteRouteEntries** within a specific period of time.
        
        @param request: DeleteRouteEntriesRequest
        @return: DeleteRouteEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entries_with_options_async(request, runtime)

    def delete_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only routes that are in the **Available** state.
        *   You cannot delete a route of a virtual private cloud (VPC) in which a vSwitch or a route is being created.
        *   Before you call this operation to delete a route of a VBR route table, call the [DescribeRouteEntryList](~~138148~~) operation to query the **NextHopId** of the route first.
        *   The **DeleteRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route:
        *   If the route is in the **Deleting** state, the route is being deleted.
        *   If you cannot query the route, the route is deleted.
        *   You cannot repeatedly call the **DeleteRouteEntry** operation to delete a route from the route table of a vRouter or a VBR within the specified period of time.
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only routes that are in the **Available** state.
        *   You cannot delete a route of a virtual private cloud (VPC) in which a vSwitch or a route is being created.
        *   Before you call this operation to delete a route of a VBR route table, call the [DescribeRouteEntryList](~~138148~~) operation to query the **NextHopId** of the route first.
        *   The **DeleteRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route:
        *   If the route is in the **Deleting** state, the route is being deleted.
        *   If you cannot query the route, the route is deleted.
        *   You cannot repeatedly call the **DeleteRouteEntry** operation to delete a route from the route table of a vRouter or a VBR within the specified period of time.
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entry(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only routes that are in the **Available** state.
        *   You cannot delete a route of a virtual private cloud (VPC) in which a vSwitch or a route is being created.
        *   Before you call this operation to delete a route of a VBR route table, call the [DescribeRouteEntryList](~~138148~~) operation to query the **NextHopId** of the route first.
        *   The **DeleteRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route:
        *   If the route is in the **Deleting** state, the route is being deleted.
        *   If you cannot query the route, the route is deleted.
        *   You cannot repeatedly call the **DeleteRouteEntry** operation to delete a route from the route table of a vRouter or a VBR within the specified period of time.
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entry_with_options(request, runtime)

    async def delete_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        """
        When you call this operation, take note of the following rules:
        *   You can delete only routes that are in the **Available** state.
        *   You cannot delete a route of a virtual private cloud (VPC) in which a vSwitch or a route is being created.
        *   Before you call this operation to delete a route of a VBR route table, call the [DescribeRouteEntryList](~~138148~~) operation to query the **NextHopId** of the route first.
        *   The **DeleteRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteEntryList](~~138148~~) operation to query the status of a route:
        *   If the route is in the **Deleting** state, the route is being deleted.
        *   If you cannot query the route, the route is deleted.
        *   You cannot repeatedly call the **DeleteRouteEntry** operation to delete a route from the route table of a vRouter or a VBR within the specified period of time.
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entry_with_options_async(request, runtime)

    def delete_route_table_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        """
        The **DeleteRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Deleting** state, the custom route table is being deleted.
        *   If you cannot query the custom route table, the custom route table is deleted.
        *   You cannot repeatedly call the **DeleteRouteTable** operation to delete a custom route table within the specified period of time.
        
        @param request: DeleteRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_table_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        """
        The **DeleteRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Deleting** state, the custom route table is being deleted.
        *   If you cannot query the custom route table, the custom route table is deleted.
        *   You cannot repeatedly call the **DeleteRouteTable** operation to delete a custom route table within the specified period of time.
        
        @param request: DeleteRouteTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_table(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        """
        The **DeleteRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Deleting** state, the custom route table is being deleted.
        *   If you cannot query the custom route table, the custom route table is deleted.
        *   You cannot repeatedly call the **DeleteRouteTable** operation to delete a custom route table within the specified period of time.
        
        @param request: DeleteRouteTableRequest
        @return: DeleteRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_route_table_with_options(request, runtime)

    async def delete_route_table_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        """
        The **DeleteRouteTable** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeRouteTableList](~~87602~~) operation to query the status of a custom route table:
        *   If the custom route table is in the **Deleting** state, the custom route table is being deleted.
        *   If you cannot query the custom route table, the custom route table is deleted.
        *   You cannot repeatedly call the **DeleteRouteTable** operation to delete a custom route table within the specified period of time.
        
        @param request: DeleteRouteTableRequest
        @return: DeleteRouteTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_table_with_options_async(request, runtime)

    def delete_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can delete only a router interface that is in the **Idle** or **Inactive** state.
        *   Before you delete a router interface, you must delete all custom route entries destined for the router interface.
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can delete only a router interface that is in the **Idle** or **Inactive** state.
        *   Before you delete a router interface, you must delete all custom route entries destined for the router interface.
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_router_interface(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can delete only a router interface that is in the **Idle** or **Inactive** state.
        *   Before you delete a router interface, you must delete all custom route entries destined for the router interface.
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_router_interface_with_options(request, runtime)

    async def delete_router_interface_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        """
        When you call this operation, take note of the following limits:
        *   You can delete only a router interface that is in the **Idle** or **Inactive** state.
        *   Before you delete a router interface, you must delete all custom route entries destined for the router interface.
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_router_interface_with_options_async(request, runtime)

    def delete_snat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        """
        DeleteSnatEntry is an asynchronous operation. After you make a request, the ID of the request is returned but the specified SNAT entry is not deleted. The system deletes the SNAT entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of SNAT entries.
        *   If the SNAT entries are in the **Deleting** state, the system is deleting the SNAT entries. In this case, you can only query the status of the SNAT entries, and cannot perform other operations.
        *   If no SNAT entry is returned in the response, the SNAT entry is deleted.
        If some SNAT entries are in the **Pending** state, you cannot delete these SNAT entries.
        
        @param request: DeleteSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        """
        DeleteSnatEntry is an asynchronous operation. After you make a request, the ID of the request is returned but the specified SNAT entry is not deleted. The system deletes the SNAT entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of SNAT entries.
        *   If the SNAT entries are in the **Deleting** state, the system is deleting the SNAT entries. In this case, you can only query the status of the SNAT entries, and cannot perform other operations.
        *   If no SNAT entry is returned in the response, the SNAT entry is deleted.
        If some SNAT entries are in the **Pending** state, you cannot delete these SNAT entries.
        
        @param request: DeleteSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snat_entry(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        """
        DeleteSnatEntry is an asynchronous operation. After you make a request, the ID of the request is returned but the specified SNAT entry is not deleted. The system deletes the SNAT entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of SNAT entries.
        *   If the SNAT entries are in the **Deleting** state, the system is deleting the SNAT entries. In this case, you can only query the status of the SNAT entries, and cannot perform other operations.
        *   If no SNAT entry is returned in the response, the SNAT entry is deleted.
        If some SNAT entries are in the **Pending** state, you cannot delete these SNAT entries.
        
        @param request: DeleteSnatEntryRequest
        @return: DeleteSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snat_entry_with_options(request, runtime)

    async def delete_snat_entry_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        """
        DeleteSnatEntry is an asynchronous operation. After you make a request, the ID of the request is returned but the specified SNAT entry is not deleted. The system deletes the SNAT entry in the background. You can call the [DescribeSnatTableEntries](~~42677~~) operation to query the status of SNAT entries.
        *   If the SNAT entries are in the **Deleting** state, the system is deleting the SNAT entries. In this case, you can only query the status of the SNAT entries, and cannot perform other operations.
        *   If no SNAT entry is returned in the response, the SNAT entry is deleted.
        If some SNAT entries are in the **Pending** state, you cannot delete these SNAT entries.
        
        @param request: DeleteSnatEntryRequest
        @return: DeleteSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snat_entry_with_options_async(request, runtime)

    def delete_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        """
        The **DeleteSslVpnClientCert** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway associated with an SSL server. You can check whether an SSL client certificate is deleted based on the status of the VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL client certificate is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL client certificate is deleted.
        *   You cannot repeatedly call **DeleteSslVpnClientCert** to delete an SSL client certificate from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnClientCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSslVpnClientCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        """
        The **DeleteSslVpnClientCert** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway associated with an SSL server. You can check whether an SSL client certificate is deleted based on the status of the VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL client certificate is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL client certificate is deleted.
        *   You cannot repeatedly call **DeleteSslVpnClientCert** to delete an SSL client certificate from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnClientCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSslVpnClientCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        """
        The **DeleteSslVpnClientCert** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway associated with an SSL server. You can check whether an SSL client certificate is deleted based on the status of the VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL client certificate is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL client certificate is deleted.
        *   You cannot repeatedly call **DeleteSslVpnClientCert** to delete an SSL client certificate from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnClientCertRequest
        @return: DeleteSslVpnClientCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_client_cert_with_options(request, runtime)

    async def delete_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        """
        The **DeleteSslVpnClientCert** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call [DescribeVpnGateway](~~73720~~) to query the status of a VPN gateway associated with an SSL server. You can check whether an SSL client certificate is deleted based on the status of the VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL client certificate is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL client certificate is deleted.
        *   You cannot repeatedly call **DeleteSslVpnClientCert** to delete an SSL client certificate from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnClientCertRequest
        @return: DeleteSslVpnClientCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_client_cert_with_options_async(request, runtime)

    def delete_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        """
        The **DeleteSslVpnServer** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of an SSL server based on the status of the associated VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL server is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL server is deleted.
        *   You cannot repeatedly call the **DeleteSslVpnServer** operation to delete an SSL server from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSslVpnServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        """
        The **DeleteSslVpnServer** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of an SSL server based on the status of the associated VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL server is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL server is deleted.
        *   You cannot repeatedly call the **DeleteSslVpnServer** operation to delete an SSL server from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnServerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSslVpnServerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_server(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        """
        The **DeleteSslVpnServer** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of an SSL server based on the status of the associated VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL server is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL server is deleted.
        *   You cannot repeatedly call the **DeleteSslVpnServer** operation to delete an SSL server from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnServerRequest
        @return: DeleteSslVpnServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_server_with_options(request, runtime)

    async def delete_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        """
        The **DeleteSslVpnServer** operation is asynchronous. After you send a request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of an SSL server based on the status of the associated VPN gateway.
        *   If the VPN gateway is in the **updating** state, the SSL server is being deleted.
        *   If the VPN gateway is in the **active** state, the SSL server is deleted.
        *   You cannot repeatedly call the **DeleteSslVpnServer** operation to delete an SSL server from the same VPN gateway within the specified period of time.
        
        @param request: DeleteSslVpnServerRequest
        @return: DeleteSslVpnServerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_server_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        """
        The **DeleteTrafficMirrorFilter** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter:
        *   If the filter is in the **Deleting** state, the filter is being deleted.
        *   If you cannot query the filter, the filter is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilter** operation to delete a filter within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorFilterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        """
        The **DeleteTrafficMirrorFilter** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter:
        *   If the filter is in the **Deleting** state, the filter is being deleted.
        *   If you cannot query the filter, the filter is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilter** operation to delete a filter within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorFilterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        """
        The **DeleteTrafficMirrorFilter** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter:
        *   If the filter is in the **Deleting** state, the filter is being deleted.
        *   If you cannot query the filter, the filter is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilter** operation to delete a filter within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRequest
        @return: DeleteTrafficMirrorFilterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_with_options(request, runtime)

    async def delete_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        """
        The **DeleteTrafficMirrorFilter** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of a filter:
        *   If the filter is in the **Deleting** state, the filter is being deleted.
        *   If you cannot query the filter, the filter is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilter** operation to delete a filter within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRequest
        @return: DeleteTrafficMirrorFilterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        """
        The **DeleteTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Deleting** state, the rule is being deleted.
        *   If you cannot query the rule, the rule is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilterRules** operation to delete an inbound or outbound rule within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorFilterRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_rule_ids):
            query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        """
        The **DeleteTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Deleting** state, the rule is being deleted.
        *   If you cannot query the rule, the rule is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilterRules** operation to delete an inbound or outbound rule within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorFilterRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_rule_ids):
            query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        """
        The **DeleteTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Deleting** state, the rule is being deleted.
        *   If you cannot query the rule, the rule is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilterRules** operation to delete an inbound or outbound rule within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRulesRequest
        @return: DeleteTrafficMirrorFilterRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_rules_with_options(request, runtime)

    async def delete_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        """
        The **DeleteTrafficMirrorFilterRules** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [ListTrafficMirrorFilters](~~261353~~) operation to query the status of an inbound or outbound rule:
        *   If the rule is in the **Deleting** state, the rule is being deleted.
        *   If you cannot query the rule, the rule is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorFilterRules** operation to delete an inbound or outbound rule within the specified period of time.
        
        @param request: DeleteTrafficMirrorFilterRulesRequest
        @return: DeleteTrafficMirrorFilterRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def delete_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        """
        **DeleteTrafficMirrorSession** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session.
        *   If the traffic mirror session is in the **Deleting** state, the traffic mirror session is being deleted.
        *   If you cannot query the traffic mirror session, the traffic mirror session is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorSession** operation to delete a traffic mirror session within the specified period of time.
        
        @param request: DeleteTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        """
        **DeleteTrafficMirrorSession** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session.
        *   If the traffic mirror session is in the **Deleting** state, the traffic mirror session is being deleted.
        *   If you cannot query the traffic mirror session, the traffic mirror session is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorSession** operation to delete a traffic mirror session within the specified period of time.
        
        @param request: DeleteTrafficMirrorSessionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrafficMirrorSessionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_session(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        """
        **DeleteTrafficMirrorSession** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session.
        *   If the traffic mirror session is in the **Deleting** state, the traffic mirror session is being deleted.
        *   If you cannot query the traffic mirror session, the traffic mirror session is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorSession** operation to delete a traffic mirror session within the specified period of time.
        
        @param request: DeleteTrafficMirrorSessionRequest
        @return: DeleteTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_session_with_options(request, runtime)

    async def delete_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        """
        **DeleteTrafficMirrorSession** is an asynchronous operation. After you send the request, the system returns a request ID and runs the task in the background. You can call the [ListTrafficMirrorSessions](~~261367~~) operation to query the status of a traffic mirror session.
        *   If the traffic mirror session is in the **Deleting** state, the traffic mirror session is being deleted.
        *   If you cannot query the traffic mirror session, the traffic mirror session is deleted.
        *   You cannot repeatedly call the **DeleteTrafficMirrorSession** operation to delete a traffic mirror session within the specified period of time.
        
        @param request: DeleteTrafficMirrorSessionRequest
        @return: DeleteTrafficMirrorSessionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_session_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a vSwitch, you must first release or remove all virtual private cloud (VPC) resources, including vSwitches, instances, router interfaces, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only vSwitches that are in the **Available** state.
        *   You cannot delete a vSwitch from a VPC where a vSwitch or a route is being created or deleted.
        *   **DeleteVSwitch** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being deleted.
        *   If you cannot query the vSwitch, the vSwitch is deleted.
        *   You cannot repeatedly call the **DeleteVSwitch** operation to delete a vSwitch within the specified period of time.
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a vSwitch, you must first release or remove all virtual private cloud (VPC) resources, including vSwitches, instances, router interfaces, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only vSwitches that are in the **Available** state.
        *   You cannot delete a vSwitch from a VPC where a vSwitch or a route is being created or deleted.
        *   **DeleteVSwitch** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being deleted.
        *   If you cannot query the vSwitch, the vSwitch is deleted.
        *   You cannot repeatedly call the **DeleteVSwitch** operation to delete a vSwitch within the specified period of time.
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a vSwitch, you must first release or remove all virtual private cloud (VPC) resources, including vSwitches, instances, router interfaces, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only vSwitches that are in the **Available** state.
        *   You cannot delete a vSwitch from a VPC where a vSwitch or a route is being created or deleted.
        *   **DeleteVSwitch** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being deleted.
        *   If you cannot query the vSwitch, the vSwitch is deleted.
        *   You cannot repeatedly call the **DeleteVSwitch** operation to delete a vSwitch within the specified period of time.
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a vSwitch, you must first release or remove all virtual private cloud (VPC) resources, including vSwitches, instances, router interfaces, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only vSwitches that are in the **Available** state.
        *   You cannot delete a vSwitch from a VPC where a vSwitch or a route is being created or deleted.
        *   **DeleteVSwitch** is an asynchronous operation. After you send a request, the system returns a request ID and runs the task in the background. You can call the [DescribeVSwitchAttributes](~~94567~~) operation to query the status of a vSwitch:
        *   If the vSwitch is in the **Pending** state, the vSwitch is being deleted.
        *   If you cannot query the vSwitch, the vSwitch is deleted.
        *   You cannot repeatedly call the **DeleteVSwitch** operation to delete a vSwitch within the specified period of time.
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def delete_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vbr_ha(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vbr_ha_with_options(request, runtime)

    async def delete_vbr_ha_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vbr_ha_with_options_async(request, runtime)

    def delete_vco_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        """
        The **DeleteVcoRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being deleted.
        *   If the IPsec-VPN connection is in the **attached** state, the route is deleted.
        *   You cannot repeatedly call the **DeleteVcoRouteEntry** operation to delete a route from the same IPsec-VPN connection within the specified period of time.
        
        @param request: DeleteVcoRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVcoRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVcoRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vco_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        """
        The **DeleteVcoRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being deleted.
        *   If the IPsec-VPN connection is in the **attached** state, the route is deleted.
        *   You cannot repeatedly call the **DeleteVcoRouteEntry** operation to delete a route from the same IPsec-VPN connection within the specified period of time.
        
        @param request: DeleteVcoRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVcoRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVcoRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vco_route_entry(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        """
        The **DeleteVcoRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being deleted.
        *   If the IPsec-VPN connection is in the **attached** state, the route is deleted.
        *   You cannot repeatedly call the **DeleteVcoRouteEntry** operation to delete a route from the same IPsec-VPN connection within the specified period of time.
        
        @param request: DeleteVcoRouteEntryRequest
        @return: DeleteVcoRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vco_route_entry_with_options(request, runtime)

    async def delete_vco_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        """
        The **DeleteVcoRouteEntry** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnConnection](~~53046~~) operation to query the status of a route based on the status of the associated IPsec-VPN connection.
        *   If the IPsec-VPN connection is in the **updating** state, the route is being deleted.
        *   If the IPsec-VPN connection is in the **attached** state, the route is deleted.
        *   You cannot repeatedly call the **DeleteVcoRouteEntry** operation to delete a route from the same IPsec-VPN connection within the specified period of time.
        
        @param request: DeleteVcoRouteEntryRequest
        @return: DeleteVcoRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vco_route_entry_with_options_async(request, runtime)

    def delete_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        """
        ## Limits
        Before you call this operation, take note of the following limits:
        *   Before you delete a VBR, you must delete all router interfaces of the VBR.
        *   You can delete only a VBR that is in the** Unconfirmed**,** Enabled**, or** Terminated** state.
        *   If the owner of an Express Connect circuit wants to delete a VBR that belongs to another Alibaba Cloud account, the VBR must be in the **Unconfirmed** state.
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        """
        ## Limits
        Before you call this operation, take note of the following limits:
        *   Before you delete a VBR, you must delete all router interfaces of the VBR.
        *   You can delete only a VBR that is in the** Unconfirmed**,** Enabled**, or** Terminated** state.
        *   If the owner of an Express Connect circuit wants to delete a VBR that belongs to another Alibaba Cloud account, the VBR must be in the **Unconfirmed** state.
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_virtual_border_router(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        """
        ## Limits
        Before you call this operation, take note of the following limits:
        *   Before you delete a VBR, you must delete all router interfaces of the VBR.
        *   You can delete only a VBR that is in the** Unconfirmed**,** Enabled**, or** Terminated** state.
        *   If the owner of an Express Connect circuit wants to delete a VBR that belongs to another Alibaba Cloud account, the VBR must be in the **Unconfirmed** state.
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_border_router_with_options(request, runtime)

    async def delete_virtual_border_router_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        """
        ## Limits
        Before you call this operation, take note of the following limits:
        *   Before you delete a VBR, you must delete all router interfaces of the VBR.
        *   You can delete only a VBR that is in the** Unconfirmed**,** Enabled**, or** Terminated** state.
        *   If the owner of an Express Connect circuit wants to delete a VBR that belongs to another Alibaba Cloud account, the VBR must be in the **Unconfirmed** state.
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_border_router_with_options_async(request, runtime)

    def delete_vpc_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a VPC, make sure that all resources deployed in the VPC are released or removed, such as vSwitches, instances, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only a VPC that is in the **Available** state.
        *   The **DeleteVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Deleting** state, the VPC is being deleted.
        *   If you cannot query the VPC, the VPC is deleted.
        *   You cannot repeatedly call the **DeleteVpc** operation to delete a VPC within the specified period of time.
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force_delete):
            query['ForceDelete'] = request.force_delete
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a VPC, make sure that all resources deployed in the VPC are released or removed, such as vSwitches, instances, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only a VPC that is in the **Available** state.
        *   The **DeleteVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Deleting** state, the VPC is being deleted.
        *   If you cannot query the VPC, the VPC is deleted.
        *   You cannot repeatedly call the **DeleteVpc** operation to delete a VPC within the specified period of time.
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force_delete):
            query['ForceDelete'] = request.force_delete
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a VPC, make sure that all resources deployed in the VPC are released or removed, such as vSwitches, instances, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only a VPC that is in the **Available** state.
        *   The **DeleteVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Deleting** state, the VPC is being deleted.
        *   If you cannot query the VPC, the VPC is deleted.
        *   You cannot repeatedly call the **DeleteVpc** operation to delete a VPC within the specified period of time.
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_with_options(request, runtime)

    async def delete_vpc_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        """
        When you call this operation, take note of the following limits:
        *   Before you delete a VPC, make sure that all resources deployed in the VPC are released or removed, such as vSwitches, instances, and high-availability virtual IP addresses (HAVIPs).
        *   You can delete only a VPC that is in the **Available** state.
        *   The **DeleteVpc** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpcAttribute](~~94565~~) operation to query the status of a VPC:
        *   If the VPC is in the **Deleting** state, the VPC is being deleted.
        *   If you cannot query the VPC, the VPC is deleted.
        *   You cannot repeatedly call the **DeleteVpc** operation to delete a VPC within the specified period of time.
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_with_options_async(request, runtime)

    def delete_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_gateway_endpoint_with_options(request, runtime)

    async def delete_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_gateway_endpoint_with_options_async(request, runtime)

    def delete_vpc_prefix_list_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        """
        You cannot repeatedly call the *DeleteDhcpOptionsSet** operation to delete a prefix list within the specified period of time.
        
        @param request: DeleteVpcPrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcPrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcPrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_prefix_list_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        """
        You cannot repeatedly call the *DeleteDhcpOptionsSet** operation to delete a prefix list within the specified period of time.
        
        @param request: DeleteVpcPrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcPrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcPrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_prefix_list(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        """
        You cannot repeatedly call the *DeleteDhcpOptionsSet** operation to delete a prefix list within the specified period of time.
        
        @param request: DeleteVpcPrefixListRequest
        @return: DeleteVpcPrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_prefix_list_with_options(request, runtime)

    async def delete_vpc_prefix_list_async(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        """
        You cannot repeatedly call the *DeleteDhcpOptionsSet** operation to delete a prefix list within the specified period of time.
        
        @param request: DeleteVpcPrefixListRequest
        @return: DeleteVpcPrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_prefix_list_with_options_async(request, runtime)

    def delete_vpn_attachment_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        """
        If the IPsec-VPN connection is associated with a transit router, you must first disassociate the IPsec-VPN connection from the transit router before you delete the IPsec-VPN connection.
        *   If the IPsec-VPN connection is not associated with a resource, you can call the `DeleteVpnAttachment` to delete the IPsec-VPN connection.
        
        @param request: DeleteVpnAttachmentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpnAttachmentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnAttachmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_attachment_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        """
        If the IPsec-VPN connection is associated with a transit router, you must first disassociate the IPsec-VPN connection from the transit router before you delete the IPsec-VPN connection.
        *   If the IPsec-VPN connection is not associated with a resource, you can call the `DeleteVpnAttachment` to delete the IPsec-VPN connection.
        
        @param request: DeleteVpnAttachmentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpnAttachmentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnAttachmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_attachment(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        """
        If the IPsec-VPN connection is associated with a transit router, you must first disassociate the IPsec-VPN connection from the transit router before you delete the IPsec-VPN connection.
        *   If the IPsec-VPN connection is not associated with a resource, you can call the `DeleteVpnAttachment` to delete the IPsec-VPN connection.
        
        @param request: DeleteVpnAttachmentRequest
        @return: DeleteVpnAttachmentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_attachment_with_options(request, runtime)

    async def delete_vpn_attachment_async(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        """
        If the IPsec-VPN connection is associated with a transit router, you must first disassociate the IPsec-VPN connection from the transit router before you delete the IPsec-VPN connection.
        *   If the IPsec-VPN connection is not associated with a resource, you can call the `DeleteVpnAttachment` to delete the IPsec-VPN connection.
        
        @param request: DeleteVpnAttachmentRequest
        @return: DeleteVpnAttachmentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_attachment_with_options_async(request, runtime)

    def delete_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        """
        The **DeleteVpnConnection** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being deleted.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection is deleted.
        *   You cannot repeatedly call **DeleteVpnConnection** to delete an IPsec-VPN connection from the same VPN gateway within the specified period of time.
        >  After an IPsec-VPN connection between a virtual private cloud (VPC) and a data center is deleted, the communication between the VPC and data center is interrupted.
        
        @param request: DeleteVpnConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpnConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        """
        The **DeleteVpnConnection** operation is asynchronous. After you send the request, the system returns a request ID. However, the operation is still being performed in the system background. You can call the [DescribeVpnGateway](~~73720~~) operation to query the status of a VPN gateway.
        *   If the VPN gateway is in the **updating** state, the IPsec-VPN connection is being deleted.
        *   If the VPN gateway is in the **active** state, the IPsec-VPN connection is deleted.
        *   You cannot repeatedly call **DeleteVpnConnection** to delete an IPsec-VPN connection from the same VPN gateway within the specified period of time.
        >  After an IPsec-VPN connection between a virtual private cloud (VPC) and a data center is deleted, the communication between the VPC and data center is interrupted.
        
        @param request: De