"""
This module contains the common PennyLane navigation bar data.
"""

NAVBAR_LEFT = [
    {
        "name": "Why PennyLane",
        "href": "https://pennylane.ai/research",
        "dropdown": [
            {
                "name": "Features",
                "href": "https://pennylane.ai/features",
            },
            {
                "name": "Demos",
                "href": "https://pennylane.ai/qml/demonstrations",
            },
            {
                "name": "Compilation",
                "href": "https://pennylane.ai/compilation",
            },
            {
                "name": "Datasets",
                "href": "https://pennylane.ai/datasets",
            },
            {
                "name": "Performance",
                "href": "https://pennylane.ai/performance",
            },
            {
                "name": "Devices",
                "href": "https://pennylane.ai/devices",
            },
            {
                "name": "Teach",
                "href": "https://pennylane.ai/education",
            },
        ],
    },
    {
        "name": "Getting Started",
        "href": "https://pennylane.ai/qml",
        "dropdown": [
            {
                "name": "Install",
                "href": "https://pennylane.ai/install",
            },
            {
                "name": "Demos",
                "href": "https://pennylane.ai/qml/demonstrations",
            },
            {
                "name": "Codebook",
                "href": "https://pennylane.ai/codebook",
            },
            {
                "name": "Challenges",
                "href": "https://pennylane.ai/challenges",
            },
            {
                "name": "Support",
                "href": "https://discuss.pennylane.ai/",
                "external": True,
            },
        ],
    },
    {
        "name": "Documentation",
        "href": "https://docs.pennylane.ai/en/stable/",
        "dropdown": [
            {
                "name": "How-to demos",
                "href": "https://pennylane.ai/search/?contentType=DEMO&categories=how-to&sort=publication_date",
            },
            {
                "name": "Development guide",
                "href": "https://docs.pennylane.ai/en/stable/development/guide.html",
            },
            {
                "name": "Catalyst",
                "href": "https://docs.pennylane.ai/projects/catalyst/en/stable/",
            },
            {
                "name": "API",
                "href": "https://docs.pennylane.ai/en/stable/code/qml.html",
            },
            {
                "name": "GitHub",
                "href": "https://github.com/PennyLaneAI/pennylane",
                "external": True,
            },
        ],
    },
    {
        "name": "Ecosystem",
        "href": "https://pennylane.ai/get-involved",
        "dropdown": [
            {
                "name": "Blog",
                "href": "https://pennylane.ai/blog/?page=1",
            },
            {
                "name": "Glossary",
                "href": "https://pennylane.ai/qml/glossary",
            },
            {
                "name": "Videos",
                "href": "https://pennylane.ai/qml/videos",
            },
            {
                "name": "FAQs",
                "href": "https://pennylane.ai/faq",
            },
            {
                "name": "GitHub",
                "href": "https://github.com/PennyLaneAI/pennylane",
                "external": True,
            },
            {
                "name": "Support",
                "href": "https://discuss.pennylane.ai/",
                "external": True,
            },
        ],
    },
]


NAVBAR_RIGHT = [
    {
        "name": "Install",
        "href": "https://pennylane.ai/install",
    },
]
