"""
This module contains the common PennyLane footer data.
"""

FOOTER = {
    "footer_about": {
        "title": "PennyLane",
        "icon": "https://assets.cloud.pennylane.ai/docs/pennylane-logo.png",
        "description": """\
        PennyLane is an open-source software framework for quantum
        machine learning, quantum chemistry, and quantum computing,
        with the ability to run on all hardware. Built with ❤️ by
        <a href="https://xanadu.ai">Xanadu</a>.
        """,
    },
    "footer_policies": [
        {
            "text": "Privacy Policy",
            "href": "https://pennylane.ai/privacy",
        },
        {
            "text": "Terms of Service",
            "href": "https://pennylane.ai/terms",
        },
        {
            "text": "Cookie Policy",
            "href": "https://pennylane.ai/cookies",
        },
        {
            "text": "Code of Conduct",
            "href": "https://pennylane.ai/conduct",
        },
    ],
    "footer_links": [
        {
            "title": "For researchers",
            "links": [
                {
                    "name": "Research",
                    "href": "https://pennylane.ai/research",
                },
                {
                    "name": "Features",
                    "href": "https://pennylane.ai/features",
                },
                {
                    "name": "Demos",
                    "href": "https://pennylane.ai/qml/demonstrations",
                },
                {
                    "name": "Compilation",
                    "href": "https://pennylane.ai/compilation",
                },
                {
                    "name": "Datasets",
                    "href": "https://pennylane.ai/datasets",
                },
                {
                    "name": "Performance",
                    "href": "https://pennylane.ai/performance",
                },
                {
                    "name": "Learn",
                    "href": "https://pennylane.ai/qml",
                },
                {
                    "name": "Videos",
                    "href": "https://pennylane.ai/qml/videos",
                },
                {
                    "name": "Documentation",
                    "href": "https://docs.pennylane.ai/",
                },
                {
                    "name": "Teach",
                    "href": "https://pennylane.ai/education",
                },
            ],
        },
        {
            "title": "For learners",
            "links": [
                {
                    "name": "Learn",
                    "href": "https://pennylane.ai/qml",
                },
                {
                    "name": "Codebook",
                    "href": "https://pennylane.ai/codebook",
                },
                {
                    "name": "Teach",
                    "href": "https://pennylane.ai/education",
                },
                {
                    "name": "Videos",
                    "href": "https://pennylane.ai/qml/videos",
                },
                {
                    "name": "Challenges",
                    "href": "https://pennylane.ai/challenges",
                },
                {
                    "name": "Demos",
                    "href": "https://pennylane.ai/qml/demonstrations",
                },
                {
                    "name": "Compilation",
                    "href": "https://pennylane.ai/compilation",
                },
                {
                    "name": "Glossary",
                    "href": "https://pennylane.ai/qml/glossary",
                },
            ],
        },
        {
            "title": "For developers",
            "links": [
                {
                    "name": "Features",
                    "href": "https://pennylane.ai/features",
                },
                {
                    "name": "Documentation",
                    "href": "https://docs.pennylane.ai",
                },
                {
                    "name": "API",
                    "href": "https://docs.pennylane.ai/en/stable/code/qml.html",
                },
                {
                    "name": "GitHub",
                    "href": "https://github.com/PennyLaneAI/pennylane",
                },
                {
                    "name": "Datasets",
                    "href": "https://pennylane.ai/datasets",
                },
                {
                    "name": "Demos",
                    "href": "https://pennylane.ai/qml/demonstrations",
                },
                {
                    "name": "Compilation",
                    "href": "https://pennylane.ai/compilation",
                },
                {
                    "name": "Performance",
                    "href": "https://pennylane.ai/performance",
                },
                {
                    "name": "Devices",
                    "href": "https://pennylane.ai/devices",
                },
                {
                    "name": "Catalyst",
                    "href": "https://docs.pennylane.ai/projects/catalyst/en/latest/",
                },
            ],
        },
    ],
    "footer_social_icons": [
        {
            "name": "Twitter",
            "icon": "bx bxl-twitter",
            "href": "https://twitter.com/PennyLaneAI",
        },
        {
            "name": "GitHub",
            "icon": "bx bxl-github",
            "href": "https://github.com/PennyLaneAI/pennylane",
        },
        {
            "name": "Discord",
            "icon": "bx bxl-discord",
            "href": "https://discord.com/invite/gnySM3nrN3",
        },
        {
            "name": "LinkedIn",
            "icon": "bx bxl-linkedin",
            "href": "https://linkedin.com/company/xanaduai/",
        },
        {
            "name": "Discourse",
            "icon": "bx bxl-discourse",
            "href": "https://discuss.pennylane.ai",
        },
        {
            "name": "YouTube",
            "icon": "bx bxl-youtube",
            "href": "https://www.youtube.com/@pennylaneai/",
        },
        {
            "name": "Slack",
            "icon": "bx bxl-slack",
            "href": "https://xanadu-quantum.slack.com/join/shared_invite/zt-nkwn25v9-H4hituCb_PUj4idG0MhSug#/shared-invite/email",
        },
    ],
    "footer_taglines": [
        {
            "text": "Stay updated with our newsletter",
            "href": "https://xanadu.us17.list-manage.com/subscribe?u=725f07a1d1a4337416c3129fd&id=294b062630",
        },
    ],
}
