# SPDX-License-Identifier: Apache-2.0
#
# The OpenSearch Contributors require contributions made to
# this file be licensed under the Apache-2.0 license or a
# compatible open source license.
#
# Modifications Copyright OpenSearch Contributors. See
# GitHub history for details.
#
#  Licensed to Elasticsearch B.V. under one or more contributor
#  license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright
#  ownership. Elasticsearch B.V. licenses this file to you under
#  the Apache License, Version 2.0 (the "License"); you may
#  not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
# 	http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.
from typing import Any

from _typeshed import Incomplete

from ..response.aggs import AggResponse as AggResponse
from ..response.aggs import BucketData as BucketData
from ..response.aggs import FieldBucketData as FieldBucketData
from ..response.aggs import TopHitsData as TopHitsData
from .utils import DslBase
from .utils import DslBase as DslBase

def A(name_or_agg: Any, filter: Incomplete | None = ..., **params: Any) -> Any: ...

class Agg(DslBase): ...
class AggBase(object): ...
class Bucket(AggBase, Agg): ...
class Filter(Bucket): ...
class Pipeline(Agg): ...
class Filters(Bucket): ...
class Children(Bucket): ...
class Parent(Bucket): ...
class DateHistogram(Bucket): ...
class AutoDateHistogram(DateHistogram): ...
class DateRange(Bucket): ...
class GeoDistance(Bucket): ...
class GeohashGrid(Bucket): ...
class GeotileGrid(Bucket): ...
class GeoCentroid(Bucket): ...
class Global(Bucket): ...
class Histogram(Bucket): ...
class IPRange(Bucket): ...
class Missing(Bucket): ...
class Nested(Bucket): ...
class Range(Bucket): ...
class RareTerms(Bucket): ...
class ReverseNested(Bucket): ...
class SignificantTerms(Bucket): ...
class SignificantText(Bucket): ...
class Terms(Bucket): ...
class Sampler(Bucket): ...
class DiversifiedSampler(Bucket): ...
class Composite(Bucket): ...
class VariableWidthHistogram(Bucket): ...
class TopHits(Agg): ...
class Avg(Agg): ...
class WeightedAvg(Agg): ...
class Cardinality(Agg): ...
class ExtendedStats(Agg): ...
class Boxplot(Agg): ...
class GeoBounds(Agg): ...
class Max(Agg): ...
class MedianAbsoluteDeviation(Agg): ...
class Min(Agg): ...
class Percentiles(Agg): ...
class PercentileRanks(Agg): ...
class ScriptedMetric(Agg): ...
class Stats(Agg): ...
class Sum(Agg): ...
class TTest(Agg): ...
class ValueCount(Agg): ...
class AvgBucket(Pipeline): ...
class BucketScript(Pipeline): ...
class BucketSelector(Pipeline): ...
class CumulativeSum(Pipeline): ...
class CumulativeCardinality(Pipeline): ...
class Derivative(Pipeline): ...
class ExtendedStatsBucket(Pipeline): ...
class Inference(Pipeline): ...
class MaxBucket(Pipeline): ...
class MinBucket(Pipeline): ...
class MovingFn(Pipeline): ...
class MovingAvg(Pipeline): ...
class MovingPercentiles(Pipeline): ...
class Normalize(Pipeline): ...
class PercentilesBucket(Pipeline): ...
class SerialDiff(Pipeline): ...
class StatsBucket(Pipeline): ...
class SumBucket(Pipeline): ...
class BucketSort(Pipeline): ...
