import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::Spider::S3Bucket::MODULE
 *
 * @schema CfnS3BucketModuleProps
 */
export interface CfnS3BucketModuleProps {
    /**
     * @schema CfnS3BucketModuleProps#Parameters
     */
    readonly parameters?: CfnS3BucketModulePropsParameters;
    /**
     * @schema CfnS3BucketModuleProps#Resources
     */
    readonly resources?: CfnS3BucketModulePropsResources;
}
/**
 * Converts an object of type 'CfnS3BucketModuleProps' to JSON representation.
 */
export declare function toJson_CfnS3BucketModuleProps(obj: CfnS3BucketModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnS3BucketModulePropsParameters
 */
export interface CfnS3BucketModulePropsParameters {
    /**
     * The environment name
     *
     * @schema CfnS3BucketModulePropsParameters#EnvName
     */
    readonly envName?: CfnS3BucketModulePropsParametersEnvName;
}
/**
 * Converts an object of type 'CfnS3BucketModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnS3BucketModulePropsParameters(obj: CfnS3BucketModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnS3BucketModulePropsResources
 */
export interface CfnS3BucketModulePropsResources {
    /**
     * @schema CfnS3BucketModulePropsResources#S3Bucket
     */
    readonly s3Bucket?: CfnS3BucketModulePropsResourcesS3Bucket;
    /**
     * @schema CfnS3BucketModulePropsResources#S3BucketPolicy
     */
    readonly s3BucketPolicy?: CfnS3BucketModulePropsResourcesS3BucketPolicy;
}
/**
 * Converts an object of type 'CfnS3BucketModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnS3BucketModulePropsResources(obj: CfnS3BucketModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnS3BucketModulePropsParametersEnvName
 */
export interface CfnS3BucketModulePropsParametersEnvName {
    /**
     * @schema CfnS3BucketModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnS3BucketModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnS3BucketModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnS3BucketModulePropsParametersEnvName(obj: CfnS3BucketModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnS3BucketModulePropsResourcesS3Bucket
 */
export interface CfnS3BucketModulePropsResourcesS3Bucket {
    /**
     * @schema CfnS3BucketModulePropsResourcesS3Bucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnS3BucketModulePropsResourcesS3Bucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnS3BucketModulePropsResourcesS3Bucket' to JSON representation.
 */
export declare function toJson_CfnS3BucketModulePropsResourcesS3Bucket(obj: CfnS3BucketModulePropsResourcesS3Bucket | undefined): Record<string, any> | undefined;
/**
 * @schema CfnS3BucketModulePropsResourcesS3BucketPolicy
 */
export interface CfnS3BucketModulePropsResourcesS3BucketPolicy {
    /**
     * @schema CfnS3BucketModulePropsResourcesS3BucketPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnS3BucketModulePropsResourcesS3BucketPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnS3BucketModulePropsResourcesS3BucketPolicy' to JSON representation.
 */
export declare function toJson_CfnS3BucketModulePropsResourcesS3BucketPolicy(obj: CfnS3BucketModulePropsResourcesS3BucketPolicy | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::Spider::S3Bucket::MODULE`
 *
 * @cloudformationResource FreyrAIM::Spider::S3Bucket::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnS3BucketModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::Spider::S3Bucket::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnS3BucketModuleProps;
    /**
     * Create a new `FreyrAIM::Spider::S3Bucket::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnS3BucketModuleProps);
}
