import * as lambda from '@aws-cdk/aws-lambda';
import { Construct, Stack, ResourceEnvironment } from '@aws-cdk/core';
/**
 * Properties for KubectlLayer.
 */
export interface KubectlLayerProps {
    /**
     * The semantic version of the kubectl AWS Lambda Layer SAR app to use.
     *
     * @default '2.0.0'
     */
    readonly version?: string;
    /**
     * The Serverless Application Repository application ID which contains the kubectl layer.
     * @default - The ARN for the `lambda-layer-kubectl` SAR app.
     * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
     */
    readonly applicationId?: string;
}
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
export declare class KubectlLayer extends Construct implements lambda.ILayerVersion {
    /**
     * The ARN of the AWS Lambda layer version.
     */
    readonly layerVersionArn: string;
    readonly stack: Stack;
    readonly env: ResourceEnvironment;
    /**
     * All runtimes are compatible.
     */
    readonly compatibleRuntimes?: lambda.Runtime[];
    constructor(scope: Construct, id: string, props?: KubectlLayerProps);
    addPermission(_id: string, _permission: lambda.LayerVersionPermission): void;
    private isChina;
}
